/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.repository.internal;

import com.bizunited.nebula.common.repository.PageRepositoryImpl;
import com.bizunited.nebula.rbac.local.dto.RoleConditionDto;
import com.bizunited.nebula.rbac.local.entity.RoleEntity;
import com.bizunited.nebula.rbac.local.repository.internal.RoleRepositoryCustom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class RoleRepositoryImpl
implements RoleRepositoryCustom,
PageRepositoryImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleRepositoryImpl.class);
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<RoleEntity> findByConditions(RoleConditionDto conditions, Pageable pageable) {
        StringBuilder select = new StringBuilder("from RoleEntity r ");
        StringBuilder where = new StringBuilder("where 1=1 ");
        StringBuilder order = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)conditions.getTenantCode())) {
            where.append(" and r.tenantCode = :tenantCode ");
            params.put("tenantCode", conditions.getTenantCode().trim());
        }
        if (StringUtils.isNotBlank((CharSequence)conditions.getRoleName())) {
            where.append(" and r.roleName like :roleName ");
            params.put("roleName", "%" + conditions.getRoleName().trim() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)conditions.getRoleCode())) {
            where.append(" and r.roleCode = :roleCode ");
            params.put("roleCode", conditions.getRoleCode().trim());
        }
        if (conditions.getStatus() != null) {
            where.append(" and r.tstatus = :tstatus ");
            params.put("tstatus", conditions.getStatus());
        }
        if (!CollectionUtils.isEmpty(conditions.getSelectedCodeList())) {
            order.append(" order by CASE ");
            List<String> list = conditions.getSelectedCodeList();
            for (int i = 0; i < list.size(); ++i) {
                String roleParam = "roleCode_" + i;
                String idxParam = "idx_" + i;
                order.append(" WHEN r.roleCode = :").append(roleParam).append(" THEN :").append(idxParam);
                params.put(roleParam, list.get(i));
                params.put(idxParam, i);
            }
            order.append(" ELSE :elseRank END asc, r.roleCode asc ");
            params.put("elseRank", Integer.MAX_VALUE);
        } else if (pageable.getSort().isSorted()) {
            order.append(" order by ");
            ArrayList sorts = new ArrayList();
            pageable.getSort().forEach(s -> sorts.add("r." + s.getProperty() + " " + s.getDirection().name()));
            order.append(String.join((CharSequence)", ", sorts));
        } else {
            order.append(" order by r.id desc ");
        }
        String hql = select + where.toString() + order;
        String countHql = "select count(r) " + select + where.toString();
        LOGGER.info("HQL = {}", (Object)hql);
        LOGGER.info("countHQL = {}", (Object)countHql);
        LOGGER.info("params = {}", params.keySet());
        return this.queryByConditions(this.entityManager, hql, countHql, params, pageable, false, null);
    }
}

