/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.saturn.context.service.simple;

import com.bizunited.nebula.saturn.context.service.PersistentRelationService;
import com.bizunited.nebula.saturn.model.PersistentClass;
import com.bizunited.nebula.saturn.model.PersistentRelation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.ehcache.Cache;

class SimplePersistentRelationService
implements PersistentRelationService {
    private Cache<String, PersistentClass> cache;

    public SimplePersistentRelationService(Cache<String, PersistentClass> cache) {
        this.cache = cache;
    }

    @Override
    public void save(PersistentRelation persistentRelation) {
        int index;
        Validate.notNull((Object)persistentRelation, (String)"[save]\uff0c\u9519\u8bef\u7684relation\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String persistentClassName = persistentRelation.getPersistentClassName();
        Validate.notBlank((CharSequence)persistentClassName, (String)"\u5fc5\u987b\u6307\u5b9a\u6a21\u578b\u7c7b\u7684\u5168\u540d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String propertyName = persistentRelation.getPropertyName();
        Validate.notBlank((CharSequence)propertyName, (String)"\u5fc5\u987b\u6307\u5b9a\u5c5e\u6027\u540d", (Object[])new Object[0]);
        String propertyClass = persistentRelation.getPropertyClass();
        Validate.notBlank((CharSequence)propertyClass, (String)"\u5fc5\u987b\u6307\u5b9a\u5c5e\u6027\u7c7b\u578b!!", (Object[])new Object[0]);
        PersistentRelation.RelationType relationType = persistentRelation.getRelationType();
        Validate.notNull((Object)((Object)relationType), (String)"\u5fc5\u987b\u6307\u5b9a\u5173\u8054\u7c7b\u578b!!", (Object[])new Object[0]);
        PersistentClass persistentClass = (PersistentClass)this.cache.get((Object)persistentClassName);
        Validate.notNull((Object)persistentClass, (String)("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7c7b\u6a21\u578b[" + persistentClassName + "]"), (Object[])new Object[0]);
        List<PersistentRelation> relations = persistentClass.getRelations();
        if (relations == null) {
            relations = new LinkedList<PersistentRelation>();
            persistentClass.setRelations(relations);
        }
        boolean found = false;
        for (index = 0; index < relations.size(); ++index) {
            PersistentRelation relationItem = relations.get(index);
            if (!StringUtils.equals((CharSequence)propertyName, (CharSequence)relationItem.getPropertyName())) continue;
            found = true;
            break;
        }
        if (found) {
            relations.set(index, persistentRelation);
        } else {
            relations.add(persistentRelation);
        }
    }

    @Override
    public Map<String, PersistentRelation> findByClassName(String className) {
        List<PersistentRelation> relations = this.findRelation(className);
        if (relations.isEmpty()) {
            return null;
        }
        Map<String, PersistentRelation> relationMapping = null;
        relationMapping = relations.stream().collect(Collectors.toMap(PersistentRelation::getPropertyName, persistentRelation -> persistentRelation));
        return relationMapping;
    }

    @Override
    public PersistentRelation findByPropertyName(String className, String propertyName) {
        List<PersistentRelation> relations = this.findRelation(className);
        if (relations.isEmpty()) {
            return null;
        }
        for (PersistentRelation relationItem : relations) {
            if (!StringUtils.equals((CharSequence)propertyName, (CharSequence)relationItem.getPropertyName())) continue;
            return relationItem;
        }
        return null;
    }

    private List<PersistentRelation> findByPropertyClassName(String className, String propertyClassName) {
        List<PersistentRelation> relations = this.findRelation(className);
        if (relations.isEmpty()) {
            return new ArrayList<PersistentRelation>();
        }
        return relations.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyClass(), (CharSequence)propertyClassName)).collect(Collectors.toList());
    }

    private List<PersistentRelation> findRelation(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return new ArrayList<PersistentRelation>();
        }
        PersistentClass persistentClass = (PersistentClass)this.cache.get((Object)className);
        if (persistentClass == null) {
            return new ArrayList<PersistentRelation>();
        }
        List<PersistentRelation> relations = persistentClass.getRelations();
        if (relations == null || relations.isEmpty()) {
            return new ArrayList<PersistentRelation>();
        }
        return relations;
    }

    @Override
    public PersistentRelation findByTargetPropertyName(String className, String propertyName) {
        PersistentRelation currentPersistentRelation = this.findByPropertyName(className, propertyName);
        if (currentPersistentRelation == null) {
            return null;
        }
        String mappedBy = currentPersistentRelation.getMappedBy();
        String targetPropertyClass = currentPersistentRelation.getPropertyClass();
        List<PersistentRelation> persistentRelations = this.findByPropertyClassName(targetPropertyClass, className);
        if (persistentRelations == null || persistentRelations.isEmpty()) {
            return null;
        }
        if (!StringUtils.isBlank((CharSequence)mappedBy)) {
            if ((persistentRelations = persistentRelations.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyName(), (CharSequence)mappedBy)).collect(Collectors.toList())) == null || persistentRelations.isEmpty()) {
                return null;
            }
        } else {
            if (persistentRelations.size() == 1) {
                return persistentRelations.get(0);
            }
            if ((persistentRelations = persistentRelations.stream().filter(item -> StringUtils.equals((CharSequence)item.getMappedBy(), (CharSequence)propertyName)).collect(Collectors.toList())) == null || persistentRelations.isEmpty()) {
                return null;
            }
        }
        return persistentRelations.get(0);
    }
}

