/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.saturn.context.service.simple;

import com.bizunited.nebula.saturn.context.service.PersistentQueryMethodService;
import com.bizunited.nebula.saturn.model.PersistentClass;
import com.bizunited.nebula.saturn.model.PersistentQueryMethod;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.ehcache.Cache;

class SimpleQueryMethodService
implements PersistentQueryMethodService {
    private Cache<String, PersistentClass> cache;

    public SimpleQueryMethodService(Cache<String, PersistentClass> cache) {
        this.cache = cache;
    }

    @Override
    public void save(PersistentQueryMethod queryMethod) {
        List currentMethodNames;
        int foundIndex;
        Validate.notNull((Object)queryMethod, (String)"\u65b0\u589e\u7684\u65b9\u6cd5\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String description = queryMethod.getDescription();
        Validate.notBlank((CharSequence)description, (String)"\u65b9\u6cd5\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String persistentClassName = queryMethod.getPersistentClassName();
        Validate.notBlank((CharSequence)persistentClassName, (String)"\u5fc5\u987b\u6307\u5b9a\u6a21\u578b\u7c7b\u7684\u5168\u540d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        PersistentClass persistentClass = (PersistentClass)this.cache.get((Object)persistentClassName);
        Validate.notNull((Object)persistentClass, (String)("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7c7b\u6a21\u578b[" + persistentClassName + "]"), (Object[])new Object[0]);
        String[] params = queryMethod.getParams();
        Validate.isTrue((params != null && params.length > 0 ? 1 : 0) != 0, (String)"\u8bf7\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u53c2\u6570\u4fe1\u606f!!", (Object[])new Object[0]);
        String methodName = queryMethod.getMethodName();
        Validate.isTrue((boolean)StringUtils.startsWithAny((CharSequence)methodName, (CharSequence[])new CharSequence[]{"find", "query"}), (String)"\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u5fc5\u987b\u4ee5find\u6216\u8005query\u5173\u952e\u5b57\u5f00\u59cb!!", (Object[])new Object[0]);
        List<PersistentQueryMethod> queryMethods = persistentClass.getQueryMethods();
        if (queryMethods == null) {
            queryMethods = new LinkedList<PersistentQueryMethod>();
            persistentClass.setQueryMethods(queryMethods);
        }
        if ((foundIndex = (currentMethodNames = queryMethods.stream().map(PersistentQueryMethod::getMethodName).collect(Collectors.toList())).indexOf(methodName)) != -1) {
            queryMethods.set(foundIndex, queryMethod);
        } else {
            queryMethods.add(queryMethod);
        }
    }

    @Override
    public List<PersistentQueryMethod> queryByClassName(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return new ArrayList<PersistentQueryMethod>();
        }
        PersistentClass persistentClass = (PersistentClass)this.cache.get((Object)className);
        if (persistentClass == null) {
            return new ArrayList<PersistentQueryMethod>();
        }
        return persistentClass.getQueryMethods();
    }
}

