/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.saturn.engine;

import com.bizunited.nebula.saturn.context.SaturnContext;
import com.bizunited.nebula.saturn.engine.SaturnFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SaturnFutureImpl
implements SaturnFuture {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaturnFutureImpl.class);
    private SaturnContext saturnContext;

    public SaturnFutureImpl(SaturnContext saturnContext) {
        this.saturnContext = saturnContext;
    }

    @Override
    public SaturnContext getSaturnContext() {
        return this.saturnContext;
    }

    @Override
    public Boolean isInitiated() {
        return this.saturnContext.getInited();
    }

    @Override
    public Boolean isException() {
        return this.saturnContext.getException();
    }

    @Override
    public String errorMgs() {
        return this.saturnContext.getErrorMgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompleted() {
        if (this.saturnContext.getCompleted().booleanValue()) {
            return;
        }
        SaturnFutureImpl saturnFutureImpl = this;
        synchronized (saturnFutureImpl) {
            while (!this.saturnContext.getCompleted().booleanValue()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return;
                }
            }
        }
    }
}

