/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.saturn.engine.handler;

import com.bizunited.nebula.saturn.context.SaturnContext;
import com.bizunited.nebula.saturn.context.service.PersistentClassService;
import com.bizunited.nebula.saturn.context.service.PersistentPropertyService;
import com.bizunited.nebula.saturn.context.service.PersistentRelationService;
import com.bizunited.nebula.saturn.engine.handler.AbstractGenerateHandler;
import com.bizunited.nebula.saturn.model.PersistentClass;
import com.bizunited.nebula.saturn.model.PersistentProperty;
import com.bizunited.nebula.saturn.model.PersistentQueryMethod;
import com.bizunited.nebula.saturn.model.PersistentRelation;
import com.bizunited.nebula.saturn.model.PersistentUpdateMethod;
import com.bizunited.nebula.saturn.utils.TStringUtils;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerGenerateHandler
extends AbstractGenerateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerGenerateHandler.class);

    @Override
    public Void handle(SaturnContext context) {
        PersistentClassService persistentClassService = context.getPersistentClassService();
        List<PersistentClass> persistentClasses = persistentClassService.queryAllClasses();
        Validate.isTrue((persistentClasses != null && !persistentClasses.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u6a21\u578b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u524d\u7f6e\u8fd0\u884c\u626b\u63cf\u5668", (Object[])new Object[0]);
        PersistentPropertyService persistentPropertyService = context.getPersistentPropertyService();
        PersistentRelationService persistentRelationService = context.getPersistentRelationService();
        if (context.getOnlyBuildEntity().booleanValue()) {
            persistentClasses = persistentClasses.stream().filter(PersistentClass::getRepositoryEntity).collect(Collectors.toList());
        }
        if (context.getOnlyBuildVo().booleanValue()) {
            persistentClasses = persistentClasses.stream().filter(item -> item.getRepositoryEntity() == false).collect(Collectors.toList());
        }
        String rootPackage = context.getRootPackage();
        String projectAbsolutePath = context.getProjectAbsolutePath();
        String projectSrcAbsolutePath = StringUtils.join((Object[])new String[]{projectAbsolutePath, "/", context.getProjectSrcPath()});
        for (PersistentClass itemPersistentClass : persistentClasses) {
            String persistentClassName = itemPersistentClass.getClassName();
            String persistentPackageName = TStringUtils.getPreviousPackage(persistentClassName);
            String domain = itemPersistentClass.getDomain();
            if (IGNOREPACKAGES.contains(persistentPackageName) || itemPersistentClass.getRepositoryEntity().booleanValue() && StringUtils.isBlank((CharSequence)itemPersistentClass.getRepositoryTable())) continue;
            String controllerPackage = null;
            controllerPackage = StringUtils.isBlank((CharSequence)domain) ? StringUtils.join((Object[])new String[]{rootPackage, ".controller"}) : StringUtils.join((Object[])new String[]{rootPackage, ".controller", ".", domain});
            HashMap<String, String> importMapping = new HashMap<String, String>();
            String simpleClassName = itemPersistentClass.getSimpleClassName();
            String controllerSimpleClass = StringUtils.join((Object[])new String[]{simpleClassName, "Controller"});
            try {
                StringBuffer repositoryFileContext = this.buildIControllerFileContext(itemPersistentClass, importMapping, rootPackage, persistentClassService, persistentPropertyService, persistentRelationService);
                if (repositoryFileContext == null) continue;
                this.buildJavaFile(repositoryFileContext.toString(), projectSrcAbsolutePath, controllerPackage, controllerSimpleClass);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
                e.printStackTrace(System.out);
            }
        }
        return null;
    }

    private StringBuffer buildIControllerFileContext(PersistentClass persistentClass, Map<String, String> importMapping, String rootPackage, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        importMapping.put("io.swagger.annotations.ApiOperation", "io.swagger.annotations.ApiOperation");
        importMapping.put("org.springframework.web.bind.annotation.PostMapping", "org.springframework.web.bind.annotation.PostMapping");
        importMapping.put("org.springframework.web.bind.annotation.GetMapping", "org.springframework.web.bind.annotation.GetMapping");
        importMapping.put("org.springframework.web.bind.annotation.DeleteMapping", "org.springframework.web.bind.annotation.DeleteMapping");
        importMapping.put("org.springframework.web.bind.annotation.PathVariable", "org.springframework.web.bind.annotation.PathVariable");
        importMapping.put("com.bizunited.nebula.common.controller.model.ResponseModel", "com.bizunited.nebula.common.controller.model.ResponseModel");
        importMapping.put("org.springframework.web.bind.annotation.RequestBody", "org.springframework.web.bind.annotation.RequestBody");
        importMapping.put("com.bizunited.nebula.common.controller.BaseController", "com.bizunited.nebula.common.controller.BaseController");
        importMapping.put("io.swagger.annotations.ApiParam", "io.swagger.annotations.ApiParam");
        importMapping.put("org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.RequestMapping");
        importMapping.put("org.springframework.web.bind.annotation.RestController", "org.springframework.web.bind.annotation.RestController");
        importMapping.put("org.springframework.web.bind.annotation.RequestMethod", "org.springframework.web.bind.annotation.RequestMethod");
        String simpleClassName = persistentClass.getSimpleClassName();
        String className = persistentClass.getClassName();
        StringBuffer javacontexts = new StringBuffer();
        String domain = persistentClass.getDomain();
        String controllerPackage = null;
        controllerPackage = StringUtils.isBlank((CharSequence)domain) ? StringUtils.join((Object[])new String[]{rootPackage, ".controller"}) : StringUtils.join((Object[])new String[]{rootPackage, ".controller", ".", domain});
        String controllerSimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Controller"});
        PersistentProperty primaryKey = persistentPropertyService.findPrimaryKey(className);
        importMapping.put(className, className);
        if (primaryKey != null) {
            String primaryKeyClass = primaryKey.getPropertyClass();
            importMapping.put(primaryKeyClass, primaryKeyClass);
        }
        javacontexts.append("package " + controllerPackage + ";" + System.lineSeparator());
        if (importMapping == null || importMapping.isEmpty()) {
            LOGGER.error("\u9519\u8bef\u7684import\u53c2\u6570\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!");
            return null;
        }
        StringBuffer javaBodyContext = new StringBuffer();
        javaBodyContext.append(System.lineSeparator());
        javaBodyContext.append("/**").append(System.lineSeparator());
        javaBodyContext.append(" * ").append(simpleClassName).append("\u4e1a\u52a1\u6a21\u578b\u7684MVC Controller\u5c42\u5b9e\u73b0\uff0c\u57fa\u4e8eHTTP Restful\u98ce\u683c").append(System.lineSeparator());
        javaBodyContext.append(" * @author saturn").append(System.lineSeparator());
        javaBodyContext.append(" */").append(System.lineSeparator());
        javaBodyContext.append("@RestController").append(System.lineSeparator());
        javaBodyContext.append("@RequestMapping(\"/v1/" + TStringUtils.letterLowercase(simpleClassName) + "\")").append(System.lineSeparator());
        javaBodyContext.append("public class " + controllerSimpleClassName + " extends BaseController { ").append(System.lineSeparator());
        javaBodyContext.append(this.buildGlobaVariable(rootPackage, persistentClass, persistentClassService, importMapping));
        javaBodyContext.append(this.buildCreateMethod(persistentClass, importMapping));
        javaBodyContext.append(this.buildUpdateMethod(persistentClass, importMapping));
        javaBodyContext.append(this.buildGetMethod(persistentClass, importMapping));
        javaBodyContext.append(this.buildDeleteMethod(persistentClass, importMapping));
        javaBodyContext.append(this.scanAndBuildCustomUpdateMethods(persistentClass, importMapping, persistentPropertyService, persistentRelationService));
        javaBodyContext.append(this.scanAndBuildCustomQueryMethods(persistentClass, persistentClassService, persistentPropertyService, persistentRelationService, importMapping));
        javaBodyContext.append(this.scanAndBuildRelationQueryMethods(persistentClass, importMapping, persistentClassService, persistentPropertyService, persistentRelationService));
        javaBodyContext.append(this.scanAndbuildUniquenessQueryMethod(persistentClass, importMapping, persistentClassService, persistentPropertyService, persistentRelationService));
        LinkedList importsList = new LinkedList();
        importMapping.keySet().stream().sorted((target, souce) -> StringUtils.compare((String)target, (String)souce)).forEach(importItem -> importsList.add("import " + importItem + ";"));
        String importContext = StringUtils.join((Object[])importsList.toArray(new String[0]), (String)System.lineSeparator());
        javacontexts.append(importContext).append(System.lineSeparator());
        javacontexts.append(javaBodyContext);
        javacontexts.append("} ").append(System.lineSeparator());
        LOGGER.debug("===================" + controllerSimpleClassName + ":" + javacontexts.toString());
        return javacontexts;
    }

    protected StringBuffer buildGlobaVariable(String rootPackageName, PersistentClass persistentClass, PersistentClassService persistentClassService, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        String simpleClassName = persistentClass.getSimpleClassName();
        String domain = persistentClass.getDomain();
        String iServiceClassName = null;
        iServiceClassName = StringUtils.isBlank((CharSequence)domain) ? StringUtils.join((Object[])new String[]{rootPackageName, ".service.", simpleClassName, "Service"}) : StringUtils.join((Object[])new String[]{rootPackageName, ".service.", domain, ".", simpleClassName, "Service"});
        String iServiceSimpleClassName = TStringUtils.getSimpleClassName(iServiceClassName, false);
        String iServiceVar = StringUtils.join((Object[])new String[]{TStringUtils.letterLowercase(simpleClassName), "Service"});
        String controllerSimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Controller"});
        importMapping.put(iServiceClassName, iServiceClassName);
        importMapping.put("org.springframework.beans.factory.annotation.Autowired", "org.springframework.beans.factory.annotation.Autowired");
        importMapping.put("org.slf4j.Logger", "org.slf4j.Logger");
        importMapping.put("org.slf4j.LoggerFactory", "org.slf4j.LoggerFactory");
        codeView.append("  /**").append(System.lineSeparator());
        codeView.append("   * \u65e5\u5fd7").append(System.lineSeparator());
        codeView.append("   */").append(System.lineSeparator());
        codeView.append("  private static final Logger LOGGER = LoggerFactory.getLogger(" + controllerSimpleClassName + ".class);").append(System.lineSeparator());
        codeView.append("  ").append(System.lineSeparator());
        codeView.append("  @Autowired").append(System.lineSeparator());
        codeView.append("  private ").append(iServiceSimpleClassName).append(" " + iServiceVar + ";").append(System.lineSeparator());
        codeView.append(System.lineSeparator());
        return codeView;
    }

    protected StringBuffer buildCreateMethod(PersistentClass persistentClass, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        String persistentClassName = persistentClass.getClassName();
        String simpleClassName = persistentClass.getSimpleClassName();
        String persistentVar = TStringUtils.letterLowercase(simpleClassName);
        String iServiceSimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Service"});
        String iServiceSimpleVar = TStringUtils.letterLowercase(iServiceSimpleClassName);
        importMapping.put(persistentClassName, persistentClassName);
        String desc = "\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efa" + persistentVar + "\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9" + persistentVar + "\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u57fa\u4e8e\uff08" + simpleClassName + "\uff09\u6a21\u578b\u7684\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684" + persistentVar + "JSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09";
        codeView.append("  /**").append(System.lineSeparator());
        codeView.append("   * ").append(desc).append(System.lineSeparator());
        codeView.append("   * */").append(System.lineSeparator());
        codeView.append("  @ApiOperation(value = \"" + desc + "\")").append(System.lineSeparator());
        codeView.append("  @PostMapping(value=\"\")").append(System.lineSeparator());
        codeView.append("  public ResponseModel create(@RequestBody @ApiParam(name=\"" + persistentVar + "\" , value=\"" + desc + "\") " + simpleClassName + " " + persistentVar + ") {").append(System.lineSeparator());
        codeView.append("    try {").append(System.lineSeparator());
        codeView.append("      " + simpleClassName + " current = this." + iServiceSimpleVar + ".create(" + persistentVar + ");").append(System.lineSeparator());
        codeView.append("      return this.buildHttpResultW(current, new String[]{});").append(System.lineSeparator());
        codeView.append("    } catch(RuntimeException e) {").append(System.lineSeparator());
        codeView.append("      LOGGER.error(e.getMessage() , e);").append(System.lineSeparator());
        codeView.append("      return this.buildHttpResultForException(e);").append(System.lineSeparator());
        codeView.append("    }").append(System.lineSeparator());
        codeView.append("  }").append(System.lineSeparator());
        codeView.append(System.lineSeparator());
        return codeView;
    }

    protected StringBuffer buildUpdateMethod(PersistentClass persistentClass, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        String persistentClassName = persistentClass.getClassName();
        String simpleClassName = persistentClass.getSimpleClassName();
        String persistentVar = TStringUtils.letterLowercase(simpleClassName);
        String iServiceSimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Service"});
        String iServiceSimpleVar = TStringUtils.letterLowercase(iServiceSimpleClassName);
        importMapping.put("org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.RequestMapping");
        importMapping.put("io.swagger.annotations.ApiOperation", "io.swagger.annotations.ApiOperation");
        importMapping.put("org.springframework.web.bind.annotation.RequestBody", "org.springframework.web.bind.annotation.RequestBody");
        importMapping.put("org.springframework.web.bind.annotation.PatchMapping", "org.springframework.web.bind.annotation.PatchMapping");
        importMapping.put(persistentClassName, persistentClassName);
        String desc = "\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u66f4\u65b0\u8fc7\u7a0b\u53ea\u4f1a\u66f4\u65b0\u5728\u6a21\u578b\u5c42\u88ab\u6807\u8bb0\u4e3a\u4e86updateable\u7684\u5c5e\u6027\uff0c\u5305\u62ec\u4e00\u822c\u5c5e\u6027\u3001ManyToOne\u548cOneToOne\u6027\u8d28\u7684\u5173\u8054\u5c5e\u6027\uff0c\u800cManyToMany\u3001OneToMany\u7684\u5173\u8054\u5c5e\u6027\uff0c\u867d\u7136\u4e5f\u4f1a\u4f20\u5165\uff0c\u4f46\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5728Service\u5c42\u5b8c\u5584\u5176\u66f4\u65b0\u8fc7\u7a0b\u6ce8\u610f\uff1a\u57fa\u4e8e\u6a21\u578b\uff08" + simpleClassName + "\uff09\u7684\u4fee\u6539\u64cd\u4f5c\u4f20\u5165\u7684" + persistentVar + "JSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u9a8c\u8bc1\u8fd9\u4e2a\u4e3b\u952e\u503c\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09";
        codeView.append("  /**").append(System.lineSeparator());
        codeView.append("   * ").append(desc).append(System.lineSeparator());
        codeView.append("   * */").append(System.lineSeparator());
        codeView.append("  @ApiOperation(value = \"" + desc + "\")").append(System.lineSeparator());
        codeView.append("  @PatchMapping(value=\"\")").append(System.lineSeparator());
        codeView.append("  public ResponseModel update(@RequestBody @ApiParam(name=\"" + persistentVar + "\" , value=\"" + desc + "\") " + simpleClassName + " " + persistentVar + ") {").append(System.lineSeparator());
        codeView.append("    try {").append(System.lineSeparator());
        codeView.append("      " + simpleClassName + " current = this." + iServiceSimpleVar + ".update(" + persistentVar + ");").append(System.lineSeparator());
        codeView.append("      return this.buildHttpResultW(current, new String[]{});").append(System.lineSeparator());
        codeView.append("    } catch(RuntimeException e) {").append(System.lineSeparator());
        codeView.append("      LOGGER.error(e.getMessage() , e);").append(System.lineSeparator());
        codeView.append("      return this.buildHttpResultForException(e);").append(System.lineSeparator());
        codeView.append("    }").append(System.lineSeparator());
        codeView.append("  }").append(System.lineSeparator());
        codeView.append(System.lineSeparator());
        return codeView;
    }

    protected StringBuffer buildGetMethod(PersistentClass persistentClass, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        String persistentClassName = persistentClass.getClassName();
        String simpleClassName = persistentClass.getSimpleClassName();
        String iServiceSimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Service"});
        String iServiceSimpleVar = TStringUtils.letterLowercase(iServiceSimpleClassName);
        importMapping.put(persistentClassName, persistentClassName);
        String desc = "\u76f8\u5173\u7684\u67e5\u8be2\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u901a\u8fc7\u4e3b\u952e\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2";
        codeView.append("  /**").append(System.lineSeparator());
        codeView.append("   * ").append(desc).append(System.lineSeparator());
        codeView.append("   * */").append(System.lineSeparator());
        codeView.append("  @ApiOperation(value = \"" + desc + "\")").append(System.lineSeparator());
        codeView.append("  @GetMapping(value=\"/{id}\")").append(System.lineSeparator());
        codeView.append("  public ResponseModel findById(@PathVariable(\"id\") @ApiParam(name=\"id\" , value=\"\u4e3b\u952e\")String id){ ").append(System.lineSeparator());
        codeView.append("    try {").append(System.lineSeparator());
        codeView.append("      " + simpleClassName + " current = this." + iServiceSimpleVar + ".findById(id);").append(System.lineSeparator());
        codeView.append("      return this.buildHttpResultW(current, new String[]{});").append(System.lineSeparator());
        codeView.append("    } catch(RuntimeException e) {").append(System.lineSeparator());
        codeView.append("      LOGGER.error(e.getMessage() , e);").append(System.lineSeparator());
        codeView.append("      return this.buildHttpResultForException(e);").append(System.lineSeparator());
        codeView.append("    }").append(System.lineSeparator());
        codeView.append("  }").append(System.lineSeparator());
        codeView.append(System.lineSeparator());
        return codeView;
    }

    protected StringBuffer buildDeleteMethod(PersistentClass persistentClass, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        String persistentClassName = persistentClass.getClassName();
        String simpleClassName = persistentClass.getSimpleClassName();
        String iServiceSimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Service"});
        String iServiceSimpleVar = TStringUtils.letterLowercase(iServiceSimpleClassName);
        importMapping.put(persistentClassName, persistentClassName);
        String desc = "\u76f8\u5173\u7684\u67e5\u8be2\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u901a\u8fc7\u4e3b\u952e\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2";
        codeView.append("  /**").append(System.lineSeparator());
        codeView.append("   * ").append(desc).append(System.lineSeparator());
        codeView.append("   * */").append(System.lineSeparator());
        codeView.append("  @ApiOperation(value = \"" + desc + "\")").append(System.lineSeparator());
        codeView.append("  @DeleteMapping(value=\"/{id}\")").append(System.lineSeparator());
        codeView.append("  public ResponseModel deleteById(@PathVariable(\"id\") @ApiParam(name=\"id\" , value=\"\u4e3b\u952e\")String id){ ").append(System.lineSeparator());
        codeView.append("    try {").append(System.lineSeparator());
        codeView.append("      this." + iServiceSimpleVar + ".deleteById(id);").append(System.lineSeparator());
        codeView.append("      return this.buildHttpResult();").append(System.lineSeparator());
        codeView.append("    } catch(RuntimeException e) {").append(System.lineSeparator());
        codeView.append("      LOGGER.error(e.getMessage() , e);").append(System.lineSeparator());
        codeView.append("      return this.buildHttpResultForException(e);").append(System.lineSeparator());
        codeView.append("    }").append(System.lineSeparator());
        codeView.append("  }").append(System.lineSeparator());
        codeView.append(System.lineSeparator());
        return codeView;
    }

    @Override
    protected void buildCustomUpdateMethods(StringBuffer codeView, PersistentUpdateMethod updateMethodItem, PersistentClass persistentClass, Map<String, String> importMapping, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        String persistentClassName = persistentClass.getClassName();
        String simpleClassName = persistentClass.getSimpleClassName();
        String iServiceSimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Service"});
        String iServiceSimpleVar = TStringUtils.letterLowercase(iServiceSimpleClassName);
        importMapping.put(persistentClassName, persistentClassName);
        importMapping.put("org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.RequestMapping");
        importMapping.put("io.swagger.annotations.ApiOperation", "io.swagger.annotations.ApiOperation");
        StringBuffer descParamContexts = new StringBuffer();
        StringBuffer paramContexts = new StringBuffer();
        StringBuffer paramVarContexts = new StringBuffer();
        this.buildCustomUpdateMethodParams(descParamContexts, paramContexts, paramVarContexts, persistentClassName, updateMethodItem, importMapping, persistentPropertyService, persistentRelationService);
        String methodDesc = StringUtils.join((Object[])new String[]{updateMethodItem.getDescription(), "<br>\u8bf7\u6ce8\u610f\uff0c\u81ea\u5b9a\u4e49\u65b9\u6cd5\u6ca1\u6709\u8fd4\u56de\u4fe1\u606f\u3002"});
        String methodName = updateMethodItem.getMethodName();
        codeView.append("  /**").append(System.lineSeparator());
        codeView.append("   * ").append(methodDesc).append(System.lineSeparator());
        codeView.append(descParamContexts);
        codeView.append("   */").append(System.lineSeparator());
        codeView.append("  @ApiOperation(value = \"" + methodDesc + "\")").append(System.lineSeparator());
        codeView.append("  @RequestMapping(value=\"/" + methodName + "\" , method={RequestMethod.PATCH})").append(System.lineSeparator());
        codeView.append("  public ResponseModel " + methodName + "(" + paramVarContexts + ") { ").append(System.lineSeparator());
        codeView.append("    try { ").append(System.lineSeparator());
        codeView.append("      this." + iServiceSimpleVar + "." + methodName + "(" + paramContexts + ");").append(System.lineSeparator());
        codeView.append("      return this.buildHttpReslut();").append(System.lineSeparator());
        codeView.append("    } catch(RuntimeException e) {").append(System.lineSeparator());
        codeView.append("      LOGGER.error(e.getMessage() , e);").append(System.lineSeparator());
        codeView.append("      return this.buildHttpResultForException(e);").append(System.lineSeparator());
        codeView.append("    }").append(System.lineSeparator());
        codeView.append("  } ").append(System.lineSeparator());
    }

    private void buildCustomUpdateMethodParams(StringBuffer descParamContexts, StringBuffer paramContexts, StringBuffer paramVarContexts, String persistentClassName, PersistentUpdateMethod updateMethodItem, Map<String, String> importMapping, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        PersistentProperty relationPrimaryKey;
        String propertyClass;
        String propertyDesc;
        PersistentRelation.RelationType relationType;
        PersistentRelation persistentRelation;
        PersistentProperty persistentProperty;
        int index;
        String[] queryParams = updateMethodItem.getQueryParams();
        String[] updateParams = updateMethodItem.getUpdateParams();
        for (index = 0; index < updateParams.length; ++index) {
            String updateParam = updateParams[index];
            persistentProperty = persistentPropertyService.findByPropertyName(persistentClassName, updateParam);
            if (persistentProperty != null) {
                if (!persistentProperty.getCanUpdate().booleanValue()) {
                    LOGGER.warn("\u5173\u8054\u5c5e\u6027[{}]\u4e0d\u5141\u8bb8\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)updateParam);
                    return;
                }
                if (index != 0) {
                    paramContexts.append(",");
                    paramVarContexts.append(",");
                }
                String propertyClass2 = persistentProperty.getPropertyClass();
                String propertyDesc2 = persistentProperty.getPropertyDesc();
                descParamContexts.append("   * @param _" + updateParam + " \u9700\u66f4\u65b0\u7684\u5b57\u6bb5:" + propertyDesc2 + System.lineSeparator());
                if (StringUtils.indexOf((CharSequence)propertyClass2, (CharSequence)".") != -1) {
                    importMapping.put(propertyClass2, propertyClass2);
                }
                paramContexts.append(" _" + updateParam);
                paramVarContexts.append("@RequestParam(\"" + updateParam + "\") @ApiParam(\" \u9700\u66f4\u65b0\u7684\u5b57\u6bb5:" + propertyDesc2 + "\") " + TStringUtils.getSimpleClassName(propertyClass2, true) + " _" + updateParam);
                continue;
            }
            persistentRelation = persistentRelationService.findByPropertyName(persistentClassName, updateParam);
            if (persistentRelation == null) {
                LOGGER.warn("\u672a\u627e\u5230\u5c5e\u6027[{}]\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)updateParam);
                return;
            }
            if (!persistentRelation.getCanUpdate().booleanValue()) {
                LOGGER.warn("\u5173\u8054\u5c5e\u6027[{}]\u4e0d\u5141\u8bb8\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)updateParam);
                return;
            }
            relationType = persistentRelation.getRelationType();
            if (relationType == PersistentRelation.RelationType.ManyToMany || relationType == PersistentRelation.RelationType.ManyToOne) {
                LOGGER.warn("\u5c5e\u6027[{}]\u5173\u8054\u65b9\u5f0f\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)updateParam);
                return;
            }
            propertyDesc = persistentRelation.getPropertyDesc();
            propertyClass = persistentRelation.getPropertyClass();
            relationPrimaryKey = persistentPropertyService.findPrimaryKey(propertyClass);
            if (relationPrimaryKey == null) {
                LOGGER.warn("\u5173\u8054\u5c5e\u6027[{}]\u6ca1\u6709\u8bbe\u5b9a\u4e3b\u952e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)updateParam);
                return;
            }
            if (index != 0) {
                paramContexts.append(",");
                paramVarContexts.append(",");
            }
            descParamContexts.append("   * @param _" + updateParam + "  \u9700\u66f4\u65b0\u7684\u5b57\u6bb5:" + propertyDesc + System.lineSeparator());
            paramContexts.append(" _" + updateParam);
            paramVarContexts.append("@RequestParam(\"" + updateParam + "\") @ApiParam(\" \u9700\u66f4\u65b0\u7684\u5b57\u6bb5:" + propertyDesc + "\") " + TStringUtils.getSimpleClassName(propertyClass, true) + " _" + updateParam);
        }
        for (index = 0; index < queryParams.length; ++index) {
            String queryParamItem = queryParams[index];
            persistentProperty = persistentPropertyService.findByPropertyName(persistentClassName, queryParamItem);
            if (persistentProperty != null) {
                paramVarContexts.append(",");
                String propertyDesc3 = persistentProperty.getPropertyDesc();
                String propertyClass3 = persistentProperty.getPropertyClass();
                descParamContexts.append("   * @param " + queryParamItem + " \u66f4\u65b0\u4f9d\u636e\uff1a" + propertyDesc3 + System.lineSeparator());
                if (StringUtils.indexOf((CharSequence)propertyClass3, (CharSequence)".") != -1) {
                    importMapping.put(propertyClass3, propertyClass3);
                }
                paramContexts.append("," + queryParamItem);
                paramVarContexts.append("@RequestParam(\"q_" + queryParamItem + "\") @ApiParam(\"\u66f4\u65b0\u4f9d\u636e\uff1a" + propertyDesc3 + "\") " + TStringUtils.getSimpleClassName(propertyClass3, true) + " " + queryParamItem);
                continue;
            }
            persistentRelation = persistentRelationService.findByPropertyName(persistentClassName, queryParamItem);
            if (persistentRelation == null) {
                LOGGER.warn("\u672a\u627e\u5230\u5c5e\u6027[{}]\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)queryParamItem);
                return;
            }
            relationType = persistentRelation.getRelationType();
            if (relationType == PersistentRelation.RelationType.ManyToMany || relationType == PersistentRelation.RelationType.ManyToOne) {
                LOGGER.warn("\u5c5e\u6027[{}]\u5173\u8054\u65b9\u5f0f\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)queryParamItem);
                return;
            }
            propertyDesc = persistentRelation.getPropertyDesc();
            propertyClass = persistentRelation.getPropertyClass();
            relationPrimaryKey = persistentPropertyService.findPrimaryKey(propertyClass);
            if (relationPrimaryKey == null) {
                LOGGER.warn("\u5173\u8054\u5c5e\u6027[{}]\u6ca1\u6709\u8bbe\u5b9a\u4e3b\u952e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)queryParamItem);
                return;
            }
            paramVarContexts.append(",");
            propertyClass = relationPrimaryKey.getPropertyClass();
            descParamContexts.append("   * @param " + queryParamItem + " \u66f4\u65b0\u4f9d\u636e\uff1a" + propertyDesc + System.lineSeparator());
            paramContexts.append("," + queryParamItem);
            paramVarContexts.append("@RequestParam(\"q_" + queryParamItem + "\") @ApiParam(\"\u66f4\u65b0\u4f9d\u636e\uff1a" + propertyDesc + "\") " + TStringUtils.getSimpleClassName(propertyClass, true) + " " + queryParamItem + " ");
        }
    }

    @Override
    protected void buildRelationQueryMethods(StringBuffer codeView, PersistentClass persistentClass, PersistentRelation persistentRelation, PersistentProperty relationPrimaryProperty, PersistentClassService persistentClassService, Map<String, String> importMapping) {
    }

    @Override
    protected void buildCustomQueryMethods(StringBuffer codeView, PersistentClass persistentClass, PersistentQueryMethod queryMethodItem, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping) {
        String persistentClassName = persistentClass.getClassName();
        String simpleClassName = persistentClass.getSimpleClassName();
        String iServiceSimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Service"});
        String iServiceSimpleVar = TStringUtils.letterLowercase(iServiceSimpleClassName);
        importMapping.put(persistentClassName, persistentClassName);
        importMapping.put("org.springframework.web.bind.annotation.RequestParam", "org.springframework.web.bind.annotation.RequestParam");
        importMapping.put("org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.RequestMapping");
        importMapping.put("io.swagger.annotations.ApiOperation", "io.swagger.annotations.ApiOperation");
        importMapping.put("java.util.List", "java.util.List");
        String methodDesc = queryMethodItem.getDescription();
        String methodName = queryMethodItem.getMethodName();
        String[] params = queryMethodItem.getParams();
        LinkedHashSet<String> filterParamsVars = new LinkedHashSet<String>();
        StringBuffer paramsContexts = new StringBuffer();
        StringBuffer propertyVarNames = new StringBuffer();
        List<PersistentRelation> persistentRelations = persistentClass.getRelations();
        List filterParamsList = persistentRelations.stream().map(PersistentRelation::getPropertyName).collect(Collectors.toList());
        filterParamsVars.addAll(filterParamsList);
        for (String param : params) {
            String[] paramItems = StringUtils.split((String)param, (String)".");
            this.foundRelationParams(persistentClass, persistentClass, paramItems, 0, persistentClassService, persistentPropertyService, persistentRelationService, importMapping, paramsContexts, propertyVarNames, filterParamsVars);
        }
        importMapping.put("java.util.List", "java.util.List");
        importMapping.put(persistentClassName, persistentClassName);
        codeView.append("  /**").append(System.lineSeparator());
        codeView.append("   * ").append(methodDesc).append(System.lineSeparator());
        codeView.append("   */").append(System.lineSeparator());
        codeView.append("  @ApiOperation(value = \"" + methodDesc + "\")").append(System.lineSeparator());
        codeView.append("  @RequestMapping(value=\"/" + methodName + "\" , method={RequestMethod.GET})").append(System.lineSeparator());
        codeView.append("  public ResponseModel " + methodName + "(" + paramsContexts + ") { ").append(System.lineSeparator());
        codeView.append("    try {").append(System.lineSeparator());
        codeView.append("      List<" + simpleClassName + "> result = this." + iServiceSimpleVar + "." + methodName + "(" + propertyVarNames + "); ").append(System.lineSeparator());
        String filterParamsVarsContexts = "\"" + StringUtils.join((Object[])filterParamsVars.toArray(new String[0]), (String)"\",\"");
        codeView.append("      return this.buildHttpReslut(result, new String[]{" + filterParamsVarsContexts + "\"}); ").append(System.lineSeparator());
        codeView.append("    } catch(RuntimeException e) {").append(System.lineSeparator());
        codeView.append("      LOGGER.error(e.getMessage() , e);").append(System.lineSeparator());
        codeView.append("      return this.buildHttpResultForException(e);").append(System.lineSeparator());
        codeView.append("    } ").append(System.lineSeparator());
        codeView.append("  } ").append(System.lineSeparator());
    }

    private void foundRelationParams(PersistentClass rootPrsistentClass, PersistentClass currentPrsistentClass, String[] paramArrayItems, int itemIndex, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping, StringBuffer paramsContexts, StringBuffer propertyVarNames, Set<String> filterParamsVars) {
        Validate.notNull((Object)rootPrsistentClass, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u63cf\u8ff0[rootPrsistentClass]!!", (Object[])new Object[0]);
        Validate.notNull((Object)currentPrsistentClass, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u63cf\u8ff0[currentPrsistentClass]!!", (Object[])new Object[0]);
        Validate.isTrue((filterParamsVars != null && !filterParamsVars.isEmpty() ? 1 : 0) != 0, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u4e2d\u7684\u6307\u5b9a\u5c5e\u6027!!", (Object[])new Object[0]);
        if (paramArrayItems == null) {
            return;
        }
        if (paramArrayItems.length == 1) {
            String param;
            String className = rootPrsistentClass.getClassName();
            PersistentProperty persistentProperty = persistentPropertyService.findByPropertyName(className, param = paramArrayItems[0]);
            if (persistentProperty == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5c5e\u6027\u4fe1\u606f\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            String desc = persistentProperty.getPropertyDesc();
            String propertyClass = persistentProperty.getPropertyClass();
            if (paramsContexts.length() != 0) {
                paramsContexts.append(" , ");
                propertyVarNames.append(" , ");
            }
            if (StringUtils.indexOf((CharSequence)propertyClass, (CharSequence)".") != -1) {
                importMapping.put(propertyClass, propertyClass);
            }
            propertyVarNames.append(param);
            importMapping.put("org.springframework.web.bind.annotation.RequestParam", "org.springframework.web.bind.annotation.RequestParam");
            paramsContexts.append("@RequestParam(\"" + param + "\") @ApiParam(\"" + desc + "\") " + TStringUtils.getSimpleClassName(propertyClass, true) + " " + param);
        } else if (paramArrayItems.length == itemIndex + 1) {
            String param;
            List<PersistentRelation> persistentRelations = currentPrsistentClass.getRelations();
            String className = currentPrsistentClass.getClassName();
            PersistentProperty persistentProperty = persistentPropertyService.findByPropertyName(className, param = paramArrayItems[itemIndex]);
            if (persistentProperty == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5c5e\u6027\u4fe1\u606f\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            String propertyClass = persistentProperty.getPropertyClass();
            String desc = persistentProperty.getPropertyDesc();
            String params = StringUtils.join((Object[])paramArrayItems, (String)"_");
            String parentParams = StringUtils.join((Object[])paramArrayItems, (String)".", (int)0, (int)itemIndex);
            String currentParam = paramArrayItems[itemIndex - 1];
            List filterParamsList = persistentRelations.stream().filter(item -> !StringUtils.equalsIgnoreCase((CharSequence)item.getPropertyName(), (CharSequence)currentParam)).map(item -> parentParams + "." + item.getPropertyName()).collect(Collectors.toList());
            filterParamsVars.addAll(filterParamsList);
            for (int index = 1; index <= paramArrayItems.length - 1; ++index) {
                String currentParentParams = StringUtils.join((Object[])paramArrayItems, (String)".", (int)0, (int)index);
                filterParamsVars.remove(currentParentParams);
            }
            if (paramsContexts.length() != 0) {
                paramsContexts.append(" , ");
                propertyVarNames.append(" , ");
            }
            if (StringUtils.indexOf((CharSequence)propertyClass, (CharSequence)".") != -1) {
                importMapping.put(propertyClass, propertyClass);
            }
            propertyVarNames.append(params);
            paramsContexts.append("@RequestParam(\"" + param + "\") @ApiParam(\"" + desc + "\")" + TStringUtils.getSimpleClassName(propertyClass, true) + " " + params);
        } else {
            String propertyName = paramArrayItems[itemIndex];
            String className = currentPrsistentClass.getClassName();
            PersistentRelation persistentRelation = persistentRelationService.findByPropertyName(className, propertyName);
            if (persistentRelation == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5173\u8054\u5c5e\u6027\u4fe1\u606f\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            String propertyClass = persistentRelation.getPropertyClass();
            PersistentClass nextPersistentClass = persistentClassService.queryByClassName(propertyClass);
            if (nextPersistentClass == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5173\u8054\u5c5e\u6027\u4fe1\u606f\u7684\u7c7b\u578b\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            this.foundRelationParams(rootPrsistentClass, nextPersistentClass, paramArrayItems, itemIndex + 1, persistentClassService, persistentPropertyService, persistentRelationService, importMapping, paramsContexts, propertyVarNames, filterParamsVars);
        }
    }

    @Override
    protected void buildUniquenessQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping) {
        String simpleClassName = persistentClass.getSimpleClassName();
        String propertyName = persistentProperty.getPropertyName();
        String propertyDesc = persistentProperty.getPropertyDesc();
        String propertyClassName = persistentProperty.getPropertyClass();
        String propertySimpleClassName = TStringUtils.getSimpleClassName(propertyClassName, false);
        importMapping.put(propertyClassName, propertyClassName);
        importMapping.put("org.springframework.web.bind.annotation.RequestParam", "org.springframework.web.bind.annotation.RequestParam");
        importMapping.put("org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.RequestMapping");
        importMapping.put("io.swagger.annotations.ApiOperation", "io.swagger.annotations.ApiOperation");
        String methodName = "findBy" + TStringUtils.letterUppercase(propertyName);
        String desc = "\u6309\u7167" + simpleClassName + "\u5b9e\u4f53\u4e2d\u7684\uff08" + propertyName + "\uff09" + propertyDesc + "\u8fdb\u884c\u67e5\u8be2";
        codeView.append("  /**" + System.lineSeparator());
        codeView.append("   * " + desc + System.lineSeparator());
        codeView.append("   * @param " + propertyName + " " + propertyDesc + System.lineSeparator());
        codeView.append("   */" + System.lineSeparator());
        codeView.append("  @ApiOperation(value = \"" + desc + "\")" + System.lineSeparator());
        codeView.append("  @RequestMapping(value=\"/" + methodName + "\" , method={RequestMethod.GET})" + System.lineSeparator());
        codeView.append("  public ResponseModel " + methodName + "(@RequestParam(\"" + propertyName + "\") @ApiParam(\"" + propertyDesc + "\") " + propertySimpleClassName + " " + propertyName + ") {" + System.lineSeparator());
        String iServiceSimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Service"});
        String iServiceSimpleVar = TStringUtils.letterLowercase(iServiceSimpleClassName);
        codeView.append("    try { ").append(System.lineSeparator());
        codeView.append("      " + simpleClassName + " result = this." + iServiceSimpleVar + "." + methodName + "(" + propertyName + "); ").append(System.lineSeparator());
        codeView.append("      return this.buildHttpResultW(result, new String[]{}); ").append(System.lineSeparator());
        codeView.append("    } catch(RuntimeException e) {").append(System.lineSeparator());
        codeView.append("      LOGGER.error(e.getMessage() , e);").append(System.lineSeparator());
        codeView.append("      return this.buildHttpResultForException(e);").append(System.lineSeparator());
        codeView.append("    } ").append(System.lineSeparator());
        codeView.append("  }  ").append(System.lineSeparator());
    }

    @Override
    protected void buildDetailsQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        this.buildDetailsQueryMethod(codeView, persistentClass, persistentProperty, importMapping, persistentClassService, false);
    }

    @Override
    protected void buildDetailsQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentRelation persistentRelation, Map<String, String> importMapping, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        PersistentProperty persistentProperty = new PersistentProperty();
        persistentProperty.setPropertyName(persistentRelation.getPropertyName());
        persistentProperty.setPropertyDesc("\u5173\u8054\u7684 " + persistentRelation.getPropertyDesc());
        PersistentProperty relationProperty = persistentPropertyService.findPrimaryKey(persistentRelation.getPropertyClass());
        persistentProperty.setPropertyClass(relationProperty.getPropertyClass());
        if (persistentRelation.getRelationType() == PersistentRelation.RelationType.ManyToOne || persistentRelation.getRelationType() == PersistentRelation.RelationType.ManyToMany) {
            this.buildDetailsQueryMethod(codeView, persistentClass, persistentProperty, importMapping, persistentClassService, true);
        } else {
            this.buildDetailsQueryMethod(codeView, persistentClass, persistentProperty, importMapping, persistentClassService, false);
        }
    }

    private void buildDetailsQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping, PersistentClassService persistentClassService, boolean isSet) {
        String simpleClassName = persistentClass.getSimpleClassName();
        String propertyName = persistentProperty.getPropertyName();
        String propertyDesc = persistentProperty.getPropertyDesc();
        String propertyClassName = persistentProperty.getPropertyClass();
        String propertySimpleClassName = TStringUtils.getSimpleClassName(propertyClassName, true);
        importMapping.put(propertyClassName, propertyClassName);
        importMapping.put("org.springframework.web.bind.annotation.RequestParam", "org.springframework.web.bind.annotation.RequestParam");
        importMapping.put("org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.RequestMapping");
        importMapping.put("io.swagger.annotations.ApiOperation", "io.swagger.annotations.ApiOperation");
        String methodName = "findDetailsBy" + TStringUtils.letterUppercase(propertyName);
        String desc = "\u6309\u7167" + simpleClassName + "\u5b9e\u4f53\u4e2d\u7684\uff08" + propertyName + "\uff09" + propertyDesc + "\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002";
        codeView.append("  /**" + System.lineSeparator());
        codeView.append("   * " + desc + System.lineSeparator());
        codeView.append("   * @param " + propertyName + " " + propertyDesc + System.lineSeparator());
        codeView.append("   */" + System.lineSeparator());
        codeView.append("  @ApiOperation(value = \"" + desc + "\")" + System.lineSeparator());
        codeView.append("  @RequestMapping(value=\"/" + methodName + "\" , method={RequestMethod.GET})" + System.lineSeparator());
        codeView.append("  public ResponseModel " + methodName + "(@RequestParam(\"" + propertyName + "\") @ApiParam(\"" + propertyDesc + "\") " + propertySimpleClassName + " " + propertyName + ") {" + System.lineSeparator());
        String iServiceSimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Service"});
        String iServiceSimpleVar = TStringUtils.letterLowercase(iServiceSimpleClassName);
        codeView.append("    try { ").append(System.lineSeparator());
        if (isSet) {
            importMapping.put("java.util.Set", "java.util.Set");
            codeView.append("      Set<" + simpleClassName + "> result = this." + iServiceSimpleVar + "." + methodName + "(" + propertyName + "); ").append(System.lineSeparator());
        } else {
            codeView.append("      " + simpleClassName + " result = this." + iServiceSimpleVar + "." + methodName + "(" + propertyName + "); ").append(System.lineSeparator());
        }
        String relationFieldNameValues = "";
        Set<String> relationFieldNameValueSet = persistentClassService.isFormInstancePersistent(persistentClass.getClassName()) ? this.buildAllWhiteProperties(persistentClass, persistentClassService) : this.buildWhiteProperties(persistentClass, persistentClassService);
        if (relationFieldNameValueSet != null && !relationFieldNameValueSet.isEmpty()) {
            Object[] returnPropertiesFilterArray = relationFieldNameValueSet.toArray(new String[0]);
            relationFieldNameValues = "\"" + StringUtils.join((Object[])returnPropertiesFilterArray, (String)"\",\"") + "\"";
        }
        codeView.append("      return this.buildHttpResultW(result, new String[]{" + relationFieldNameValues + "}); ").append(System.lineSeparator());
        codeView.append("    } catch(RuntimeException e) {").append(System.lineSeparator());
        codeView.append("      LOGGER.error(e.getMessage() , e);").append(System.lineSeparator());
        codeView.append("      return this.buildHttpResultForException(e);").append(System.lineSeparator());
        codeView.append("    } ").append(System.lineSeparator());
        codeView.append("  }  ").append(System.lineSeparator());
    }

    @Override
    protected void buildPkQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty pkProperty, Map<String, String> importMapping) {
    }

    @Override
    protected void buildPkDeleteMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping, PersistentClassService persistentClassService) {
    }
}

