/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.saturn.scan;

import com.bizunited.nebula.saturn.engine.annotation.SaturnColumn;
import com.bizunited.nebula.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.nebula.saturn.engine.annotation.SaturnDefaultController;
import com.bizunited.nebula.saturn.engine.annotation.SaturnEntity;
import com.bizunited.nebula.saturn.engine.annotation.SaturnValidate;
import com.bizunited.nebula.saturn.model.PersistentProperty;
import com.bizunited.nebula.saturn.model.PersistentRelation;
import com.bizunited.nebula.saturn.scan.JavassistAnalysis;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaTagJavassistAnalysis
extends JavassistAnalysis {
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaTagJavassistAnalysis.class);

    @Override
    protected PersistentProperty analysisGeneralField(CtField fieldItem, int fieldIndex) {
        boolean hasSaturnValidateAnnotation;
        boolean insertable;
        boolean hasSaturnColumnAnnotation = fieldItem.hasAnnotation(SaturnColumn.class);
        boolean hasColumnAnnotation = fieldItem.hasAnnotation(Column.class);
        boolean hasPrimaryKeyAnnotation = fieldItem.hasAnnotation(Id.class);
        boolean hasSaturnDefaultControllerAnnotation = fieldItem.hasAnnotation(SaturnDefaultController.class);
        if (!(hasSaturnColumnAnnotation || hasColumnAnnotation || hasPrimaryKeyAnnotation)) {
            return null;
        }
        CtClass fieldType = null;
        String fieldTypeName = null;
        String realClassName = null;
        String fieldName = fieldItem.getName();
        ClassPool classPool = ClassPool.getDefault();
        CtClass collectionClass = null;
        boolean isCollectionInterface = false;
        try {
            fieldType = fieldItem.getType();
            collectionClass = classPool.get("java.util.Collection");
            isCollectionInterface = fieldType.subtypeOf(collectionClass);
            realClassName = fieldItem.getFieldInfo().getDescriptor();
            if (fieldType instanceof CtPrimitiveType) {
                CtPrimitiveType primitiveType = (CtPrimitiveType)fieldType;
                fieldTypeName = primitiveType.getWrapperName();
            } else {
                fieldTypeName = fieldType.getName();
            }
            realClassName = fieldItem.getFieldInfo().getDescriptor();
        }
        catch (NotFoundException e) {
            LOGGER.debug(e.getMessage());
            return null;
        }
        Validate.isTrue((realClassName.indexOf("[") == -1 ? 1 : 0) != 0, (String)("\u5728\u626b\u63cf\u9759\u6001\u6a21\u578b\u5c5e\u6027\u65f6\u53d1\u73b0\u6570\u7ec4\u5b9a\u4e49\uff08" + fieldName + "\uff09\uff0c\u8bf7\u6539\u7528\u5173\u8054\u6a21\u578b\u8fdb\u884c\u63cf\u8ff0\u3002"), (Object[])new Object[0]);
        if (!(StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.lang.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.math.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.util.") && !isCollectionInterface)) {
            return null;
        }
        PersistentProperty property = new PersistentProperty();
        property.setPropertyClass(fieldTypeName);
        property.setPropertyName(fieldName);
        property.setIndex(fieldIndex);
        property.setPropertyClass(fieldType.getName());
        if (hasSaturnColumnAnnotation) {
            SaturnColumn saturnColumnAnnotation;
            try {
                saturnColumnAnnotation = (SaturnColumn)fieldItem.getAnnotation(SaturnColumn.class);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn(e.getMessage());
                return null;
            }
            insertable = true;
            try {
                insertable = saturnColumnAnnotation.insertable();
            }
            catch (Exception e) {
                insertable = true;
            }
            property.setCanInsert(insertable);
            boolean nullable = true;
            try {
                nullable = saturnColumnAnnotation.nullable();
            }
            catch (Exception e) {
                nullable = true;
            }
            property.setNullable(nullable);
            boolean pkColumn = false;
            try {
                pkColumn = saturnColumnAnnotation.pkColumn();
            }
            catch (Exception e) {
                pkColumn = false;
            }
            property.setPrimaryKey(pkColumn);
            boolean unique = false;
            try {
                unique = saturnColumnAnnotation.unique();
            }
            catch (Exception e) {
                unique = false;
            }
            property.setUnique(unique);
            boolean updatable = false;
            try {
                updatable = saturnColumnAnnotation.updatable();
            }
            catch (Exception e) {
                updatable = false;
            }
            property.setCanUpdate(updatable);
            String description = "";
            try {
                description = saturnColumnAnnotation.description();
            }
            catch (Exception e) {
                description = "";
            }
            property.setPropertyDesc(description);
            Integer maxLength = null;
            try {
                maxLength = saturnColumnAnnotation.length();
            }
            catch (Exception e) {
                maxLength = null;
            }
            property.setMaxLen(maxLength);
        }
        if (hasColumnAnnotation) {
            Column columnAnnotation;
            try {
                columnAnnotation = (Column)fieldItem.getAnnotation(Column.class);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn(e.getMessage());
                return null;
            }
            insertable = true;
            try {
                insertable = columnAnnotation.insertable();
            }
            catch (Exception e) {
                insertable = true;
            }
            property.setCanInsert(insertable);
            boolean canUpdate = true;
            try {
                columnAnnotation.updatable();
            }
            catch (Exception e) {
                canUpdate = true;
            }
            property.setCanUpdate(canUpdate);
            boolean nullable = true;
            try {
                nullable = columnAnnotation.nullable();
            }
            catch (Exception e) {
                nullable = true;
            }
            property.setNullable(nullable);
            String propertyDbName = "";
            try {
                propertyDbName = columnAnnotation.name();
            }
            catch (Exception e) {
                propertyDbName = "";
            }
            property.setPropertyDbName(propertyDbName);
            boolean unique = false;
            try {
                unique = columnAnnotation.unique();
            }
            catch (Exception e) {
                unique = false;
            }
            property.setUnique(unique);
            Integer maxLength = null;
            try {
                maxLength = columnAnnotation.length();
            }
            catch (Exception e) {
                maxLength = null;
            }
            property.setMaxLen(maxLength);
        }
        if (hasSaturnDefaultControllerAnnotation) {
            SaturnDefaultController saturnDefaultController;
            try {
                saturnDefaultController = (SaturnDefaultController)fieldItem.getAnnotation(SaturnDefaultController.class);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn(e.getMessage());
                return null;
            }
            String defaultKeys = "";
            try {
                defaultKeys = saturnDefaultController.defaultKeys();
            }
            catch (Exception e) {
                defaultKeys = "";
            }
            property.setDefaultKeys(defaultKeys);
            String defaultValues = "";
            try {
                defaultValues = saturnDefaultController.defaultValues();
            }
            catch (Exception e) {
                defaultValues = "";
            }
            property.setDefaultValues(defaultValues);
            String defaultType = "";
            try {
                defaultType = saturnDefaultController.defaultType().toString();
            }
            catch (Exception e) {
                defaultType = "";
            }
            property.setDefaultType(defaultType);
            if (saturnDefaultController.defaultType() == SaturnDefaultController.Type.RADIO || saturnDefaultController.defaultType() == SaturnDefaultController.Type.SELECT || saturnDefaultController.defaultType() == SaturnDefaultController.Type.CHECKBOX) {
                Validate.isTrue((!StringUtils.isBlank((CharSequence)defaultKeys) && !StringUtils.isBlank((CharSequence)defaultValues) ? 1 : 0) != 0, (String)"\u5f53\u9ed8\u8ba4\u63a7\u4ef6\u6307\u5b9a\u4e3aRADIO\u6216\u8005SELECT\u6216\u8005CHECKBOX\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9aK-V\u7684\u9ed8\u8ba4\u8bbe\u5b9a\u503c\uff08defaultKeys\u3001defaultValues\uff09", (Object[])new Object[0]);
            }
        }
        if (hasPrimaryKeyAnnotation) {
            property.setPrimaryKey(true);
            property.setCanUpdate(false);
            property.setUnique(true);
            property.setPropertyDbName("id");
            property.setNullable(false);
            property.setPropertyDesc("\u4e3b\u952e");
            property.setIndex(1);
        }
        if (hasSaturnValidateAnnotation = fieldItem.hasAnnotation(SaturnValidate.class)) {
            SaturnValidate saturnValidateAnnotation;
            try {
                saturnValidateAnnotation = (SaturnValidate)fieldItem.getAnnotation(SaturnValidate.class);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn(e.getMessage());
                return null;
            }
            property.setValidateType(saturnValidateAnnotation.type());
        }
        String className = fieldItem.getDeclaringClass().getName();
        Validate.notBlank((CharSequence)property.getPropertyDesc(), (String)("\u5fc5\u987b\u4f7f\u7528SaturnColumn\u6ce8\u89e3\u5b8c\u6210\u5b57\u6bb5\u540d\u79f0\u7684\u63cf\u8ff0:[" + className + ":" + fieldItem.getName() + ":" + property.getPropertyClass() + "]"), (Object[])new Object[0]);
        return property;
    }

    @Override
    protected PersistentRelation analysisRelationField(Class<?> reflectClass, CtField fieldItem, int fieldIndex) {
        boolean insertable;
        CtClass paramsClass;
        boolean hasJoinColumnAnnotation = fieldItem.hasAnnotation(JoinColumn.class);
        boolean hasJoinTableAnnotation = fieldItem.hasAnnotation(JoinTable.class);
        boolean hasManyToOneAnnotation = fieldItem.hasAnnotation(ManyToOne.class);
        boolean hasManyToManyAnnotation = fieldItem.hasAnnotation(ManyToMany.class);
        boolean hasOneToManyAnnotation = fieldItem.hasAnnotation(OneToMany.class);
        boolean hasOneToOneAnnotation = fieldItem.hasAnnotation(OneToOne.class);
        boolean hasSaturnRelationAnnotation = fieldItem.hasAnnotation(SaturnColumnRelation.class);
        if (!(hasJoinColumnAnnotation || hasManyToOneAnnotation || hasManyToManyAnnotation || hasOneToManyAnnotation || hasOneToOneAnnotation || hasSaturnRelationAnnotation)) {
            return null;
        }
        boolean hasSaturnColumnAnnotation = fieldItem.hasAnnotation(SaturnColumn.class);
        CtClass fieldType = null;
        String fieldTypeName = null;
        String fieldName = fieldItem.getName();
        String realClassName = null;
        try {
            fieldType = fieldItem.getType();
            if (fieldType instanceof CtPrimitiveType) {
                return null;
            }
            fieldTypeName = fieldType.getName();
            realClassName = fieldItem.getFieldInfo().getDescriptor();
        }
        catch (NotFoundException e) {
            LOGGER.debug(e.getMessage());
            return null;
        }
        Validate.isTrue((realClassName.indexOf("[") == -1 ? 1 : 0) != 0, (String)("\u5728\u626b\u63cf\u9759\u6001\u6a21\u578b\u5c5e\u6027\u65f6\u53d1\u73b0\u6570\u7ec4\u5b9a\u4e49\uff08" + fieldName + "\uff09\uff0c\u8bf7\u6539\u7528\u5173\u8054\u6a21\u578b\u8fdb\u884c\u63cf\u8ff0\u3002"), (Object[])new Object[0]);
        if (StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.lang.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.math.") || StringUtils.equals((CharSequence)fieldTypeName, (CharSequence)"java.util.Date")) {
            return null;
        }
        boolean isCollectionInterface = false;
        ClassPool classPool = ClassPool.getDefault();
        try {
            Field reflectField;
            Type genericType;
            CtClass collectionClass = classPool.get("java.util.Collection");
            isCollectionInterface = fieldType.subtypeOf(collectionClass);
            if (isCollectionInterface && (genericType = (reflectField = reflectClass.getDeclaredField(fieldName)).getGenericType()) instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                fieldTypeName = genericClazz.getName();
            }
        }
        catch (NoSuchFieldException | SecurityException | NotFoundException e) {
            LOGGER.warn(e.getMessage());
            return null;
        }
        try {
            paramsClass = classPool.get(fieldTypeName);
        }
        catch (NotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        boolean hasEntityAnnotation = paramsClass.hasAnnotation(Entity.class);
        boolean hasSaturnEntityAnnotation = paramsClass.hasAnnotation(SaturnEntity.class);
        if (!hasEntityAnnotation && !hasSaturnEntityAnnotation) {
            return null;
        }
        PersistentRelation relation = new PersistentRelation();
        relation.setPropertyClass(fieldTypeName);
        relation.setPropertyName(fieldName);
        relation.setIndex(fieldIndex);
        if (hasSaturnColumnAnnotation) {
            SaturnColumn saturnColumnAnnotation;
            try {
                saturnColumnAnnotation = (SaturnColumn)fieldItem.getAnnotation(SaturnColumn.class);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn(e.getMessage());
                return null;
            }
            insertable = true;
            try {
                insertable = saturnColumnAnnotation.insertable();
            }
            catch (Exception e) {
                insertable = true;
            }
            relation.setCanInsert(insertable);
            boolean nullable = true;
            try {
                nullable = saturnColumnAnnotation.nullable();
            }
            catch (Exception e) {
                nullable = true;
            }
            relation.setNullable(nullable);
            boolean updatable = false;
            try {
                updatable = saturnColumnAnnotation.updatable();
            }
            catch (Exception e) {
                updatable = false;
            }
            relation.setCanUpdate(updatable);
            String description = "";
            try {
                description = saturnColumnAnnotation.description();
            }
            catch (Exception e) {
                description = "";
            }
            relation.setPropertyDesc(description);
        }
        if (hasJoinColumnAnnotation) {
            JoinColumn columnAnnotation;
            try {
                columnAnnotation = (JoinColumn)fieldItem.getAnnotation(JoinColumn.class);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn(e.getMessage());
                return null;
            }
            insertable = true;
            try {
                insertable = columnAnnotation.insertable();
            }
            catch (Exception e) {
                insertable = true;
            }
            relation.setCanInsert(insertable);
            boolean canUpdate = true;
            try {
                canUpdate = columnAnnotation.updatable();
            }
            catch (Exception e) {
                canUpdate = true;
            }
            relation.setCanUpdate(canUpdate);
            boolean nullable = true;
            try {
                nullable = columnAnnotation.nullable();
            }
            catch (Exception e) {
                nullable = true;
            }
            relation.setNullable(nullable);
            String propertyDbName = "";
            try {
                propertyDbName = columnAnnotation.name();
            }
            catch (Exception e) {
                propertyDbName = "";
            }
            relation.setPropertyDbName(propertyDbName);
        }
        if (hasManyToOneAnnotation) {
            relation.setRelationType(PersistentRelation.RelationType.ManyToOne);
            relation.setCanInsert(false);
            relation.setCanUpdate(false);
        } else if (hasManyToManyAnnotation) {
            if (!this.analysisGeneraManyToMany(relation, fieldItem, hasJoinTableAnnotation)) {
                return null;
            }
        } else if (hasOneToManyAnnotation) {
            if (!this.analysisGeneraOneToMany(relation, fieldItem)) {
                return null;
            }
        } else if (hasOneToOneAnnotation) {
            if (!this.analysisGeneraOneToOne(relation, fieldItem)) {
                return null;
            }
        } else if (hasSaturnRelationAnnotation) {
            if (!this.analysisGeneraSaturnColumnRelation(relation, fieldItem)) {
                return null;
            }
        } else {
            LOGGER.warn("\u9519\u8bef\u7684\u5173\u8054\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u5efa\u6a21\u60c5\u51b5");
            return null;
        }
        String className = fieldItem.getDeclaringClass().getName();
        Validate.notBlank((CharSequence)relation.getPropertyDesc(), (String)("\u5fc5\u987b\u4f7f\u7528SaturnColumn\u6ce8\u89e3\u5b8c\u6210\u5b57\u6bb5\u540d\u79f0\u7684\u63cf\u8ff0[" + className + ":" + fieldItem.getName() + ":" + relation.getPropertyClass() + "]"), (Object[])new Object[0]);
        return relation;
    }

    private boolean analysisGeneraSaturnColumnRelation(PersistentRelation relation, CtField fieldItem) {
        SaturnColumnRelation saturnRelationAnnotation;
        try {
            saturnRelationAnnotation = (SaturnColumnRelation)fieldItem.getAnnotation(SaturnColumnRelation.class);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn(e.getMessage() + "\uff1a\u9519\u8bef\u7684\u5173\u8054\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u5efa\u6a21\u60c5\u51b5");
            return false;
        }
        SaturnColumnRelation.RelationType pRelationType = saturnRelationAnnotation.type();
        if (pRelationType == SaturnColumnRelation.RelationType.ManyToMany) {
            relation.setRelationType(PersistentRelation.RelationType.ManyToMany);
            relation.setCanInsert(false);
            relation.setCanUpdate(false);
            relation.setMasterMapping(saturnRelationAnnotation.master());
            relation.setMappedBy(saturnRelationAnnotation.mappedBy());
        } else if (pRelationType == SaturnColumnRelation.RelationType.ManyToOne) {
            relation.setRelationType(PersistentRelation.RelationType.ManyToOne);
            relation.setCanInsert(false);
            relation.setCanUpdate(false);
        } else if (pRelationType == SaturnColumnRelation.RelationType.OneToMany) {
            relation.setRelationType(PersistentRelation.RelationType.OneToMany);
            relation.setCanInsert(true);
            relation.setCanUpdate(true);
            relation.setMappedBy(saturnRelationAnnotation.mappedBy());
        } else if (pRelationType == SaturnColumnRelation.RelationType.OneToOne) {
            relation.setRelationType(PersistentRelation.RelationType.OneToOne);
            relation.setCanInsert(true);
            relation.setCanUpdate(true);
            relation.setMappedBy(saturnRelationAnnotation.mappedBy());
        }
        String mappedBy = "";
        try {
            mappedBy = saturnRelationAnnotation.mappedBy();
        }
        catch (Exception e) {
            mappedBy = null;
        }
        relation.setMappedBy(mappedBy);
        return true;
    }

    private boolean analysisGeneraOneToOne(PersistentRelation relation, CtField fieldItem) {
        relation.setRelationType(PersistentRelation.RelationType.OneToOne);
        relation.setCanInsert(true);
        relation.setCanUpdate(true);
        String mappedBy = "";
        try {
            OneToOne oneToOneAnnotation = (OneToOne)fieldItem.getAnnotation(OneToOne.class);
            mappedBy = oneToOneAnnotation.mappedBy();
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn(e.getMessage());
            return false;
        }
        catch (Exception e) {
            mappedBy = null;
        }
        relation.setMappedBy(mappedBy);
        return true;
    }

    private boolean analysisGeneraOneToMany(PersistentRelation relation, CtField fieldItem) {
        relation.setRelationType(PersistentRelation.RelationType.OneToMany);
        relation.setCanInsert(true);
        relation.setCanUpdate(true);
        String mappedBy = "";
        try {
            OneToMany oneToManyAnnotation = (OneToMany)fieldItem.getAnnotation(OneToMany.class);
            mappedBy = oneToManyAnnotation.mappedBy();
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn(e.getMessage());
            return false;
        }
        catch (Exception e) {
            mappedBy = null;
        }
        relation.setMappedBy(mappedBy);
        return true;
    }

    private boolean analysisGeneraManyToMany(PersistentRelation relation, CtField fieldItem, boolean hasJoinTableAnnotation) {
        relation.setRelationType(PersistentRelation.RelationType.ManyToMany);
        relation.setCanInsert(false);
        relation.setCanUpdate(false);
        String mappedBy = "";
        try {
            ManyToMany manyToManyAnnotation = (ManyToMany)fieldItem.getAnnotation(ManyToMany.class);
            mappedBy = manyToManyAnnotation.mappedBy();
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn(e.getMessage());
            return false;
        }
        catch (Exception e) {
            mappedBy = null;
        }
        relation.setMappedBy(mappedBy);
        if (hasJoinTableAnnotation) {
            try {
                JoinTable joinTableAnnotation = (JoinTable)fieldItem.getAnnotation(JoinTable.class);
                String mappingTableName = joinTableAnnotation.name();
                JoinColumn[] joinColumns = joinTableAnnotation.joinColumns();
                JoinColumn joinColumn = joinColumns[0];
                String mappingDbPropertyName = joinColumn.name();
                JoinColumn[] inverseJoinColumns = joinTableAnnotation.inverseJoinColumns();
                JoinColumn inverseJoinColumn = inverseJoinColumns[0];
                String mappingDbInversePropertyName = inverseJoinColumn.name();
                relation.setMappingDbPropertyName(mappingDbPropertyName);
                relation.setMappingInverseDbPropertyName(mappingDbInversePropertyName);
                relation.setMappingTable(mappingTableName);
                relation.setMasterMapping(true);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
                return false;
            }
        }
        return true;
    }
}

