/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.saturn.engine.handler;

import com.bizunited.nebula.saturn.context.SaturnContext;
import com.bizunited.nebula.saturn.context.service.PersistentClassService;
import com.bizunited.nebula.saturn.context.service.PersistentPropertyService;
import com.bizunited.nebula.saturn.context.service.PersistentRelationService;
import com.bizunited.nebula.saturn.engine.handler.AbstractGenerateHandler;
import com.bizunited.nebula.saturn.model.PersistentClass;
import com.bizunited.nebula.saturn.model.PersistentProperty;
import com.bizunited.nebula.saturn.model.PersistentQueryMethod;
import com.bizunited.nebula.saturn.model.PersistentRelation;
import com.bizunited.nebula.saturn.model.PersistentUpdateMethod;
import com.bizunited.nebula.saturn.utils.TStringUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateJpaRepositoryGenerateHandler
extends AbstractGenerateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateJpaRepositoryGenerateHandler.class);

    @Override
    public Void handle(SaturnContext context) {
        String rootPackage = context.getRootPackage();
        String projectAbsolutePath = context.getProjectAbsolutePath();
        String projectSrcAbsolutePath = StringUtils.join((Object[])new String[]{projectAbsolutePath, "/", context.getProjectSrcPath()});
        Validate.notBlank((CharSequence)rootPackage, (String)"\u5fc5\u987b\u6307\u5b9a\u6839\u5305\u8def\u5f84[rootPackages]\uff0c\u624d\u80fd\u5728\u6839\u5305\u8def\u5f84\u7684\u4f4d\u7f6e\u5b8c\u6210\u6570\u636e\u5c42\u4ee3\u7801\u751f\u6210", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)projectSrcAbsolutePath, (String)"\u5fc5\u987b\u6307\u5b9a\u4e3b\u4ee3\u7801\u8def\u5f84[projectSrcAbsolutePath]", (Object[])new Object[0]);
        PersistentClassService persistentClassService = context.getPersistentClassService();
        Validate.notNull((Object)persistentClassService, (String)"not found persistentClassService!!error", (Object[])new Object[0]);
        List<PersistentClass> persistentClasses = persistentClassService.queryAllClasses();
        Validate.isTrue((persistentClasses != null && !persistentClasses.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u6a21\u578b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u524d\u7f6e\u8fd0\u884c\u626b\u63cf\u5668", (Object[])new Object[0]);
        PersistentPropertyService persistentPropertyService = context.getPersistentPropertyService();
        PersistentRelationService persistentRelationService = context.getPersistentRelationService();
        Validate.notNull((Object)persistentPropertyService, (String)"not found persistentPropertyService!!error", (Object[])new Object[0]);
        Validate.notNull((Object)persistentRelationService, (String)"not found persistentRelationService!!error", (Object[])new Object[0]);
        List entityPersistentClasses = persistentClasses.stream().filter(PersistentClass::getRepositoryEntity).collect(Collectors.toList());
        if (entityPersistentClasses != null && entityPersistentClasses.isEmpty()) {
            LOGGER.warn("\u672a\u53d1\u73b0\u57fa\u4e8e\u6570\u636e\u5c42\u5b9a\u4e49\u7684\u6a21\u578b\u89c4\u8303\uff0c\u6570\u636e\u5c42JPA\u751f\u6210\u8fc7\u7a0b\u7ec8\u6b62!!");
            return null;
        }
        if (context.getOnlyBuildVo().booleanValue()) {
            return null;
        }
        for (PersistentClass itemPersistentClass : entityPersistentClasses) {
            HashMap<String, String> importMapping = new HashMap<String, String>();
            String simpleClassName = itemPersistentClass.getSimpleClassName();
            String persistentClassName = itemPersistentClass.getClassName();
            String persistentPackageName = TStringUtils.getPreviousPackage(persistentClassName);
            String domain = itemPersistentClass.getDomain();
            String repositoryInternalPackage = null;
            String repositoryPackage = null;
            if (IGNOREPACKAGES.contains(persistentPackageName)) continue;
            if (StringUtils.isBlank((CharSequence)domain)) {
                repositoryInternalPackage = StringUtils.join((Object[])new String[]{rootPackage, ".repository.internal"});
                repositoryPackage = StringUtils.join((Object[])new String[]{rootPackage, ".repository"});
            } else {
                repositoryInternalPackage = StringUtils.join((Object[])new String[]{rootPackage, ".repository.internal.", domain});
                repositoryPackage = StringUtils.join((Object[])new String[]{rootPackage, ".repository.", domain});
            }
            String repositorySimpleClass = StringUtils.join((Object[])new String[]{simpleClassName, "Repository"});
            String customRepositorySimpleClass = StringUtils.join((Object[])new String[]{simpleClassName, "RepositoryCustom"});
            String customRepositoryImplSimpleClass = StringUtils.join((Object[])new String[]{simpleClassName, "RepositoryImpl"});
            if (itemPersistentClass.getRepositoryEntity().booleanValue() && StringUtils.isBlank((CharSequence)itemPersistentClass.getRepositoryTable())) continue;
            try {
                StringBuffer customeRepositoryImplContext;
                StringBuffer repositoryFileContext = this.buildRepositoryFileContext(itemPersistentClass, importMapping, rootPackage, persistentClassService, persistentPropertyService, persistentRelationService);
                if (repositoryFileContext != null) {
                    this.buildJavaFile(repositoryFileContext.toString(), projectSrcAbsolutePath, repositoryPackage, repositorySimpleClass);
                }
                if (!itemPersistentClass.getBuildCustomRepository().booleanValue()) continue;
                StringBuffer customRepositoryContext = this.buildCustomRepositoryFileContext(itemPersistentClass, rootPackage);
                if (customRepositoryContext != null) {
                    this.buildJavaFile(customRepositoryContext.toString(), projectSrcAbsolutePath, repositoryInternalPackage, customRepositorySimpleClass);
                }
                if ((customeRepositoryImplContext = this.buildCustomRepositoryImplFileContext(itemPersistentClass, rootPackage)) == null) continue;
                this.buildJavaFile(customeRepositoryImplContext.toString(), projectSrcAbsolutePath, repositoryInternalPackage, customRepositoryImplSimpleClass);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
                e.printStackTrace(System.out);
            }
        }
        return null;
    }

    private StringBuffer buildCustomRepositoryFileContext(PersistentClass persistentClass, String rootPackage) {
        String persistentClassName = persistentClass.getClassName();
        String simpleClassName = persistentClass.getSimpleClassName();
        String domain = persistentClass.getDomain();
        String repositoryInternalPackage = null;
        repositoryInternalPackage = StringUtils.isBlank((CharSequence)domain) ? StringUtils.join((Object[])new String[]{rootPackage, ".repository.internal"}) : StringUtils.join((Object[])new String[]{rootPackage, ".repository.internal.", domain});
        String customRepositorySimpleClass = StringUtils.join((Object[])new String[]{simpleClassName, "RepositoryCustom"});
        StringBuffer code = new StringBuffer();
        code.append("package ").append(repositoryInternalPackage).append(";").append(System.lineSeparator());
        code.append("import org.springframework.data.domain.Page;").append(System.lineSeparator());
        code.append("import org.springframework.data.domain.Pageable;").append(System.lineSeparator());
        code.append("import ").append(persistentClassName).append(";").append(System.lineSeparator());
        code.append("/**").append(System.lineSeparator());
        code.append(" * ").append(simpleClassName).append("\u6a21\u578b\u7684\u6570\u636e\u5c42\u81ea\u5b9a\u4e49\u63a5\u53e3\uff0c\u53ef\u4ee5\u7531\u7a0b\u5e8f\u5458\u6839\u636e\u5b9e\u9645\u60c5\u51b5\u5b8c\u5584").append(System.lineSeparator());
        code.append(" * @author saturn").append(System.lineSeparator());
        code.append(" */").append(System.lineSeparator());
        code.append("public interface ").append(customRepositorySimpleClass).append(" {").append(System.lineSeparator());
        code.append("  /**").append(System.lineSeparator());
        code.append("   * \u8fd9\u662f\u5206\u9875\u65b9\u6cd5\u7684\u96cf\u5f62\uff0c\u53ef\u4ee5\u6839\u636e\u4e1a\u52a1\u8981\u6c42\u8fdb\u884c\u4fee\u6539").append(System.lineSeparator());
        code.append("   */").append(System.lineSeparator());
        code.append("  Page<").append(simpleClassName).append("> queryPage(Pageable pageable);").append(System.lineSeparator());
        code.append("}").append(System.lineSeparator());
        return code;
    }

    private StringBuffer buildCustomRepositoryImplFileContext(PersistentClass persistentClass, String rootPackage) {
        String persistentClassName = persistentClass.getClassName();
        String simpleClassName = persistentClass.getSimpleClassName();
        String domain = persistentClass.getDomain();
        String repositoryInternalPackage = null;
        repositoryInternalPackage = StringUtils.isBlank((CharSequence)domain) ? StringUtils.join((Object[])new String[]{rootPackage, ".repository.internal"}) : StringUtils.join((Object[])new String[]{rootPackage, ".repository.internal.", domain});
        String customRepositorySimpleClass = StringUtils.join((Object[])new String[]{simpleClassName, "RepositoryCustom"});
        String customRepositoryImplSimpleClass = StringUtils.join((Object[])new String[]{simpleClassName, "RepositoryImpl"});
        StringBuffer code = new StringBuffer();
        code.append("package ").append(repositoryInternalPackage).append(";").append(System.lineSeparator());
        code.append("import javax.persistence.EntityManager;").append(System.lineSeparator());
        code.append("import javax.persistence.PersistenceContext;").append(System.lineSeparator());
        code.append("import java.util.HashMap;").append(System.lineSeparator());
        code.append("import java.util.Map;").append(System.lineSeparator());
        code.append(System.lineSeparator());
        code.append("import org.springframework.beans.factory.annotation.Autowired;").append(System.lineSeparator());
        code.append("import org.springframework.data.domain.Page;").append(System.lineSeparator());
        code.append("import org.springframework.data.domain.Pageable;").append(System.lineSeparator());
        code.append("import com.bizunited.nebula.common.repository.PageRepositoryImpl;").append(System.lineSeparator());
        code.append("import ").append(persistentClassName).append(";").append(System.lineSeparator());
        code.append("/**").append(System.lineSeparator());
        code.append(" * ").append(simpleClassName).append("\u6a21\u578b\u7684\u6570\u636e\u5c42\u81ea\u5b9a\u4e49\u63a5\u53e3\u5b9e\u73b0\uff0c\u53ef\u4ee5\u7531\u7a0b\u5e8f\u5458\u6839\u636e\u5b9e\u9645\u60c5\u51b5\u5b8c\u5584").append(System.lineSeparator());
        code.append(" * @author saturn").append(System.lineSeparator());
        code.append(" */").append(System.lineSeparator());
        code.append("public class ").append(customRepositoryImplSimpleClass).append(" implements ").append(customRepositorySimpleClass).append(", PageRepositoryImpl").append(" {").append(System.lineSeparator());
        code.append("  @Autowired").append(System.lineSeparator());
        code.append("  @PersistenceContext").append(System.lineSeparator());
        code.append("  private EntityManager entityManager;").append(System.lineSeparator());
        code.append("  @Override").append(System.lineSeparator());
        code.append("  public Page<").append(simpleClassName).append("> queryPage(Pageable pageable) {").append(System.lineSeparator());
        code.append("  StringBuilder hql = new StringBuilder(\"from ").append(simpleClassName).append(" c where 1=1\");").append(System.lineSeparator());
        code.append("  StringBuilder countHql = new StringBuilder(\"select count(*) FROM ").append(simpleClassName).append(" c where 1=1\");").append(System.lineSeparator());
        code.append("  StringBuilder condition = new StringBuilder();").append(System.lineSeparator());
        code.append("  Map<String, Object> parameters = new HashMap<>();").append(System.lineSeparator());
        code.append("  // TODO \u8fd9\u91cc\u7684\u4ee3\u7801\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5b8c\u5584\u2014\u2014\u6784\u9020\u81ea\u5b9a\u4e49\u6761\u4ef6").append(System.lineSeparator());
        code.append("  hql.append(condition);").append(System.lineSeparator());
        code.append("  countHql.append(condition);").append(System.lineSeparator());
        code.append("  return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);").append(System.lineSeparator());
        code.append("  }").append(System.lineSeparator());
        code.append("}").append(System.lineSeparator());
        return code;
    }

    private StringBuffer buildRepositoryFileContext(PersistentClass persistentClass, Map<String, String> importMapping, String rootPackage, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        String simpleClassName = persistentClass.getSimpleClassName();
        String className = persistentClass.getClassName();
        String domain = persistentClass.getDomain();
        StringBuffer javacontexts = new StringBuffer();
        String repositoryPackage = null;
        String repositoryInternalPackage = null;
        if (StringUtils.isBlank((CharSequence)domain)) {
            repositoryPackage = StringUtils.join((Object[])new String[]{rootPackage, ".repository"});
            repositoryInternalPackage = StringUtils.join((Object[])new String[]{rootPackage, ".repository.internal"});
        } else {
            repositoryPackage = StringUtils.join((Object[])new String[]{rootPackage, ".repository.", domain});
            repositoryInternalPackage = StringUtils.join((Object[])new String[]{rootPackage, ".repository.internal.", domain});
        }
        String repositorySimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Repository"});
        String repositoryInternalSimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "RepositoryCustom"});
        String repositoryInternalClassName = StringUtils.join((Object[])new String[]{repositoryInternalPackage, ".", repositoryInternalSimpleClassName});
        PersistentProperty primaryKey = persistentPropertyService.findPrimaryKey(className);
        String primaryKeyClass = primaryKey.getPropertyClass();
        importMapping.put(primaryKeyClass, primaryKeyClass);
        javacontexts.append("package " + repositoryPackage + ";" + System.lineSeparator());
        if (importMapping == null || importMapping.isEmpty()) {
            LOGGER.error("\u9519\u8bef\u7684import\u53c2\u6570\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!");
            return null;
        }
        importMapping.put("org.springframework.data.jpa.repository.JpaRepository", "org.springframework.data.jpa.repository.JpaRepository");
        importMapping.put("org.springframework.data.jpa.repository.JpaSpecificationExecutor", "org.springframework.data.jpa.repository.JpaSpecificationExecutor");
        importMapping.put("org.springframework.stereotype.Repository", "org.springframework.stereotype.Repository");
        importMapping.put(className, className);
        if (persistentClass.getBuildCustomRepository().booleanValue()) {
            importMapping.put(repositoryInternalClassName, repositoryInternalClassName);
        }
        StringBuffer javaBodyContext = new StringBuffer();
        javaBodyContext.append(System.lineSeparator());
        javaBodyContext.append("/**").append(System.lineSeparator());
        javaBodyContext.append(" * ").append(simpleClassName).append("\u4e1a\u52a1\u6a21\u578b\u7684\u6570\u636e\u5e93\u65b9\u6cd5\u652f\u6301").append(System.lineSeparator());
        javaBodyContext.append(" * @author saturn").append(System.lineSeparator());
        javaBodyContext.append(" */").append(System.lineSeparator());
        javaBodyContext.append("@Repository(\"_").append(simpleClassName).append("Repository\")").append(System.lineSeparator());
        javaBodyContext.append("public interface ").append(repositorySimpleClassName).append(System.lineSeparator());
        javaBodyContext.append("    extends").append(System.lineSeparator());
        javaBodyContext.append("      JpaRepository<").append(TStringUtils.getSimpleClassName(className, false)).append(", ").append(TStringUtils.getSimpleClassName(primaryKeyClass, false)).append(">").append(System.lineSeparator());
        javaBodyContext.append("      ,JpaSpecificationExecutor<").append(TStringUtils.getSimpleClassName(className, false)).append(">").append(System.lineSeparator());
        if (persistentClass.getBuildCustomRepository().booleanValue()) {
            javaBodyContext.append("      ,").append(repositoryInternalSimpleClassName).append(" ").append(System.lineSeparator());
        }
        javaBodyContext.append("  {").append(System.lineSeparator());
        StringBuffer methodContexts = this.scanAndBuildRelationQueryMethods(persistentClass, importMapping, persistentClassService, persistentPropertyService, persistentRelationService);
        javaBodyContext.append(methodContexts);
        javaBodyContext.append(System.lineSeparator());
        methodContexts = this.scanAndbuildUniquenessQueryMethod(persistentClass, importMapping, persistentClassService, persistentPropertyService, persistentRelationService);
        javaBodyContext.append(methodContexts);
        javaBodyContext.append(System.lineSeparator());
        methodContexts = this.scanAndBuildCustomQueryMethods(persistentClass, persistentClassService, persistentPropertyService, persistentRelationService, importMapping);
        javaBodyContext.append(methodContexts);
        javaBodyContext.append(System.lineSeparator());
        methodContexts = this.scanAndBuildCustomUpdateMethods(persistentClass, importMapping, persistentPropertyService, persistentRelationService);
        javaBodyContext.append(methodContexts);
        javaBodyContext.append(System.lineSeparator());
        LinkedList importsList = new LinkedList();
        importMapping.keySet().stream().sorted((target, souce) -> StringUtils.compare((String)target, (String)souce)).forEach(importItem -> importsList.add("import " + importItem + ";"));
        String importContext = StringUtils.join((Object[])importsList.toArray(new String[0]), (String)System.lineSeparator());
        javacontexts.append(importContext).append(System.lineSeparator());
        javacontexts.append(javaBodyContext);
        javacontexts.append("}");
        LOGGER.debug("===================" + repositorySimpleClassName + ":" + javacontexts.toString());
        return javacontexts;
    }

    @Override
    protected void buildCustomQueryMethods(StringBuffer codeView, PersistentClass persistentClass, PersistentQueryMethod queryMethodItem, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping) {
        String simpleClassName = persistentClass.getSimpleClassName();
        String methodName = queryMethodItem.getMethodName();
        String description = queryMethodItem.getDescription();
        String[] params = queryMethodItem.getParams();
        PersistentQueryMethod.QueryType[] queryTypes = queryMethodItem.getQueryTypes();
        String[] orderByParams = queryMethodItem.getOrderByParams();
        PersistentQueryMethod.OrderType[] orderTypes = queryMethodItem.getOrderTypes();
        if (StringUtils.isBlank((CharSequence)description) || params == null || params.length == 0 || queryTypes == null || queryTypes.length == 0 || params.length != queryTypes.length) {
            LOGGER.warn("\u81ea\u5b9a\u4e49\u67e5\u8be2[{}]\uff0c\u5b58\u5728\u53c2\u6570\u9519\u8bef\uff0c\u5ffd\u7565\u4e00\u4e2a\u9519\u8bef\u7684\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u5efa\uff0c\u8bf7\u68c0\u67e5!!", (Object)simpleClassName);
            return;
        }
        StringBuffer descParamsContexts = new StringBuffer();
        StringBuffer leftJoinContexts = new StringBuffer();
        StringBuffer conditionParamsContexts = new StringBuffer();
        StringBuffer paramsContexts = new StringBuffer();
        String currentParamAlis = TStringUtils.letterLowercase(simpleClassName);
        for (String param : params) {
            String[] paramItems = StringUtils.split((String)param, (String)".");
            this.foundRelationParams(persistentClass, persistentClass, paramItems, 0, persistentClassService, persistentPropertyService, persistentRelationService, importMapping, descParamsContexts, leftJoinContexts, conditionParamsContexts, paramsContexts, currentParamAlis);
        }
        codeView.append("  /**").append(System.lineSeparator());
        codeView.append("   * ").append(description).append(System.lineSeparator());
        codeView.append(descParamsContexts);
        codeView.append("   */").append(System.lineSeparator());
        codeView.append("  @Query(\"select distinct ").append(currentParamAlis).append(" from ").append(simpleClassName).append(" ").append(currentParamAlis).append(" \"").append(System.lineSeparator());
        codeView.append(leftJoinContexts);
        codeView.append("      + \" where ").append(conditionParamsContexts).append(" \" ");
        if (orderByParams != null && orderTypes != null && orderByParams.length == orderTypes.length) {
            StringBuffer orderContxt = new StringBuffer(System.lineSeparator() + "      + \" order by ");
            for (int index = 0; index < orderByParams.length; ++index) {
                if (index != 0) {
                    orderContxt.append(",");
                }
                String orderByParam = orderByParams[index];
                PersistentQueryMethod.OrderType orderType = orderTypes[index];
                orderContxt.append(TStringUtils.letterLowercase(simpleClassName)).append(".").append(orderByParam).append(" ").append(orderType == PersistentQueryMethod.OrderType.ASC ? "asc" : "desc");
            }
            codeView.append(orderContxt).append(" \" ");
        }
        codeView.append(")").append(System.lineSeparator());
        importMapping.put("java.util.List", "java.util.List");
        codeView.append("  List<" + simpleClassName + "> " + methodName + "(" + paramsContexts + ");");
        codeView.append(System.lineSeparator()).append(System.lineSeparator());
    }

    private void foundRelationParams(PersistentClass rootPrsistentClass, PersistentClass currentPrsistentClass, String[] paramArrayItems, int itemIndex, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping, StringBuffer descParamsContexts, StringBuffer leftJoinContexts, StringBuffer conditionParamsContexts, StringBuffer paramsContexts, String currentParamAlis) {
        Validate.notNull((Object)rootPrsistentClass, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u63cf\u8ff0[rootPrsistentClass]!!", (Object[])new Object[0]);
        Validate.notNull((Object)currentPrsistentClass, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u63cf\u8ff0[currentPrsistentClass]!!", (Object[])new Object[0]);
        Validate.isTrue((paramArrayItems != null && paramArrayItems.length > 0 ? 1 : 0) != 0, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u4e2d\u7684\u6307\u5b9a\u5c5e\u6027!!", (Object[])new Object[0]);
        if (paramArrayItems.length == 1) {
            String param;
            String simpleClassName = rootPrsistentClass.getSimpleClassName();
            String className = rootPrsistentClass.getClassName();
            PersistentProperty persistentProperty = persistentPropertyService.findByPropertyName(className, param = paramArrayItems[0]);
            if (persistentProperty == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5c5e\u6027\u4fe1\u606f\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            String propertyClass = persistentProperty.getPropertyClass();
            String propertyDesc = persistentProperty.getPropertyDesc();
            String buildParam = TStringUtils.letterLowercase(simpleClassName) + "_" + param;
            descParamsContexts.append("   * @param " + buildParam + " " + propertyDesc + System.lineSeparator());
            if (conditionParamsContexts.length() != 0) {
                conditionParamsContexts.append(" and ");
            }
            conditionParamsContexts.append(TStringUtils.letterLowercase(simpleClassName) + "." + param + "=:" + buildParam);
            if (paramsContexts.length() != 0) {
                paramsContexts.append(" , ");
            }
            if (StringUtils.indexOf((CharSequence)propertyClass, (CharSequence)".") != -1) {
                importMapping.put(propertyClass, propertyClass);
            }
            paramsContexts.append("@Param(\"" + buildParam + "\") " + TStringUtils.getSimpleClassName(propertyClass, true) + " " + buildParam);
        } else if (paramArrayItems.length != 1 && paramArrayItems.length == itemIndex + 1) {
            String className = currentPrsistentClass.getClassName();
            String param = paramArrayItems[itemIndex];
            String nextParamAlis = currentParamAlis + "_" + param;
            PersistentProperty persistentProperty = persistentPropertyService.findByPropertyName(className, param);
            if (persistentProperty == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5c5e\u6027\u4fe1\u606f\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            String propertyClass = persistentProperty.getPropertyClass();
            String propertyDesc = persistentProperty.getPropertyDesc();
            descParamsContexts.append("   * @param " + nextParamAlis + " " + propertyDesc + System.lineSeparator());
            if (conditionParamsContexts.length() != 0) {
                conditionParamsContexts.append(" and ");
            }
            conditionParamsContexts.append(currentParamAlis + "." + param + "=:" + nextParamAlis);
            if (paramsContexts.length() != 0) {
                paramsContexts.append(" , ");
            }
            if (StringUtils.indexOf((CharSequence)propertyClass, (CharSequence)".") != -1) {
                importMapping.put(propertyClass, propertyClass);
            }
            paramsContexts.append("@Param(\"" + nextParamAlis + "\") " + TStringUtils.getSimpleClassName(propertyClass, true) + " " + nextParamAlis);
        } else {
            String propertyName = paramArrayItems[itemIndex];
            String className = currentPrsistentClass.getClassName();
            PersistentRelation persistentRelation = persistentRelationService.findByPropertyName(className, propertyName);
            if (persistentRelation == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5173\u8054\u5c5e\u6027\u4fe1\u606f\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            String propertyClass = persistentRelation.getPropertyClass();
            PersistentClass nextPersistentClass = persistentClassService.queryByClassName(propertyClass);
            if (nextPersistentClass == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5173\u8054\u5c5e\u6027\u4fe1\u606f\u7684\u7c7b\u578b\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            String nextParamAlis = currentParamAlis + "_" + propertyName;
            leftJoinContexts.append("      + \" left join fetch " + currentParamAlis + "." + propertyName + " " + nextParamAlis + " \" " + System.lineSeparator());
            this.foundRelationParams(rootPrsistentClass, nextPersistentClass, paramArrayItems, itemIndex + 1, persistentClassService, persistentPropertyService, persistentRelationService, importMapping, descParamsContexts, leftJoinContexts, conditionParamsContexts, paramsContexts, nextParamAlis);
        }
    }

    @Override
    protected void buildCustomUpdateMethods(StringBuffer codeView, PersistentUpdateMethod updateMethodItem, PersistentClass persistentClass, Map<String, String> importMapping, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        PersistentProperty relationPrimaryKey;
        String propertyClass;
        String propertyDesc;
        String propertyDbName;
        PersistentRelation.RelationType relationType;
        PersistentRelation persistentRelation;
        String propertyDbName2;
        PersistentProperty persistentProperty;
        int index;
        String[] queryParams = updateMethodItem.getQueryParams();
        String[] updateParams = updateMethodItem.getUpdateParams();
        String repositoryTable = persistentClass.getRepositoryTable();
        String targetClassName = persistentClass.getClassName();
        String description = updateMethodItem.getDescription();
        String methodName = updateMethodItem.getMethodName();
        importMapping.put("org.springframework.data.jpa.repository.Modifying", "org.springframework.data.jpa.repository.Modifying");
        StringBuffer descParamContexts = new StringBuffer();
        StringBuffer updateContexts = new StringBuffer();
        StringBuffer conditionContexts = new StringBuffer();
        StringBuffer paramContexts = new StringBuffer();
        for (index = 0; index < updateParams.length; ++index) {
            String updateParam = updateParams[index];
            persistentProperty = persistentPropertyService.findByPropertyName(targetClassName, updateParam);
            if (persistentProperty != null) {
                if (!persistentProperty.getCanUpdate().booleanValue()) {
                    LOGGER.warn("\u5173\u8054\u5c5e\u6027[{}]\u4e0d\u5141\u8bb8\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)updateParam);
                    return;
                }
                if (index != 0) {
                    updateContexts.append(",");
                    paramContexts.append(",");
                }
                propertyDbName2 = persistentProperty.getPropertyDbName();
                String propertyClass2 = persistentProperty.getPropertyClass();
                String propertyDesc2 = persistentProperty.getPropertyDesc();
                descParamContexts.append("   * @param _" + updateParam + " " + propertyDesc2 + System.lineSeparator());
                updateContexts.append(propertyDbName2 + "=:_" + updateParam);
                if (StringUtils.indexOf((CharSequence)propertyClass2, (CharSequence)".") != -1) {
                    importMapping.put(propertyClass2, propertyClass2);
                }
                importMapping.put("org.springframework.data.repository.query.Param", "org.springframework.data.repository.query.Param");
                paramContexts.append("@Param(\"_" + updateParam + "\")" + TStringUtils.getSimpleClassName(propertyClass2, true) + " _" + updateParam);
                continue;
            }
            persistentRelation = persistentRelationService.findByPropertyName(targetClassName, updateParam);
            if (persistentRelation == null) {
                LOGGER.warn("\u672a\u627e\u5230\u5c5e\u6027[{}]\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)updateParam);
                return;
            }
            if (!persistentRelation.getCanUpdate().booleanValue()) {
                LOGGER.warn("\u5173\u8054\u5c5e\u6027[{}]\u4e0d\u5141\u8bb8\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)updateParam);
                return;
            }
            relationType = persistentRelation.getRelationType();
            if (relationType == PersistentRelation.RelationType.ManyToMany || relationType == PersistentRelation.RelationType.ManyToOne) {
                LOGGER.warn("\u5c5e\u6027[{}]\u5173\u8054\u65b9\u5f0f\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)updateParam);
                return;
            }
            propertyDbName = persistentRelation.getPropertyDbName();
            propertyDesc = persistentRelation.getPropertyDesc();
            propertyClass = persistentRelation.getPropertyClass();
            relationPrimaryKey = persistentPropertyService.findPrimaryKey(propertyClass);
            if (relationPrimaryKey == null) {
                LOGGER.warn("\u5173\u8054\u5c5e\u6027[{}]\u6ca1\u6709\u8bbe\u5b9a\u4e3b\u952e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)updateParam);
                return;
            }
            if (index != 0) {
                updateContexts.append(",");
                paramContexts.append(",");
            }
            propertyClass = relationPrimaryKey.getPropertyClass();
            descParamContexts.append("   * @param _" + updateParam + " " + propertyDesc + System.lineSeparator());
            updateContexts.append(propertyDbName + "=:_" + updateParam);
            if (StringUtils.indexOf((CharSequence)propertyClass, (CharSequence)".") != -1) {
                importMapping.put(propertyClass, propertyClass);
            }
            importMapping.put("org.springframework.data.repository.query.Param", "org.springframework.data.repository.query.Param");
            paramContexts.append("@Param(\"_" + updateParam + "\")" + TStringUtils.getSimpleClassName(propertyClass, true) + " _" + updateParam);
        }
        for (index = 0; index < queryParams.length; ++index) {
            String queryParamItem = queryParams[index];
            persistentProperty = persistentPropertyService.findByPropertyName(targetClassName, queryParamItem);
            if (persistentProperty != null) {
                if (index != 0) {
                    conditionContexts.append(" AND ");
                }
                paramContexts.append(",");
                propertyDbName2 = persistentProperty.getPropertyDbName();
                String propertyDesc3 = persistentProperty.getPropertyDesc();
                String propertyClass3 = persistentProperty.getPropertyClass();
                descParamContexts.append("   * @param " + queryParamItem + " " + propertyDesc3 + System.lineSeparator());
                conditionContexts.append(propertyDbName2 + "=:" + queryParamItem);
                if (StringUtils.indexOf((CharSequence)propertyClass3, (CharSequence)".") != -1) {
                    importMapping.put(propertyClass3, propertyClass3);
                }
                paramContexts.append("@Param(\"" + queryParamItem + "\")" + TStringUtils.getSimpleClassName(propertyClass3, true) + " " + queryParamItem);
                continue;
            }
            persistentRelation = persistentRelationService.findByPropertyName(targetClassName, queryParamItem);
            if (persistentRelation == null) {
                LOGGER.warn("\u672a\u627e\u5230\u5c5e\u6027[{}]\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)queryParamItem);
                return;
            }
            relationType = persistentRelation.getRelationType();
            if (relationType == PersistentRelation.RelationType.ManyToMany || relationType == PersistentRelation.RelationType.ManyToOne) {
                LOGGER.warn("\u5c5e\u6027[]\u5173\u8054\u65b9\u5f0f\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)queryParamItem);
                return;
            }
            propertyDbName = persistentRelation.getPropertyDbName();
            propertyDesc = persistentRelation.getPropertyDesc();
            propertyClass = persistentRelation.getPropertyClass();
            relationPrimaryKey = persistentPropertyService.findPrimaryKey(propertyClass);
            if (relationPrimaryKey == null) {
                LOGGER.warn("\u5173\u8054\u5c5e\u6027[{}]\u6ca1\u6709\u8bbe\u5b9a\u4e3b\u952e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!", (Object)queryParamItem);
                return;
            }
            if (index != 0) {
                conditionContexts.append(" AND ");
            }
            paramContexts.append(",");
            propertyClass = relationPrimaryKey.getPropertyClass();
            descParamContexts.append("   * @param " + queryParamItem + " " + propertyDesc + System.lineSeparator());
            conditionContexts.append(propertyDbName + "=:" + queryParamItem);
            if (StringUtils.indexOf((CharSequence)propertyClass, (CharSequence)".") != -1) {
                importMapping.put(propertyClass, propertyClass);
            }
            paramContexts.append("@Param(\"" + queryParamItem + "\")" + TStringUtils.getSimpleClassName(propertyClass, true) + " " + queryParamItem + " ");
        }
        codeView.append("  /**" + System.lineSeparator());
        codeView.append("   * " + description + System.lineSeparator());
        codeView.append(descParamContexts);
        codeView.append("   */" + System.lineSeparator());
        codeView.append("  @Modifying" + System.lineSeparator());
        codeView.append("  @Query(value=\"update " + repositoryTable + " set " + updateContexts + " where " + conditionContexts + "\" , nativeQuery=true)" + System.lineSeparator());
        codeView.append("  void " + methodName + "(" + paramContexts + ");" + System.lineSeparator());
        codeView.append(System.lineSeparator());
    }

    @Override
    protected void buildRelationQueryMethods(StringBuffer codeView, PersistentClass persistentClass, PersistentRelation persistentRelation, PersistentProperty relationPrimaryProperty, PersistentClassService persistentClassService, Map<String, String> importMapping) {
    }

    @Override
    protected void buildUniquenessQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping) {
        String persistentSimpleClassName = persistentClass.getSimpleClassName();
        String propertyName = persistentProperty.getPropertyName();
        String propertyDesc = persistentProperty.getPropertyDesc();
        String propertyClassName = persistentProperty.getPropertyClass();
        String propertySimpleClassName = TStringUtils.getSimpleClassName(propertyClassName, true);
        importMapping.put(propertyClassName, propertyClassName);
        importMapping.put("org.springframework.data.repository.query.Param", "org.springframework.data.repository.query.Param");
        importMapping.put("org.springframework.data.jpa.repository.Query", "org.springframework.data.jpa.repository.Query");
        codeView.append("  /**").append(System.lineSeparator());
        codeView.append("   * \u6309\u7167" + propertyDesc + "\u8fdb\u884c\u67e5\u8be2").append(System.lineSeparator());
        codeView.append("   * @param " + propertyName + " " + propertyDesc).append(System.lineSeparator());
        codeView.append("   * */").append(System.lineSeparator());
        codeView.append("  @Query(\" from " + persistentSimpleClassName + " f where f." + propertyName + " = :" + propertyName + "\")").append(System.lineSeparator());
        codeView.append("  " + persistentSimpleClassName + " findBy" + TStringUtils.letterUppercase(propertyName) + "(@Param(\"" + propertyName + "\") " + propertySimpleClassName + " " + propertyName + ");").append(System.lineSeparator());
    }

    @Override
    protected void buildDetailsQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        List<PersistentRelation> persistentRelations = persistentClass.getRelations();
        String persistentSimpleClassName = persistentClass.getSimpleClassName();
        String propertyName = persistentProperty.getPropertyName();
        String propertyDesc = persistentProperty.getPropertyDesc();
        String propertyClassName = persistentProperty.getPropertyClass();
        String simpleClassName = TStringUtils.getSimpleClassName(propertyClassName, true);
        if (StringUtils.indexOf((CharSequence)propertyClassName, (CharSequence)".") != -1) {
            importMapping.put(propertyClassName, propertyClassName);
        }
        importMapping.put("org.springframework.data.jpa.repository.Query", "org.springframework.data.jpa.repository.Query");
        importMapping.put("org.springframework.data.repository.query.Param", "org.springframework.data.repository.query.Param");
        codeView.append("  /**").append(System.lineSeparator());
        codeView.append("   * \u6309\u7167" + propertyDesc + "\u8fdb\u884c\u8be6\u60c5\u67e5\u8be2\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09").append(System.lineSeparator());
        codeView.append("   * @param " + propertyName + " " + propertyDesc).append(System.lineSeparator());
        codeView.append("   * */").append(System.lineSeparator());
        String persistentAlias = TStringUtils.letterLowercase(persistentSimpleClassName);
        StringBuffer hql = new StringBuffer("\"select distinct " + persistentAlias + " from " + persistentSimpleClassName + " " + persistentAlias + " \"").append(System.lineSeparator());
        for (int index = 0; persistentRelations != null && index < persistentRelations.size(); ++index) {
            PersistentRelation relationItem = persistentRelations.get(index);
            if (relationItem.getRelationType() != PersistentRelation.RelationType.ManyToOne && relationItem.getRelationType() != PersistentRelation.RelationType.ManyToMany) continue;
            String relationPropertyName = relationItem.getPropertyName();
            String relationLeftJoinContext = persistentAlias + "." + relationPropertyName;
            String relationPropertyAlias = persistentAlias + "_" + relationPropertyName;
            hql.append("      + \" left join fetch ").append(relationLeftJoinContext).append(" ").append(relationPropertyAlias).append(" \"").append(System.lineSeparator());
        }
        hql.append("      + \" where " + persistentAlias + "." + propertyName + "=:" + propertyName).append(" \")").append(System.lineSeparator());
        codeView.append("  @Query(" + hql);
        codeView.append("  " + persistentSimpleClassName + " findDetailsBy" + TStringUtils.letterUppercase(propertyName) + "(@Param(\"" + propertyName + "\") " + simpleClassName + " " + propertyName + ");" + System.lineSeparator());
    }

    @Override
    protected void buildDetailsQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentRelation persistentRelation, Map<String, String> importMapping, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        String persistentSimpleClassName = persistentClass.getSimpleClassName();
        String propertyName = persistentRelation.getPropertyName();
        String propertyDesc = persistentRelation.getPropertyDesc();
        String propertyClassName = persistentRelation.getPropertyClass();
        importMapping.put("org.springframework.data.jpa.repository.Query", "org.springframework.data.jpa.repository.Query");
        importMapping.put("org.springframework.data.repository.query.Param", "org.springframework.data.repository.query.Param");
        codeView.append("  /**").append(System.lineSeparator());
        codeView.append("   * \u6309\u7167" + propertyDesc + "\u8fdb\u884c\u8be6\u60c5\u67e5\u8be2\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09").append(System.lineSeparator());
        codeView.append("   * @param " + propertyName + " " + propertyDesc).append(System.lineSeparator());
        codeView.append("   * */").append(System.lineSeparator());
        String persistentAlias = TStringUtils.letterLowercase(persistentSimpleClassName);
        StringBuffer hql = new StringBuffer("\"select distinct " + persistentAlias + " from " + persistentSimpleClassName + " " + persistentAlias + " \"").append(System.lineSeparator());
        String whereCondition = null;
        String paramSimpleClassName = null;
        String paramName = null;
        List<PersistentRelation> persistentRelations = persistentClass.getRelations();
        for (int index = 0; persistentRelations != null && index < persistentRelations.size(); ++index) {
            PersistentRelation relationItem = persistentRelations.get(index);
            if (relationItem.getRelationType() != PersistentRelation.RelationType.ManyToOne && relationItem.getRelationType() != PersistentRelation.RelationType.ManyToMany && !StringUtils.equals((CharSequence)relationItem.getPropertyClass(), (CharSequence)propertyClassName)) continue;
            String relationPropertyName = relationItem.getPropertyName();
            String relationLeftJoinContext = persistentAlias + "." + relationPropertyName;
            String relationPropertyAlias = persistentAlias + "_" + relationPropertyName;
            hql.append("      + \" left join fetch ").append(relationLeftJoinContext).append(" ").append(relationPropertyAlias).append(" \"").append(System.lineSeparator());
            if (!StringUtils.equals((CharSequence)relationItem.getPropertyClass(), (CharSequence)propertyClassName)) continue;
            PersistentProperty pkProperty = persistentPropertyService.findPrimaryKey(relationItem.getPersistentClassName());
            paramName = pkProperty.getPropertyName();
            String paramClassName = pkProperty.getPropertyClass();
            paramSimpleClassName = TStringUtils.getSimpleClassName(paramClassName, true);
            whereCondition = " + \" where " + relationPropertyAlias + "." + paramName + " = :" + paramName + "\")";
        }
        if (whereCondition == null) {
            return;
        }
        hql.append("      ").append(whereCondition).append(System.lineSeparator());
        if (persistentRelation.getRelationType() == PersistentRelation.RelationType.ManyToOne || persistentRelation.getRelationType() == PersistentRelation.RelationType.ManyToMany) {
            importMapping.put("java.util.Set", "java.util.Set");
            codeView.append("  @Query(" + hql);
            codeView.append("  Set<" + persistentSimpleClassName + "> findDetailsBy" + TStringUtils.letterUppercase(propertyName) + "(@Param(\"" + paramName + "\") " + paramSimpleClassName + " " + paramName + ");" + System.lineSeparator());
        } else {
            codeView.append("  @Query(" + hql);
            codeView.append("  " + persistentSimpleClassName + " findDetailsBy" + TStringUtils.letterUppercase(propertyName) + "(@Param(\"" + paramName + "\") " + paramSimpleClassName + " " + paramName + ");" + System.lineSeparator());
        }
    }

    @Override
    protected void buildPkQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty pkProperty, Map<String, String> importMapping) {
    }

    @Override
    protected void buildPkDeleteMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping, PersistentClassService persistentClassService) {
    }
}

