/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.saturn.engine.handler;

import com.bizunited.nebula.saturn.context.SaturnContext;
import com.bizunited.nebula.saturn.context.service.PersistentClassService;
import com.bizunited.nebula.saturn.context.service.PersistentPropertyService;
import com.bizunited.nebula.saturn.context.service.PersistentRelationService;
import com.bizunited.nebula.saturn.engine.handler.ServiceInterfaceGenerateHandler;
import com.bizunited.nebula.saturn.model.PersistentClass;
import com.bizunited.nebula.saturn.model.PersistentProperty;
import com.bizunited.nebula.saturn.model.PersistentQueryMethod;
import com.bizunited.nebula.saturn.model.PersistentRelation;
import com.bizunited.nebula.saturn.model.PersistentUpdateMethod;
import com.bizunited.nebula.saturn.utils.TStringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceImplGenerateHandler
extends ServiceInterfaceGenerateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceImplGenerateHandler.class);

    @Override
    public Void handle(SaturnContext context) {
        String rootPackage = context.getRootPackage();
        String projectAbsolutePath = context.getProjectAbsolutePath();
        String projectSrcAbsolutePath = StringUtils.join((Object[])new String[]{projectAbsolutePath, "/", context.getProjectSrcPath()});
        PersistentClassService persistentClassService = context.getPersistentClassService();
        List<PersistentClass> persistentClasses = persistentClassService.queryAllClasses();
        Validate.isTrue((persistentClasses != null && !persistentClasses.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u6a21\u578b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u524d\u7f6e\u8fd0\u884c\u626b\u63cf\u5668", (Object[])new Object[0]);
        PersistentPropertyService persistentPropertyService = context.getPersistentPropertyService();
        PersistentRelationService persistentRelationService = context.getPersistentRelationService();
        if (context.getOnlyBuildEntity().booleanValue()) {
            persistentClasses = persistentClasses.stream().filter(PersistentClass::getRepositoryEntity).collect(Collectors.toList());
        }
        if (context.getOnlyBuildVo().booleanValue()) {
            persistentClasses = persistentClasses.stream().filter(PersistentClass::getRepositoryEntity).collect(Collectors.toList());
        }
        for (PersistentClass itemPersistentClass : persistentClasses) {
            HashMap<String, String> importMapping = new HashMap<String, String>();
            String simpleClassName = itemPersistentClass.getSimpleClassName();
            String domain = itemPersistentClass.getDomain();
            String persistentClassName = itemPersistentClass.getClassName();
            String persistentPackageName = TStringUtils.getPreviousPackage(persistentClassName);
            if (IGNOREPACKAGES.contains(persistentPackageName)) continue;
            String servicePackage = null;
            servicePackage = StringUtils.isBlank((CharSequence)domain) ? StringUtils.join((Object[])new String[]{rootPackage, ".service.internal"}) : StringUtils.join((Object[])new String[]{rootPackage, ".service.internal", ".", domain});
            String serviceSimpleClass = StringUtils.join((Object[])new String[]{simpleClassName, "ServiceImpl"});
            if (itemPersistentClass.getRepositoryEntity().booleanValue() && StringUtils.isBlank((CharSequence)itemPersistentClass.getRepositoryTable())) continue;
            try {
                StringBuffer repositoryFileContext = this.buildServiceFileContext(itemPersistentClass, importMapping, rootPackage, persistentClassService, persistentPropertyService, persistentRelationService);
                if (repositoryFileContext == null) continue;
                this.buildJavaFile(repositoryFileContext.toString(), projectSrcAbsolutePath, servicePackage, serviceSimpleClass);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
                e.printStackTrace(System.out);
            }
        }
        return null;
    }

    private StringBuffer buildServiceFileContext(PersistentClass persistentClass, Map<String, String> importMapping, String rootPackage, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        String simpleClassName = persistentClass.getSimpleClassName();
        String domain = persistentClass.getDomain();
        String className = persistentClass.getClassName();
        StringBuffer javacontexts = new StringBuffer();
        String servicePackage = null;
        String serviceInternalPackage = null;
        if (StringUtils.isBlank((CharSequence)domain)) {
            servicePackage = StringUtils.join((Object[])new String[]{rootPackage, ".service"});
            serviceInternalPackage = StringUtils.join((Object[])new String[]{rootPackage, ".service.internal"});
        } else {
            servicePackage = StringUtils.join((Object[])new String[]{rootPackage, ".service", ".", domain});
            serviceInternalPackage = StringUtils.join((Object[])new String[]{rootPackage, ".service.internal", ".", domain});
        }
        String serviceSimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Service"});
        String serviceClassName = StringUtils.join((Object[])new String[]{servicePackage, ".", serviceSimpleClassName});
        String serviceInternalSimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "ServiceImpl"});
        PersistentProperty primaryKey = persistentPropertyService.findPrimaryKey(className);
        importMapping.put(className, className);
        importMapping.put(serviceClassName, serviceClassName);
        if (primaryKey != null) {
            String primaryKeyClass = primaryKey.getPropertyClass();
            importMapping.put(primaryKeyClass, primaryKeyClass);
        }
        javacontexts.append("package " + serviceInternalPackage + ";" + System.lineSeparator());
        if (importMapping.isEmpty()) {
            LOGGER.error("\u9519\u8bef\u7684import\u53c2\u6570\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!");
            return null;
        }
        StringBuffer javaBodyContext = new StringBuffer();
        importMapping.put("org.springframework.stereotype.Service", "org.springframework.stereotype.Service");
        importMapping.put("org.springframework.beans.factory.annotation.Autowired", "org.springframework.beans.factory.annotation.Autowired");
        javaBodyContext.append(System.lineSeparator());
        javaBodyContext.append("/**").append(System.lineSeparator());
        javaBodyContext.append(" * ").append(simpleClassName).append("\u4e1a\u52a1\u6a21\u578b\u7684\u670d\u52a1\u5c42\u63a5\u53e3\u5b9e\u73b0").append(System.lineSeparator());
        javaBodyContext.append(" * @author saturn").append(System.lineSeparator());
        javaBodyContext.append(" */").append(System.lineSeparator());
        javaBodyContext.append("@Service(\"" + serviceInternalSimpleClassName + "\")").append(System.lineSeparator());
        javaBodyContext.append("public class ").append(serviceInternalSimpleClassName).append(" implements " + serviceSimpleClassName + " { ").append(System.lineSeparator());
        StringBuffer globaVariableContext = this.buildGlobaVariable(rootPackage, persistentClass, persistentClassService, persistentPropertyService, importMapping);
        javaBodyContext.append(globaVariableContext);
        StringBuffer createContext = this.buildCreateMethod(persistentClass, persistentClassService, persistentPropertyService, persistentRelationService, importMapping);
        javaBodyContext.append(createContext);
        StringBuffer createFormContext = this.buildCreateFormMethod(persistentClass, persistentClassService, persistentPropertyService, persistentRelationService, importMapping);
        javaBodyContext.append(createFormContext);
        StringBuffer createValidationContext = this.buildCreateValidation(rootPackage, persistentClass, persistentClassService, persistentPropertyService, persistentRelationService, importMapping);
        javaBodyContext.append(createValidationContext);
        StringBuffer updateContext = this.buildUpdateMethod(persistentClass, persistentClassService, persistentPropertyService, persistentRelationService, importMapping);
        javaBodyContext.append(updateContext);
        StringBuffer updateFormContext = this.buildUpdateFormMethod(persistentClass, persistentClassService, persistentPropertyService, persistentRelationService, importMapping);
        javaBodyContext.append(updateFormContext);
        StringBuffer updateValidationContext = this.buildUpdateValidation(rootPackage, persistentClass, persistentPropertyService, importMapping);
        javaBodyContext.append(updateValidationContext);
        StringBuffer methodContexts = this.scanAndBuildCustomUpdateMethods(persistentClass, importMapping, persistentPropertyService, persistentRelationService);
        javaBodyContext.append(methodContexts);
        methodContexts = this.scanAndBuildRelationQueryMethods(persistentClass, importMapping, persistentClassService, persistentPropertyService, persistentRelationService);
        javaBodyContext.append(methodContexts);
        methodContexts = this.scanAndbuildUniquenessQueryMethod(persistentClass, importMapping, persistentClassService, persistentPropertyService, persistentRelationService);
        javaBodyContext.append(methodContexts);
        methodContexts = this.scanAndBuildCustomQueryMethods(persistentClass, persistentClassService, persistentPropertyService, persistentRelationService, importMapping);
        javaBodyContext.append(methodContexts);
        LinkedList importsList = new LinkedList();
        importMapping.keySet().stream().sorted((target, souce) -> StringUtils.compare((String)target, (String)souce)).forEach(importItem -> importsList.add("import " + importItem + ";"));
        String importContext = StringUtils.join((Object[])importsList.toArray(new String[0]), (String)System.lineSeparator());
        javacontexts.append(importContext).append(System.lineSeparator());
        javacontexts.append(javaBodyContext);
        javacontexts.append("} ").append(System.lineSeparator());
        LOGGER.debug("===================" + serviceSimpleClassName + ":" + javacontexts.toString());
        return javacontexts;
    }

    protected StringBuffer buildGlobaVariable(String rootPackageName, PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        String className = persistentClass.getClassName();
        String simpleClassName = persistentClass.getSimpleClassName();
        List<PersistentRelation> persistentRelations = persistentClass.getRelations();
        String persistentClassName = persistentClass.getClassName();
        boolean isMainForm = persistentClassService.isFormInstancePersistent(className);
        HashSet<String> alreadyRelationIServiceClassNames = new HashSet<String>();
        if (persistentRelations != null && !persistentRelations.isEmpty()) {
            for (PersistentRelation persistentRelation : persistentRelations) {
                List oneToManys;
                PersistentClass relationPersistentClass;
                List<PersistentRelation> relationPersistentRelations;
                boolean isHandle = false;
                if ((persistentRelation.getRelationType() == PersistentRelation.RelationType.OneToMany || persistentRelation.getRelationType() == PersistentRelation.RelationType.OneToOne) && isMainForm) {
                    isHandle = true;
                } else if (persistentRelation.getRelationType() == PersistentRelation.RelationType.ManyToMany || persistentRelation.getRelationType() == PersistentRelation.RelationType.ManyToOne) {
                    isHandle = true;
                }
                if (StringUtils.equals((CharSequence)persistentClassName, (CharSequence)"com.bizunited.nebula.user.entity.UserEntity") || StringUtils.equals((CharSequence)persistentClassName, (CharSequence)"com.bizunited.nebula.user.entity.UserGroupEntity") || StringUtils.equals((CharSequence)persistentClassName, (CharSequence)"com.bizunited.nebula.user.entity.RoleEntity") || StringUtils.equals((CharSequence)persistentClassName, (CharSequence)"com.bizunited.nebula.user.entity.PositionEntity") || StringUtils.equals((CharSequence)persistentClassName, (CharSequence)"com.bizunited.nebula.user.entity.OrganizationEntity") || !isHandle) continue;
                this.buildGlobalVariableService(codeView, persistentRelation, persistentClassService, importMapping, alreadyRelationIServiceClassNames);
                if (persistentRelation.getRelationType() != PersistentRelation.RelationType.OneToOne || (relationPersistentRelations = (relationPersistentClass = persistentClassService.queryByClassName(persistentRelation.getPropertyClass())).getRelations()) == null || relationPersistentRelations.isEmpty() || (oneToManys = relationPersistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToMany).collect(Collectors.toList())) == null || oneToManys.isEmpty()) continue;
                for (PersistentRelation oneToMany : oneToManys) {
                    this.buildGlobalVariableService(codeView, oneToMany, persistentClassService, importMapping, alreadyRelationIServiceClassNames);
                }
            }
        }
        if (persistentClass.getRepositoryEntity().booleanValue()) {
            String domain = persistentClass.getDomain();
            String repositoryClassName = null;
            repositoryClassName = StringUtils.isBlank((CharSequence)domain) ? StringUtils.join((Object[])new String[]{rootPackageName, ".repository.", simpleClassName, "Repository"}) : StringUtils.join((Object[])new String[]{rootPackageName, ".repository.", domain, ".", simpleClassName, "Repository"});
            importMapping.put(repositoryClassName, repositoryClassName);
            String repositorySimpleClassName = TStringUtils.getSimpleClassName(repositoryClassName, true);
            String repositoryVar = TStringUtils.letterLowercase(repositorySimpleClassName);
            codeView.append("  @Autowired").append(System.lineSeparator());
            codeView.append("  private ").append(repositorySimpleClassName).append(" ").append(repositoryVar).append(";").append(System.lineSeparator());
        }
        importMapping.put("org.springframework.beans.factory.annotation.Autowired", "org.springframework.beans.factory.annotation.Autowired");
        return codeView;
    }

    private void buildGlobalVariableService(StringBuffer codeView, PersistentRelation persistentRelation, PersistentClassService persistentClassService, Map<String, String> importMapping, Set<String> alreadyRelationIServiceClassNames) {
        String relationClassName = persistentRelation.getPropertyClass();
        String relationPackage = TStringUtils.getPreviousPackage(relationClassName);
        String relationPreviousPackage = TStringUtils.getPreviousPackage(relationPackage);
        String relationSimpleClassName = TStringUtils.getSimpleClassName(relationClassName, true);
        PersistentClass relationPersistentClass = persistentClassService.queryByClassName(relationClassName);
        Validate.notNull((Object)relationPersistentClass, (String)"\u9519\u8bef\u7684\u5173\u8054\u6a21\u578b\u7c7b\u578b\u2014\u2014\u672a\u627e\u5230\u6a21\u578b\u7c7b\u3010%s\u3011", (Object[])new Object[]{relationClassName});
        String relationDomian = relationPersistentClass.getDomain();
        String relationIServiceClassName = null;
        relationIServiceClassName = StringUtils.isBlank((CharSequence)relationDomian) ? StringUtils.join((Object[])new String[]{relationPreviousPackage, ".service.", relationSimpleClassName, "Service"}) : StringUtils.join((Object[])new String[]{relationPreviousPackage, ".service.", relationDomian, ".", relationSimpleClassName, "Service"});
        String relationServiceVar = TStringUtils.letterLowercase(TStringUtils.getSimpleClassName(relationIServiceClassName, true));
        importMapping.put(relationIServiceClassName, relationIServiceClassName);
        if (!alreadyRelationIServiceClassNames.contains(relationIServiceClassName)) {
            codeView.append("  @Autowired").append(System.lineSeparator());
            codeView.append("  private ").append(TStringUtils.getSimpleClassName(relationIServiceClassName, true)).append(" ").append(relationServiceVar).append(";").append(System.lineSeparator());
            alreadyRelationIServiceClassNames.add(relationIServiceClassName);
        }
    }

    @Override
    protected StringBuffer buildCreateFormMethod(PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        String simpleClassName = persistentClass.getSimpleClassName();
        String persistentClassName = persistentClass.getClassName();
        importMapping.put("javax.transaction.Transactional", "javax.transaction.Transactional");
        importMapping.put("java.lang.Override", "java.lang.Override");
        codeView.append("  @Transactional").append(System.lineSeparator());
        codeView.append("  @Override").append(System.lineSeparator());
        codeView.append("  public " + simpleClassName + " createForm(" + simpleClassName + " " + TStringUtils.letterLowercase(simpleClassName) + ") { " + System.lineSeparator());
        String modleVar = TStringUtils.letterLowercase(simpleClassName);
        boolean isMainForm = persistentClassService.isFormInstancePersistent(persistentClassName);
        codeView.append("   /* ").append(System.lineSeparator());
        codeView.append("    * \u9488\u5bf91.1.3\u7248\u672c\u7684\u9700\u6c42\uff0c\u8fd9\u4e2a\u5bf9\u9759\u6001\u6a21\u578b\u7684\u4fdd\u5b58\u64cd\u4f5c\u505a\u51fa\u8c03\u6574\uff0c\u65b0\u7684\u5305\u88f9\u8fc7\u7a0b\u4e3a\uff1a").append(System.lineSeparator());
        codeView.append("    * 1\u3001\u5982\u679c\u5f53\u524d\u6a21\u578b\u5bf9\u8c61\u4e0d\u662f\u4e3b\u6a21\u578b").append(System.lineSeparator());
        codeView.append("    * 1.1\u3001\u90a3\u4e48\u521b\u5efa\u524d\u53ea\u4f1a\u9a8c\u8bc1\u57fa\u672c\u4fe1\u606f\uff0c\u76f4\u63a5\u7684ManyToOne\u5173\u8054\uff08\u5355\u9009\uff09\u548cManyToMany\u5173\u8054\uff08\u591a\u9009\uff09").append(System.lineSeparator());
        codeView.append("    * 1.2\u3001\u9a8c\u8bc1\u5b8c\u6210\u540e\uff0c\u4e5f\u53ea\u4f1a\u4fdd\u5b58\u5f53\u524d\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff0c\u76f4\u63a5\u7684\u5355\u9009").append(System.lineSeparator());
        codeView.append("    * TODO 1.3\u3001ManyToMany\u7684\u5173\u8054\uff08\u591a\u9009\uff09\uff0c\u6682\u65f6\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5904\u7406").append(System.lineSeparator());
        codeView.append("    * 2\u3001\u5982\u679c\u5f53\u524d\u6a21\u578b\u5bf9\u8c61\u662f\u4e3b\u4e1a\u52a1\u6a21\u578b").append(System.lineSeparator());
        codeView.append("    *  2.1\u3001\u521b\u5efa\u524d\u4f1a\u9a8c\u8bc1\u5f53\u524d\u6a21\u578b\u7684\u57fa\u672c\u5c5e\u6027\uff0c\u5355\u9009\u548c\u591a\u9009\u5c5e\u6027").append(System.lineSeparator());
        codeView.append("    *  2.2\u3001\u7136\u540e\u8fd8\u4f1a\u9a8c\u8bc1\u5f53\u524d\u6a21\u578b\u5173\u8054\u7684\u5404\u4e2aOneToMany\u660e\u7ec6\u4fe1\u606f\uff0c\u8c03\u7528\u660e\u7ec6\u5bf9\u8c61\u7684\u670d\u52a1\uff0c\u660e\u6bcf\u4e00\u6761\u65e2\u6709\u660e\u7ec6\u8fdb\u884c\u9a8c\u8bc1").append(System.lineSeparator());
        codeView.append("    *  \uff082.2\u7684\u6b65\u9aa4\u8fd8\u9700\u8981\u6ce8\u610f\uff0c\u5982\u679c\u5f53\u524d\u88ab\u9a8c\u8bc1\u7684\u5173\u8054\u5bf9\u8c61\u662f\u56de\u6eaf\u5bf9\u8c61\uff0c\u5219\u4e0d\u9700\u8981\u9a8c\u8bc1\u4e86\uff09").append(System.lineSeparator());
        codeView.append("    * 2.3\u3001\u8fd8\u4f1a\u9a8c\u8bc1\u5f53\u524d\u6a21\u578b\u5173\u8054\u7684\u5404\u4e2aOneToOne\u5206\u7ec4\uff0c\u8c03\u7528\u5206\u7ec4\u5bf9\u8c61\u7684\u670d\u52a1\uff0c\u5bf9\u5206\u7ec4\u4e2d\u7684\u4fe1\u606f\u8fdb\u884c\u9a8c\u8bc1").append(System.lineSeparator());
        codeView.append("    *   2.3.1\u3001\u5305\u62ec\u9a8c\u8bc1\u6bcf\u4e00\u4e2a\u5206\u7ec4\u9879\u7684\u57fa\u672c\u4fe1\u606f\u3001\u76f4\u63a5\u7684\u5355\u9009\u3001\u591a\u9009\u4fe1\u606f").append(System.lineSeparator());
        codeView.append("    *   2.3.2\u3001\u4ee5\u53ca\u9a8c\u8bc1\u6bcf\u4e2a\u5206\u7ec4\u7684OneToMany\u660e\u7ec6\u4fe1\u606f").append(System.lineSeparator());
        codeView.append("    * */").append(System.lineSeparator());
        if (!isMainForm) {
            List<PersistentRelation> relations = persistentClass.getRelations();
            this.buildEntityCreateMethod(codeView, simpleClassName, modleVar, persistentClass, relations);
        } else {
            this.buildMainEntityCreateMethod(codeView, persistentClass, persistentClassService, persistentPropertyService, persistentRelationService, importMapping);
        }
        codeView.append("    // \u8fd4\u56de\u6700\u7ec8\u5904\u7406\u7684\u7ed3\u679c\uff0c\u91cc\u9762\u5e26\u6709\u8be6\u7ec6\u7684\u5173\u8054\u4fe1\u606f").append(System.lineSeparator());
        codeView.append("    return ").append(modleVar).append(";").append(System.lineSeparator());
        codeView.append("  }").append(System.lineSeparator());
        return codeView;
    }

    private StringBuffer buildMainEntityCreateMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping) {
        String groupRelationVarName;
        String groupRelationSimpleClassName;
        String groupRelationClassName;
        String groupRelationPropertyName;
        PersistentRelation groupRelationItem;
        int index;
        String simpleClassName = persistentClass.getSimpleClassName();
        String persistentClassName = persistentClass.getClassName();
        String modleVar = TStringUtils.letterLowercase(simpleClassName);
        String repositorySimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Repository"});
        String repositoryVar = TStringUtils.letterLowercase(repositorySimpleClassName);
        List<PersistentRelation> relations = persistentClass.getRelations();
        if (relations == null || relations.isEmpty()) {
            relations = new LinkedList<PersistentRelation>();
        }
        List groupRelations = relations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToOne).collect(Collectors.toList());
        for (index = 0; groupRelations != null && index < groupRelations.size(); ++index) {
            groupRelationItem = (PersistentRelation)groupRelations.get(index);
            groupRelationPropertyName = groupRelationItem.getPropertyName();
            String groupRelationPropertyDesc = groupRelationItem.getPropertyDesc();
            groupRelationClassName = groupRelationItem.getPropertyClass();
            groupRelationSimpleClassName = TStringUtils.getSimpleClassName(groupRelationClassName, false);
            groupRelationVarName = TStringUtils.letterLowercase(groupRelationSimpleClassName) + "Group";
            importMapping.put(groupRelationClassName, groupRelationClassName);
            codeView.append("    // \u4f18\u5148\u5904\u7406\u5206\u7ec4\u4fe1\u606f\u7684\u4fdd\u5b58\uff1a" + groupRelationPropertyDesc + "").append(System.lineSeparator());
            codeView.append("    " + groupRelationSimpleClassName + " " + groupRelationVarName + " = " + modleVar + ".get" + TStringUtils.letterUppercase(groupRelationPropertyName) + "();").append(System.lineSeparator());
            codeView.append("    Validate.notNull(" + groupRelationVarName + " , \"" + groupRelationPropertyDesc + "\u5206\u7ec4\u4fe1\u606f\uff0c\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!\");").append(System.lineSeparator());
            String targetRelationServiceVarName = TStringUtils.letterLowercase(groupRelationSimpleClassName) + "Service";
            codeView.append("    this." + targetRelationServiceVarName + ".create(" + groupRelationVarName + ");").append(System.lineSeparator());
        }
        codeView.append("    this.createValidation(" + modleVar + ");").append(System.lineSeparator());
        codeView.append("    ").append(System.lineSeparator());
        codeView.append("    // ===============================").append(System.lineSeparator());
        codeView.append("    //  \u548c\u4e1a\u52a1\u6709\u5173\u7684\u9a8c\u8bc1\u586b\u5199\u5728\u8fd9\u4e2a\u533a\u57df    ").append(System.lineSeparator());
        codeView.append("    // ===============================").append(System.lineSeparator());
        codeView.append("    ").append(System.lineSeparator());
        if (persistentClass.getRepositoryEntity().booleanValue()) {
            for (index = 0; groupRelations != null && index < groupRelations.size(); ++index) {
                groupRelationItem = (PersistentRelation)groupRelations.get(index);
                groupRelationPropertyName = groupRelationItem.getPropertyName();
                String groupRelationClassName2 = groupRelationItem.getPropertyClass();
                String groupRelationSimpleClassName2 = TStringUtils.getSimpleClassName(groupRelationClassName2, false);
                String groupRelationVarName2 = TStringUtils.letterLowercase(groupRelationSimpleClassName2) + "Group";
                PersistentRelation targetPersistentRelation = persistentRelationService.findByTargetPropertyName(persistentClassName, groupRelationPropertyName);
                if (targetPersistentRelation == null) continue;
                String targetRelationName = targetPersistentRelation.getPropertyName();
                codeView.append("    " + groupRelationVarName2 + ".set" + TStringUtils.letterUppercase(targetRelationName) + "(" + modleVar + ");").append(System.lineSeparator());
            }
            codeView.append("    this.").append(repositoryVar).append(".saveAndFlush(").append(modleVar).append(");").append(System.lineSeparator());
        } else {
            codeView.append("    // TODO \u6ca1\u6709\u6570\u636e\u5c42\uff0c\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5b8c\u5584").append(System.lineSeparator());
        }
        if (relations.isEmpty()) {
            return codeView;
        }
        List<PersistentRelation> itemsRelations = relations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToMany).collect(Collectors.toList());
        this.buildItemsCreateMethod(codeView, persistentClassName, modleVar, itemsRelations, persistentRelationService, importMapping);
        if (itemsRelations != null && !itemsRelations.isEmpty()) {
            codeView.append("    this.").append(repositoryVar).append(".flush();").append(System.lineSeparator());
        }
        boolean continueFlash = false;
        for (int index2 = 0; groupRelations != null && index2 < groupRelations.size(); ++index2) {
            PersistentRelation groupRelationItem2 = (PersistentRelation)groupRelations.get(index2);
            groupRelationClassName = groupRelationItem2.getPropertyClass();
            groupRelationSimpleClassName = TStringUtils.getSimpleClassName(groupRelationClassName, false);
            groupRelationVarName = TStringUtils.letterLowercase(groupRelationSimpleClassName) + "Group";
            PersistentClass groupRelationPersistentClass = persistentClassService.queryByClassName(groupRelationClassName);
            List<PersistentRelation> groupOfRelations = groupRelationPersistentClass.getRelations();
            if (groupOfRelations == null || groupOfRelations.isEmpty()) continue;
            List<PersistentRelation> groupOfitems = groupOfRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToMany).collect(Collectors.toList());
            this.buildItemsCreateMethod(codeView, groupRelationClassName, groupRelationVarName, groupOfitems, persistentRelationService, importMapping);
            if (groupOfitems == null || groupOfitems.isEmpty()) continue;
            continueFlash = true;
        }
        if (continueFlash) {
            codeView.append("    this.").append(repositoryVar).append(".flush();").append(System.lineSeparator());
        }
        return codeView;
    }

    @Override
    protected StringBuffer buildCreateMethod(PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        importMapping.put("javax.transaction.Transactional", "javax.transaction.Transactional");
        importMapping.put("java.lang.Override", "java.lang.Override");
        importMapping.put("java.util.Date", "java.util.Date");
        codeView.append("  @Transactional").append(System.lineSeparator());
        codeView.append("  @Override").append(System.lineSeparator());
        String persistentSimpleClassName = persistentClass.getSimpleClassName();
        String varName = TStringUtils.letterLowercase(persistentSimpleClassName);
        codeView.append("  public " + persistentSimpleClassName + " create(" + persistentSimpleClassName + " " + varName + ") { " + System.lineSeparator());
        codeView.append("    " + persistentSimpleClassName + " current = this.createForm(" + varName + ");").append(System.lineSeparator());
        codeView.append("    //==================================================== ").append(System.lineSeparator());
        codeView.append("    //    \u8fd9\u91cc\u53ef\u4ee5\u5904\u7406\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8c03\u7528\uff08\u6216\u7279\u6b8a\u5904\u7406\u8fc7\u7a0b\uff09").append(System.lineSeparator());
        codeView.append("    //====================================================").append(System.lineSeparator());
        codeView.append("    return current;").append(System.lineSeparator());
        codeView.append("  } ").append(System.lineSeparator());
        return codeView;
    }

    private void buildEntityCreateMethod(StringBuffer codeView, String simpleClassName, String modleVar, PersistentClass persistentClass, List<PersistentRelation> relations) {
        String repositorySimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Repository"});
        String repositoryVar = TStringUtils.letterLowercase(repositorySimpleClassName);
        codeView.append("    Date now = new Date();").append(System.lineSeparator());
        codeView.append("    " + modleVar + ".setCreateAccount(SecurityUtils.getUserAccount());").append(System.lineSeparator());
        codeView.append("    " + modleVar + ".setCreateTime(now);").append(System.lineSeparator());
        codeView.append("    " + modleVar + ".setModifyAccount(SecurityUtils.getUserAccount());").append(System.lineSeparator());
        codeView.append("    " + modleVar + ".setModifyTime(now);").append(System.lineSeparator());
        codeView.append(System.lineSeparator());
        codeView.append("    this.createValidation(" + modleVar + ");").append(System.lineSeparator());
        codeView.append("    ").append(System.lineSeparator());
        codeView.append("    // ===============================").append(System.lineSeparator());
        codeView.append("    //  \u548c\u4e1a\u52a1\u6709\u5173\u7684\u9a8c\u8bc1\u586b\u5199\u5728\u8fd9\u4e2a\u533a\u57df    ").append(System.lineSeparator());
        codeView.append("    // ===============================").append(System.lineSeparator());
        codeView.append("    ").append(System.lineSeparator());
        if (persistentClass.getRepositoryEntity().booleanValue()) {
            codeView.append("    this.").append(repositoryVar).append(".save(").append(modleVar).append(");").append(System.lineSeparator());
        } else {
            codeView.append("    // TODO \u6ca1\u6709\u6570\u636e\u5c42\uff0c\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5b8c\u5584").append(System.lineSeparator());
        }
        if (relations == null || relations.isEmpty()) {
            return;
        }
        List manyToManyRelations = relations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.ManyToMany).collect(Collectors.toList());
        for (int index = 0; manyToManyRelations != null && index < manyToManyRelations.size(); ++index) {
            PersistentRelation manyToManyRelationItem = (PersistentRelation)manyToManyRelations.get(index);
            String manyToManyRelationPropertyDesc = manyToManyRelationItem.getPropertyDesc();
            codeView.append("    // TODO manyToMany\u5173\u8054" + manyToManyRelationPropertyDesc + "\u76ee\u524d\u7248\u672c\u4e0b\u8fd8\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5904\u7406").append(System.lineSeparator());
        }
        codeView.append("    ").append(System.lineSeparator());
    }

    private void buildItemsCreateMethod(StringBuffer codeView, String persistentClassName, String modleVar, List<PersistentRelation> itemsRelations, PersistentRelationService persistentRelationService, Map<String, String> importMapping) {
        for (int index = 0; itemsRelations != null && index < itemsRelations.size(); ++index) {
            PersistentRelation itemsRelationItem = itemsRelations.get(index);
            String itemsRelationPropertyName = itemsRelationItem.getPropertyName();
            String itemsRelationPropertyDesc = itemsRelationItem.getPropertyDesc();
            String itemsRelationClassName = itemsRelationItem.getPropertyClass();
            String itemsRelationSimpleClassName = TStringUtils.getSimpleClassName(itemsRelationClassName, false);
            String itemsRelationVarNames = TStringUtils.letterLowercase(itemsRelationSimpleClassName) + "Items";
            String itemsRelationVarName = TStringUtils.letterLowercase(itemsRelationSimpleClassName) + "Item";
            PersistentRelation targetPersistentRelation = persistentRelationService.findByTargetPropertyName(persistentClassName, itemsRelationPropertyName);
            if (targetPersistentRelation == null) continue;
            String targetRelationName = targetPersistentRelation.getPropertyName();
            String targetRelationServiceVarName = TStringUtils.letterLowercase(itemsRelationSimpleClassName) + "Service";
            importMapping.put("java.util.Set", "java.util.Set");
            importMapping.put(itemsRelationClassName, itemsRelationClassName);
            codeView.append("    // \u5904\u7406\u660e\u7ec6\u4fe1\u606f\uff1a" + itemsRelationPropertyDesc + "").append(System.lineSeparator());
            codeView.append("    Set<" + itemsRelationSimpleClassName + "> " + itemsRelationVarNames + " = " + modleVar + ".get" + TStringUtils.letterUppercase(itemsRelationPropertyName) + "();").append(System.lineSeparator());
            if (!itemsRelationItem.getNullable().booleanValue()) {
                codeView.append("    Validate.isTrue(" + itemsRelationVarNames + " != null && !" + itemsRelationVarNames + ".isEmpty() , \"" + itemsRelationPropertyDesc + "\u660e\u7ec6\u4fe1\u606f\uff0c\u81f3\u5c11\u586b\u5199\u4e00\u6761\uff0c\u8bf7\u68c0\u67e5!!\");").append(System.lineSeparator());
            }
            codeView.append("    if(" + itemsRelationVarNames + " != null) {").append(System.lineSeparator());
            codeView.append("      for (" + itemsRelationSimpleClassName + " " + itemsRelationVarName + " : " + itemsRelationVarNames + ") {").append(System.lineSeparator());
            codeView.append("        " + itemsRelationVarName + ".set" + TStringUtils.letterUppercase(targetRelationName) + "(" + modleVar + ");").append(System.lineSeparator());
            codeView.append("        this." + targetRelationServiceVarName + ".create(" + itemsRelationVarName + ");").append(System.lineSeparator());
            codeView.append("      }").append(System.lineSeparator());
            codeView.append("    }").append(System.lineSeparator());
        }
        codeView.append("    ").append(System.lineSeparator());
    }

    private StringBuffer buildCreateValidation(String rootPackageName, PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping) {
        String propertyDesc;
        String propertyName;
        String propertyName2;
        StringBuffer codeView = new StringBuffer();
        String simpleClassName = persistentClass.getSimpleClassName();
        String varName = TStringUtils.letterLowercase(simpleClassName);
        codeView.append("  /**" + System.lineSeparator());
        codeView.append("   * \u5728\u521b\u5efa\u4e00\u4e2a\u65b0\u7684" + simpleClassName + "\u6a21\u578b\u5bf9\u8c61\u4e4b\u524d\uff0c\u68c0\u67e5\u5bf9\u8c61\u5404\u5c5e\u6027\u7684\u6b63\u786e\u6027\uff0c\u5176\u4e3b\u952e\u5c5e\u6027\u5fc5\u987b\u6ca1\u6709\u503c" + System.lineSeparator());
        codeView.append("   */" + System.lineSeparator());
        codeView.append("  private void createValidation(" + simpleClassName + " " + varName + ") { " + System.lineSeparator());
        List<PersistentProperty> persistentProperties = persistentClass.getProperties();
        List<PersistentRelation> relations = persistentClass.getRelations();
        String persistentSimpleClassName = persistentClass.getSimpleClassName();
        String persistentClassName = persistentClass.getClassName();
        PersistentProperty instanceProperty = persistentPropertyService.findByPropertyName(persistentClassName, "formInstanceId");
        boolean isMainForm = instanceProperty != null;
        List notNulltProperties = persistentProperties.stream().filter(item -> item.getNullable() == false).collect(Collectors.toList());
        importMapping.put("org.apache.commons.lang3.Validate", "org.apache.commons.lang3.Validate");
        codeView.append("    Validate.notNull(" + varName + " , \"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!\");").append(System.lineSeparator());
        codeView.append("    // \u5224\u5b9a\u90a3\u4e9b\u4e0d\u80fd\u4e3anull\u7684\u8f93\u5165\u503c\uff1a\u6761\u4ef6\u4e3a caninsert = true\uff0c\u4e14nullable = false").append(System.lineSeparator());
        for (PersistentProperty notNulltProperty : notNulltProperties) {
            String setMethodName;
            String propertyClass = notNulltProperty.getPropertyClass();
            propertyName2 = notNulltProperty.getPropertyName();
            String propertyDesc2 = notNulltProperty.getPropertyDesc();
            String methodName = StringUtils.join((Object[])new String[]{varName, ".get", TStringUtils.letterUppercase(propertyName2), "()"});
            if ("createAccount".equals(propertyName2) || "modifyAccount".equals(propertyName2) || "createTime".equals(propertyName2) || "modifyTime".equals(propertyName2)) continue;
            if (StringUtils.equals((CharSequence)propertyClass, (CharSequence)"java.lang.String") && !notNulltProperty.getPrimaryKey().booleanValue()) {
                codeView.append("    Validate.notBlank(" + methodName + ", \"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c" + propertyDesc2 + "\u4e0d\u80fd\u4e3a\u7a7a\uff01\");").append(System.lineSeparator());
                continue;
            }
            if (StringUtils.equals((CharSequence)propertyClass, (CharSequence)"java.lang.String") && notNulltProperty.getPrimaryKey().booleanValue()) {
                codeView.append("    Validate.isTrue(StringUtils.isBlank(" + methodName + "), \"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01\");").append(System.lineSeparator());
                setMethodName = StringUtils.join((Object[])new String[]{varName, ".set", TStringUtils.letterUppercase(propertyName2), "(null)"});
                codeView.append("    " + setMethodName + ";").append(System.lineSeparator());
                continue;
            }
            if (!StringUtils.equals((CharSequence)propertyClass, (CharSequence)"java.lang.String") && notNulltProperty.getPrimaryKey().booleanValue()) {
                codeView.append("    Validate.isTrue(" + methodName + " == null, \"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01\");").append(System.lineSeparator());
                setMethodName = StringUtils.join((Object[])new String[]{varName, ".set", TStringUtils.letterUppercase(propertyName2), "(null)"});
                codeView.append("    " + setMethodName + ";").append(System.lineSeparator());
                continue;
            }
            codeView.append("    Validate.notNull(" + methodName + ", \"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c" + propertyDesc2 + "\u4e0d\u80fd\u4e3a\u7a7a\uff01\");").append(System.lineSeparator());
        }
        List checkNullProperties = persistentProperties.stream().filter(item -> item.getUnique() != false && item.getPrimaryKey() == false && item.getNullable() != false && StringUtils.equals((CharSequence)item.getPropertyClass(), (CharSequence)"java.lang.String")).collect(Collectors.toList());
        for (int index = 0; checkNullProperties != null && index < checkNullProperties.size(); ++index) {
            PersistentProperty checkNullProperty = (PersistentProperty)checkNullProperties.get(index);
            propertyName2 = checkNullProperty.getPropertyName();
            codeView.append("    // \u5c5e\u6027" + propertyName2 + "\u8bbe\u5b9a\u4e3a\u201c\u552f\u4e00\u201d\uff0c\u4e14\u53c8\u5141\u8bb8\u4e3anull\uff0c\u6240\u4ee5\u9700\u8981\u4fee\u6b63\u7a7a\u5b57\u7b26\u4e32\u5f62\u5f0f\u7684\u8d4b\u503c").append(System.lineSeparator());
            codeView.append("    if(StringUtils.isBlank(" + varName + ".get" + TStringUtils.letterUppercase(propertyName2) + "())) {").append(System.lineSeparator());
            codeView.append("      " + varName + ".set" + TStringUtils.letterUppercase(propertyName2) + "(null);").append(System.lineSeparator());
            codeView.append("    } ").append(System.lineSeparator());
        }
        List stringProperties = persistentProperties.stream().filter(item -> item.getPrimaryKey() == false && StringUtils.equals((CharSequence)"java.lang.String", (CharSequence)item.getPropertyClass()) && item.getMaxLen() != null).collect(Collectors.toList());
        if (stringProperties != null) {
            codeView.append("    // \u9a8c\u8bc1\u957f\u5ea6\uff0c\u88ab\u9a8c\u8bc1\u7684\u8fd9\u4e9b\u5b57\u6bb5\u7b26\u5408\u7279\u5f81: \u5b57\u6bb5\u7c7b\u578b\u4e3aString\uff0c\u4e14\u4e0d\u4e3aPK \uff08\u6ce8\u610f\u8fde\u7eed\u7a7a\u5b57\u7b26\u4e32\u7684\u60c5\u51b5\uff09 ").append(System.lineSeparator());
            for (PersistentProperty persistentPropertyItem : stringProperties) {
                if ("createAccount".equals(persistentPropertyItem.getPropertyName()) || "modifyAccount".equals(persistentPropertyItem.getPropertyName()) || "createTime".equals(persistentPropertyItem.getPropertyName()) || "modifyTime".equals(persistentPropertyItem.getPropertyName())) continue;
                Integer maxLen = persistentPropertyItem.getMaxLen();
                propertyName = persistentPropertyItem.getPropertyName();
                propertyDesc = persistentPropertyItem.getPropertyDesc();
                codeView.append("    Validate.isTrue(" + varName + ".get" + TStringUtils.letterUppercase(propertyName) + "() == null || " + varName + ".get" + TStringUtils.letterUppercase(propertyName) + "().length() < " + maxLen + " , \"" + propertyDesc + ",\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(" + maxLen + ")\uff0c\u8bf7\u68c0\u67e5!\");").append(System.lineSeparator());
            }
        }
        List uniquenessProperties = persistentProperties.stream().filter(item -> item.getUnique() != false && item.getCanInsert() != false && item.getPrimaryKey() == false).collect(Collectors.toList());
        for (int index = 0; uniquenessProperties != null && index < uniquenessProperties.size(); ++index) {
            PersistentProperty uniquenessProperty = (PersistentProperty)uniquenessProperties.get(index);
            if (uniquenessProperty.getPrimaryKey().booleanValue()) continue;
            propertyName = uniquenessProperty.getPropertyName();
            propertyDesc = uniquenessProperty.getPropertyDesc();
            String getMethodName = StringUtils.join((Object[])new String[]{varName, ".get", TStringUtils.letterUppercase(propertyName), "()"});
            String findMethodName = StringUtils.join((Object[])new String[]{"this.findBy", TStringUtils.letterUppercase(propertyName), "(" + getMethodName + ")"});
            String currentVarName = "current" + TStringUtils.letterUppercase(varName);
            if (index == 0) {
                codeView.append("    " + persistentSimpleClassName + " " + currentVarName + " = " + findMethodName).append(";").append(System.lineSeparator());
            } else {
                codeView.append("    " + currentVarName + " = " + findMethodName).append(";").append(System.lineSeparator());
            }
            codeView.append("    Validate.isTrue(" + currentVarName + " == null, \"" + propertyDesc + "\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5\");").append(System.lineSeparator());
        }
        List notNullRelations = relations.stream().filter(item -> item.getNullable() == false).collect(Collectors.toList());
        for (int index = 0; notNullRelations != null && isMainForm && index < notNullRelations.size(); ++index) {
            PersistentRelation notNullRelationItem = (PersistentRelation)notNullRelations.get(index);
            if (notNullRelationItem.getRelationType() == PersistentRelation.RelationType.OneToMany) continue;
            String relationClassName = notNullRelationItem.getPropertyClass();
            String relationSimpleClassName = TStringUtils.getSimpleClassName(relationClassName, true);
            String relationyName = notNullRelationItem.getPropertyName();
            String relationDesc = notNullRelationItem.getPropertyDesc();
            String getMethodName = StringUtils.join((Object[])new String[]{varName, ".get", TStringUtils.letterUppercase(relationyName), "()"});
            importMapping.put(relationClassName, relationClassName);
            String currentVarName = StringUtils.join((Object[])new String[]{"current", TStringUtils.letterUppercase(relationyName)});
            String currentVarPkName = StringUtils.join((Object[])new String[]{"currentPk", TStringUtils.letterUppercase(relationyName)});
            String relationServiceVarName = StringUtils.join((Object[])new String[]{TStringUtils.letterLowercase(relationSimpleClassName), "Service"});
            PersistentProperty relationPkProperty = persistentPropertyService.findPrimaryKey(relationClassName);
            String relationPkClassName = relationPkProperty.getPropertyClass();
            String relationPkSimpleClassName = TStringUtils.getSimpleClassName(relationPkClassName, false);
            String relationPkMethod = StringUtils.join((Object[])new String[]{"get", TStringUtils.letterUppercase(relationPkProperty.getPropertyName())});
            String relationServicePkMethodName = "findBy" + TStringUtils.letterUppercase(relationPkProperty.getPropertyName());
            if (StringUtils.equals((CharSequence)relationClassName, (CharSequence)"com.bizunited.nebula.user.entity.UserEntity") || StringUtils.equals((CharSequence)relationClassName, (CharSequence)"com.bizunited.nebula.user.entity.UserGroupEntity") || StringUtils.equals((CharSequence)relationClassName, (CharSequence)"com.bizunited.nebula.user.entity.RoleEntity") || StringUtils.equals((CharSequence)relationClassName, (CharSequence)"com.bizunited.nebula.user.entity.PositionEntity") || StringUtils.equals((CharSequence)relationClassName, (CharSequence)"com.bizunited.nebula.user.entity.OrganizationEntity")) continue;
            if (notNullRelationItem.getRelationType() == PersistentRelation.RelationType.OneToOne) {
                codeView.append("    // \u9a8c\u8bc1OneToOne\u5173\u8054\uff1a" + relationDesc + "\u7ed1\u5b9a\u503c\u7684\u6b63\u786e\u6027").append(System.lineSeparator());
                codeView.append("    " + relationSimpleClassName + " " + currentVarName + " = " + getMethodName + ";").append(System.lineSeparator());
                codeView.append("    Validate.notNull(" + currentVarName + " , \"" + relationDesc + "\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!\");").append(System.lineSeparator());
                continue;
            }
            if (notNullRelationItem.getRelationType() == PersistentRelation.RelationType.ManyToOne) {
                codeView.append("    // \u9a8c\u8bc1ManyToOne\u5173\u8054\uff1a" + relationDesc + "\u7ed1\u5b9a\u503c\u7684\u6b63\u786e\u6027").append(System.lineSeparator());
                codeView.append("    " + relationSimpleClassName + " " + currentVarName + " = " + getMethodName + ";").append(System.lineSeparator());
                codeView.append("    Validate.notNull(" + currentVarName + " , \"" + relationDesc + "\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!\");").append(System.lineSeparator());
                if (StringUtils.equals((CharSequence)relationPkClassName, (CharSequence)"java.lang.String")) {
                    codeView.append("    String " + currentVarPkName + " = " + currentVarName + "." + relationPkMethod + "();").append(System.lineSeparator());
                    codeView.append("    Validate.notBlank(" + currentVarPkName + ", \"\u521b\u5efa\u64cd\u4f5c\u65f6\uff0c\u5f53\u524d" + relationDesc + "\u4fe1\u606f\u5fc5\u987b\u5173\u8054\uff01\");").append(System.lineSeparator());
                } else {
                    importMapping.put(relationPkClassName, relationPkClassName);
                    codeView.append("    " + relationPkSimpleClassName + " " + currentVarPkName + " = " + currentVarName + "." + relationPkMethod + "();").append(System.lineSeparator());
                    codeView.append("    Validate.notNull(" + currentVarPkName + ", \"\u521b\u5efa\u64cd\u4f5c\u65f6\uff0c\u5f53\u524d" + relationDesc + "\u4fe1\u606f\u5fc5\u987b\u5173\u8054\uff01\");").append(System.lineSeparator());
                }
                codeView.append("    Validate.notNull(this." + relationServiceVarName + "." + relationServicePkMethodName + "(" + currentVarPkName + ") , \"" + relationDesc + "\u5173\u8054\u4fe1\u606f\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!\");").append(System.lineSeparator());
                continue;
            }
            if (notNullRelationItem.getRelationType() != PersistentRelation.RelationType.ManyToMany) continue;
            codeView.append("    // \u9a8c\u8bc1ManyToMany\u5173\u8054\uff1a" + relationDesc + "\u7ed1\u5b9a\u503c\u7684\u6b63\u786e\u6027").append(System.lineSeparator());
            importMapping.put("java.util.Collection", "java.util.Collection");
            codeView.append("    Collection<" + relationSimpleClassName + "> " + currentVarName + " = " + getMethodName + ";").append(System.lineSeparator());
            codeView.append("    Validate.isTrue(" + currentVarName + " != null && !" + currentVarName + ".isEmpty());").append(System.lineSeparator());
            String currentVarItemName = StringUtils.join((Object[])new String[]{currentVarName, "Item"});
            String currentVarItemPkName = StringUtils.join((Object[])new String[]{currentVarName, "ItemPk"});
            codeView.append("    for (" + relationSimpleClassName + " " + currentVarItemName + " : " + currentVarName + ") {").append(System.lineSeparator());
            if (StringUtils.equals((CharSequence)relationPkClassName, (CharSequence)"java.lang.String")) {
                codeView.append("      String " + currentVarItemPkName + " = " + currentVarItemName + "." + relationPkMethod + "();").append(System.lineSeparator());
                codeView.append("      Validate.notBlank(" + currentVarItemPkName + ", \"\u521b\u5efa\u64cd\u4f5c\u65f6\uff0c\u5f53\u524d" + relationDesc + "\u4fe1\u606f\u5fc5\u987b\u5168\u90e8\u5173\u8054\uff01\");").append(System.lineSeparator());
            } else {
                importMapping.put(relationPkClassName, relationPkClassName);
                codeView.append("      " + relationPkSimpleClassName + " " + currentVarItemPkName + " = " + currentVarItemName + "." + relationPkMethod + "();").append(System.lineSeparator());
                codeView.append("      Validate.notNull(" + currentVarItemPkName + ", \"\u521b\u5efa\u64cd\u4f5c\u65f6\uff0c\u5f53\u524d" + relationDesc + "\u4fe1\u606f\u5fc5\u987b\u5168\u90e8\u5173\u8054\uff01\");").append(System.lineSeparator());
            }
            codeView.append("      Validate.notNull(this." + relationServiceVarName + "." + relationServicePkMethodName + "(" + currentVarItemPkName + ") , \"" + relationDesc + "\u5173\u8054\u4fe1\u606f\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!\");").append(System.lineSeparator());
            codeView.append("    } ").append(System.lineSeparator());
        }
        codeView.append("  }").append(System.lineSeparator());
        return codeView;
    }

    @Override
    protected StringBuffer buildUpdateMethod(PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        importMapping.put("javax.transaction.Transactional", "javax.transaction.Transactional");
        importMapping.put("java.lang.Override", "java.lang.Override");
        codeView.append("  @Transactional").append(System.lineSeparator());
        codeView.append("  @Override").append(System.lineSeparator());
        String persistentSimpleClassName = persistentClass.getSimpleClassName();
        String varName = TStringUtils.letterLowercase(persistentSimpleClassName);
        codeView.append("  public " + persistentSimpleClassName + " update(" + persistentSimpleClassName + " " + varName + ") { " + System.lineSeparator());
        codeView.append("    " + persistentSimpleClassName + " current = this.updateForm(" + varName + ");").append(System.lineSeparator());
        codeView.append("    //==================================================== ").append(System.lineSeparator());
        codeView.append("    //    \u8fd9\u91cc\u53ef\u4ee5\u5904\u7406\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8c03\u7528\uff08\u6216\u7279\u6b8a\u5904\u7406\u8fc7\u7a0b\uff09").append(System.lineSeparator());
        codeView.append("    //====================================================").append(System.lineSeparator());
        codeView.append("    return current;").append(System.lineSeparator());
        codeView.append("  } ").append(System.lineSeparator());
        return codeView;
    }

    @Override
    protected StringBuffer buildUpdateFormMethod(PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        importMapping.put("javax.transaction.Transactional", "javax.transaction.Transactional");
        importMapping.put("java.lang.Override", "java.lang.Override");
        importMapping.put("com.bizunited.nebula.common.util.SecurityUtils", "com.bizunited.nebula.common.util.SecurityUtils");
        codeView.append("  @Transactional").append(System.lineSeparator());
        codeView.append("  @Override").append(System.lineSeparator());
        String persistentClassName = persistentClass.getClassName();
        String persistentSimpleClassName = persistentClass.getSimpleClassName();
        String varCurrentObject = StringUtils.join((Object[])new String[]{"current", persistentSimpleClassName});
        String varName = TStringUtils.letterLowercase(persistentSimpleClassName);
        codeView.append("  public " + persistentSimpleClassName + " updateForm(" + persistentSimpleClassName + " " + varName + ") { " + System.lineSeparator());
        PersistentProperty instanceProperty = persistentPropertyService.findByPropertyName(persistentClassName, "formInstanceId");
        boolean isMainForm = instanceProperty != null;
        codeView.append("    /* ").append(System.lineSeparator());
        codeView.append("     * \u9488\u5bf91.1.3\u7248\u672c\u7684\u9700\u6c42\uff0c\u8fd9\u4e2a\u5bf9\u9759\u6001\u6a21\u578b\u7684\u4fee\u6539\u64cd\u4f5c\u505a\u51fa\u8c03\u6574\uff0c\u65b0\u7684\u8fc7\u7a0b\u4e3a\uff1a").append(System.lineSeparator());
        codeView.append("     * 1\u3001\u5982\u679c\u5f53\u524d\u6a21\u578b\u5bf9\u8c61\u4e0d\u662f\u4e3b\u6a21\u578b").append(System.lineSeparator());
        codeView.append("     * 1.1\u3001\u90a3\u4e48\u521b\u5efa\u524d\u53ea\u4f1a\u9a8c\u8bc1\u57fa\u672c\u4fe1\u606f\uff0c\u76f4\u63a5\u7684ManyToOne\u5173\u8054\uff08\u5355\u9009\uff09\u548cManyToMany\u5173\u8054\uff08\u591a\u9009\uff09").append(System.lineSeparator());
        codeView.append("     * 1.2\u3001\u9a8c\u8bc1\u5b8c\u6210\u540e\uff0c\u4e5f\u53ea\u4f1a\u4fdd\u5b58\u5f53\u524d\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff0c\u76f4\u63a5\u7684\u5355\u9009").append(System.lineSeparator());
        codeView.append("     * TODO 1.3\u3001ManyToMany\u7684\u5173\u8054\uff08\u591a\u9009\uff09\uff0c\u6682\u65f6\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5904\u7406\uff08\u6c42\u5220\u9664\u3001\u65b0\u589e\u7ed1\u5b9a\u7684\u4ee3\u7801\u5df2\u751f\u6210\uff09").append(System.lineSeparator());
        codeView.append("     * ").append(System.lineSeparator());
        codeView.append("     * 2\u3001\u5982\u679c\u5f53\u524d\u6a21\u578b\u5bf9\u8c61\u662f\u4e3b\u4e1a\u52a1\u6a21\u578b").append(System.lineSeparator());
        codeView.append("     *  2.1\u3001\u521b\u5efa\u524d\u4f1a\u9a8c\u8bc1\u5f53\u524d\u6a21\u578b\u7684\u57fa\u672c\u5c5e\u6027\uff0c\u5355\u9009\u548c\u591a\u9009\u5c5e\u6027").append(System.lineSeparator());
        codeView.append("     *  2.2\u3001\u7136\u540e\u8fd8\u4f1a\u9a8c\u8bc1\u5f53\u524d\u6a21\u578b\u5173\u8054\u7684\u5404\u4e2aOneToMany\u660e\u7ec6\u4fe1\u606f\uff0c\u8c03\u7528\u660e\u7ec6\u5bf9\u8c61\u7684\u670d\u52a1\uff0c\u660e\u6bcf\u4e00\u6761\u65e2\u6709\u660e\u7ec6\u8fdb\u884c\u9a8c\u8bc1").append(System.lineSeparator());
        codeView.append("     *  \uff082.2\u7684\u6b65\u9aa4\u8fd8\u9700\u8981\u6ce8\u610f\uff0c\u5982\u679c\u5f53\u524d\u88ab\u9a8c\u8bc1\u7684\u5173\u8054\u5bf9\u8c61\u662f\u56de\u6eaf\u5bf9\u8c61\uff0c\u5219\u4e0d\u9700\u8981\u9a8c\u8bc1\u4e86\uff09").append(System.lineSeparator());
        codeView.append("     *  2.3\u3001\u8fd8\u4f1a\u9a8c\u8bc1\u5f53\u524d\u6a21\u578b\u5173\u8054\u7684\u5404\u4e2aOneToOne\u5206\u7ec4\uff0c\u8c03\u7528\u5206\u7ec4\u5bf9\u8c61\u7684\u670d\u52a1\uff0c\u5bf9\u5206\u7ec4\u4e2d\u7684\u4fe1\u606f\u8fdb\u884c\u9a8c\u8bc1").append(System.lineSeparator());
        codeView.append("     *    2.3.1\u3001\u5305\u62ec\u9a8c\u8bc1\u6bcf\u4e00\u4e2a\u5206\u7ec4\u9879\u7684\u57fa\u672c\u4fe1\u606f\u3001\u76f4\u63a5\u7684\u5355\u9009\u3001\u591a\u9009\u4fe1\u606f").append(System.lineSeparator());
        codeView.append("     *    2.3.2\u3001\u4ee5\u53ca\u9a8c\u8bc1\u6bcf\u4e2a\u5206\u7ec4\u7684OneToMany\u660e\u7ec6\u4fe1\u606f").append(System.lineSeparator());
        codeView.append("     * */").append(System.lineSeparator());
        codeView.append("    ").append(System.lineSeparator());
        if (!isMainForm) {
            this.buildEntityUpdateMethod(codeView, persistentClass, persistentClassService, persistentRelationService, persistentPropertyService, importMapping);
        } else {
            this.buildMainEntityUpdateMethod(codeView, persistentClass, persistentClassService, persistentRelationService, persistentPropertyService, importMapping);
        }
        codeView.append("    return ").append(varCurrentObject).append(";").append(System.lineSeparator());
        codeView.append("  }").append(System.lineSeparator());
        return codeView;
    }

    private void buildMainEntityUpdateMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentRelationService persistentRelationService, PersistentPropertyService persistentPropertyService, Map<String, String> importMapping) {
        String persistentClassName = persistentClass.getClassName();
        String persistentSimpleClassName = persistentClass.getSimpleClassName();
        String varName = TStringUtils.letterLowercase(persistentSimpleClassName);
        List<PersistentRelation> persistentRelations = persistentClass.getRelations();
        this.buildEntityUpdateMethod(codeView, persistentClass, persistentClassService, persistentRelationService, persistentPropertyService, importMapping);
        this.buildItemsUpdateMethod(codeView, persistentRelations, persistentClassName, varName, persistentRelationService, persistentPropertyService, importMapping);
        List oneToOneRelations = persistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToOne).collect(Collectors.toList());
        for (int index = 0; oneToOneRelations != null && index < oneToOneRelations.size(); ++index) {
            PersistentRelation relationItem = (PersistentRelation)oneToOneRelations.get(index);
            String relationClassName = relationItem.getPropertyClass();
            String relationSimpleClassName = TStringUtils.getSimpleClassName(relationClassName, true);
            String relationName = relationItem.getPropertyName();
            String relationNameVar = TStringUtils.letterLowercase(relationName);
            importMapping.put(relationClassName, relationClassName);
            String relationServiceVar = TStringUtils.letterLowercase(StringUtils.join((Object[])new String[]{relationSimpleClassName, "Service"}));
            PersistentRelation targetRelation = persistentRelationService.findByTargetPropertyName(persistentClassName, relationName);
            if (targetRelation == null) continue;
            String targetRelationPropertyName = targetRelation.getPropertyName();
            codeView.append("    // \u5904\u7406OneToOne\u5173\u7cfb\uff08\u5206\u7ec4\uff09" + relationName + "").append(System.lineSeparator());
            codeView.append("    " + relationSimpleClassName + " " + relationNameVar + " = " + varName + ".get" + TStringUtils.letterUppercase(relationName) + "();").append(System.lineSeparator());
            codeView.append("    " + relationNameVar + ".set" + TStringUtils.letterUppercase(targetRelationPropertyName) + "(" + varName + ");").append(System.lineSeparator());
            codeView.append("    this." + relationServiceVar + ".update(" + relationNameVar + ");").append(System.lineSeparator());
            PersistentClass groupPersistentClass = persistentClassService.queryByClassName(relationClassName);
            List<PersistentRelation> groupPersistentRelations = groupPersistentClass.getRelations();
            if (groupPersistentRelations == null || groupPersistentRelations.isEmpty()) continue;
            List<PersistentRelation> itemsPersistentRelations = groupPersistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToMany).collect(Collectors.toList());
            codeView.append("    // \u5904\u7406OneToOne\u5173\u7cfb\uff08\u5206\u7ec4\uff09" + relationName + "\u4e0b\u7684\u5404\u4e2a\u660e\u7ec6\u4fe1\u606f").append(System.lineSeparator());
            this.buildItemsUpdateMethod(codeView, itemsPersistentRelations, relationClassName, relationNameVar, persistentRelationService, persistentPropertyService, importMapping);
            codeView.append("    ").append(System.lineSeparator());
        }
    }

    private void buildEntityUpdateMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentRelationService persistentRelationService, PersistentPropertyService persistentPropertyService, Map<String, String> importMapping) {
        String persistentClassName = persistentClass.getClassName();
        String persistentSimpleClassName = persistentClass.getSimpleClassName();
        String varName = TStringUtils.letterLowercase(persistentSimpleClassName);
        String varRepositoryName = StringUtils.join((Object[])new String[]{TStringUtils.letterLowercase(persistentSimpleClassName), "Repository"});
        codeView.append("    this.updateValidation(" + varName + ");").append(System.lineSeparator());
        codeView.append("    // ===================\u57fa\u672c\u4fe1\u606f").append(System.lineSeparator());
        PersistentProperty primaryKeyProperty = persistentPropertyService.findPrimaryKey(persistentClassName);
        Validate.notNull((Object)primaryKeyProperty, (String)("\u672a\u627e\u5230\u4e3b\u952e\u4fe1\u606f[" + persistentClassName + "]\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        String primaryKeyClassName = primaryKeyProperty.getPropertyClass();
        String primaryKeyName = primaryKeyProperty.getPropertyName();
        String primaryKeySimpleClassName = TStringUtils.getSimpleClassName(primaryKeyClassName, true);
        String pkMethodName = StringUtils.join((Object[])new String[]{varName, ".", "get", TStringUtils.letterUppercase(primaryKeyName), "()"});
        String varPk = StringUtils.join((Object[])new String[]{"current", TStringUtils.letterUppercase(primaryKeyName)});
        String varCurrentObject = StringUtils.join((Object[])new String[]{"current", persistentSimpleClassName});
        String varOpCurrentObject = StringUtils.join((Object[])new String[]{"op_", varCurrentObject});
        String queryMethodName = StringUtils.join((Object[])new String[]{"this." + varRepositoryName + ".findById(", varPk, ")"});
        if (!persistentClass.getRepositoryEntity().booleanValue()) {
            codeView.append("    // TODO \u6ca1\u6709\u6570\u636e\u5c42\uff0c\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5b8c\u5584").append(System.lineSeparator());
            codeView.append("    " + persistentSimpleClassName + " " + varCurrentObject + " = null;").append(System.lineSeparator());
            codeView.append("    Validate.notNull(" + varCurrentObject + " ,\"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1\");").append(System.lineSeparator());
            return;
        }
        codeView.append("    " + primaryKeySimpleClassName + " " + varPk + " = " + pkMethodName + ";").append(System.lineSeparator());
        importMapping.put("java.util.Optional", "java.util.Optional");
        codeView.append("    Optional<" + persistentSimpleClassName + "> " + varOpCurrentObject + " = " + queryMethodName + ";").append(System.lineSeparator());
        codeView.append("    " + persistentSimpleClassName + " " + varCurrentObject + " = " + varOpCurrentObject + ".orElse(null);").append(System.lineSeparator());
        codeView.append("    " + varCurrentObject + " = Validate.notNull(" + varCurrentObject + " ,\"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1\");").append(System.lineSeparator());
        List notNullProperties = persistentClass.getProperties().stream().filter(item -> item.getPrimaryKey() == false).collect(Collectors.toList());
        codeView.append("    // \u5f00\u59cb\u8d4b\u503c\u2014\u2014\u66f4\u65b0\u65f6\u95f4\u4e0e\u66f4\u65b0\u4eba").append(System.lineSeparator());
        codeView.append("    Date now = new Date();").append(System.lineSeparator());
        codeView.append("    " + varCurrentObject + ".setModifyAccount(SecurityUtils.getUserAccount());").append(System.lineSeparator());
        codeView.append("    " + varCurrentObject + ".setModifyTime(now);").append(System.lineSeparator());
        if (notNullProperties != null && !notNullProperties.isEmpty()) {
            codeView.append("    // \u5f00\u59cb\u91cd\u65b0\u8d4b\u503c\u2014\u2014\u4e00\u822c\u5c5e\u6027").append(System.lineSeparator());
        }
        for (PersistentProperty persistentPropertyItem : notNullProperties) {
            String propertyName = persistentPropertyItem.getPropertyName();
            if ("createAccount".equals(persistentPropertyItem.getPropertyName()) || "modifyAccount".equals(persistentPropertyItem.getPropertyName()) || "createTime".equals(persistentPropertyItem.getPropertyName()) || "modifyTime".equals(persistentPropertyItem.getPropertyName())) continue;
            String setMethod = StringUtils.join((Object[])new String[]{varCurrentObject, ".set", TStringUtils.letterUppercase(propertyName)});
            String getMethod = StringUtils.join((Object[])new String[]{varName, ".get", TStringUtils.letterUppercase(propertyName), "()"});
            codeView.append("    " + setMethod + "(" + getMethod + ");").append(System.lineSeparator());
        }
        List<PersistentRelation> persistentRelations = persistentClass.getRelations();
        if (persistentRelations != null && !persistentRelations.isEmpty()) {
            List manyToOneRelations = persistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.ManyToOne).collect(Collectors.toList());
            for (int index = 0; manyToOneRelations != null && index < manyToOneRelations.size(); ++index) {
                PersistentRelation manyToOneRelationItem = (PersistentRelation)manyToOneRelations.get(index);
                String propertyName = manyToOneRelationItem.getPropertyName();
                String setMethod = StringUtils.join((Object[])new String[]{varCurrentObject, ".set", TStringUtils.letterUppercase(propertyName)});
                String getMethod = StringUtils.join((Object[])new String[]{varName, ".get", TStringUtils.letterUppercase(propertyName), "()"});
                codeView.append("    " + setMethod + "(" + getMethod + ");").append(System.lineSeparator());
            }
        }
        codeView.append("    ").append(System.lineSeparator());
        if (persistentClass.getRepositoryEntity().booleanValue()) {
            codeView.append("    this." + varRepositoryName + ".saveAndFlush(" + varCurrentObject + ");").append(System.lineSeparator());
        } else {
            codeView.append("    // TODO \u6ca1\u6709\u6570\u636e\u5c42\uff0c\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5b8c\u5584").append(System.lineSeparator());
        }
        if (persistentRelations == null || persistentRelations.isEmpty()) {
            return;
        }
        boolean isHandleManyToMany = false;
        if (persistentClassService.isFormInstancePersistent(persistentClassName)) {
            isHandleManyToMany = true;
        }
        List manyToOneRelations = persistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.ManyToOne).collect(Collectors.toList());
        block2: for (int index = 0; manyToOneRelations != null && index < manyToOneRelations.size(); ++index) {
            PersistentRelation manyToOneRelation = (PersistentRelation)manyToOneRelations.get(index);
            String manyToOneClassName = manyToOneRelation.getPropertyClass();
            PersistentClass manyToOnePersistentClass = persistentClassService.queryByClassName(manyToOneClassName);
            List<PersistentRelation> manyToOneRersistentRelations = manyToOnePersistentClass.getRelations();
            if (manyToOneRersistentRelations == null || manyToOneRersistentRelations.isEmpty()) {
                return;
            }
            List oneToOneRelations = manyToOneRersistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToOne).collect(Collectors.toList());
            for (int mindex = 0; oneToOneRelations != null && mindex < oneToOneRelations.size(); ++mindex) {
                PersistentRelation oneToOneRelation = (PersistentRelation)oneToOneRelations.get(mindex);
                if (!persistentClassService.isFormInstancePersistent(oneToOneRelation.getPropertyClass())) continue;
                isHandleManyToMany = true;
                continue block2;
            }
        }
        if (!isHandleManyToMany) {
            return;
        }
        List manyToManyRelations = persistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.ManyToMany).collect(Collectors.toList());
        for (int index = 0; manyToManyRelations != null && index < manyToManyRelations.size(); ++index) {
            PersistentRelation manyToManyRelationItem = (PersistentRelation)manyToManyRelations.get(index);
            String manyToManyRelationDesc = manyToManyRelationItem.getPropertyDesc();
            String relationClassName = manyToManyRelationItem.getPropertyClass();
            String relationName = manyToManyRelationItem.getPropertyName();
            String relationSimpleClassName = TStringUtils.getSimpleClassName(relationClassName, false);
            PersistentProperty manyToManyPkProperty = persistentPropertyService.findPrimaryKey(relationClassName);
            String manyToManyPkPropertyClassName = manyToManyPkProperty.getPropertyClass();
            String manyToManyPkPropertySimpleClassName = TStringUtils.getSimpleClassName(manyToManyPkPropertyClassName, false);
            String manyToManyPkPropertyName = manyToManyPkProperty.getPropertyName();
            String oldManyToManyVarNames = StringUtils.join((Object[])new String[]{"old", TStringUtils.letterUppercase(relationName), "s"});
            String currentManyToManyVarNames = StringUtils.join((Object[])new String[]{"current", TStringUtils.letterUppercase(relationName), "s"});
            String relationService = StringUtils.join((Object[])new String[]{TStringUtils.letterLowercase(relationSimpleClassName), "Service"});
            String deletePkVarNames = StringUtils.join((Object[])new String[]{TStringUtils.letterLowercase(relationName), "DeleteIds"});
            String newPkVarNames = StringUtils.join((Object[])new String[]{TStringUtils.letterLowercase(relationName), "NewIds"});
            PersistentRelation targetRelationProperty = persistentRelationService.findByTargetPropertyName(persistentClassName, relationName);
            if (targetRelationProperty == null) continue;
            String targetRelationPropertyName = targetRelationProperty.getPropertyName();
            importMapping.put("java.util.Set", "java.util.Set");
            importMapping.put(relationClassName, relationClassName);
            importMapping.put("com.google.common.collect.Sets", "com.google.common.collect.Sets");
            codeView.append("    // \u5bf9ManyToMany\u5173\u7cfb" + manyToManyRelationDesc + "\u8fdb\u884c\u5904\u7406").append(System.lineSeparator());
            codeView.append("    Set<" + relationSimpleClassName + "> " + currentManyToManyVarNames + " = " + varName + ".get" + TStringUtils.letterUppercase(relationName) + "();").append(System.lineSeparator());
            codeView.append("    Set<" + relationSimpleClassName + "> " + oldManyToManyVarNames + " = this." + relationService + ".findDetailsBy" + TStringUtils.letterUppercase(targetRelationPropertyName) + "(" + varPk + ");").append(System.lineSeparator());
            codeView.append("    if(" + oldManyToManyVarNames + " == null) { ").append(System.lineSeparator());
            codeView.append("      " + oldManyToManyVarNames + " = Sets.newLinkedHashSet();").append(System.lineSeparator());
            codeView.append("    }").append(System.lineSeparator());
            codeView.append("    if(" + currentManyToManyVarNames + " != null) { ").append(System.lineSeparator());
            codeView.append("      " + currentManyToManyVarNames + " = Sets.newLinkedHashSet();;").append(System.lineSeparator());
            codeView.append("    } ").append(System.lineSeparator());
            codeView.append("    Set<" + manyToManyPkPropertySimpleClassName + "> " + deletePkVarNames + " = kuiperToolkitService.collectionDiffent(" + oldManyToManyVarNames + ", " + currentManyToManyVarNames + ", " + relationSimpleClassName + "::get" + TStringUtils.letterUppercase(manyToManyPkPropertyName) + ");").append(System.lineSeparator());
            codeView.append("    if(!" + deletePkVarNames + ".isEmpty()) { ").append(System.lineSeparator());
            codeView.append("      // TODO " + deletePkVarNames + "\u7ed3\u679c\u662f\u88ab\u5220\u9664\u7684\u5173\u8054id\uff0c\u6620\u5c04\u8868\u7684\u5220\u9664\u64cd\u4f5c\u9700\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5904\u7406").append(System.lineSeparator());
            codeView.append("    } ").append(System.lineSeparator());
            codeView.append("    Set<" + manyToManyPkPropertySimpleClassName + "> " + newPkVarNames + " = kuiperToolkitService.collectionDiffent(" + currentManyToManyVarNames + " , " + oldManyToManyVarNames + "," + relationSimpleClassName + "::get" + TStringUtils.letterUppercase(manyToManyPkPropertyName) + ");").append(System.lineSeparator());
            codeView.append("    if(!" + newPkVarNames + ".isEmpty()) { ").append(System.lineSeparator());
            codeView.append("      // TODO " + newPkVarNames + "\u7ed3\u679c\u662f\u6dfb\u52a0\u7684\u6620\u5c04\u5173\u8054id\uff0c\u6620\u5c04\u8868\u7684\u6dfb\u52a0\u64cd\u4f5c\u9700\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5904\u7406").append(System.lineSeparator());
            codeView.append("    } ").append(System.lineSeparator());
            codeView.append("    ").append(System.lineSeparator());
        }
    }

    private void buildItemsUpdateMethod(StringBuffer codeView, List<PersistentRelation> persistentRelations, String persistentClassName, String varName, PersistentRelationService persistentRelationService, PersistentPropertyService persistentPropertyService, Map<String, String> importMapping) {
        PersistentProperty primaryKeyProperty = persistentPropertyService.findPrimaryKey(persistentClassName);
        String primaryKeyName = primaryKeyProperty.getPropertyName();
        List oneToManyRelationProperties = persistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToMany).collect(Collectors.toList());
        for (int index = 0; oneToManyRelationProperties != null && index < oneToManyRelationProperties.size(); ++index) {
            PersistentRelation relationItem = (PersistentRelation)oneToManyRelationProperties.get(index);
            importMapping.put("com.google.common.collect.Sets", "com.google.common.collect.Sets");
            importMapping.put("java.util.Set", "java.util.Set");
            String relationClassName = relationItem.getPropertyClass();
            String relationName = relationItem.getPropertyName();
            String relationSimpleClassName = TStringUtils.getSimpleClassName(relationClassName, true);
            PersistentRelation targetRelationProperty = persistentRelationService.findByTargetPropertyName(persistentClassName, relationName);
            if (targetRelationProperty == null) continue;
            PersistentProperty relationPk = persistentPropertyService.findPrimaryKey(relationClassName);
            String relationPkName = relationPk.getPropertyName();
            String relationPkClassName = relationPk.getPropertyClass();
            String relationPkSimpleClassName = TStringUtils.getSimpleClassName(relationPkClassName, true);
            importMapping.put(relationClassName, relationClassName);
            String relationCollVar = TStringUtils.letterLowercase(relationSimpleClassName) + "s";
            String relationCollItemVar = TStringUtils.letterLowercase(relationSimpleClassName) + "Item";
            String relationServiceVar = TStringUtils.letterLowercase(StringUtils.join((Object[])new String[]{relationSimpleClassName, "Service"}));
            codeView.append("    // ==========\u51c6\u5907\u5904\u7406OneToMany\u5173\u7cfb\u7684\u8be6\u60c5" + relationName).append(System.lineSeparator());
            codeView.append("    // \u6e05\u7406\u51fa\u90a3\u4e9b\u9700\u8981\u5220\u9664\u7684" + relationName + "\u4fe1\u606f").append(System.lineSeparator());
            codeView.append("    Set<" + relationSimpleClassName + "> " + relationCollVar + " = null;").append(System.lineSeparator());
            codeView.append("    if(" + varName + ".get" + TStringUtils.letterUppercase(relationName) + "() != null) { ").append(System.lineSeparator());
            codeView.append("      " + relationCollVar + " = Sets.newLinkedHashSet(" + varName + ".get" + TStringUtils.letterUppercase(relationName) + "());").append(System.lineSeparator());
            codeView.append("    } else { ").append(System.lineSeparator());
            codeView.append("      " + relationCollVar + " = Sets.newLinkedHashSet();").append(System.lineSeparator());
            codeView.append("    } ").append(System.lineSeparator());
            String dbRelationCollVar = "db" + TStringUtils.letterUppercase(relationCollVar);
            codeView.append("    Set<" + relationSimpleClassName + "> " + dbRelationCollVar + " = this." + relationServiceVar + ".findDetailsBy" + TStringUtils.letterUppercase(targetRelationProperty.getPropertyName()) + "(" + varName + ".get" + TStringUtils.letterUppercase(primaryKeyName) + "());").append(System.lineSeparator());
            codeView.append("    if(" + dbRelationCollVar + " == null) { ").append(System.lineSeparator());
            codeView.append("      " + dbRelationCollVar + " = Sets.newLinkedHashSet();").append(System.lineSeparator());
            codeView.append("    } ").append(System.lineSeparator());
            codeView.append("    // \u6c42\u5f97\u7684\u5dee\u96c6\u65e2\u662f\u9700\u8981\u5220\u9664\u7684\u6570\u636e ").append(System.lineSeparator());
            String mustDeleteVars = "mustDelete" + TStringUtils.letterUppercase(relationName) + "Pks";
            String mustDeleteVar = "mustDelete" + TStringUtils.letterUppercase(relationName) + "Pk";
            codeView.append("    Set<" + relationPkSimpleClassName + "> " + mustDeleteVars + " = kuiperToolkitService.collectionDiffent(" + dbRelationCollVar + ", " + relationCollVar + ", " + relationSimpleClassName + "::get" + TStringUtils.letterUppercase(relationPkName) + ");").append(System.lineSeparator());
            codeView.append("    if(" + mustDeleteVars + " != null && !" + mustDeleteVars + ".isEmpty()) { ").append(System.lineSeparator());
            codeView.append("      for (" + relationPkSimpleClassName + " " + mustDeleteVar + " : " + mustDeleteVars + ") { ").append(System.lineSeparator());
            codeView.append("        this." + relationServiceVar + ".deleteBy" + TStringUtils.letterUppercase(relationPkName) + "(" + mustDeleteVar + ");").append(System.lineSeparator());
            codeView.append("      } ").append(System.lineSeparator());
            codeView.append("    } ").append(System.lineSeparator());
            codeView.append("    // \u5bf9\u4f20\u6765\u7684\u8bb0\u5f55\u8fdb\u884c\u6dfb\u52a0\u6216\u8005\u4fee\u6539\u64cd\u4f5c ").append(System.lineSeparator());
            codeView.append("    for (" + relationSimpleClassName + " " + relationCollItemVar + " : " + relationCollVar + ") { ").append(System.lineSeparator());
            codeView.append("      " + relationCollItemVar + ".set" + TStringUtils.letterUppercase(targetRelationProperty.getPropertyName()) + "(" + varName + "); ").append(System.lineSeparator());
            codeView.append("      if(StringUtils.isBlank(" + relationCollItemVar + ".get" + TStringUtils.letterUppercase(relationPkName) + "())) {").append(System.lineSeparator());
            codeView.append("        " + relationServiceVar + ".create(" + relationCollItemVar + "); ").append(System.lineSeparator());
            codeView.append("      } else { ").append(System.lineSeparator());
            codeView.append("        " + relationServiceVar + ".update(" + relationCollItemVar + ");").append(System.lineSeparator());
            codeView.append("      }").append(System.lineSeparator());
            codeView.append("    }").append(System.lineSeparator());
            codeView.append("    ").append(System.lineSeparator());
        }
    }

    private StringBuffer buildUpdateValidation(String rootPackageName, PersistentClass persistentClass, PersistentPropertyService persistentPropertyService, Map<String, String> importMapping) {
        List relationsProperies;
        String propertyName;
        String persistentClassName = persistentClass.getClassName();
        String persistentSimpleClassName = persistentClass.getSimpleClassName();
        String varName = TStringUtils.letterLowercase(persistentSimpleClassName);
        PersistentProperty instanceProperty = persistentPropertyService.findByPropertyName(persistentClassName, "formInstanceId");
        boolean isMainForm = instanceProperty != null;
        StringBuffer codeView = new StringBuffer();
        codeView.append("  /**" + System.lineSeparator());
        codeView.append("   * \u5728\u66f4\u65b0\u4e00\u4e2a\u5df2\u6709\u7684" + persistentSimpleClassName + "\u6a21\u578b\u5bf9\u8c61\u4e4b\u524d\uff0c\u8be5\u79c1\u6709\u65b9\u6cd5\u68c0\u67e5\u5bf9\u8c61\u5404\u5c5e\u6027\u7684\u6b63\u786e\u6027\uff0c\u5176id\u5c5e\u6027\u5fc5\u987b\u6709\u503c" + System.lineSeparator());
        codeView.append("   */" + System.lineSeparator());
        codeView.append("  private void updateValidation(" + persistentSimpleClassName + " " + TStringUtils.letterLowercase(persistentSimpleClassName) + ") { " + System.lineSeparator());
        PersistentProperty primaryKeyProperty = persistentPropertyService.findPrimaryKey(persistentClassName);
        Validate.notNull((Object)primaryKeyProperty, (String)"\u672a\u627e\u5230\u4e3b\u952e\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!! , persistentClassName", (Object[])new Object[0]);
        String primaryKeyPropertyClassName = primaryKeyProperty.getPropertyClass();
        String primaryKeyPropertyName = primaryKeyProperty.getPropertyName();
        String methodName = StringUtils.join((Object[])new String[]{varName, ".", "get", TStringUtils.letterUppercase(primaryKeyPropertyName), "()"});
        if (StringUtils.equals((CharSequence)primaryKeyPropertyClassName, (CharSequence)"java.lang.String")) {
            codeView.append("    Validate.isTrue(!StringUtils.isBlank(" + methodName + "), \"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01\");").append(System.lineSeparator());
        } else {
            codeView.append("    Validate.isTrue(" + methodName + " == null, \"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01\");").append(System.lineSeparator());
        }
        List notNullPersistentProperies = persistentClass.getProperties().stream().filter(item -> item.getPrimaryKey() == false && item.getNullable() == false).collect(Collectors.toList());
        importMapping.put("org.apache.commons.lang3.Validate", "org.apache.commons.lang3.Validate");
        if (notNullPersistentProperies != null && !notNullPersistentProperies.isEmpty()) {
            codeView.append("    ").append(System.lineSeparator());
            codeView.append("    // \u57fa\u7840\u4fe1\u606f\u5224\u65ad\uff0c\u57fa\u672c\u5c5e\u6027\uff0c\u9700\u8981\u6ee1\u8db3not null").append(System.lineSeparator());
        }
        for (PersistentProperty persistentPropertyItem : notNullPersistentProperies) {
            String propertyClass = persistentPropertyItem.getPropertyClass();
            String propertyDesc = persistentPropertyItem.getPropertyDesc();
            String propertyName2 = persistentPropertyItem.getPropertyName();
            if ("createAccount".equals(propertyName2) || "modifyAccount".equals(propertyName2) || "createTime".equals(propertyName2) || "modifyTime".equals(propertyName2)) continue;
            String itemMethodName = StringUtils.join((Object[])new String[]{varName, ".", "get", TStringUtils.letterUppercase(propertyName2), "()"});
            if (StringUtils.equals((CharSequence)propertyClass, (CharSequence)"java.lang.String")) {
                codeView.append("    Validate.notBlank(" + itemMethodName + ", \"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c" + propertyDesc + "\u4e0d\u80fd\u4e3a\u7a7a\uff01\");").append(System.lineSeparator());
                continue;
            }
            codeView.append("    Validate.notNull(" + itemMethodName + ", \"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c" + propertyDesc + "\u4e0d\u80fd\u4e3a\u7a7a\uff01\");").append(System.lineSeparator());
        }
        List uniquePersistentProperies = persistentClass.getProperties().stream().filter(item -> item.getUnique() != false && item.getPrimaryKey() == false).collect(Collectors.toList());
        if (uniquePersistentProperies != null && !uniquePersistentProperies.isEmpty()) {
            codeView.append("    ").append(System.lineSeparator());
            codeView.append("    // \u91cd\u590d\u6027\u5224\u65ad\uff0c\u57fa\u672c\u5c5e\u6027\uff0c\u9700\u8981\u6ee1\u8db3unique = true").append(System.lineSeparator());
        }
        for (int index = 0; uniquePersistentProperies != null && index < uniquePersistentProperies.size(); ++index) {
            PersistentProperty persistentPropertyItem = (PersistentProperty)uniquePersistentProperies.get(index);
            String propertyClass = persistentPropertyItem.getPropertyClass();
            String propertyDesc = persistentPropertyItem.getPropertyDesc();
            propertyName = persistentPropertyItem.getPropertyName();
            if ("createAccount".equals(propertyName) || "modifyAccount".equals(propertyName) || "createTime".equals(propertyName) || "modifyTime".equals(propertyName)) continue;
            String itemMethodName = StringUtils.join((Object[])new String[]{varName, ".", "get", TStringUtils.letterUppercase(propertyName), "()"});
            String queryMethodName = StringUtils.join((Object[])new String[]{"this.findBy", TStringUtils.letterUppercase(propertyName), "(", itemMethodName, ")"});
            String itemCurrentVar = StringUtils.join((Object[])new String[]{"currentFor", TStringUtils.letterUppercase(propertyName)});
            if (persistentPropertyItem.getNullable().booleanValue()) {
                codeView.append("    // \u7531\u4e8e\u552f\u4e00\u5c5e\u6027\u201c" + propertyName + "\u201d\u5141\u8bb8\u4e3anull\uff0c\u6240\u4ee5\u6761\u4ef6\u6210\u7acb\u65f6\uff0c\u5f3a\u5236\u8bbe\u7f6e\u4e3anull").append(System.lineSeparator());
                codeView.append("    if(StringUtils.isBlank(" + varName + ".get" + TStringUtils.letterUppercase(propertyName) + "())) { ").append(System.lineSeparator());
                codeView.append("      " + varName + ".set" + TStringUtils.letterUppercase(propertyName) + "(null);").append(System.lineSeparator());
                codeView.append("    }").append(System.lineSeparator());
            }
            codeView.append("    " + persistentSimpleClassName + " " + itemCurrentVar + " = " + queryMethodName + ";").append(System.lineSeparator());
            if (StringUtils.equals((CharSequence)propertyClass, (CharSequence)"java.lang.String")) {
                codeView.append("    Validate.isTrue(" + itemCurrentVar + " == null || StringUtils.equals(" + itemCurrentVar + ".get" + TStringUtils.letterUppercase(primaryKeyPropertyName) + "() , " + varName + ".get" + TStringUtils.letterUppercase(primaryKeyPropertyName) + "()) , \"" + propertyDesc + "\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5\"); ").append(System.lineSeparator());
                continue;
            }
            codeView.append("    Validate.isTrue(" + itemCurrentVar + " == null || " + itemCurrentVar + ".get" + TStringUtils.letterUppercase(primaryKeyPropertyName) + "() == " + varName + ".get" + TStringUtils.letterUppercase(primaryKeyPropertyName) + "() , \"" + propertyDesc + "\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5\"); ").append(System.lineSeparator());
        }
        List stringProperties = persistentClass.getProperties().stream().filter(item -> item.getPrimaryKey() == false && StringUtils.equals((CharSequence)"java.lang.String", (CharSequence)item.getPropertyClass()) && item.getMaxLen() != null).collect(Collectors.toList());
        if (stringProperties != null) {
            codeView.append("    // \u9a8c\u8bc1\u957f\u5ea6\uff0c\u88ab\u9a8c\u8bc1\u7684\u8fd9\u4e9b\u5b57\u6bb5\u7b26\u5408\u7279\u5f81: \u5b57\u6bb5\u7c7b\u578b\u4e3aString\uff0c\u4e14\u4e0d\u4e3aPK\uff0c\u4e14canupdate = true").append(System.lineSeparator());
            for (PersistentProperty stringProperty : stringProperties) {
                if ("createAccount".equals(stringProperty.getPropertyName()) || "modifyAccount".equals(stringProperty.getPropertyName()) || "createTime".equals(stringProperty.getPropertyName()) || "modifyTime".equals(stringProperty.getPropertyName())) continue;
                Integer maxLen = stringProperty.getMaxLen();
                propertyName = stringProperty.getPropertyName();
                String propertyDesc = stringProperty.getPropertyDesc();
                codeView.append("    Validate.isTrue(" + varName + ".get" + TStringUtils.letterUppercase(propertyName) + "() == null || " + varName + ".get" + TStringUtils.letterUppercase(propertyName) + "().length() < " + maxLen + " , \"" + propertyDesc + ",\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(" + maxLen + ")\uff0c\u8bf7\u68c0\u67e5!\");").append(System.lineSeparator());
            }
        }
        if ((relationsProperies = persistentClass.getRelations().stream().filter(item -> item.getNullable() == false && (item.getRelationType() == PersistentRelation.RelationType.ManyToOne || item.getRelationType() == PersistentRelation.RelationType.OneToOne)).collect(Collectors.toList())) != null && !relationsProperies.isEmpty()) {
            codeView.append("    ").append(System.lineSeparator());
            codeView.append("    // \u5173\u8054\u6027\u5224\u65ad\uff0c\u5173\u8054\u5c5e\u6027\u5224\u65ad\uff0c\u9700\u8981\u6ee1\u8db3ManyToOne\u6216\u8005OneToOne\uff0c\u4e14not null \u4e14\u662f\u4e3b\u6a21\u578b").append(System.lineSeparator());
        }
        for (int index = 0; relationsProperies != null && isMainForm && index < relationsProperies.size(); ++index) {
            PersistentRelation persistentRelation = (PersistentRelation)relationsProperies.get(index);
            String propertyClass = persistentRelation.getPropertyClass();
            String propertyName3 = persistentRelation.getPropertyName();
            String propertySimpleClass = TStringUtils.getSimpleClassName(propertyClass, true);
            String propertyDesc = persistentRelation.getPropertyDesc();
            String itemMethodName = StringUtils.join((Object[])new String[]{varName, ".", "get", TStringUtils.letterUppercase(propertyName3), "()"});
            String itemCurrentVar = StringUtils.join((Object[])new String[]{"currentFor", TStringUtils.letterUppercase(propertyName3)});
            importMapping.put(propertyClass, propertyClass);
            codeView.append("    " + propertySimpleClass + " " + itemCurrentVar + " = " + itemMethodName + ";").append(System.lineSeparator());
            codeView.append("    Validate.notNull(" + itemCurrentVar + " , \"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c" + propertyDesc + "\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!\");").append(System.lineSeparator());
        }
        codeView.append("  } ").append(System.lineSeparator());
        return codeView;
    }

    @Override
    protected void buildRelationQueryMethods(StringBuffer codeView, PersistentClass persistentClass, PersistentRelation persistentRelation, PersistentProperty relationPrimaryProperty, PersistentClassService persistentClassService, Map<String, String> importMapping) {
    }

    @Override
    protected void buildCustomQueryMethods(StringBuffer codeView, PersistentClass persistentClass, PersistentQueryMethod queryMethodItem, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping) {
        String[] params = queryMethodItem.getParams();
        LinkedList<String> paramsVars = new LinkedList<String>();
        LinkedList<String> paramsClasses = new LinkedList<String>();
        StringBuffer paramsContexts = new StringBuffer();
        for (String param : params) {
            String[] paramItems = StringUtils.split((String)param, (String)".");
            this.foundRelationParams(persistentClass, persistentClass, paramItems, 0, persistentClassService, persistentPropertyService, persistentRelationService, importMapping, paramsVars, paramsClasses, paramsContexts);
        }
        String className = persistentClass.getClassName();
        String methodName = queryMethodItem.getMethodName();
        String simpleClassName = persistentClass.getSimpleClassName();
        importMapping.put("java.util.Set", "java.util.Set");
        importMapping.put("java.lang.Override", "java.lang.Override");
        importMapping.put(className, className);
        codeView.append("  @Override").append(System.lineSeparator());
        codeView.append("  public Set<" + simpleClassName + "> " + methodName + "(" + paramsContexts + ") { ").append(System.lineSeparator());
        for (int index = 0; index < paramsVars.size(); ++index) {
            String paramsVarItem = (String)paramsVars.get(index);
            String paramsClassItem = (String)paramsClasses.get(index);
            if (StringUtils.equals((CharSequence)paramsClassItem, (CharSequence)"java.lang.String")) {
                codeView.append("    if(StringUtils.isBlank(" + paramsVarItem + ")) { ").append(System.lineSeparator());
            } else {
                codeView.append("    if(" + paramsVarItem + " == null) { ").append(System.lineSeparator());
            }
            importMapping.put("com.google.common.collect.Sets", "com.google.common.collect.Sets");
            codeView.append("      return Sets.newHashSet();").append(System.lineSeparator());
            codeView.append("    }").append(System.lineSeparator());
        }
        String repositorySimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Repository"});
        String repositoryVar = TStringUtils.letterLowercase(repositorySimpleClassName);
        if (persistentClass.getRepositoryEntity().booleanValue()) {
            String methodVars = StringUtils.join(paramsVars, (String)",");
            codeView.append("    return " + repositoryVar + "." + methodName + "(" + methodVars + ");").append(System.lineSeparator());
        } else {
            codeView.append("    // TODO \u6ca1\u6709\u6570\u636e\u5c42\uff0c\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5b8c\u5584").append(System.lineSeparator());
            codeView.append("    return null;").append(System.lineSeparator());
        }
        codeView.append("  }").append(System.lineSeparator());
    }

    private void foundRelationParams(PersistentClass rootPrsistentClass, PersistentClass currentPrsistentClass, String[] paramArrayItems, int itemIndex, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping, List<String> paramsVars, List<String> paramsClasses, StringBuffer paramsContexts) {
        Validate.notNull((Object)rootPrsistentClass, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u63cf\u8ff0[rootPrsistentClass]!!", (Object[])new Object[0]);
        Validate.notNull((Object)currentPrsistentClass, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u63cf\u8ff0[currentPrsistentClass]!!", (Object[])new Object[0]);
        Validate.isTrue((paramArrayItems != null && paramArrayItems.length > 0 ? 1 : 0) != 0, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u4e2d\u7684\u6307\u5b9a\u5c5e\u6027!!", (Object[])new Object[0]);
        if (paramArrayItems.length == 1) {
            String param;
            String className = rootPrsistentClass.getClassName();
            PersistentProperty persistentProperty = persistentPropertyService.findByPropertyName(className, param = paramArrayItems[0]);
            if (persistentProperty == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5c5e\u6027\u4fe1\u606f\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            String propertyClass = persistentProperty.getPropertyClass();
            paramsVars.add(param);
            importMapping.put(propertyClass, propertyClass);
            paramsClasses.add(propertyClass);
            if (paramsContexts.length() != 0) {
                paramsContexts.append(" , ");
            }
            paramsContexts.append(TStringUtils.getSimpleClassName(propertyClass, true) + " " + param);
        } else if (paramArrayItems.length == itemIndex + 1) {
            String param;
            String className = currentPrsistentClass.getClassName();
            PersistentProperty persistentProperty = persistentPropertyService.findByPropertyName(className, param = paramArrayItems[itemIndex]);
            if (persistentProperty == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5c5e\u6027\u4fe1\u606f\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            String propertyClass = persistentProperty.getPropertyClass();
            String params = StringUtils.join((Object[])paramArrayItems, (String)"_");
            paramsVars.add(params);
            importMapping.put(propertyClass, propertyClass);
            paramsClasses.add(propertyClass);
            if (paramsContexts.length() != 0) {
                paramsContexts.append(" , ");
            }
            paramsContexts.append(TStringUtils.getSimpleClassName(propertyClass, true) + " " + params);
        } else {
            String propertyName = paramArrayItems[itemIndex];
            String className = currentPrsistentClass.getClassName();
            PersistentRelation persistentRelation = persistentRelationService.findByPropertyName(className, propertyName);
            if (persistentRelation == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5173\u8054\u5c5e\u6027\u4fe1\u606f\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            String propertyClass = persistentRelation.getPropertyClass();
            PersistentClass nextPersistentClass = persistentClassService.queryByClassName(propertyClass);
            if (nextPersistentClass == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5173\u8054\u5c5e\u6027\u4fe1\u606f\u7684\u7c7b\u578b\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            this.foundRelationParams(rootPrsistentClass, nextPersistentClass, paramArrayItems, itemIndex + 1, persistentClassService, persistentPropertyService, persistentRelationService, importMapping, paramsVars, paramsClasses, paramsContexts);
        }
    }

    @Override
    protected void buildCustomUpdateMethods(StringBuffer codeView, PersistentUpdateMethod updateMethodItem, PersistentClass persistentClass, Map<String, String> importMapping, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        PersistentProperty persistentProperty;
        super.buildCustomUpdateMethods(codeView, updateMethodItem, persistentClass, importMapping, persistentPropertyService, persistentRelationService);
        int offset = codeView.lastIndexOf("  public void");
        importMapping.put("javax.transaction.Transactional", "javax.transaction.Transactional");
        codeView.insert(offset, "  @Transactional" + System.lineSeparator());
        int lineSeparatorLen = System.lineSeparator().length();
        codeView.replace(codeView.length() - 1 - lineSeparatorLen, codeView.length(), " { " + System.lineSeparator());
        String[] queryParams = updateMethodItem.getQueryParams();
        if (queryParams == null || queryParams.length == 0) {
            throw new IllegalArgumentException("\u5728\u6784\u9020\u81ea\u5b9a\u4e49\u66f4\u65b0\u65b9\u6cd5\uff1a" + updateMethodItem.getMethodName() + " \u65f6\u53d1\u73b0\u5176\u6ca1\u6709\u8bbe\u5b9a\u67e5\u8be2\u6761\u4ef6\uff0c\u8fd9\u79cd\u81ea\u5b9a\u4e49\u65b9\u6cd5\u5b58\u5728\u4e1a\u52a1\u98ce\u9669\uff0c\u8bf7\u68c0\u67e5!!");
        }
        String[] updateParams = updateMethodItem.getUpdateParams();
        if (updateParams == null || updateParams.length == 0) {
            throw new IllegalArgumentException("\u5728\u6784\u9020\u81ea\u5b9a\u4e49\u66f4\u65b0\u65b9\u6cd5\uff1a" + updateMethodItem.getMethodName() + " \u65f6\u53d1\u73b0\u5176\u6ca1\u6709\u8bbe\u5b9a\u66f4\u65b0\u53c2\u6570\uff0c\u8fd9\u79cd\u81ea\u5b9a\u4e49\u65b9\u6cd5\u5b58\u5728\u4e1a\u52a1\u98ce\u9669\uff0c\u8bf7\u68c0\u67e5!!");
        }
        String persistentClassName = persistentClass.getClassName();
        String invokeParams = "";
        codeView.append("    // \u66f4\u65b0\u503c\u7684\u7ea6\u675f\uff0c\u4ec5\u5bf9\u6a21\u578b\u4e2d\u8bbe\u5b9a\u4e3anot null able\u7684\u5c5e\u6027\u8fdb\u884c\u7ea6\u675f").append(System.lineSeparator());
        for (String updateParam : updateParams) {
            if (!StringUtils.equals((CharSequence)invokeParams, (CharSequence)"")) {
                invokeParams = invokeParams + ",";
            }
            invokeParams = invokeParams + "_" + updateParam;
            persistentProperty = persistentPropertyService.findByPropertyName(persistentClassName, updateParam);
            if (persistentProperty != null) {
                String propertyDesc = persistentProperty.getPropertyDesc();
                boolean nullable = persistentProperty.getNullable();
                if (nullable) continue;
                codeView.append("    Validate.notNull(_" + updateParam + " , \"\u8fdb\u884c\u66f4\u65b0\u65f6\uff0c_" + updateParam + "[" + propertyDesc + "]\u7684\u65b0\u503c\u5fc5\u987b\u8bbe\u5b9a!!\");").append(System.lineSeparator());
                continue;
            }
            PersistentRelation relationProperty = persistentRelationService.findByPropertyName(persistentClassName, updateParam);
            String propertyDesc = relationProperty.getPropertyDesc();
            boolean nullable = relationProperty.getNullable();
            if (nullable) continue;
            codeView.append("    Validate.notNull(_" + updateParam + " , \"\u8fdb\u884c\u66f4\u65b0\u65f6\uff0c_" + updateParam + "[" + propertyDesc + "]\u7684\u65b0\u503c\u5fc5\u987b\u8bbe\u5b9a!!\");").append(System.lineSeparator());
        }
        codeView.append("    // \u66f4\u65b0\u6761\u4ef6\u7684\u7ea6\u675f").append(System.lineSeparator());
        for (String queryParam : queryParams) {
            invokeParams = invokeParams + "," + queryParam;
            persistentProperty = persistentPropertyService.findByPropertyName(persistentClassName, queryParam);
            if (persistentProperty != null) {
                String propertyClassName = persistentProperty.getPropertyClass();
                String propertyDesc = persistentProperty.getPropertyDesc();
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.String")) {
                    codeView.append("    Validate.notBlank(" + queryParam + " , \"\u8fdb\u884c\u66f4\u65b0\u65f6\uff0c" + queryParam + "[" + propertyDesc + "]\u7684\u7ea6\u675f\u6761\u4ef6\u5fc5\u987b\u6709\u503c!!\");").append(System.lineSeparator());
                    continue;
                }
                codeView.append("    Validate.notNull(" + queryParam + " , \"\u8fdb\u884c\u66f4\u65b0\u65f6\uff0c" + queryParam + "[" + propertyDesc + "]\u7684\u7ea6\u675f\u6761\u4ef6\u5fc5\u987b\u6709\u503c!!\");").append(System.lineSeparator());
                continue;
            }
            PersistentRelation persistentRelation = persistentRelationService.findByPropertyName(persistentClassName, queryParam);
            String propertyClassName = persistentRelation.getPropertyClass();
            String propertyDesc = persistentRelation.getPropertyDesc();
            if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.String")) {
                codeView.append("    Validate.notBlank(" + queryParam + " , \"\u8fdb\u884c\u66f4\u65b0\u65f6\uff0c" + queryParam + "[" + propertyDesc + "]\u7684\u7ea6\u675f\u6761\u4ef6\u5fc5\u987b\u6709\u503c!!\");").append(System.lineSeparator());
                continue;
            }
            codeView.append("    Validate.notNull(" + queryParam + " , \"\u8fdb\u884c\u66f4\u65b0\u65f6\uff0c" + queryParam + "[" + propertyDesc + "]\u7684\u7ea6\u675f\u6761\u4ef6\u5fc5\u987b\u6709\u503c!!\");").append(System.lineSeparator());
        }
        if (persistentClass.getRepositoryEntity().booleanValue()) {
            String simpleClassName = persistentClass.getSimpleClassName();
            String repositoryVar = TStringUtils.letterLowercase(StringUtils.join((Object[])new String[]{simpleClassName, "Repository"}));
            String methodName = updateMethodItem.getMethodName();
            codeView.append("    this." + repositoryVar + "." + methodName + "(" + invokeParams + ");").append(System.lineSeparator());
        } else {
            codeView.append("    // TODO \u6ca1\u6709\u6570\u636e\u5c42\uff0c\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u7f16\u5199\u6301\u4e45\u5c42\u4fdd\u5b58\u4ee3\u7801").append(System.lineSeparator());
        }
        codeView.append("  }").append(System.lineSeparator());
    }

    @Override
    protected void buildUniquenessQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping) {
        String className = persistentClass.getClassName();
        String propertyName = persistentProperty.getPropertyName();
        String propertyClassName = persistentProperty.getPropertyClass();
        String simpleClassName = TStringUtils.getSimpleClassName(className, true);
        String simplePropertyClassName = TStringUtils.getSimpleClassName(propertyClassName, true);
        if (StringUtils.indexOf((CharSequence)propertyClassName, (CharSequence)".") != -1) {
            importMapping.put(propertyClassName, propertyClassName);
        }
        importMapping.put(className, className);
        importMapping.put("java.lang.Override", "java.lang.Override");
        String methodName = "findBy" + TStringUtils.letterUppercase(propertyName);
        codeView.append("  @Override").append(System.lineSeparator());
        codeView.append("  public " + simpleClassName + " " + methodName + "(" + simplePropertyClassName + " " + propertyName + ") { " + System.lineSeparator());
        if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.String")) {
            importMapping.put("org.apache.commons.lang3.StringUtils", "org.apache.commons.lang3.StringUtils");
            codeView.append("    if(StringUtils.isBlank(" + TStringUtils.letterLowercase(propertyName) + ")) { ").append(System.lineSeparator());
        } else {
            codeView.append("    if(" + TStringUtils.letterLowercase(propertyName) + " == null) { ").append(System.lineSeparator());
        }
        codeView.append("      return null;").append(System.lineSeparator());
        codeView.append("    }").append(System.lineSeparator());
        if (persistentClass.getRepositoryEntity().booleanValue()) {
            String repositoryVar = TStringUtils.letterLowercase(StringUtils.join((Object[])new String[]{simpleClassName, "Repository"}));
            codeView.append("    return this." + repositoryVar + "." + methodName + "(" + TStringUtils.letterLowercase(propertyName) + ");").append(System.lineSeparator());
        } else {
            codeView.append("    // TODO \u6ca1\u6709\u6570\u636e\u5c42\uff0c\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5b8c\u5584").append(System.lineSeparator());
            codeView.append("    return null;").append(System.lineSeparator());
        }
        codeView.append("  } ").append(System.lineSeparator());
    }

    @Override
    protected void buildDetailsQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        String persistentClassName = persistentClass.getClassName();
        if (persistentClassService.isFormInstancePersistent(persistentClassName)) {
            this.buildMainEntityDetailsQueryMethod(codeView, persistentClass, persistentProperty, importMapping, persistentClassService, persistentRelationService, persistentPropertyService);
        } else {
            this.buildEntityDetailsQueryMethod(codeView, persistentClass, persistentProperty, importMapping, persistentClassService, false);
        }
    }

    @Override
    protected void buildDetailsQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentRelation persistentRelation, Map<String, String> importMapping, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        PersistentProperty persistentProperty = new PersistentProperty();
        persistentProperty.setPropertyName(persistentRelation.getPropertyName());
        PersistentProperty relationProperty = persistentPropertyService.findPrimaryKey(persistentRelation.getPropertyClass());
        persistentProperty.setPropertyClass(relationProperty.getPropertyClass());
        if (persistentRelation.getRelationType() == PersistentRelation.RelationType.ManyToOne || persistentRelation.getRelationType() == PersistentRelation.RelationType.ManyToMany) {
            this.buildEntityDetailsQueryMethod(codeView, persistentClass, persistentProperty, importMapping, persistentClassService, true);
        } else {
            this.buildEntityDetailsQueryMethod(codeView, persistentClass, persistentProperty, importMapping, persistentClassService, false);
        }
    }

    private void buildEntityDetailsQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping, PersistentClassService persistentClassService, boolean isSet) {
        String propertyClass = persistentProperty.getPropertyClass();
        String propertyName = persistentProperty.getPropertyName();
        String simpleClassName = persistentClass.getSimpleClassName();
        String propertyMethodName = "findDetailsBy" + TStringUtils.letterUppercase(propertyName);
        this.buildDetailsQueryMethodHead(codeView, importMapping, persistentClass, persistentClassService, persistentProperty, propertyName, propertyClass, simpleClassName, isSet);
        if (StringUtils.equals((CharSequence)propertyClass, (CharSequence)"java.lang.String")) {
            importMapping.put("org.apache.commons.lang3.StringUtils", "org.apache.commons.lang3.StringUtils");
            codeView.append("    if(StringUtils.isBlank(" + TStringUtils.letterLowercase(propertyName) + ")) { ").append(System.lineSeparator());
        } else {
            codeView.append("    if(" + TStringUtils.letterLowercase(propertyName) + " == null) { ").append(System.lineSeparator());
        }
        if (isSet) {
            importMapping.put("com.google.common.collect.Sets", "com.google.common.collect.Sets");
            codeView.append("      return Sets.newHashSet();").append(System.lineSeparator());
        } else {
            codeView.append("      return null;").append(System.lineSeparator());
        }
        codeView.append("    }").append(System.lineSeparator());
        if (persistentClass.getRepositoryEntity().booleanValue()) {
            String repositoryVar = TStringUtils.letterLowercase(StringUtils.join((Object[])new String[]{simpleClassName, "Repository"}));
            codeView.append("    return this." + repositoryVar + "." + propertyMethodName + "(" + TStringUtils.letterLowercase(propertyName) + ");").append(System.lineSeparator());
        } else {
            codeView.append("    // TODO \u6ca1\u6709\u6570\u636e\u5c42\uff0c\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5b8c\u5584").append(System.lineSeparator());
            codeView.append("    return null;").append(System.lineSeparator());
        }
        codeView.append("  }").append(System.lineSeparator());
    }

    private void buildMainEntityDetailsQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping, PersistentClassService persistentClassService, PersistentRelationService persistentRelationService, PersistentPropertyService persistentPropertyService) {
        List oneToOneRelations;
        String persistentClassName = persistentClass.getClassName();
        String persistentSimpleClassName = persistentClass.getSimpleClassName();
        String propertyClassName = persistentProperty.getPropertyClass();
        String propertySimpleClassName = TStringUtils.getSimpleClassName(propertyClassName, true);
        String propertyName = persistentProperty.getPropertyName();
        this.buildDetailsQueryMethodHead(codeView, importMapping, persistentClass, persistentClassService, persistentProperty, propertyName, propertyClassName, persistentClassName, false);
        codeView.append("    /* ").append(System.lineSeparator());
        codeView.append("     * 1\u3001\u9996\u5148\u67e5\u8be2\u8fd9\u4e2a\u4e3b\u4e1a\u52a1\u6a21\u578b\u7684\u57fa\u672c\u4fe1\u606f\u548c\u5173\u8054\u7684\uff08ManyToOne\uff09\u5355\u9009\u4fe1\u606f\u548c\uff08ManyToMany\uff09\u591a\u9009\u4fe1\u606f ").append(System.lineSeparator());
        codeView.append("     * 2\u3001\u7136\u540e\u67e5\u8be2\u8fd9\u4e2a\u4e3b\u4e1a\u52a1\u6a21\u578b\u7684\u660e\u7ec6\u5173\u8054\u4fe1\u606f\uff08OneToMany\u5173\u8054\uff09\uff0c\u5982\u4e0b\uff1a").append(System.lineSeparator());
        codeView.append("     *   2.1\u3001\u6bcf\u4e00\u4e2a\u660e\u7ec6\u5173\u8054\u4fe1\u606f\u90fd\u9700\u8981\u6309\u7167\u5f53\u524d\u4e3b\u4e1a\u52a1\u8868\u7684id\uff0c\u67e5\u8be2\u5176\u4e0b\u7684\u4e00\u822c\u4fe1\u606f\u3001\u5355\u9009\u4fe1\u606f\u548c\u591a\u9009\u4fe1\u606f").append(System.lineSeparator());
        codeView.append("     *   2.2\u3001\u67e5\u8be2\u5230\u7684\u4fe1\u606f\u5c06\u8fd4\u56de\u7ed9\u4e3b\u4e1a\u52a1\u6a21\u578b\u7684\u76f8\u5173\u5b57\u6bb5\u8fdb\u884c\u5173\u8054").append(System.lineSeparator());
        codeView.append("     * 3\u3001\u67e5\u8be2\u8fd9\u4e2a\u4e3b\u4e1a\u52a1\u6a21\u578b\u7684\u5206\u7ec4\u5173\u8054\u4fe1\u606f\uff08OneToOne\u5173\u8054\uff09\uff0c\u5982\u4e0b\uff1a").append(System.lineSeparator());
        codeView.append("     *   3.1\u3001\u6bcf\u4e00\u5206\u7ec4\u4fe1\u606f\u90fd\u8981\u67e5\u8be2\u5206\u7ec4\u7684\u4e00\u822c\u4fe1\u606f\uff0c\u4ee5\u53ca\u5206\u7ec4\u7684\u5355\u9009\u548c\u591a\u9009\u5173\u8054\u4fe1\u606f").append(System.lineSeparator());
        codeView.append("     *   3.2\u3001\u7136\u540e\u67e5\u8be2\u5206\u7ec4\u4fe1\u606f\u4e0b\u53ef\u80fd\u7684\u660e\u7ec6\u4fe1\u606f\uff08\u5b9e\u9645\u4e0a\u5c31\u662f\u4ee5\u4e0a\u201d\u6b65\u9aa42\u201c\u7684\u64cd\u4f5c\u6b65\u9aa4\u7684\u91cd\u7528\uff09").append(System.lineSeparator());
        codeView.append("     *   3.3\u3001\u6700\u540e\u5c06\u5f97\u5230\u7684\u5206\u7ec4\u4fe1\u606f\uff0c\u548c\u4e3b\u4e1a\u52a1\u8868\u7684\u76f8\u5173\u5b57\u6bb5\u8fdb\u884c\u5173\u8054").append(System.lineSeparator());
        codeView.append("     * \u6ce8\u610f\uff1a\u4e0d\u80fd\u5077\u61d2\u53ea\u5199\u4e00\u4e2aHQL\uff0c\u56e0\u4e3a\u5173\u8054\u4fe1\u606f\u5f88\u591a\uff0c\u6570\u636e\u8868\u4e00\u65e6\u8fc7\u5927\uff0c\u4f1a\u670910\u591a\u4e2a\u5de6\u5916\u8fde\u63a5\uff0c\u800c\u4e14\u7ecf\u5e38\u51fa\u73b0\u91cd\u590d\u6570\u636e").append(System.lineSeparator());
        codeView.append("     * */").append(System.lineSeparator());
        codeView.append("    ").append(System.lineSeparator());
        String mainEntityVarName = "current";
        codeView.append("    // \u8fd9\u662f\u4e3b\u6a21\u578b\u4e0b\u7684\u660e\u7ec6\u67e5\u8be2\u8fc7\u7a0b").append(System.lineSeparator());
        codeView.append("    // 1\u3001=======").append(System.lineSeparator());
        codeView.append("    if(StringUtils.isBlank(" + propertyName + ")) { ").append(System.lineSeparator());
        codeView.append("      return null; ").append(System.lineSeparator());
        codeView.append("    } ").append(System.lineSeparator());
        String propertyMethodName = "findDetailsBy" + TStringUtils.letterUppercase(propertyName);
        if (persistentClass.getRepositoryEntity().booleanValue()) {
            String repositoryVar = TStringUtils.letterLowercase(StringUtils.join((Object[])new String[]{persistentSimpleClassName, "Repository"}));
            codeView.append("    " + persistentSimpleClassName + " " + mainEntityVarName + " = this." + repositoryVar + "." + propertyMethodName + "(" + TStringUtils.letterLowercase(propertyName) + ");").append(System.lineSeparator());
        } else {
            codeView.append("    // TODO \u6ca1\u6709\u6570\u636e\u5c42\uff0c\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5b8c\u5584\uff08\u8bf7\u4ece\u8fd9\u91cc\u8fdb\u884c\u4fee\u6539\uff09").append(System.lineSeparator());
            codeView.append("    " + persistentSimpleClassName + " " + mainEntityVarName + " = new " + persistentSimpleClassName + "();").append(System.lineSeparator());
        }
        codeView.append("    if(" + mainEntityVarName + " == null) {").append(System.lineSeparator());
        codeView.append("      return null;").append(System.lineSeparator());
        codeView.append("    } ").append(System.lineSeparator());
        List<PersistentRelation> relations = persistentClass.getRelations();
        if (relations == null || relations.isEmpty()) {
            codeView.append("    return " + mainEntityVarName + ";").append(System.lineSeparator());
            codeView.append("  }").append(System.lineSeparator());
            return;
        }
        String propertyVarName = "currentPkValue";
        codeView.append("    " + propertySimpleClassName + " " + propertyVarName + " = " + mainEntityVarName + ".getId();").append(System.lineSeparator());
        List<PersistentRelation> oneToManyRelations = relations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToMany).collect(Collectors.toList());
        if (oneToManyRelations != null && !oneToManyRelations.isEmpty()) {
            codeView.append("    // 2\u3001======").append(System.lineSeparator());
            this.buildItemsDetailsQueryMethod(codeView, persistentClassName, mainEntityVarName, propertyVarName, oneToManyRelations, importMapping, persistentRelationService);
        }
        if ((oneToOneRelations = relations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToOne).collect(Collectors.toList())) == null || oneToOneRelations.isEmpty()) {
            codeView.append("    return " + mainEntityVarName + ";").append(System.lineSeparator());
            codeView.append("  }").append(System.lineSeparator());
            return;
        }
        codeView.append("    // 3\u3001======").append(System.lineSeparator());
        for (PersistentRelation oneToOneRelation : oneToOneRelations) {
            String oneToOneClassName = oneToOneRelation.getPropertyClass();
            String oneToOnePropertyName = oneToOneRelation.getPropertyName();
            String oneToOneSimpleClassName = TStringUtils.getSimpleClassName(oneToOneClassName, true);
            PersistentProperty oneToOnePkProperty = persistentPropertyService.findPrimaryKey(oneToOneClassName);
            String oneToOnePkPropertyName = oneToOnePkProperty.getPropertyName();
            String oneToOneSimpleServiceClassName = TStringUtils.letterLowercase(StringUtils.join((Object[])new String[]{oneToOneSimpleClassName, "Service"}));
            String oneToOneDesc = oneToOnePkProperty.getPropertyDesc();
            String oneToOneVarName = StringUtils.join((Object[])new String[]{"oneToOne", TStringUtils.letterUppercase(oneToOnePropertyName), "Group"});
            String oneToOnePkVarName = StringUtils.join((Object[])new String[]{oneToOneVarName, "Pk"});
            String oneToOnePkClassName = oneToOnePkProperty.getPropertyClass();
            String oneToOnePkSimpleClassName = TStringUtils.getSimpleClassName(oneToOnePkClassName, true);
            PersistentRelation targetPersistentRelation = persistentRelationService.findByTargetPropertyName(persistentClassName, oneToOnePropertyName);
            if (targetPersistentRelation == null) continue;
            String targetOneToManyPropertyName = targetPersistentRelation.getPropertyName();
            codeView.append("    // " + oneToOneDesc + " \u5206\u7ec4\u4fe1\u606f\u67e5\u8be2").append(System.lineSeparator());
            codeView.append("    " + oneToOneSimpleClassName + " " + oneToOneVarName + " = this." + oneToOneSimpleServiceClassName + ".findDetailsBy" + TStringUtils.letterUppercase(targetOneToManyPropertyName) + "(" + propertyVarName + ");").append(System.lineSeparator());
            codeView.append("    if(" + oneToOneVarName + " != null) { ").append(System.lineSeparator());
            codeView.append("      " + mainEntityVarName + ".set" + TStringUtils.letterUppercase(oneToOnePropertyName) + "(" + oneToOneVarName + ");").append(System.lineSeparator());
            PersistentClass oneToOnePersistentClass = persistentClassService.queryByClassName(oneToOneClassName);
            List<PersistentRelation> targetRelations = oneToOnePersistentClass.getRelations();
            if (targetRelations == null || targetRelations.isEmpty()) {
                codeView.append("    }").append(System.lineSeparator());
                continue;
            }
            List<PersistentRelation> oneToOneTargetRelations = targetRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToMany).collect(Collectors.toList());
            if (oneToOneTargetRelations == null || oneToOneTargetRelations.isEmpty()) {
                codeView.append("    }").append(System.lineSeparator());
                continue;
            }
            codeView.append("      " + oneToOnePkSimpleClassName + " " + oneToOnePkVarName + " = " + oneToOneVarName + ".get" + TStringUtils.letterUppercase(oneToOnePkPropertyName) + "();").append(System.lineSeparator());
            this.buildItemsDetailsQueryMethod(codeView, oneToOneClassName, oneToOneVarName, oneToOnePkVarName, oneToOneTargetRelations, importMapping, persistentRelationService);
            codeView.append("    }").append(System.lineSeparator());
        }
        Set<String> returnPropertiesFilters = this.buildAllWhiteProperties(persistentClass, persistentClassService);
        String returnPropertiesFilter = "";
        if (returnPropertiesFilters != null && !returnPropertiesFilters.isEmpty()) {
            Object[] returnPropertiesFilterArray = returnPropertiesFilters.toArray(new String[0]);
            returnPropertiesFilter = "\"" + StringUtils.join((Object[])returnPropertiesFilterArray, (String)"\",\"") + "\"";
        }
        importMapping.put("java.util.LinkedHashSet", "java.util.LinkedHashSet");
        importMapping.put("java.util.LinkedList", "java.util.LinkedList");
        codeView.append("    " + persistentSimpleClassName + " currentt = this.kuiperToolkitService.copyObjectByWhiteList(" + mainEntityVarName + ", " + persistentSimpleClassName + ".class, LinkedHashSet.class, LinkedList.class, new String[]{" + returnPropertiesFilter + "});").append(System.lineSeparator());
        codeView.append("    ").append(System.lineSeparator());
        codeView.append("    return currentt;").append(System.lineSeparator());
        codeView.append("  }").append(System.lineSeparator());
    }

    private void buildDetailsQueryMethodHead(StringBuffer codeView, Map<String, String> importMapping, PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentProperty persistentProperty, String propertyName, String propertyClassName, String persistentClassName, boolean isSet) {
        String simpleClassName = persistentClass.getSimpleClassName();
        String propertySimpleClassName = TStringUtils.getSimpleClassName(propertyClassName, true);
        String methodName = "findDetailsBy" + TStringUtils.letterUppercase(propertyName);
        if (StringUtils.indexOf((CharSequence)propertyClassName, (CharSequence)".") != -1) {
            importMapping.put(propertyClassName, propertyClassName);
        }
        importMapping.put("java.lang.Override", "java.lang.Override");
        codeView.append("  @Override").append(System.lineSeparator());
        if (isSet) {
            importMapping.put("java.util.Set", "java.util.Set");
            codeView.append("  public Set<" + simpleClassName + "> " + methodName + "(" + propertySimpleClassName + " " + propertyName + ") {" + System.lineSeparator());
        } else {
            codeView.append("  public " + simpleClassName + " " + methodName + "(" + propertySimpleClassName + " " + propertyName + ") {" + System.lineSeparator());
        }
    }

    private void buildItemsDetailsQueryMethod(StringBuffer codeView, String persistentClassName, String parentEntityVarName, String parentEntityPkVarName, List<PersistentRelation> oneToManyRelations, Map<String, String> importMapping, PersistentRelationService persistentRelationService) {
        for (PersistentRelation oneToManyRelation : oneToManyRelations) {
            String oneToManyClassName = oneToManyRelation.getPropertyClass();
            String oneToManyDesc = oneToManyRelation.getPropertyDesc();
            String oneToManySimpleClassName = TStringUtils.getSimpleClassName(oneToManyClassName, true);
            String oneToManySimpleServiceClassName = TStringUtils.letterLowercase(StringUtils.join((Object[])new String[]{oneToManySimpleClassName, "Service"}));
            String relationName = oneToManyRelation.getPropertyName();
            PersistentRelation targetPersistentRelation = persistentRelationService.findByTargetPropertyName(persistentClassName, relationName);
            if (targetPersistentRelation == null) continue;
            String targetOneToManyPropertyName = targetPersistentRelation.getPropertyName();
            String oneToManyVarName = StringUtils.join((Object[])new String[]{"oneToMany", TStringUtils.letterUppercase(relationName), "Details"});
            importMapping.put("com.google.common.collect.Sets", "com.google.common.collect.Sets");
            importMapping.put("java.util.Collection", "java.util.Collection");
            codeView.append("    // " + oneToManyDesc + " \u7684\u660e\u7ec6\u4fe1\u606f\u67e5\u8be2").append(System.lineSeparator());
            codeView.append("    Collection<" + oneToManySimpleClassName + "> " + oneToManyVarName + " = this." + oneToManySimpleServiceClassName + ".findDetailsBy" + TStringUtils.letterUppercase(targetOneToManyPropertyName) + "(" + parentEntityPkVarName + ");").append(System.lineSeparator());
            codeView.append("    " + parentEntityVarName + ".set" + TStringUtils.letterUppercase(relationName) + "(Sets.newLinkedHashSet(" + oneToManyVarName + "));").append(System.lineSeparator());
        }
        codeView.append("    ").append(System.lineSeparator());
    }

    @Override
    protected void buildPkQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty pkProperty, Map<String, String> importMapping) {
        String persistentSimpleClassName = persistentClass.getSimpleClassName();
        String pkPropertyName = pkProperty.getPropertyName();
        String pkPropertyClassName = pkProperty.getPropertyClass();
        String pkSimplePropertyClassName = TStringUtils.getSimpleClassName(pkPropertyClassName, false);
        String repositoryVar = TStringUtils.letterLowercase(StringUtils.join((Object[])new String[]{persistentSimpleClassName, "Repository"}));
        importMapping.put("java.lang.Override", "java.lang.Override");
        importMapping.put("java.util.Optional", "java.util.Optional");
        codeView.append("  @Override").append(System.lineSeparator());
        codeView.append("  public " + persistentSimpleClassName + " findBy" + TStringUtils.letterUppercase(pkPropertyName) + "(" + pkSimplePropertyClassName + " " + pkPropertyName + ") { " + System.lineSeparator());
        if (StringUtils.equals((CharSequence)pkPropertyClassName, (CharSequence)"java.lang.String")) {
            importMapping.put("org.apache.commons.lang3.StringUtils", "org.apache.commons.lang3.StringUtils");
            codeView.append("    if(StringUtils.isBlank(" + TStringUtils.letterLowercase(pkPropertyName) + ")) { ").append(System.lineSeparator());
        } else {
            codeView.append("    if(" + TStringUtils.letterLowercase(pkPropertyName) + " == null) { ").append(System.lineSeparator());
        }
        codeView.append("      return null;").append(System.lineSeparator());
        codeView.append("    }").append(System.lineSeparator());
        codeView.append("    ").append(System.lineSeparator());
        codeView.append("    Optional<" + persistentSimpleClassName + "> op = " + repositoryVar + ".findById(" + pkPropertyName + ");").append(System.lineSeparator());
        codeView.append("    return op.orElse(null); ").append(System.lineSeparator());
        codeView.append("  }").append(System.lineSeparator());
    }

    @Override
    protected void buildPkDeleteMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping, PersistentClassService persistentClassService) {
        String propertyName = persistentProperty.getPropertyName();
        String propertyClassName = persistentProperty.getPropertyClass();
        String propertySimpleClassName = TStringUtils.getSimpleClassName(propertyClassName, true);
        if (StringUtils.indexOf((CharSequence)propertyClassName, (CharSequence)".") != -1) {
            importMapping.put(propertyClassName, propertyClassName);
        }
        String simpleClassName = persistentClass.getSimpleClassName();
        String repositoryClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Repository"});
        String repositoryVar = TStringUtils.letterLowercase(repositoryClassName);
        importMapping.put("java.lang.Override", "java.lang.Override");
        importMapping.put("org.apache.commons.lang3.Validate", "org.apache.commons.lang3.Validate");
        importMapping.put("javax.transaction.Transactional", "javax.transaction.Transactional");
        codeView.append("  @Override").append(System.lineSeparator());
        codeView.append("  @Transactional").append(System.lineSeparator());
        codeView.append("  public void deleteBy" + TStringUtils.letterUppercase(propertyName) + "(" + propertySimpleClassName + " " + propertyName + ") {" + System.lineSeparator());
        codeView.append("    // \u53ea\u6709\u5b58\u5728\u624d\u8fdb\u884c\u5220\u9664").append(System.lineSeparator());
        codeView.append("    Validate.notBlank(id , \"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!\");").append(System.lineSeparator());
        if (!persistentClass.getRepositoryEntity().booleanValue()) {
            codeView.append("    // TODO \u6ca1\u6709\u6570\u636e\u5c42\uff0c\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5b8c\u5584 ").append(System.lineSeparator());
            codeView.append("  } ").append(System.lineSeparator());
        } else {
            codeView.append("    " + simpleClassName + " current = this.findById(" + propertyName + ");").append(System.lineSeparator());
            codeView.append("    if(current != null) { ").append(System.lineSeparator());
            codeView.append("      this." + repositoryVar + ".delete(current);").append(System.lineSeparator());
            codeView.append("    }").append(System.lineSeparator());
            codeView.append("  }").append(System.lineSeparator());
        }
    }
}

