/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.saturn.engine.handler;

import com.bizunited.nebula.saturn.context.SaturnContext;
import com.bizunited.nebula.saturn.context.service.PersistentClassService;
import com.bizunited.nebula.saturn.context.service.PersistentPropertyService;
import com.bizunited.nebula.saturn.context.service.PersistentRelationService;
import com.bizunited.nebula.saturn.engine.handler.AbstractGenerateHandler;
import com.bizunited.nebula.saturn.model.PersistentClass;
import com.bizunited.nebula.saturn.model.PersistentProperty;
import com.bizunited.nebula.saturn.model.PersistentQueryMethod;
import com.bizunited.nebula.saturn.model.PersistentRelation;
import com.bizunited.nebula.saturn.model.PersistentUpdateMethod;
import com.bizunited.nebula.saturn.utils.TStringUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInterfaceGenerateHandler
extends AbstractGenerateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceInterfaceGenerateHandler.class);

    @Override
    public Void handle(SaturnContext context) {
        String rootPackage = context.getRootPackage();
        String projectAbsolutePath = context.getProjectAbsolutePath();
        String projectSrcAbsolutePath = StringUtils.join((Object[])new String[]{projectAbsolutePath, "/", context.getProjectSrcPath()});
        Validate.notBlank((CharSequence)rootPackage, (String)"\u5fc5\u987b\u6307\u5b9a\u6839\u5305\u8def\u5f84[rootPackages]\uff0c\u624d\u80fd\u5728\u6839\u5305\u8def\u5f84\u7684\u4f4d\u7f6e\u5b8c\u6210\u6570\u636e\u5c42\u4ee3\u7801\u751f\u6210", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)projectSrcAbsolutePath, (String)"\u5fc5\u987b\u6307\u5b9a\u4e3b\u4ee3\u7801\u8def\u5f84[projectSrcAbsolutePath]", (Object[])new Object[0]);
        PersistentClassService persistentClassService = context.getPersistentClassService();
        Validate.notNull((Object)persistentClassService, (String)"not found persistentClassService!!error", (Object[])new Object[0]);
        List<PersistentClass> persistentClasses = persistentClassService.queryAllClasses();
        Validate.isTrue((persistentClasses != null && !persistentClasses.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u6a21\u578b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u524d\u7f6e\u8fd0\u884c\u626b\u63cf\u5668", (Object[])new Object[0]);
        PersistentPropertyService persistentPropertyService = context.getPersistentPropertyService();
        PersistentRelationService persistentRelationService = context.getPersistentRelationService();
        Validate.notNull((Object)persistentPropertyService, (String)"not found persistentPropertyService!!error", (Object[])new Object[0]);
        Validate.notNull((Object)persistentRelationService, (String)"not found persistentRelationService!!error", (Object[])new Object[0]);
        if (context.getOnlyBuildEntity().booleanValue()) {
            persistentClasses = persistentClasses.stream().filter(item -> item.getRepositoryEntity()).collect(Collectors.toList());
        }
        if (context.getOnlyBuildVo().booleanValue()) {
            persistentClasses = persistentClasses.stream().filter(item -> item.getRepositoryEntity() == false).collect(Collectors.toList());
        }
        for (PersistentClass itemPersistentClass : persistentClasses) {
            HashMap<String, String> importMapping = new HashMap<String, String>();
            String simpleClassName = itemPersistentClass.getSimpleClassName();
            String domain = itemPersistentClass.getDomain();
            String persistentClassName = itemPersistentClass.getClassName();
            String persistentPackageName = TStringUtils.getPreviousPackage(persistentClassName);
            if (AbstractGenerateHandler.IGNOREPACKAGES.contains(persistentPackageName)) continue;
            String servicePackage = null;
            servicePackage = StringUtils.isBlank((CharSequence)domain) ? StringUtils.join((Object[])new String[]{rootPackage, ".service"}) : StringUtils.join((Object[])new String[]{rootPackage, ".service", ".", domain});
            String serviceSimpleClass = StringUtils.join((Object[])new String[]{simpleClassName, "Service"});
            if (itemPersistentClass.getRepositoryEntity().booleanValue() && StringUtils.isBlank((CharSequence)itemPersistentClass.getRepositoryTable())) continue;
            try {
                StringBuffer repositoryFileContext = this.buildIServiceFileContext(itemPersistentClass, importMapping, rootPackage, persistentClassService, persistentPropertyService, persistentRelationService);
                if (repositoryFileContext == null) continue;
                this.buildJavaFile(repositoryFileContext.toString(), projectSrcAbsolutePath, servicePackage, serviceSimpleClass);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
                e.printStackTrace(System.out);
            }
        }
        return null;
    }

    private StringBuffer buildIServiceFileContext(PersistentClass persistentClass, Map<String, String> importMapping, String rootPackage, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        String simpleClassName = persistentClass.getSimpleClassName();
        String className = persistentClass.getClassName();
        StringBuffer javacontexts = new StringBuffer();
        String domain = persistentClass.getDomain();
        String servicePackage = null;
        servicePackage = StringUtils.isBlank((CharSequence)domain) ? StringUtils.join((Object[])new String[]{rootPackage, ".service"}) : StringUtils.join((Object[])new String[]{rootPackage, ".service", ".", domain});
        String serviceSimpleClassName = StringUtils.join((Object[])new String[]{simpleClassName, "Service"});
        PersistentProperty primaryKey = persistentPropertyService.findPrimaryKey(className);
        importMapping.put(className, className);
        if (primaryKey != null) {
            String primaryKeyClass = primaryKey.getPropertyClass();
            importMapping.put(primaryKeyClass, primaryKeyClass);
        }
        javacontexts.append("package " + servicePackage + ";" + System.lineSeparator());
        if (importMapping.isEmpty()) {
            LOGGER.error("\u9519\u8bef\u7684import\u53c2\u6570\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!");
            return null;
        }
        StringBuffer javaBodyContext = new StringBuffer();
        javaBodyContext.append(System.lineSeparator());
        javaBodyContext.append("/**").append(System.lineSeparator());
        javaBodyContext.append(" * ").append(simpleClassName).append("\u4e1a\u52a1\u6a21\u578b\u7684\u670d\u52a1\u5c42\u63a5\u53e3\u5b9a\u4e49").append(System.lineSeparator());
        javaBodyContext.append(" * @author saturn").append(System.lineSeparator());
        javaBodyContext.append(" */").append(System.lineSeparator());
        javaBodyContext.append("public interface ").append(serviceSimpleClassName).append(" { ").append(System.lineSeparator());
        StringBuffer createContext = this.buildCreateMethod(persistentClass, persistentClassService, persistentPropertyService, persistentRelationService, importMapping);
        javaBodyContext.append(createContext);
        StringBuffer createFormContext = this.buildCreateFormMethod(persistentClass, persistentClassService, persistentPropertyService, persistentRelationService, importMapping);
        javaBodyContext.append(createFormContext);
        StringBuffer updateContext = this.buildUpdateMethod(persistentClass, persistentClassService, persistentPropertyService, persistentRelationService, importMapping);
        javaBodyContext.append(updateContext);
        StringBuffer updateFormContext = this.buildUpdateFormMethod(persistentClass, persistentClassService, persistentPropertyService, persistentRelationService, importMapping);
        javaBodyContext.append(updateFormContext);
        StringBuffer methodContexts = this.scanAndBuildCustomUpdateMethods(persistentClass, importMapping, persistentPropertyService, persistentRelationService);
        javaBodyContext.append(methodContexts);
        methodContexts = this.scanAndBuildRelationQueryMethods(persistentClass, importMapping, persistentClassService, persistentPropertyService, persistentRelationService);
        javaBodyContext.append(methodContexts);
        methodContexts = this.scanAndbuildUniquenessQueryMethod(persistentClass, importMapping, persistentClassService, persistentPropertyService, persistentRelationService);
        javaBodyContext.append(methodContexts);
        methodContexts = this.scanAndBuildCustomQueryMethods(persistentClass, persistentClassService, persistentPropertyService, persistentRelationService, importMapping);
        javaBodyContext.append(methodContexts);
        LinkedList importsList = new LinkedList();
        importMapping.keySet().stream().sorted((target, souce) -> StringUtils.compare((String)target, (String)souce)).forEach(importItem -> importsList.add("import " + importItem + ";"));
        String importContext = StringUtils.join((Object[])importsList.toArray(new String[0]), (String)System.lineSeparator());
        javacontexts.append(importContext).append(System.lineSeparator());
        javacontexts.append(javaBodyContext);
        javacontexts.append("}");
        LOGGER.debug("===================" + serviceSimpleClassName + ":" + javacontexts.toString());
        return javacontexts;
    }

    protected StringBuffer buildCreateMethod(PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService PersistentRelationService2, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        String simpleClassName = persistentClass.getSimpleClassName();
        String desc = "\u521b\u5efa\u4e00\u4e2a\u65b0\u7684" + simpleClassName + "\u6a21\u578b\u5bf9\u8c61\uff08\u5305\u62ec\u4e86\u53ef\u80fd\u7684\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8c03\u7528\u3001\u590d\u6742\u903b\u8f91\u5904\u7406\u7b49\uff09";
        codeView.append("  /**" + System.lineSeparator());
        codeView.append("   * " + desc + System.lineSeparator());
        codeView.append("   */" + System.lineSeparator());
        codeView.append("  " + simpleClassName + " create(" + simpleClassName + " " + TStringUtils.letterLowercase(simpleClassName) + ");" + System.lineSeparator());
        return codeView;
    }

    protected StringBuffer buildCreateFormMethod(PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService PersistentRelationService2, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        String simpleClassName = persistentClass.getSimpleClassName();
        String desc = "\u521b\u5efa\u4e00\u4e2a\u65b0\u7684StudentEntity\u6a21\u578b\u5bf9\u8c61" + System.lineSeparator();
        desc = StringUtils.join((Object[])new String[]{desc, "   * \u8be5\u4ee3\u7801\u7531satrun\u9aa8\u67b6\u751f\u6210\uff0c\u9ed8\u8ba4\u4e0d\u5305\u62ec\u4efb\u4f55\u53ef\u80fd\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8c03\u7528\u3001\u4efb\u4f55\u590d\u6742\u903b\u8f91\u5904\u7406\u7b49\uff0c\u4e3b\u8981\u5e94\u7528\u573a\u666f\u4e3a\u524d\u7aef\u8868\u5355\u6570\u636e\u7684\u6682\u5b58\u529f\u80fd</br>", System.lineSeparator()});
        desc = StringUtils.join((Object[])new String[]{desc, "   * \u8be5\u65b9\u6cd5\u4e0e\u672c\u63a5\u53e3\u4e2d\u7684updateFrom\u65b9\u6cd5\u547c\u5e94"});
        codeView.append("  /**" + System.lineSeparator());
        codeView.append("   * " + desc + System.lineSeparator());
        codeView.append("   */" + System.lineSeparator());
        codeView.append("  " + simpleClassName + " createForm(" + simpleClassName + " " + TStringUtils.letterLowercase(simpleClassName) + ");" + System.lineSeparator());
        return codeView;
    }

    protected StringBuffer buildUpdateMethod(PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        String simpleClassName = persistentClass.getSimpleClassName();
        String simpleDesc = StringUtils.join((Object[])new String[]{"\u66f4\u65b0\u4e00\u4e2a\u5df2\u6709\u7684", simpleClassName, "\u6a21\u578b\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u5c5e\u6027\u5fc5\u987b\u6709\u503c(1.1.4-release\u7248\u672c\u8c03\u6574)\u3002"});
        String desc = StringUtils.join((Object[])new String[]{simpleDesc, System.lineSeparator()});
        desc = StringUtils.join((Object[])new String[]{desc, "   * \u8fd9\u4e2a\u65b9\u6cd5\u5b9e\u9645\u4e0a\u4e00\u5171\u5206\u4e3a\u4e09\u4e2a\u6b65\u9aa4\uff08\u9ed8\u8ba4\uff09\uff1a</br>", System.lineSeparator()});
        desc = StringUtils.join((Object[])new String[]{desc, "   * 1\u3001\u8c03\u7528updateValidation\u65b9\u6cd5\u5b8c\u6210\u8868\u5355\u6570\u636e\u66f4\u65b0\u524d\u7684\u9a8c\u8bc1</br>", System.lineSeparator()});
        desc = StringUtils.join((Object[])new String[]{desc, "   * 2\u3001\u8c03\u7528updateForm\u65b9\u6cd5\u5b8c\u6210\u8868\u5355\u6570\u636e\u7684\u66f4\u65b0</br>", System.lineSeparator()});
        desc = StringUtils.join((Object[])new String[]{desc, "   * 3\u3001\u5b8c\u6210\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5728\u672cupdate\u65b9\u6cd5\u4e2d\u4e66\u5199\u7684\uff0c\u8fdb\u884c\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8c03\u7528\uff08\u6216\u7279\u6b8a\u5904\u7406\u8fc7\u7a0b\uff09\u7684\u6267\u884c\u3002</br>", System.lineSeparator()});
        desc = StringUtils.join((Object[])new String[]{desc, "   * \u8fd9\u6837\u505a\u7684\u76ee\u7684\uff0c\u5b9e\u9645\u4e0a\u662f\u4e3a\u4e86\u4fdd\u8bc1updateForm\u65b9\u6cd5\u4e2d\u7eaf\u7cb9\u662f\u5904\u7406\u8868\u5355\u6570\u636e\u7684\uff0c\u5728\u6570\u636e\u6062\u590d\u8868\u5355\u5f15\u64ce\u9ed8\u8ba4\u8c03\u7528updateForm\u65b9\u6cd5\u65f6\uff0c\u4e0d\u4f1a\u5f71\u54cd\u4efb\u4f55\u7b2c\u4e09\u65b9\u4e1a\u52a1\u6570\u636e", System.lineSeparator()});
        desc = StringUtils.join((Object[])new String[]{desc, "   * \uff08\u5f53\u7136\uff0c\u5982\u679c\u7cfb\u7edf\u6709\u7279\u522b\u8981\u6c42\uff0c\u53ef\u7531\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5b8c\u6210\u4ee3\u7801\u903b\u8f91\u8c03\u6574\uff09", System.lineSeparator()});
        codeView.append("  /**" + System.lineSeparator());
        codeView.append("   * " + desc);
        codeView.append("   */" + System.lineSeparator());
        codeView.append("  " + simpleClassName + " update(" + simpleClassName + " " + TStringUtils.letterLowercase(simpleClassName) + ");" + System.lineSeparator());
        return codeView;
    }

    protected StringBuffer buildUpdateFormMethod(PersistentClass persistentClass, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping) {
        StringBuffer codeView = new StringBuffer();
        String simpleClassName = persistentClass.getSimpleClassName();
        String simpleDesc = "\u8be5\u65b9\u6cd5\u53ea\u7528\u4e8e\u5904\u7406\u4e1a\u52a1\u8868\u5355\u4fe1\u606f\uff0c\u5305\u62ec\u4e86\u4e3b\u4e1a\u52a1\u6a21\u578b\u3001\u5176\u4e0b\u7684\u5173\u8054\u6a21\u578b\u3001\u5206\u7ec4\u4fe1\u606f\u548c\u660e\u7ec6\u7ec6\u4fe1\u606f\u7b49";
        String desc = StringUtils.join((Object[])new String[]{simpleDesc, System.lineSeparator()});
        desc = StringUtils.join((Object[])new String[]{desc, "   * \u8be5\u65b9\u6cd5\u975e\u5e38\u91cd\u8981\uff0c\u56e0\u4e3a\u5982\u679c\u8fdb\u884c\u9759\u6001\u8868\u5355\u7684\u6570\u636e\u6062\u590d\uff0c\u90a3\u4e48\u8868\u5355\u5f15\u64ce\u5c06\u9ed8\u8ba4\u8c03\u7528\u4e3b\u4e1a\u52a1\u6a21\u578b\uff08\u670d\u52a1\u5c42\uff09\u7684\u8fd9\u4e2a\u65b9\u6cd5\u3002</br>", System.lineSeparator()});
        desc = StringUtils.join((Object[])new String[]{desc, "   * \u8fd9\u6837\u4e00\u6765\u4fdd\u8bc1\u4e86\u6570\u636e\u6062\u590d\u65f6\uff0c\u4e0d\u4f1a\u6d89\u53ca\u4efb\u4f55\u7b2c\u4e09\u65b9\u7cfb\u7edf\u7684\u8c03\u7528\uff08\u5f53\u7136\uff0c\u5982\u679c\u5f00\u53d1\u4eba\u5458\u9700\u8981\u6d89\u53ca\u7684\uff0c\u53ef\u4ee5\u81ea\u884c\u8fdb\u884c\u4fee\u6539\uff09", System.lineSeparator()});
        codeView.append("  /**" + System.lineSeparator());
        codeView.append("   * " + desc);
        codeView.append("   */" + System.lineSeparator());
        codeView.append("  " + simpleClassName + " updateForm(" + simpleClassName + " " + TStringUtils.letterLowercase(simpleClassName) + ");" + System.lineSeparator());
        return codeView;
    }

    @Override
    protected void buildRelationQueryMethods(StringBuffer codeView, PersistentClass persistentClass, PersistentRelation persistentRelation, PersistentProperty relationPrimaryProperty, PersistentClassService persistentClassService, Map<String, String> importMapping) {
    }

    @Override
    protected void buildCustomQueryMethods(StringBuffer codeView, PersistentClass persistentClass, PersistentQueryMethod queryMethodItem, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping) {
        String className = persistentClass.getClassName();
        String simpleClassName = persistentClass.getSimpleClassName();
        String methodName = queryMethodItem.getMethodName();
        String description = queryMethodItem.getDescription();
        String[] params = queryMethodItem.getParams();
        StringBuffer descParamsContexts = new StringBuffer();
        StringBuffer paramsContexts = new StringBuffer();
        for (String param : params) {
            String[] paramItems = StringUtils.split((String)param, (String)".");
            this.foundRelationParams(persistentClass, persistentClass, paramItems, 0, persistentClassService, persistentPropertyService, persistentRelationService, importMapping, paramsContexts, descParamsContexts);
        }
        codeView.append("  /**").append(System.lineSeparator());
        codeView.append("   * ").append(description).append(System.lineSeparator());
        codeView.append(descParamsContexts);
        codeView.append("   */").append(System.lineSeparator());
        importMapping.put("java.util.List", "java.util.List");
        importMapping.put(className, className);
        codeView.append("  List<" + simpleClassName + "> " + methodName + "(" + paramsContexts + ");").append(System.lineSeparator());
    }

    private void foundRelationParams(PersistentClass rootPrsistentClass, PersistentClass currentPrsistentClass, String[] paramArrayItems, int itemIndex, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService, Map<String, String> importMapping, StringBuffer paramsContexts, StringBuffer descParamsContexts) {
        Validate.notNull((Object)rootPrsistentClass, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u63cf\u8ff0[rootPrsistentClass]!!", (Object[])new Object[0]);
        Validate.notNull((Object)currentPrsistentClass, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u63cf\u8ff0[currentPrsistentClass]!!", (Object[])new Object[0]);
        Validate.isTrue((paramArrayItems != null && paramArrayItems.length > 0 ? 1 : 0) != 0, (String)"\u6ca1\u6709\u627e\u5230\u6a21\u578b\u7ed3\u6784\u4e2d\u7684\u6307\u5b9a\u5c5e\u6027!!", (Object[])new Object[0]);
        if (paramArrayItems.length == 1) {
            String param;
            String className = rootPrsistentClass.getClassName();
            PersistentProperty persistentProperty = persistentPropertyService.findByPropertyName(className, param = paramArrayItems[0]);
            if (persistentProperty == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5c5e\u6027\u4fe1\u606f\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            String propertyClass = persistentProperty.getPropertyClass();
            String propertyDesc = persistentProperty.getPropertyDesc();
            descParamsContexts.append("   * @param " + param + " " + propertyDesc + System.lineSeparator());
            if (paramsContexts.length() != 0) {
                paramsContexts.append(" , ");
            }
            if (StringUtils.indexOf((CharSequence)propertyClass, (CharSequence)".") != -1) {
                importMapping.put(propertyClass, propertyClass);
            }
            paramsContexts.append(TStringUtils.getSimpleClassName(propertyClass, true) + " " + param);
        } else if (paramArrayItems.length == itemIndex + 1) {
            String param;
            String className = currentPrsistentClass.getClassName();
            PersistentProperty persistentProperty = persistentPropertyService.findByPropertyName(className, param = paramArrayItems[itemIndex]);
            if (persistentProperty == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5c5e\u6027\u4fe1\u606f\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            String propertyDesc = persistentProperty.getPropertyDesc();
            String propertyClass = persistentProperty.getPropertyClass();
            String params = StringUtils.join((Object[])paramArrayItems, (String)"_");
            descParamsContexts.append("   * @param " + params + " " + propertyDesc + System.lineSeparator());
            if (paramsContexts.length() != 0) {
                paramsContexts.append(" , ");
            }
            if (StringUtils.indexOf((CharSequence)propertyClass, (CharSequence)".") != -1) {
                importMapping.put(propertyClass, propertyClass);
            }
            paramsContexts.append(TStringUtils.getSimpleClassName(propertyClass, true) + " " + params);
        } else {
            String propertyName = paramArrayItems[itemIndex];
            String className = currentPrsistentClass.getClassName();
            PersistentRelation persistentRelation = persistentRelationService.findByPropertyName(className, propertyName);
            if (persistentRelation == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5173\u8054\u5c5e\u6027\u4fe1\u606f\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            String propertyClass = persistentRelation.getPropertyClass();
            PersistentClass nextPersistentClass = persistentClassService.queryByClassName(propertyClass);
            if (nextPersistentClass == null) {
                LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u5173\u8054\u5c5e\u6027\u4fe1\u606f\u7684\u7c7b\u578b\uff0c\u8be5\u81ea\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\u7684\u6784\u9020\u7ec8\u6b62!!");
                return;
            }
            this.foundRelationParams(rootPrsistentClass, nextPersistentClass, paramArrayItems, itemIndex + 1, persistentClassService, persistentPropertyService, persistentRelationService, importMapping, paramsContexts, descParamsContexts);
        }
    }

    @Override
    protected void buildCustomUpdateMethods(StringBuffer codeView, PersistentUpdateMethod updateMethodItem, PersistentClass persistentClass, Map<String, String> importMapping, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        PersistentProperty relationPrimaryKey;
        String propertyClass;
        String propertyDesc;
        PersistentRelation.RelationType relationType;
        PersistentRelation persistentRelation;
        PersistentProperty persistentProperty;
        int index;
        String description = updateMethodItem.getDescription();
        String methodName = updateMethodItem.getMethodName();
        String[] queryParams = updateMethodItem.getQueryParams();
        String[] updateParams = updateMethodItem.getUpdateParams();
        String targetClassName = persistentClass.getClassName();
        StringBuffer descParamContexts = new StringBuffer();
        StringBuffer updateContexts = new StringBuffer();
        StringBuffer paramContexts = new StringBuffer();
        for (index = 0; index < updateParams.length; ++index) {
            String updateParam = updateParams[index];
            persistentProperty = persistentPropertyService.findByPropertyName(targetClassName, updateParam);
            if (persistentProperty != null) {
                if (!persistentProperty.getCanUpdate().booleanValue()) {
                    LOGGER.warn("canUpdate\u8bbe\u7f6e\u4e3afalse\u7684\u5c5e\u6027[" + updateParam + "]\u4e0d\u5141\u8bb8\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!");
                    return;
                }
                if (index != 0) {
                    updateContexts.append(",");
                    paramContexts.append(",");
                }
                String propertyClass2 = persistentProperty.getPropertyClass();
                String propertyDesc2 = persistentProperty.getPropertyDesc();
                descParamContexts.append("   * @param _" + updateParam + " \u53ef\u4ee5\u88ab\u66f4\u65b0\u7684\u5c5e\u6027\uff1a" + propertyDesc2 + System.lineSeparator());
                if (propertyClass2.indexOf(".") != -1) {
                    importMapping.put(propertyClass2, propertyClass2);
                    paramContexts.append(TStringUtils.getSimpleClassName(propertyClass2, true) + " _" + updateParam);
                    continue;
                }
                paramContexts.append(propertyClass2 + " _" + updateParam);
                continue;
            }
            persistentRelation = persistentRelationService.findByPropertyName(targetClassName, updateParam);
            if (persistentRelation == null) {
                LOGGER.warn("\u672a\u627e\u5230\u5c5e\u6027[" + updateParam + "]\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!");
                return;
            }
            if (!persistentRelation.getCanUpdate().booleanValue()) {
                LOGGER.warn("canUpdate\u8bbe\u7f6e\u4e3afalse\u7684\u5c5e\u6027[" + updateParam + "]\u4e0d\u5141\u8bb8\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!");
                return;
            }
            relationType = persistentRelation.getRelationType();
            if (relationType == PersistentRelation.RelationType.ManyToMany || relationType == PersistentRelation.RelationType.ManyToOne) {
                LOGGER.warn("\u5c5e\u6027[" + updateParam + "]\u5173\u8054\u65b9\u5f0f\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!");
                return;
            }
            propertyDesc = persistentRelation.getPropertyDesc();
            propertyClass = persistentRelation.getPropertyClass();
            relationPrimaryKey = persistentPropertyService.findPrimaryKey(propertyClass);
            if (relationPrimaryKey == null) {
                LOGGER.warn("\u5173\u8054\u5c5e\u6027[" + updateParam + "]\u6ca1\u6709\u8bbe\u5b9a\u4e3b\u952e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!");
                return;
            }
            if (index != 0) {
                updateContexts.append(",");
                paramContexts.append(",");
            }
            descParamContexts.append("   * @param _" + updateParam + " " + propertyDesc + System.lineSeparator());
            paramContexts.append(TStringUtils.getSimpleClassName(propertyClass, true) + " _" + updateParam);
        }
        for (index = 0; index < queryParams.length; ++index) {
            String queryParamItem = queryParams[index];
            persistentProperty = persistentPropertyService.findByPropertyName(targetClassName, queryParamItem);
            if (persistentProperty != null) {
                paramContexts.append(",");
                String propertyDesc3 = persistentProperty.getPropertyDesc();
                String propertyClass3 = persistentProperty.getPropertyClass();
                descParamContexts.append("   * @param " + queryParamItem + " \u66f4\u65b0\u6240\u4f9d\u636e\u7684\u67e5\u8be2\u5c5e\u6027\uff1a" + propertyDesc3 + System.lineSeparator());
                if (StringUtils.indexOf((CharSequence)propertyClass3, (CharSequence)".") != -1) {
                    importMapping.put(propertyClass3, propertyClass3);
                }
                paramContexts.append(TStringUtils.getSimpleClassName(propertyClass3, true) + " " + queryParamItem);
                continue;
            }
            persistentRelation = persistentRelationService.findByPropertyName(targetClassName, queryParamItem);
            if (persistentRelation == null) {
                LOGGER.warn("\u672a\u627e\u5230\u5c5e\u6027[" + queryParamItem + "]\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!");
                return;
            }
            relationType = persistentRelation.getRelationType();
            if (relationType == PersistentRelation.RelationType.ManyToMany || relationType == PersistentRelation.RelationType.ManyToOne) {
                LOGGER.warn("\u5c5e\u6027[" + queryParamItem + "]\u5173\u8054\u65b9\u5f0f\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!");
                return;
            }
            propertyDesc = persistentRelation.getPropertyDesc();
            propertyClass = persistentRelation.getPropertyClass();
            relationPrimaryKey = persistentPropertyService.findPrimaryKey(propertyClass);
            if (relationPrimaryKey == null) {
                LOGGER.warn("\u5173\u8054\u5c5e\u6027[" + queryParamItem + "]\u6ca1\u6709\u8bbe\u5b9a\u4e3b\u952e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff0c\u5ffd\u7565\u8be5\u81ea\u5b9a\u4e49\u66f4\u65b0\u64cd\u4f5c\u7684\u521b\u5efa\u8fc7\u7a0b!!");
                return;
            }
            paramContexts.append(",");
            propertyClass = relationPrimaryKey.getPropertyClass();
            descParamContexts.append("   * @param " + queryParamItem + " " + propertyDesc + System.lineSeparator());
            paramContexts.append(TStringUtils.getSimpleClassName(propertyClass, true) + " " + queryParamItem + " ");
        }
        codeView.append("  /**" + System.lineSeparator());
        codeView.append("   * " + description + System.lineSeparator());
        codeView.append(descParamContexts);
        codeView.append("   */" + System.lineSeparator());
        codeView.append("  void " + methodName + "(" + paramContexts + ");" + System.lineSeparator());
    }

    @Override
    protected void buildUniquenessQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping) {
        String simpleClassName = persistentClass.getSimpleClassName();
        String propertyName = persistentProperty.getPropertyName();
        String propertyDesc = persistentProperty.getPropertyDesc();
        String propertyClassName = persistentProperty.getPropertyClass();
        String propertySimpleClassName = TStringUtils.getSimpleClassName(propertyClassName, true);
        if (StringUtils.indexOf((CharSequence)propertyClassName, (CharSequence)".") != -1) {
            importMapping.put(propertyClassName, propertyClassName);
        }
        String methodName = "findBy" + TStringUtils.letterUppercase(propertyName);
        String desc = "\u6309\u7167" + propertyDesc + "\u8fdb\u884c\u67e5\u8be2";
        codeView.append("  /**" + System.lineSeparator());
        codeView.append("   * " + desc + System.lineSeparator());
        codeView.append("   * @param " + propertyName + " " + propertyDesc + System.lineSeparator());
        codeView.append("   */" + System.lineSeparator());
        codeView.append("  " + simpleClassName + " " + methodName + "(" + propertySimpleClassName + " " + propertyName + ");" + System.lineSeparator());
    }

    @Override
    protected void buildDetailsQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        this.buildDetailsQueryMethod(codeView, persistentClass, persistentProperty, importMapping, persistentClassService, false);
    }

    @Override
    protected void buildDetailsQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentRelation persistentRelation, Map<String, String> importMapping, PersistentClassService persistentClassService, PersistentPropertyService persistentPropertyService, PersistentRelationService persistentRelationService) {
        PersistentProperty persistentProperty = new PersistentProperty();
        persistentProperty.setPropertyName(persistentRelation.getPropertyName());
        persistentProperty.setPropertyDesc("\u5173\u8054\u7684 " + persistentRelation.getPropertyDesc());
        PersistentProperty relationProperty = persistentPropertyService.findPrimaryKey(persistentRelation.getPropertyClass());
        persistentProperty.setPropertyClass(relationProperty.getPropertyClass());
        if (persistentRelation.getRelationType() == PersistentRelation.RelationType.ManyToOne || persistentRelation.getRelationType() == PersistentRelation.RelationType.ManyToMany) {
            this.buildDetailsQueryMethod(codeView, persistentClass, persistentProperty, importMapping, persistentClassService, true);
        } else {
            this.buildDetailsQueryMethod(codeView, persistentClass, persistentProperty, importMapping, persistentClassService, false);
        }
    }

    private void buildDetailsQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping, PersistentClassService persistentClassService, boolean isSet) {
        String simpleClassName = persistentClass.getSimpleClassName();
        String propertyName = persistentProperty.getPropertyName();
        String propertyDesc = persistentProperty.getPropertyDesc();
        String propertyClassName = persistentProperty.getPropertyClass();
        String propertySimpleClassName = TStringUtils.getSimpleClassName(propertyClassName, true);
        if (StringUtils.indexOf((CharSequence)propertyClassName, (CharSequence)".") != -1) {
            importMapping.put(propertyClassName, propertyClassName);
        }
        String methodName = "findDetailsBy" + TStringUtils.letterUppercase(propertyName);
        String desc = "\u6309\u7167" + propertyDesc + "\u8fdb\u884c\u8be6\u60c5\u67e5\u8be2\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09";
        codeView.append("  /**" + System.lineSeparator());
        codeView.append("   * " + desc + System.lineSeparator());
        codeView.append("   * @param " + propertyName + " " + propertyDesc + System.lineSeparator());
        codeView.append("   */" + System.lineSeparator());
        if (isSet) {
            importMapping.put("java.util.Set", "java.util.Set");
            codeView.append("  Set<" + simpleClassName + "> " + methodName + "(" + propertySimpleClassName + " " + propertyName + ");" + System.lineSeparator());
        } else {
            codeView.append("  " + simpleClassName + " " + methodName + "(" + propertySimpleClassName + " " + propertyName + ");" + System.lineSeparator());
        }
    }

    @Override
    protected void buildPkQueryMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty pkProperty, Map<String, String> importMapping) {
        String persistentSimpleClassName = persistentClass.getSimpleClassName();
        String pkPropertyName = pkProperty.getPropertyName();
        String pkPropertyDesc = pkProperty.getPropertyDesc();
        String pkPropertyClassName = pkProperty.getPropertyClass();
        String pkSimplePropertyClassName = TStringUtils.getSimpleClassName(pkPropertyClassName, false);
        codeView.append("  /**").append(System.lineSeparator());
        codeView.append("   * \u6309\u7167" + persistentSimpleClassName + "\u7684\u4e3b\u952e\u7f16\u53f7\uff0c\u67e5\u8be2\u6307\u5b9a\u7684\u6570\u636e\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09").append(System.lineSeparator());
        codeView.append("   * @param " + pkPropertyName + " " + pkPropertyDesc).append(System.lineSeparator());
        codeView.append("   * */").append(System.lineSeparator());
        codeView.append("  " + persistentSimpleClassName + " findBy" + TStringUtils.letterUppercase(pkPropertyName) + "(" + pkSimplePropertyClassName + " " + pkPropertyName + ");" + System.lineSeparator());
    }

    @Override
    protected void buildPkDeleteMethod(StringBuffer codeView, PersistentClass persistentClass, PersistentProperty persistentProperty, Map<String, String> importMapping, PersistentClassService persistentClassService) {
        String propertyName = persistentProperty.getPropertyName();
        String propertyDesc = persistentProperty.getPropertyDesc();
        String propertyClassName = persistentProperty.getPropertyClass();
        String propertySimpleClassName = TStringUtils.getSimpleClassName(propertyClassName, true);
        if (StringUtils.indexOf((CharSequence)propertyClassName, (CharSequence)".") != -1) {
            importMapping.put(propertyClassName, propertyClassName);
        }
        codeView.append("  /**" + System.lineSeparator());
        codeView.append("   *  \u6309\u7167\u4e3b\u952e\u8fdb\u884c\u4fe1\u606f\u7684\u771f\u5220\u9664 " + System.lineSeparator());
        codeView.append("   * @param " + propertyName + " " + propertyDesc + " " + System.lineSeparator());
        codeView.append("   */" + System.lineSeparator());
        codeView.append("  void deleteBy" + TStringUtils.letterUppercase(propertyName) + "(" + propertySimpleClassName + " " + propertyName + ");" + System.lineSeparator());
    }
}

