/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.saturn.scan;

import com.bizunited.nebula.saturn.engine.annotation.SaturnColumn;
import com.bizunited.nebula.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.nebula.saturn.engine.annotation.SaturnDefaultController;
import com.bizunited.nebula.saturn.engine.annotation.SaturnEntity;
import com.bizunited.nebula.saturn.engine.annotation.SaturnValidate;
import com.bizunited.nebula.saturn.model.PersistentProperty;
import com.bizunited.nebula.saturn.model.PersistentRelation;
import com.bizunited.nebula.saturn.scan.JavassistAnalysis;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwnerTagJavassistAnalysis
extends JavassistAnalysis {
    private static final Logger LOGGER = LoggerFactory.getLogger(OwnerTagJavassistAnalysis.class);

    @Override
    protected PersistentProperty analysisGeneralField(CtField fieldItem, int fieldIndex) {
        boolean hasSaturnValidateAnnotation;
        SaturnColumn saturnColumnAnnotation;
        boolean hasSaturnColumnAnnotation = fieldItem.hasAnnotation(SaturnColumn.class);
        boolean hasSaturnDefaultControllerAnnotation = fieldItem.hasAnnotation(SaturnDefaultController.class);
        if (!hasSaturnColumnAnnotation) {
            return null;
        }
        CtClass fieldType = null;
        String fieldTypeName = null;
        String realClassName = null;
        String fieldName = fieldItem.getName();
        ClassPool classPool = ClassPool.getDefault();
        CtClass collectionClass = null;
        boolean isCollectionInterface = false;
        try {
            fieldType = fieldItem.getType();
            collectionClass = classPool.get("java.util.Collection");
            isCollectionInterface = fieldType.subtypeOf(collectionClass);
            realClassName = fieldItem.getFieldInfo().getDescriptor();
            if (fieldType instanceof CtPrimitiveType) {
                CtPrimitiveType primitiveType = (CtPrimitiveType)fieldType;
                fieldTypeName = primitiveType.getWrapperName();
            } else {
                fieldTypeName = fieldType.getName();
            }
            realClassName = fieldItem.getFieldInfo().getDescriptor();
        }
        catch (NotFoundException e) {
            LOGGER.debug(e.getMessage());
            return null;
        }
        Validate.isTrue((realClassName.indexOf("[") == -1 ? 1 : 0) != 0, (String)("\u5728\u626b\u63cf\u9759\u6001\u6a21\u578b\u5c5e\u6027\u65f6\u53d1\u73b0\u6570\u7ec4\u5b9a\u4e49\uff08" + fieldName + "\uff09\uff0c\u8bf7\u6539\u7528\u5173\u8054\u6a21\u578b\u8fdb\u884c\u63cf\u8ff0\u3002"), (Object[])new Object[0]);
        if (!(StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.lang.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.math.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.util.") && !isCollectionInterface)) {
            return null;
        }
        PersistentProperty property = new PersistentProperty();
        property.setPropertyClass(fieldTypeName);
        property.setPropertyName(fieldName);
        property.setIndex(fieldIndex);
        property.setPropertyClass(fieldType.getName());
        try {
            saturnColumnAnnotation = (SaturnColumn)fieldItem.getAnnotation(SaturnColumn.class);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn(e.getMessage());
            return null;
        }
        boolean insertable = true;
        try {
            insertable = saturnColumnAnnotation.insertable();
        }
        catch (Exception e) {
            insertable = true;
        }
        property.setCanInsert(insertable);
        boolean nullable = true;
        try {
            nullable = saturnColumnAnnotation.nullable();
        }
        catch (Exception e) {
            nullable = true;
        }
        property.setNullable(nullable);
        boolean pkColumn = false;
        try {
            pkColumn = saturnColumnAnnotation.pkColumn();
        }
        catch (Exception e) {
            pkColumn = false;
        }
        property.setPrimaryKey(pkColumn);
        boolean unique = false;
        try {
            unique = saturnColumnAnnotation.unique();
        }
        catch (Exception e) {
            unique = false;
        }
        property.setUnique(unique);
        boolean updatable = false;
        try {
            updatable = saturnColumnAnnotation.updatable();
        }
        catch (Exception e) {
            updatable = false;
        }
        property.setCanUpdate(updatable);
        String description = "";
        try {
            description = saturnColumnAnnotation.description();
        }
        catch (Exception e) {
            description = "";
        }
        property.setPropertyDesc(description);
        Integer maxLength = null;
        try {
            maxLength = saturnColumnAnnotation.length();
        }
        catch (Exception e) {
            maxLength = null;
        }
        property.setMaxLen(maxLength);
        if (pkColumn) {
            property.setCanUpdate(false);
            property.setUnique(true);
            property.setPropertyDbName("id");
            property.setNullable(false);
            property.setPropertyDesc("\u4e3b\u952e");
            property.setIndex(1);
        }
        if (hasSaturnDefaultControllerAnnotation) {
            SaturnDefaultController saturnDefaultController;
            try {
                saturnDefaultController = (SaturnDefaultController)fieldItem.getAnnotation(SaturnDefaultController.class);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn(e.getMessage());
                return null;
            }
            String defaultKeys = "";
            try {
                defaultKeys = saturnDefaultController.defaultKeys();
            }
            catch (Exception e) {
                defaultKeys = "";
            }
            property.setDefaultKeys(defaultKeys);
            String defaultValues = "";
            try {
                defaultValues = saturnDefaultController.defaultValues();
            }
            catch (Exception e) {
                defaultValues = "";
            }
            property.setDefaultValues(defaultValues);
            String defaultType = "";
            try {
                defaultType = saturnDefaultController.defaultType().toString();
            }
            catch (Exception e) {
                defaultType = "";
            }
            property.setDefaultType(defaultType);
            if (saturnDefaultController.defaultType() == SaturnDefaultController.Type.RADIO || saturnDefaultController.defaultType() == SaturnDefaultController.Type.SELECT || saturnDefaultController.defaultType() == SaturnDefaultController.Type.CHECKBOX) {
                Validate.isTrue((!StringUtils.isBlank((CharSequence)defaultKeys) && !StringUtils.isBlank((CharSequence)defaultValues) ? 1 : 0) != 0, (String)"\u5f53\u9ed8\u8ba4\u63a7\u4ef6\u6307\u5b9a\u4e3aRADIO\u6216\u8005SELECT\u6216\u8005CHECKBOX\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9aK-V\u7684\u9ed8\u8ba4\u8bbe\u5b9a\u503c\uff08defaultKeys\u3001defaultValues\uff09", (Object[])new Object[0]);
            }
        }
        if (hasSaturnValidateAnnotation = fieldItem.hasAnnotation(SaturnValidate.class)) {
            SaturnValidate saturnValidateAnnotation;
            try {
                saturnValidateAnnotation = (SaturnValidate)fieldItem.getAnnotation(SaturnValidate.class);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn(e.getMessage());
                return null;
            }
            property.setValidateType(saturnValidateAnnotation.type());
        }
        String className = fieldItem.getDeclaringClass().getName();
        Validate.notBlank((CharSequence)property.getPropertyDesc(), (String)("\u5fc5\u987b\u4f7f\u7528SaturnColumn\u6ce8\u89e3\u5b8c\u6210\u5b57\u6bb5\u540d\u79f0\u7684\u63cf\u8ff0:[" + className + ":" + fieldItem.getName() + ":" + property.getPropertyClass() + "]"), (Object[])new Object[0]);
        return property;
    }

    @Override
    protected PersistentRelation analysisRelationField(Class<?> reflectClass, CtField fieldItem, int fieldIndex) {
        CtClass paramsClass;
        String fieldName = fieldItem.getName();
        CtClass fieldType = null;
        ClassPool classPool = ClassPool.getDefault();
        CtClass collectionClass = null;
        boolean isCollectionInterface = false;
        String realClassName = null;
        try {
            fieldType = fieldItem.getType();
            collectionClass = classPool.get("java.util.Collection");
            isCollectionInterface = fieldType.subtypeOf(collectionClass);
            realClassName = fieldItem.getFieldInfo().getDescriptor();
        }
        catch (NotFoundException e) {
            LOGGER.debug(e.getMessage());
            return null;
        }
        Validate.isTrue((realClassName.indexOf("[") == -1 ? 1 : 0) != 0, (String)"\u5728\u626b\u63cf\u9759\u6001\u6a21\u578b\u5c5e\u6027\u65f6\u53d1\u73b0\u6570\u7ec4\u5b9a\u4e49\uff08%s\uff09\uff0c\u8bf7\u6539\u7528\u5173\u8054\u6a21\u578b\u8fdb\u884c\u63cf\u8ff0\u3002", (Object[])new Object[]{fieldName});
        String fieldTypeName = null;
        if (fieldType instanceof CtPrimitiveType) {
            return null;
        }
        fieldTypeName = fieldType.getName();
        if ((StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"javax.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"org.springframework.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"org.apache.")) && !isCollectionInterface) {
            return null;
        }
        boolean hasSaturnRelationAnnotation = fieldItem.hasAnnotation(SaturnColumnRelation.class);
        Validate.isTrue((boolean)hasSaturnRelationAnnotation, (String)"\u5728\u8fdb\u884cVO\u6027\u8d28\u9759\u6001\u6a21\u578b\u626b\u63cf\u65f6\uff0c\u53d1\u73b0\u4e86\u6a21\u578b\u5173\u8054\u5c5e\u6027\uff08%s\uff09\uff0c\u4f46\u662f\u6ca1\u6709\u53d1\u73b0SaturnColumnRelation\u6ce8\u89e3\uff0c\u8bf7\u8fdb\u884c\u68c0\u67e5!!", (Object[])new Object[]{fieldName});
        boolean hasSaturnColumnAnnotation = fieldItem.hasAnnotation(SaturnColumn.class);
        try {
            Field reflectField;
            Type genericType;
            if (isCollectionInterface && (genericType = (reflectField = reflectClass.getDeclaredField(fieldName)).getGenericType()) instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                fieldTypeName = genericClazz.getName();
            }
        }
        catch (NoSuchFieldException | SecurityException e) {
            LOGGER.warn(e.getMessage());
            return null;
        }
        try {
            paramsClass = classPool.get(fieldTypeName);
        }
        catch (NotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        boolean hasSaturnEntityAnnotation = paramsClass.hasAnnotation(SaturnEntity.class);
        if (!hasSaturnEntityAnnotation) {
            return null;
        }
        PersistentRelation relation = new PersistentRelation();
        relation.setPropertyClass(fieldTypeName);
        relation.setPropertyName(fieldName);
        relation.setIndex(fieldIndex);
        if (hasSaturnColumnAnnotation) {
            SaturnColumn saturnColumnAnnotation;
            try {
                saturnColumnAnnotation = (SaturnColumn)fieldItem.getAnnotation(SaturnColumn.class);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn(e.getMessage());
                return null;
            }
            boolean insertable = true;
            try {
                insertable = saturnColumnAnnotation.insertable();
            }
            catch (Exception e) {
                insertable = true;
            }
            relation.setCanInsert(insertable);
            boolean nullable = true;
            try {
                nullable = saturnColumnAnnotation.nullable();
            }
            catch (Exception e) {
                nullable = true;
            }
            relation.setNullable(nullable);
            boolean updatable = false;
            try {
                updatable = saturnColumnAnnotation.updatable();
            }
            catch (Exception e) {
                updatable = false;
            }
            relation.setCanUpdate(updatable);
            String description = "";
            try {
                description = saturnColumnAnnotation.description();
            }
            catch (Exception e) {
                description = "";
            }
            relation.setPropertyDesc(description);
        }
        if (!this.analysisGeneraSaturnColumnRelation(relation, fieldItem)) {
            return null;
        }
        String className = fieldItem.getDeclaringClass().getName();
        Validate.notBlank((CharSequence)relation.getPropertyDesc(), (String)("\u5fc5\u987b\u4f7f\u7528SaturnColumn\u6ce8\u89e3\u5b8c\u6210\u5b57\u6bb5\u540d\u79f0\u7684\u63cf\u8ff0[" + className + ":" + fieldItem.getName() + ":" + relation.getPropertyClass() + "]"), (Object[])new Object[0]);
        return relation;
    }

    private boolean analysisGeneraSaturnColumnRelation(PersistentRelation relation, CtField fieldItem) {
        SaturnColumnRelation saturnRelationAnnotation;
        try {
            saturnRelationAnnotation = (SaturnColumnRelation)fieldItem.getAnnotation(SaturnColumnRelation.class);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn(e.getMessage() + "\uff1a\u9519\u8bef\u7684\u5173\u8054\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u5efa\u6a21\u60c5\u51b5");
            return false;
        }
        SaturnColumnRelation.RelationType pRelationType = saturnRelationAnnotation.type();
        if (pRelationType == SaturnColumnRelation.RelationType.ManyToMany) {
            relation.setRelationType(PersistentRelation.RelationType.ManyToMany);
            relation.setCanInsert(false);
            relation.setCanUpdate(false);
            relation.setMasterMapping(saturnRelationAnnotation.master());
            relation.setMappedBy(saturnRelationAnnotation.mappedBy());
        } else if (pRelationType == SaturnColumnRelation.RelationType.ManyToOne) {
            relation.setRelationType(PersistentRelation.RelationType.ManyToOne);
            relation.setCanInsert(false);
            relation.setCanUpdate(false);
        } else if (pRelationType == SaturnColumnRelation.RelationType.OneToMany) {
            relation.setRelationType(PersistentRelation.RelationType.OneToMany);
            relation.setCanInsert(true);
            relation.setCanUpdate(true);
            relation.setMappedBy(saturnRelationAnnotation.mappedBy());
        } else if (pRelationType == SaturnColumnRelation.RelationType.OneToOne) {
            relation.setRelationType(PersistentRelation.RelationType.OneToOne);
            relation.setCanInsert(true);
            relation.setCanUpdate(true);
            relation.setMappedBy(saturnRelationAnnotation.mappedBy());
        }
        String mappedBy = "";
        try {
            mappedBy = saturnRelationAnnotation.mappedBy();
        }
        catch (Exception e) {
            mappedBy = null;
        }
        relation.setMappedBy(mappedBy);
        return true;
    }
}

