/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.script.repository;

import com.bizunited.nebula.script.entity.ScriptEntity;
import com.bizunited.nebula.script.repository.ScriptRepositoryCustom;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="ScriptRepositoryImpl")
public class ScriptRepositoryImpl
implements ScriptRepositoryCustom {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String MESS_LANGUAGE = "language";
    private static final String MESS_NAME = "name";

    @Override
    public Page<ScriptEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
        String tenantCode;
        Object language;
        StringBuilder hql = new StringBuilder("from ScriptEntity script where 1=1");
        StringBuilder countHql = new StringBuilder("select count(*) from ScriptEntity script where 1=1");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Object name = conditions.get(MESS_NAME);
        if (name != null) {
            condition.append(" AND script.name = :name ");
            parameters.put(MESS_NAME, name);
        }
        if ((language = conditions.get(MESS_LANGUAGE)) != null) {
            condition.append(" AND script.language = :language ");
            parameters.put(MESS_LANGUAGE, language);
        }
        if (StringUtils.isNotBlank((CharSequence)(tenantCode = (String)conditions.get("tenantCode")))) {
            condition.append(" AND script.tenantCode = :tenantCode ");
            parameters.put("tenantCode", tenantCode);
        }
        hql.append((CharSequence)condition);
        countHql.append((CharSequence)condition);
        return ScriptRepositoryImpl.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
    }

    private static <T> Page<T> queryByConditions(EntityManager entityManager, String sql, String countSql, Map<String, Object> parameter, Pageable pageable, boolean nativeQuery, Class<T> resultClazz) {
        Query countQuery;
        Query query;
        if (nativeQuery) {
            Validate.notNull(resultClazz, (String)"resultClazz\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            query = entityManager.createNativeQuery(sql);
            ((NativeQueryImpl)query.unwrap(NativeQueryImpl.class)).setResultTransformer(Transformers.aliasToBean(resultClazz));
            countQuery = entityManager.createNativeQuery(countSql);
        } else {
            query = entityManager.createQuery(sql);
            countQuery = entityManager.createQuery(countSql);
        }
        parameter.forEach((k, v) -> {
            query.setParameter(k, v);
            countQuery.setParameter(k, v);
        });
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        long count = nativeQuery ? ((BigInteger)countQuery.getResultList().get(0)).longValue() : ((Long)countQuery.getResultList().get(0)).longValue();
        ArrayList result = count > 0L ? query.getResultList() : new ArrayList();
        return new PageImpl(result, pageable, count);
    }
}

