/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.script.controller;

import com.alibaba.fastjson.JSON;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.script.model.ScriptInputParamsModel;
import com.bizunited.nebula.script.service.ScriptVoService;
import com.bizunited.nebula.script.vo.ScriptVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="ScriptController", tags={"\u811a\u672c\u94fe\u8c03\u7528"})
@RestController
@RequestMapping(value={"/v1/script/scripts"})
public class ScriptController
extends BaseController {
    @Autowired
    private ScriptVoService scriptService;

    @ApiOperation(value="\u4fdd\u5b58\u811a\u672c\u81f4\u6587\u4ef6\u7cfb\u7edf")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@RequestParam(name="scriptEntity") String scriptEntityStr, @RequestParam(name="scriptContent") String scriptContent) {
        try {
            ScriptVo scriptVo = (ScriptVo)JSON.parseObject((String)scriptEntityStr, ScriptVo.class);
            ScriptVo result = this.scriptService.create(scriptVo, scriptContent);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u811a\u672c\u81f4\u6587\u4ef6\u7cfb\u7edf")
    @RequestMapping(value={"/update"}, method={RequestMethod.PATCH})
    public ResponseModel update(@RequestParam(name="scriptEntity") String scriptEntityStr, @RequestParam(name="scriptContent") String scriptContent) {
        try {
            ScriptVo scriptVo = (ScriptVo)JSON.parseObject((String)scriptEntityStr, ScriptVo.class);
            ScriptVo result = this.scriptService.update(scriptVo, scriptContent);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u540e\u7aef\u811a\u672c\u6267\u884c")
    @RequestMapping(value={"/invoke"}, method={RequestMethod.POST})
    public ResponseModel invoke(@RequestBody ScriptInputParamsModel scriptInputParamsModel) {
        try {
            Validate.notNull((Object)scriptInputParamsModel, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty(scriptInputParamsModel.getScriptIds(), (String)"\u811a\u672cID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Map result = this.scriptService.invoke(scriptInputParamsModel.getScriptIds().toArray(new String[0]), scriptInputParamsModel.getParams());
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@RequestParam(name="name") String name, @RequestParam(name="language") String language, Pageable pageable) {
        try {
            Page page = this.scriptService.findByConditions(pageable, name, language);
            return this.buildHttpResultW(page, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u811a\u672c\u5185\u5bb9\u6839\u636e\u811a\u672c\u552f\u4e00\u8bc6\u522b\u540d\u8fdb\u884c\u67e5\u8be2")
    @RequestMapping(value={"/findContentByName"}, method={RequestMethod.GET})
    public ResponseModel findContentByName(@RequestParam(name="scriptName") String scriptName) {
        try {
            String content = this.scriptService.findContentByName(scriptName);
            return this.buildHttpResult(content);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u811a\u672c\u5185\u5bb9")
    @RequestMapping(value={"/findContentById"}, method={RequestMethod.GET})
    public ResponseModel findContentById(@RequestParam(name="scriptId") String scriptId) {
        try {
            String content = this.scriptService.findContentById(scriptId);
            return this.buildHttpResult(content);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u811a\u672c\u57fa\u7840\u4fe1\u606f")
    @RequestMapping(value={"/findById"}, method={RequestMethod.GET})
    public ResponseModel findById(@RequestParam(name="scriptId") String scriptId) {
        try {
            ScriptVo entity = this.scriptService.findById(scriptId);
            return this.buildHttpResultW(entity, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }
}

