/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.script.service.internal;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.script.entity.ScriptEntity;
import com.bizunited.nebula.script.event.ScriptProcessingEventListener;
import com.bizunited.nebula.script.exception.InvokeProxyException;
import com.bizunited.nebula.script.repository.ScriptRepository;
import com.bizunited.nebula.script.service.ScriptVoService;
import com.bizunited.nebula.script.vo.ScriptVo;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

@Service(value="ScriptVoServiceImpl")
public class ScriptVoServiceImpl
implements ScriptVoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptVoServiceImpl.class);
    @Autowired(required=false)
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private ScriptRepository scriptRepository;
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<ScriptProcessingEventListener> scriptProcessingEventListeners;
    private static Map<String, ReentrantLock> scriptExecuteLocks = Maps.newConcurrentMap();
    private static Map<String, Script> scriptExecuteMapping = new ConcurrentReferenceHashMap();
    private static final String DEFAULT_KEY = "DEFAULT_KEY";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public ScriptVo update(ScriptVo scriptVo, String scriptContent) {
        Validate.notNull((Object)scriptVo, (String)"\u811a\u672c\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptContent, (String)"\u811a\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scriptVo.getLanguage(), (String)"\u811a\u672c\u8bed\u8a00\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptVo.getName(), (String)"\u811a\u672c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((scriptVo.getName().length() <= 255 ? 1 : 0) != 0, (String)"\u811a\u672c\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7255\u4e2a\u5b57\u7b26\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptVo.getId(), (String)"\u811a\u672cID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional op = this.scriptRepository.findById(scriptVo.getId());
        ScriptEntity existEntity = op.orElse(null);
        Validate.notNull((Object)existEntity, (String)"\u67e5\u8be2\u811a\u672c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String account = this.findAccount();
        account = StringUtils.isBlank((CharSequence)account) ? "admin" : account;
        String[] fileinfo = this.saveScriptContent(scriptContent);
        existEntity.setFileName(fileinfo[0]);
        existEntity.setFileCode(fileinfo[1]);
        existEntity.setModifyTime(new Date());
        existEntity.setModifyAccount(account);
        existEntity.setLanguage(scriptVo.getLanguage());
        existEntity.setName(scriptVo.getName());
        existEntity.setDescription(scriptVo.getDescription());
        try {
            existEntity = (ScriptEntity)this.scriptRepository.save(existEntity);
            ScriptVo scriptVo2 = (ScriptVo)this.nebulaToolkitService.copyObjectByBlankList((Object)existEntity, ScriptVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            return scriptVo2;
        }
        finally {
            scriptExecuteLocks.clear();
            scriptExecuteMapping.clear();
        }
    }

    private String[] saveScriptContent(String scriptContent) {
        String uuid = UUID.randomUUID().toString();
        String fileRename = uuid + ".txt";
        byte[] scriptContentBytes = scriptContent.getBytes(StandardCharsets.UTF_8);
        String account = this.findAccount();
        OrdinaryFileVo ordinaryFileVo = this.fileHandleService.fileUpload("groovyScript", account, null, fileRename, scriptContentBytes);
        return new String[]{ordinaryFileVo.getFileName(), ordinaryFileVo.getRelativeLocal()};
    }

    @Transactional
    public ScriptVo create(ScriptVo scriptVo, String scriptContent) {
        Validate.notNull((Object)scriptVo, (String)"\u811a\u672c\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptContent, (String)"\u811a\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)scriptVo.getLanguage(), (String)"\u811a\u672c\u8bed\u8a00\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptVo.getName(), (String)"\u811a\u672c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ScriptEntity existEntity = this.scriptRepository.findByName(scriptVo.getName());
        Validate.isTrue((null == existEntity ? 1 : 0) != 0, (String)"\u811a\u672c\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)scriptVo.getCreateAccount()) || StringUtils.isBlank((CharSequence)scriptVo.getModifyAccount())) {
            String account = this.findAccount();
            account = StringUtils.isBlank((CharSequence)account) ? "admin" : account;
            scriptVo.setCreateAccount(account);
            scriptVo.setModifyAccount(account);
        }
        String[] fileinfo = this.saveScriptContent(scriptContent);
        scriptVo.setFileName(fileinfo[0]);
        scriptVo.setFileCode(fileinfo[1]);
        scriptVo.setCreateTime(new Date());
        scriptVo.setModifyTime(new Date());
        scriptVo.setTenantCode(TenantUtils.getTenantCode());
        ScriptEntity scriptEntity = (ScriptEntity)this.nebulaToolkitService.copyObjectByBlankList((Object)scriptVo, ScriptEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        scriptEntity.setProjectName(TenantUtils.getTenantCode());
        this.scriptRepository.save(scriptEntity);
        scriptVo.setId(scriptEntity.getId());
        return scriptVo;
    }

    public Page<ScriptVo> findByConditions(Pageable pageable, String name, String language) {
        Page result;
        Validate.notNull((Object)pageable, (String)"\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, String> conditions = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            conditions.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)language)) {
            conditions.put("language", language);
        }
        if ((result = this.scriptRepository.findByConditions(pageable, conditions)) == null || !result.hasContent()) {
            return null;
        }
        Collection scriptVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)result, ScriptEntity.class, ScriptVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        PageImpl page = new PageImpl((List)Lists.newArrayList((Iterable)scriptVos), pageable, result.getTotalElements());
        return page;
    }

    public ScriptVo findById(String scriptId) {
        if (StringUtils.isBlank((CharSequence)scriptId)) {
            return null;
        }
        ScriptEntity scriptEntity = this.scriptRepository.findById(scriptId).orElse(null);
        if (scriptEntity == null) {
            return null;
        }
        return (ScriptVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)scriptEntity, ScriptVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public ScriptVo findByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        ScriptEntity scriptEntity = this.scriptRepository.findByName(name);
        if (scriptEntity == null) {
            return null;
        }
        return (ScriptVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)scriptEntity, ScriptVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public String findContentByName(String scriptName) {
        if (StringUtils.isBlank((CharSequence)scriptName)) {
            return null;
        }
        ScriptVo currentScript = this.findByName(scriptName);
        if (currentScript == null) {
            return null;
        }
        return this.findContentById(currentScript.getId());
    }

    public String findContentById(String scriptId) {
        if (StringUtils.isBlank((CharSequence)scriptId)) {
            return null;
        }
        Optional scriptEntity = this.scriptRepository.findById(scriptId);
        if (!scriptEntity.isPresent()) {
            return null;
        }
        byte[] contents = this.fileHandleService.findContentByFilePathAndFileRename(((ScriptEntity)scriptEntity.get()).getFileCode(), ((ScriptEntity)scriptEntity.get()).getFileName());
        return new String(contents, StandardCharsets.UTF_8);
    }

    public Map<String, Object> invoke(String[] scriptIds, Map<String, Object> params) throws InvokeProxyException {
        return this.invoke(DEFAULT_KEY, scriptIds, params);
    }

    public Map<String, Object> invoke(String key, String[] scriptIds, Map<String, Object> params) throws InvokeProxyException {
        Validate.notBlank((CharSequence)key, (String)"\u8fdb\u884cscript\u5168\u5c40\u5bf9\u8c61\u9694\u79bb\u7684key\u503c\uff0c\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notNull((Object)scriptIds, (String)"\u81f3\u5c11\u9700\u8981\u4f20\u5165\u4e00\u4e2a\u811a\u672c\u5185\u5bb9\u7f16\u53f7", (Object[])new Object[0]);
        Validate.isTrue((scriptIds.length >= 0 ? 1 : 0) != 0, (String)"\u81f3\u5c11\u9700\u8981\u4f20\u5165\u4e00\u4e2a\u811a\u672c\u5185\u5bb9\u7f16\u53f7", (Object[])new Object[0]);
        Map<String, Object> currentParams = params;
        if (currentParams == null) {
            currentParams = new HashMap<String, Object>();
        }
        ArrayList<ScriptEntity> scriptEntities = new ArrayList<ScriptEntity>();
        for (String scriptId : scriptIds) {
            Validate.notBlank((CharSequence)scriptId, (String)"\u811a\u672cID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Optional op = this.scriptRepository.findById(scriptId);
            ScriptEntity scriptEntity = op.orElse(null);
            Validate.notNull((Object)scriptEntity, (String)"[%s]\u5bf9\u5e94\u7684\u811a\u672c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{scriptId});
            scriptEntities.add(scriptEntity);
        }
        for (ScriptEntity scriptItem : scriptEntities) {
            Pair<Object, Map<String, Object>> results = this.invokeOne(key, scriptItem, currentParams);
            Map result = (Map)results.getRight();
            if (CollectionUtils.isEmpty((Map)result)) continue;
            currentParams.putAll(result);
        }
        return currentParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Pair<Object, Map<String, Object>> invokeOne(String key, ScriptEntity scriptItem, Map<String, Object> params) throws InvokeProxyException {
        String scriptItemId = scriptItem.getId();
        String realKey = StringUtils.join((Object[])new String[]{key, "_", scriptItemId}).intern();
        ReentrantLock currentLock = scriptExecuteLocks.get(realKey);
        if (currentLock == null) {
            Class<ScriptVoService> clazz = ScriptVoService.class;
            // MONITORENTER : com.bizunited.nebula.script.service.ScriptVoService.class
            while (currentLock == null) {
                currentLock = new ReentrantLock();
                scriptExecuteLocks.put(realKey, currentLock);
            }
            // MONITOREXIT : clazz
        }
        currentLock.lock();
        try {
            Script groovyScript = scriptExecuteMapping.get(realKey);
            if (groovyScript == null) {
                byte[] scriptContent = this.fileHandleService.findContentByFilePathAndFileRename(scriptItem.getFileCode(), scriptItem.getFileName());
                String groovyStr = new String(scriptContent);
                LOGGER.info("\u6b63\u5728\u8fdb\u884cgroovy\u811a\u672c\u7f16\u8bd1\uff0c\u811a\u672cid = " + scriptItemId);
                GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.applicationContext.getClassLoader());
                GroovyShell shell = new GroovyShell((ClassLoader)groovyClassLoader);
                groovyScript = shell.parse(groovyStr);
                scriptExecuteMapping.put(realKey, groovyScript);
            }
            Pair<Object, Map<String, Object>> pair = this.executeOne(realKey, groovyScript, params);
            return pair;
        }
        catch (CompilationFailedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u7f16\u8bd1groovy\u811a\u672c\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            currentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Pair<Object, Map<String, Object>> invokeOne(String key, String scriptItemId, String groovyStr, Map<String, Object> params) throws InvokeProxyException {
        String realKey = StringUtils.join((Object[])new String[]{key, "_", scriptItemId}).intern();
        ReentrantLock currentLock = scriptExecuteLocks.get(realKey);
        if (currentLock == null) {
            Class<ScriptVoService> clazz = ScriptVoService.class;
            // MONITORENTER : com.bizunited.nebula.script.service.ScriptVoService.class
            while (currentLock == null) {
                currentLock = new ReentrantLock();
                scriptExecuteLocks.put(realKey, currentLock);
            }
            // MONITOREXIT : clazz
        }
        currentLock.lock();
        try {
            Script groovyScript = scriptExecuteMapping.get(realKey);
            if (groovyScript == null) {
                LOGGER.info("\u6b63\u5728\u8fdb\u884cgroovy\u811a\u672c\u7f16\u8bd1\uff0c\u811a\u672cid = " + scriptItemId);
                GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.applicationContext.getClassLoader());
                GroovyShell shell = new GroovyShell((ClassLoader)groovyClassLoader);
                groovyScript = shell.parse(groovyStr);
                scriptExecuteMapping.put(realKey, groovyScript);
            }
            Pair<Object, Map<String, Object>> pair = this.executeOne(realKey, groovyScript, params);
            return pair;
        }
        catch (CompilationFailedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u7f16\u8bd1groovy\u811a\u672c\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            currentLock.unlock();
        }
    }

    private Pair<Object, Map<String, Object>> executeOne(String key, Script groovyScript, Map<String, Object> params) {
        HashMap<String, Object> resultVars = new HashMap<String, Object>();
        Object result = null;
        Binding binding = this.bindingScriptVars(params);
        groovyScript.setBinding(binding);
        result = groovyScript.run();
        Map bindingParams = binding.getVariables();
        if (!CollectionUtils.isEmpty((Map)bindingParams)) {
            for (String paramKey : bindingParams.keySet()) {
                resultVars.put(paramKey, binding.getVariable(paramKey));
            }
        }
        return Pair.of((Object)result, resultVars);
    }

    private Binding bindingScriptVars(Map<String, Object> params) {
        Binding binding = new Binding();
        HashMap<String, Object> bindMapping = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(this.scriptProcessingEventListeners)) {
            for (ScriptProcessingEventListener scriptProcessingEventListener : this.scriptProcessingEventListeners) {
                scriptProcessingEventListener.onBeforeScriptRunning(bindMapping);
            }
        }
        bindMapping.putAll(params);
        if (bindMapping != null && !CollectionUtils.isEmpty(bindMapping)) {
            for (Map.Entry entry : bindMapping.entrySet()) {
                binding.setVariable((String)entry.getKey(), entry.getValue());
            }
        }
        return binding;
    }

    public Object invoke(String scriptContent, Map<String, Object> params) throws InvokeProxyException {
        return this.invoke(DEFAULT_KEY, scriptContent, params);
    }

    public Object invoke(String key, String scriptContent, Map<String, Object> params) throws InvokeProxyException {
        Validate.notBlank((CharSequence)key, (String)"\u8fdb\u884cscript\u5168\u5c40\u5bf9\u8c61\u9694\u79bb\u7684key\u503c\uff0c\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptContent, (String)"\u5fc5\u987b\u8981\u6709\u9700\u8981\u6267\u884c\u7684\u811a\u672c\u5185\u5bb9", (Object[])new Object[0]);
        Map<String, Object> currentParams = params;
        if (currentParams == null) {
            currentParams = new HashMap<String, Object>();
        }
        String scriptItemId = String.valueOf(scriptContent.intern().hashCode()).intern();
        Pair<Object, Map<String, Object>> results = this.invokeOne(key, scriptItemId, scriptContent, currentParams);
        return results.getLeft();
    }

    private String findAccount() {
        Authentication authentication;
        String account = "admin";
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext != null && (authentication = securityContext.getAuthentication()) != null) {
            account = authentication.getName();
        }
        return account;
    }
}

