/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.config;

import com.bizunited.nebula.common.filters.CleanupTenantFilter;
import com.bizunited.nebula.security.local.login.DefaultAuthenticationUserEventListener;
import com.bizunited.nebula.security.local.login.NebulaSecurityAuthenticationFailureHandler;
import com.bizunited.nebula.security.local.login.NebulaSecurityAuthenticationSuccessHandler;
import com.bizunited.nebula.security.local.login.SimpleNebulaSecurityAuthenticationSuccessPrinter;
import com.bizunited.nebula.security.local.loginform.SimpleLoginValidateStrategy;
import com.bizunited.nebula.security.local.transform.JwtRefreshAuthorizationFilter;
import com.bizunited.nebula.security.local.transform.JwtSecurityAuthorizationFilter;
import com.bizunited.nebula.security.local.voter.DefaultAuthenticationCompetenceEventListener;
import com.bizunited.nebula.security.local.voter.NebulaSecurityAccessDecisionVoter;
import com.bizunited.nebula.security.local.voter.SimpleAccessDeniedHandler;
import com.bizunited.nebula.security.sdk.config.CustomFilterAfterConfig;
import com.bizunited.nebula.security.sdk.config.CustomFilterBeforeConfig;
import com.bizunited.nebula.security.sdk.config.NebulaWebSecurityConfigurerAdapter;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.event.AuthenticationCompetenceEventListener;
import com.bizunited.nebula.security.sdk.event.AuthenticationUserEventListener;
import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import com.bizunited.nebula.security.sdk.password.Aes2PasswordEncoder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@ComponentScan(basePackages={"com.bizunited.nebula.security"})
public class SecurityConfigAutoConfiguration {
    @Autowired
    private AuthenticationConfiguration authenticationConfiguration;
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;
    @Autowired
    private AuthenticationDetailsSource<HttpServletRequest, LoginDetails> authenticationDetailsSource;
    @Autowired
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    @Autowired
    private AuthenticationFailureHandler authenticationFailureHandler;
    @Autowired
    private LogoutSuccessHandler logoutSuccessHandler;
    @Autowired
    private SimpleAccessDeniedHandler simpleAccessDeniedHandler;
    @Autowired(required=false)
    private NebulaWebSecurityConfigurerAdapter nebulaWebSecurityConfigurerAdapter;
    @Autowired
    private JwtSecurityAuthorizationFilter jwtSecurityAuthorizationFilter;
    @Autowired
    private JwtRefreshAuthorizationFilter jwtRefreshAuthorizationFilter;
    @Autowired
    private AccessDecisionManager accessDecisionManager;
    @Autowired
    private CleanupTenantFilter cleanupTenantFilter;
    @Autowired(required=false)
    private List<CustomFilterBeforeConfig> customFilterBeforeConfigs;
    @Autowired(required=false)
    private List<CustomFilterAfterConfig> customFilterAfterConfigs;
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityConfigAutoConfiguration.class);

    @Bean
    public AuthenticationManager authenticationManager() throws Exception {
        AuthenticationManager authenticationManager = this.authenticationConfiguration.getAuthenticationManager();
        return authenticationManager;
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        String loginUrl = this.simpleSecurityProperties.getLoginUrl();
        String logoutUrl = this.simpleSecurityProperties.getLogoutUrl();
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.cors().configurationSource(this.corsConfigurationSource()).and()).headers().frameOptions().disable().and()).sessionManagement().enableSessionUrlRewriting(true).and()).authorizeRequests().requestMatchers(new RequestMatcher[]{CorsUtils::isPreFlightRequest})).permitAll().anyRequest()).authenticated().and()).authorizeRequests().accessDecisionManager(this.accessDecisionManager)).and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.simpleAccessDeniedHandler).accessDeniedHandler((AccessDeniedHandler)this.simpleAccessDeniedHandler).and()).formLogin().loginPage(loginUrl).loginProcessingUrl(loginUrl)).successHandler(this.authenticationSuccessHandler)).failureHandler(this.authenticationFailureHandler)).authenticationDetailsSource(this.authenticationDetailsSource)).permitAll()).and()).logout().logoutUrl(logoutUrl).logoutSuccessHandler(this.logoutSuccessHandler).permitAll().and()).csrf().disable()).addFilterBefore((Filter)this.jwtSecurityAuthorizationFilter, UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.jwtRefreshAuthorizationFilter, JwtSecurityAuthorizationFilter.class).addFilterBefore((Filter)this.cleanupTenantFilter, JwtSecurityAuthorizationFilter.class);
        if (!CollectionUtils.isEmpty(this.customFilterBeforeConfigs)) {
            for (CustomFilterBeforeConfig customFilterBeforeConfig : this.customFilterBeforeConfigs) {
                http.addFilterBefore(customFilterBeforeConfig.getCustomFilterBefore(), UsernamePasswordAuthenticationFilter.class);
            }
        }
        if (!CollectionUtils.isEmpty(this.customFilterAfterConfigs)) {
            for (CustomFilterAfterConfig customFilterAfterConfig : this.customFilterAfterConfigs) {
                http.addFilterAfter(customFilterAfterConfig.getCustomFilterAfter(), FilterSecurityInterceptor.class);
            }
        }
        if (this.nebulaWebSecurityConfigurerAdapter != null) {
            this.nebulaWebSecurityConfigurerAdapter.configure(http);
        }
        return (SecurityFilterChain)http.build();
    }

    private CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOriginPatterns(Arrays.asList("*"));
        configuration.setAllowedMethods(Arrays.asList("*"));
        configuration.setAllowedHeaders(Arrays.asList("*"));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    @Bean
    @ConditionalOnMissingBean
    public NebulaSecurityAccessDecisionVoter getNebulaSecurityAccessDecisionVoter() {
        return new NebulaSecurityAccessDecisionVoter();
    }

    @Bean
    public AccessDecisionManager accessDecisionManager(NebulaSecurityAccessDecisionVoter nebulaSecurityAccessDecisionVoter) {
        ArrayList decisionVoters = Lists.newArrayList((Object[])new AccessDecisionVoter[]{nebulaSecurityAccessDecisionVoter});
        return new AffirmativeBased((List)decisionVoters);
    }

    @Bean(value={"nebulaSecurityAuthenticationSuccessHandler"})
    @ConditionalOnMissingBean
    public AuthenticationSuccessHandler getAuthenticationSuccessHandler() {
        return new NebulaSecurityAuthenticationSuccessHandler();
    }

    @Bean(value={"nebulaSecurityAuthenticationFailureHandler"})
    @ConditionalOnMissingBean
    public AuthenticationFailureHandler getAuthenticationFailureHandler() {
        return new NebulaSecurityAuthenticationFailureHandler();
    }

    @Bean(value={"SimpleLoginValidateStrategy"})
    @ConditionalOnMissingBean
    public SimpleLoginValidateStrategy getLoginValidateStrategy() {
        return new SimpleLoginValidateStrategy();
    }

    @Bean(value={"SimpleNebulaSecurityAuthenticationSuccessPrinter"})
    @ConditionalOnMissingBean
    public SimpleNebulaSecurityAuthenticationSuccessPrinter getSimpleNebulaSecurityAuthenticationSuccessPrinter() {
        return new SimpleNebulaSecurityAuthenticationSuccessPrinter();
    }

    @Bean(name={"passwordEncoder"})
    @ConditionalOnMissingBean
    public PasswordEncoder passwordEncoder() {
        return new Pbkdf2PasswordEncoder();
    }

    @Bean(name={"aes2PasswordEncoder"})
    @ConditionalOnMissingBean
    public Aes2PasswordEncoder aes2PasswordEncoder() {
        return new Aes2PasswordEncoder();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationCompetenceEventListener getDefaultAuthenticationCompetenceEventListener() {
        LOGGER.warn(" ==== \u5f53\u524d\u5e94\u7528\u7a0b\u5e8f\u4f7f\u7528\u4e86\u9ed8\u8ba4\u7684AuthenticationCompetenceEventListener\u76d1\u542c\u63a5\u53e3\u5b9e\u73b0com.bizunited.nebula.security.local.notifier.AuthenticationCompetenceEventListener\uff0c\u8be5\u5b9e\u73b0\u9ed8\u8ba4\u6240\u6709\u7684\u65b9\u6cd5\u90fd\u53ef\u4ee5\u8bbf\u95ee\uff0c\u5982\u679c\u9700\u8981\u9650\u5236\u65b9\u6cd5\u6743\u9650\uff0c\u8bf7\u81ea\u884c\u5b9e\u73b0AuthenticationCompetenceEventListener\u76d1\u542c\u63a5\u53e3\uff08\u82e5\u5df2\u4f7f\u7528@Primary\u6ce8\u89e3\uff0c\u5219\u53ef\u4ee5\u5ffd\u7565\u8be5\u8b66\u544a\uff09!! ");
        return new DefaultAuthenticationCompetenceEventListener();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationUserEventListener getDefaultAuthenticationUserEventListener() {
        LOGGER.warn(" ==== \u5f53\u524d\u5e94\u7528\u7a0b\u5e8f\u4f7f\u7528\u4e86\u9ed8\u8ba4\u7684AuthenticationUserEventListener\u76d1\u542c\u63a5\u53e3\u5b9e\u73b0com.bizunited.nebula.security.local.notifier.DefaultAuthenticationUserEventListener\uff0c\u8be5\u5b9e\u73b0\u9ed8\u8ba4\u6240\u6709\u7684\u64cd\u4f5c\u8005\u90fd\u62e5\u6709ADMIN\u89d2\u8272\uff0c\u5982\u9700\u8981\u9650\u5236\u7528\u6237\u7684\u89d2\u8272\uff0c\u8bf7\u81ea\u884c\u5b9e\u73b0AuthenticationUserEventListener\u76d1\u542c\u63a5\u53e3(\u82e5\u5df2\u4f7f\u7528@Primary\u6ce8\u89e3\uff0c\u5219\u53ef\u4ee5\u5ffd\u7565\u8be5\u8b66\u544a)!! ");
        return new DefaultAuthenticationUserEventListener();
    }
}

