/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.login;

import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.event.AuthenticationUserEventListener;
import com.bizunited.nebula.security.sdk.login.AuthenticationDecisionStrategy;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NebulaSecurityAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NebulaSecurityAuthenticationProvider.class);
    private static final String ERROR_USER = "\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\u6216\u5176\u6570\u636e\u5b58\u50a8\u7f16\u53f7\uff0c\u4e5f\u53ef\u80fd\u662f\u56e0\u4e3a\u6307\u5b9a\u7684\u9274\u6743\u65b9\u5f0f\u6682\u672a\u5b9e\u73b0";
    private static final String ERROR_ROLE = "\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\u5e26\u6709\u4efb\u4f55\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u6743\u9650\u8bbe\u5b9a";
    @Autowired(required=false)
    private List<AuthenticationDecisionStrategy> authenticationDecisions;
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;
    @Autowired
    private AuthenticationUserEventListener authenticationEventListener;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (CollectionUtils.isEmpty(this.authenticationDecisions)) {
            throw new AuthenticationCredentialsNotFoundException("\u672c\u5e94\u7528\u7cfb\u7edf/\u5fae\u670d\u52a1\uff0c\u7981\u6b62\u4efb\u4f55\u5f62\u5f0f\u7684\u767b\u5f55(\u6ca1\u6709\u4efb\u4f55\u767b\u5f55\u7b56\u7565)!!");
        }
        LoginDetails loginDetails = (LoginDetails)authentication.getDetails();
        LOGGER.debug("\u5f53\u524d\u6709\u7528\u6237\u6b63\u5728\u8fdb\u884c\u7ecf\u5178\u767b\u5f55\u9274\u6743 =  " + loginDetails.toString());
        Integer type = loginDetails.getType();
        if (type == null) {
            type = this.simpleSecurityProperties.getDefaultLoginType();
        }
        UserIdentity userIdentity = null;
        try {
            TenantContextHolder.clean();
            for (AuthenticationDecisionStrategy authenticationDecisionStrategy : this.authenticationDecisions) {
                Integer currentType = authenticationDecisionStrategy.type();
                if (!currentType.equals(type)) continue;
                userIdentity = authenticationDecisionStrategy.decide(loginDetails, currentType);
                break;
            }
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new AuthenticationCredentialsNotFoundException(e.getMessage(), (Throwable)e);
        }
        if (userIdentity == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{userIdentity.getTenantCode(), userIdentity.getAccount()})) {
            throw new UsernameNotFoundException(ERROR_USER);
        }
        if (this.authenticationEventListener != null) {
            Set roleCodes = this.authenticationEventListener.onRequestRoleCodes(userIdentity.getTenantCode(), userIdentity.getAccount(), loginDetails);
            if (CollectionUtils.isEmpty((Collection)roleCodes)) {
                roleCodes = this.authenticationEventListener.onRequestRoleCodes(userIdentity.getTenantCode(), userIdentity.getAccount());
            }
            if (CollectionUtils.isEmpty((Collection)roleCodes)) {
                throw new BadCredentialsException(ERROR_ROLE);
            }
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            for (String roleCode : roleCodes) {
                SimpleGrantedAuthority authoritie = new SimpleGrantedAuthority(StringUtils.upperCase((String)roleCode));
                authorities.add(authoritie);
            }
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)loginDetails.getAccount(), (Object)loginDetails.getPassword(), authorities);
            token.setDetails((Object)userIdentity);
            return token;
        }
        throw new BadCredentialsException("\u672a\u914d\u7f6enebula-security\u7ec4\u4ef6\u7684\u5b9e\u73b0\u6a21\u5757\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!!");
    }

    public boolean supports(Class<?> authentication) {
        return true;
    }
}

