/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.loginform;

import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import com.bizunited.nebula.security.sdk.loginform.LoginValidateStrategy;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NebulaSecurityLoginFormDetailsSource
implements AuthenticationDetailsSource<HttpServletRequest, LoginDetails> {
    @Autowired
    private List<LoginValidateStrategy> loginValidateStrategies;
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;

    public LoginDetails buildDetails(HttpServletRequest request) {
        Validate.isTrue((!CollectionUtils.isEmpty(this.loginValidateStrategies) ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u4efb\u4f55\u767b\u5f55\u8868\u5355\u9a8c\u8bc1\u548c\u8f6c\u6362\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5\u8bbe\u7f6e!!", (Object[])new Object[0]);
        String typeObject = request.getParameter("type");
        Integer type = null;
        type = !StringUtils.isBlank((CharSequence)typeObject) ? Integer.valueOf(Integer.parseInt(typeObject)) : this.simpleSecurityProperties.getDefaultLoginType();
        Validate.notNull((Object)type, (String)"\u672a\u53d1\u73b0\u63cf\u8ff0\u767b\u5f55\u8868\u5355\u7c7b\u578b\u7684\uff08type\uff09\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LoginValidateStrategy matchedLoginValidateStrategy = null;
        for (LoginValidateStrategy loginValidateStrategy : this.loginValidateStrategies) {
            if (!loginValidateStrategy.matched(request, type)) continue;
            matchedLoginValidateStrategy = loginValidateStrategy;
            break;
        }
        Validate.notNull(matchedLoginValidateStrategy, (String)"\u9519\u8bef\u7684\u767b\u5f55\u8868\u5355\u8f6c\u6362\u548c\u9a8c\u8bc1\u6d4b\u4e86\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LoginDetails loginDetails = matchedLoginValidateStrategy.validateAndTransform(request);
        Validate.notNull((Object)loginDetails, (String)"\u9519\u8bef\u7684\u767b\u5f55\u8868\u5355\u63cf\u8ff0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return loginDetails;
    }
}

