/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.transform;

import com.bizunited.nebula.common.configuration.SimpleTenantProperties;
import com.bizunited.nebula.common.interceptor.NebulaFeignRequestInterceptor;
import com.bizunited.nebula.security.local.utils.JwtUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import feign.RequestTemplate;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

@Component
public class JwtFeignRequestInterceptor
implements NebulaFeignRequestInterceptor {
    private static final String JWT_HEADER = "jwt";
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;
    @Autowired
    private SimpleTenantProperties simpleTenantProperties;

    public void apply(RequestTemplate requestTemplate) {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            return;
        }
        Object detailsObject = authentication.getDetails();
        if (detailsObject == null || !(detailsObject instanceof UserIdentity)) {
            return;
        }
        UserIdentity userIdentity = (UserIdentity)detailsObject;
        String jwtEncodeContent = JwtUtils.encode(userIdentity, this.simpleSecurityProperties.getJwtttl(), this.simpleSecurityProperties.getSecretKey());
        requestTemplate.header(JWT_HEADER, new String[]{jwtEncodeContent});
        String headAppKey = this.simpleTenantProperties.getHeadAppKey();
        String encodeBase64 = Base64Utils.encodeToString((byte[])userIdentity.getTenantCode().getBytes(StandardCharsets.UTF_8));
        requestTemplate.header(headAppKey, new String[]{encodeBase64});
    }

    public int getOrder() {
        return 2;
    }
}

