/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.voter;

import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.event.AuthenticationCompetenceEventListener;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.mvc.condition.PathPatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPattern;

public class NebulaSecurityAccessDecisionVoter
implements AccessDecisionVoter<FilterInvocation> {
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;
    @Autowired
    private RequestMappingHandlerMapping frameworkEndpointHandler;
    @Autowired(required=false)
    private AuthenticationCompetenceEventListener authenticationCompetenceEventListener;
    private static final String ANONYMOUS = "ROLE_ANONYMOUS";
    private static final Logger LOGGER = LoggerFactory.getLogger(NebulaSecurityAccessDecisionVoter.class);

    public int vote(Authentication authentication, FilterInvocation filterInvocation, Collection<ConfigAttribute> attributes) {
        HttpServletRequest httpRequest = filterInvocation.getHttpRequest();
        String requestUrl = filterInvocation.getRequestUrl();
        ArrayList currentIgnoreUrls = new ArrayList();
        Object[] ignoreUrls = this.simpleSecurityProperties.getIgnoreUrls();
        if (ignoreUrls != null && ignoreUrls.length > 0) {
            currentIgnoreUrls.addAll(Lists.newArrayList((Object[])ignoreUrls));
        }
        currentIgnoreUrls.addAll(Lists.newArrayList((Object[])SimpleSecurityProperties.DEFAULT_IGNOREURLS));
        for (String ignoreUrl : currentIgnoreUrls) {
            AntPathRequestMatcher requestMatcher = new AntPathRequestMatcher(ignoreUrl);
            if (!requestMatcher.matches(httpRequest)) continue;
            return 1;
        }
        if (this.authenticationCompetenceEventListener == null) {
            throw new AccessDeniedException("not author\uff08no authenticationCompetenceEventListener\uff09!");
        }
        Set ignoreMethodCheckRoleCodes = this.authenticationCompetenceEventListener.onRequestIgnoreMethodCheckRoles();
        Collection currentRoles = authentication.getAuthorities();
        if (CollectionUtils.isEmpty((Collection)currentRoles)) {
            throw new AccessDeniedException("not found any author from this single in user!");
        }
        if (!this.simpleSecurityProperties.getAllowAnonymous().booleanValue() && currentRoles.size() == 1 && StringUtils.equalsIgnoreCase((CharSequence)((GrantedAuthority)currentRoles.iterator().next()).getAuthority(), (CharSequence)ANONYMOUS)) {
            throw new AccessDeniedException("not found any author from this single in user(ROLE_ANONYMOUS)!");
        }
        Set currentRoleCodes = currentRoles.stream().map(Object::toString).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty((Collection)ignoreMethodCheckRoleCodes)) {
            CharSequence[] ignoreMethodCheckArrayRoleCodes = ignoreMethodCheckRoleCodes.toArray(new String[0]);
            for (String currentRoleCode : currentRoleCodes) {
                if (!StringUtils.equalsAnyIgnoreCase((CharSequence)currentRoleCode, (CharSequence[])ignoreMethodCheckArrayRoleCodes)) continue;
                return 1;
            }
        }
        ArrayList matchingResults = Lists.newArrayList();
        Map pathMapping = this.frameworkEndpointHandler.getHandlerMethods();
        Set requestMappings = pathMapping.keySet();
        for (RequestMappingInfo requestMappingInfo : requestMappings) {
            try {
                PathPatternsRequestCondition pathPatternsRequestCondition = requestMappingInfo.getPathPatternsCondition();
                String patternString = null;
                if (pathPatternsRequestCondition != null) {
                    AntPathMatcher antPathMatcher = new AntPathMatcher();
                    PathPattern pathPattern = pathPatternsRequestCondition.getFirstPattern();
                    patternString = pathPattern.getPatternString();
                    if (!antPathMatcher.match(patternString, requestUrl)) continue;
                    matchingResults.add(requestMappingInfo);
                    continue;
                }
                PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
                if (patternsRequestCondition == null || patternsRequestCondition.getMatchingPatterns(requestUrl).isEmpty()) continue;
                matchingResults.add(requestMappingInfo);
            }
            catch (RuntimeException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        if (matchingResults.isEmpty()) {
            return 1;
        }
        Object loginDetailsObject = authentication.getDetails();
        if (!(loginDetailsObject instanceof UserIdentity)) {
            throw new AccessDeniedException("not author\uff08no login\uff09!");
        }
        UserIdentity userIdentity = (UserIdentity)loginDetailsObject;
        String tenantCode = userIdentity.getTenantCode();
        Set currentCompetenceRoleCodes = this.authenticationCompetenceEventListener.onRequestRoleCodes((List)matchingResults, tenantCode, httpRequest);
        if (CollectionUtils.isEmpty((Collection)currentCompetenceRoleCodes)) {
            return 1;
        }
        for (String currentCompetenceRoleCode : currentCompetenceRoleCodes) {
            for (String currentRoleCode : currentRoleCodes) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)currentRoleCode, (CharSequence)currentCompetenceRoleCode)) continue;
                return 1;
            }
        }
        return -1;
    }

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

