/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.login;

import com.bizunited.nebula.common.controller.model.ResponseCode;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.security.local.utils.HandleOutPut;
import com.bizunited.nebula.security.local.utils.JWTContext;
import com.bizunited.nebula.security.local.utils.JwtUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Component;

@Component(value="simpleLogoutSuccessHandler")
public class SimpleLogoutSuccessHandler
implements LogoutSuccessHandler,
HandleOutPut {
    private static final Logger log = LoggerFactory.getLogger(SimpleLogoutSuccessHandler.class);
    @Autowired(required=false)
    private SimpleSecurityProperties simpleSecurityProperties;
    @Autowired(required=false)
    private RedisTemplate redisTemplate;

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String username = "";
        if (authentication != null) {
            username = authentication.getName();
        }
        String jwt = null;
        if (StringUtil.isEmpty((CharSequence)username)) {
            jwt = request.getHeader("jwt");
            try {
                JWTContext jwtContent = JwtUtils.decode(jwt, this.simpleSecurityProperties.getSecretKey());
                username = jwtContent.getAccount();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (StringUtil.isNotEmpty((CharSequence)username)) {
            log.info("\u7528\u6237\u767b\u51fa\u7cfb\u7edf username[{}] JWT[{}] ", (Object)username, (Object)jwt);
            this.redisTemplate.opsForValue().set((Object)("user:login_out" + username), (Object)System.currentTimeMillis(), (long)this.simpleSecurityProperties.getJwtttl(), TimeUnit.MILLISECONDS);
        }
        log.info("\u7528\u6237\u767b\u51fa\u7cfb\u7edf userName[{}] ", (Object)username);
        Cookie[] allCookies = request.getCookies();
        if (allCookies != null) {
            for (int index = 0; index < allCookies.length; ++index) {
                Cookie currentCookie = allCookies[index];
                currentCookie.setMaxAge(0);
                response.addCookie(currentCookie);
            }
        }
        ResponseModel result = new ResponseModel(Long.valueOf(new Date().getTime()), (Object)username, ResponseCode.E0, null);
        result.setSuccess(Boolean.valueOf(true));
        result.setMessage(this.simpleSecurityProperties.getLogoutSuccessRedirect());
        this.writeResponse(response, result);
    }
}

