/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.security.local.login;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.configuration.SimpleTenantProperties;
import com.bizunited.nebula.security.local.notifier.TenantRequestEventListenerForSecurity;
import com.bizunited.nebula.security.local.utils.HandleOutPut;
import com.bizunited.nebula.security.local.utils.JwtUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.event.AuthenticatedEventListener;
import com.bizunited.nebula.security.sdk.event.NebulaSecurityAuthenticationSuccessPrinter;
import com.bizunited.nebula.security.sdk.event.SuccessPrinterContext;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.CollectionUtils;

public class SimpleNebulaSecurityAuthenticationSuccessPrinter
implements NebulaSecurityAuthenticationSuccessPrinter,
HandleOutPut {
    @Autowired(required=false)
    private List<AuthenticatedEventListener> authenticatedEventListeners;
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;
    @Autowired
    private SimpleTenantProperties simpleTenantProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantRequestEventListenerForSecurity.class);

    public int getOrder() {
        return 100;
    }

    @Transactional
    public void print(SuccessPrinterContext successPrinterContext, HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        UserIdentity userIdentity = (UserIdentity)authentication.getDetails();
        String tenantCode = userIdentity.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = this.findTenantCodeFromServletRequest(request);
            try {
                Field field = UserIdentity.class.getDeclaredField("tenantCode");
                field.setAccessible(true);
                field.set(userIdentity, tenantCode);
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty(this.authenticatedEventListeners)) {
            for (AuthenticatedEventListener authenticatedEventListener : this.authenticatedEventListeners) {
                authenticatedEventListener.onAuthenticationSuccess(userIdentity, authentication);
            }
        }
        Collection setCookies = response.getHeaders("Set-Cookie");
        String jsession = null;
        if (setCookies != null) {
            for (String setCookie : setCookies) {
                String value;
                int indexd;
                if (StringUtils.indexOf((CharSequence)setCookie, (CharSequence)"persistence=") != -1) {
                    indexd = setCookie.indexOf(61);
                    value = setCookie.substring(indexd + 1);
                    response.setHeader("persistence", value);
                    continue;
                }
                if (StringUtils.indexOf((CharSequence)setCookie, (CharSequence)"JSESSIONID=") == -1) continue;
                indexd = setCookie.indexOf(61);
                jsession = value = setCookie.substring(indexd + 1);
            }
            response.setHeader("Access-Control-Expose-Headers", "JSESSIONID,persistence,Cookie");
        }
        if (StringUtils.isBlank(jsession)) {
            HttpSession session = request.getSession();
            jsession = session.getId();
            Cookie cookie = new Cookie("JSESSIONID", jsession);
            cookie.setSecure(true);
            response.addCookie(cookie);
            session.setAttribute("tenantCode", (Object)tenantCode);
        }
        response.setHeader("JSESSIONID", jsession);
        String[] roles = null;
        Collection authoritys = authentication.getAuthorities();
        if (!CollectionUtils.isEmpty((Collection)authoritys)) {
            roles = (String[])authoritys.stream().map(GrantedAuthority::getAuthority).toArray(String[]::new);
        }
        String jwtEncodeContent = JwtUtils.encode(userIdentity, this.simpleSecurityProperties.getJwtttl(), this.simpleSecurityProperties.getSecretKey());
        successPrinterContext.put("account", (Object)userIdentity.getAccount());
        successPrinterContext.put("identityType", (Object)userIdentity.getIdentityType());
        successPrinterContext.put("tenantCode", (Object)tenantCode);
        successPrinterContext.put("roles", (Object)roles);
        successPrinterContext.put("jwt", (Object)jwtEncodeContent);
    }

    private String decodeBase64(String data) {
        return new String(Base64.getDecoder().decode(data), StandardCharsets.UTF_8);
    }

    private String findTenantCodeFromServletRequest(HttpServletRequest request) {
        try {
            String securityData = request.getHeader(this.simpleTenantProperties.getHeadAppKey());
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{securityData})) {
                if (this.simpleTenantProperties.getUseDefaultTenantCode().booleanValue()) {
                    return this.simpleTenantProperties.getDefaultTenantCode();
                }
                return null;
            }
            JSONObject jsonData = JSON.parseObject((String)this.decodeBase64(securityData));
            Validate.notNull((Object)jsonData, (String)"\u7f51\u5173\u4fe1\u606f\u89e3\u5bc6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            String tenantCode = jsonData.getString("tenantCode");
            Validate.notBlank((CharSequence)tenantCode, (String)"\u7f51\u5173\u4fe1\u606f\u4e0d\u5168\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            LOGGER.debug("\u5f53\u524d\u8bf7\u6c42\u643a\u5e26\u7684\u79df\u6237\u4fe1\u606f\u4e3a:{}", (Object)tenantCode);
            return tenantCode;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            if (this.simpleTenantProperties.getUseDefaultTenantCode().booleanValue()) {
                return this.simpleTenantProperties.getDefaultTenantCode();
            }
            return null;
        }
    }
}

