/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.configuration;

import com.bizunited.nebula.task.dto.DynamicTaskSchedulerDto;
import com.bizunited.nebula.task.local.service.internal.task.DynamicTaskOperation;
import com.bizunited.nebula.task.local.service.internal.task.DynamicTaskOperationCreateTask;
import com.bizunited.nebula.task.local.service.internal.task.DynamicTaskOperationFindTask;
import com.bizunited.nebula.task.local.service.internal.task.DynamicTaskOperationUpdateTask;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

@Configuration
@EntityScan(basePackages={"com.bizunited.nebula.task.local.entity"})
@EnableJpaRepositories(basePackages={"com.bizunited.nebula.task.local.repository"})
@ComponentScan(basePackages={"com.bizunited.nebula.task"})
@Component(value="_schedulerConfig")
@EnableElasticsearchRepositories(basePackages={"com.bizunited.nebula.task.local.log"})
public class SchedulerAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;

    @Bean(value={"platform_dTaskMasterKeeperThreadExecutor"})
    public ThreadPoolExecutor getDynamicTaskMasterKeeperThreadExecutor() {
        ThreadPoolExecutor dynamicTaskMasterKeeperThreadExecutor = new ThreadPoolExecutor(3, 3, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "platform_DynamicTask_MasterKeeperThread_" + this.count.incrementAndGet());
                ClassLoader classLoader = SchedulerAutoConfiguration.this.applicationContext.getClassLoader();
                thread.setContextClassLoader(classLoader);
                thread.setDaemon(false);
                return thread;
            }
        });
        return dynamicTaskMasterKeeperThreadExecutor;
    }

    @Bean(value={"platform_dTaskOperationThreadExecutor"})
    public ThreadPoolExecutor getDynamicTaskOperationThreadExecutor() {
        ThreadPoolExecutor dynamicTaskMasterKeeperThreadExecutor = new ThreadPoolExecutor(2, 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "platform_DynamicTask_OperationThread_" + this.count.incrementAndGet());
                ClassLoader classLoader = SchedulerAutoConfiguration.this.applicationContext.getClassLoader();
                thread.setContextClassLoader(classLoader);
                thread.setDaemon(false);
                return thread;
            }
        });
        return dynamicTaskMasterKeeperThreadExecutor;
    }

    @Bean
    @Scope(value="prototype")
    public DynamicTaskOperationCreateTask getDynamicTaskOperationCreateTask(DynamicTaskSchedulerVo task, String scriptContent) {
        return new DynamicTaskOperationCreateTask(task, scriptContent, DynamicTaskOperation.createIgnorePrefix);
    }

    @Bean
    @Scope(value="prototype")
    public DynamicTaskOperationCreateTask getDynamicTaskOperationCreateTask(String appCode, String taskCode, String invokeBeanName, String method, Integer taskType, String executeExpression, Date executePoint, Date validityTime, String taskDesc, Object ... args) {
        return new DynamicTaskOperationCreateTask(appCode, taskCode, invokeBeanName, method, taskType, executeExpression, executePoint, validityTime, taskDesc, DynamicTaskOperation.createIgnorePrefixForTaskType, args);
    }

    @Bean
    @Scope(value="prototype")
    public DynamicTaskOperationCreateTask getDynamicTaskOperationCreateTask(String appCode, String taskCode, String invokeBeanName, String method, String executeExpression, Date validityTime, String taskDesc, Object ... args) {
        return new DynamicTaskOperationCreateTask(appCode, taskCode, invokeBeanName, method, executeExpression, validityTime, taskDesc, DynamicTaskOperation.createIgnorePrefixForParams, args);
    }

    @Bean
    @Scope(value="prototype")
    public DynamicTaskOperationCreateTask getDynamicTaskOperationCreateTask(List<DynamicTaskSchedulerVo> tasks, Integer invokeType, String applicationName, String appCode) {
        return new DynamicTaskOperationCreateTask(tasks, invokeType, applicationName, appCode, DynamicTaskOperation.saveIgnorePrefix);
    }

    @Bean
    @Scope(value="prototype")
    public DynamicTaskOperationUpdateTask getDynamicTaskOperationUpdateTask(DynamicTaskSchedulerVo task, String scriptContent) {
        return new DynamicTaskOperationUpdateTask(task, scriptContent, DynamicTaskOperation.updateIgnorePrefix);
    }

    @Bean
    @Scope(value="prototype")
    public DynamicTaskOperationUpdateTask getDynamicTaskOperationUpdateTask(String appCode, String taskCode, String executeExpression, Date validityTime, String taskDesc, Object ... args) {
        return new DynamicTaskOperationUpdateTask(appCode, taskCode, executeExpression, validityTime, taskDesc, DynamicTaskOperation.updateIgnorePrefixForParams, args);
    }

    @Bean
    @Scope(value="prototype")
    public DynamicTaskOperationUpdateTask getDynamicTaskOperationUpdateTask(String appCode, String[] taskCodes, DynamicTaskOperation dynamicTaskOperation) {
        return new DynamicTaskOperationUpdateTask(appCode, taskCodes, dynamicTaskOperation);
    }

    @Bean
    @Scope(value="prototype")
    public DynamicTaskOperationFindTask getDynamicTaskOperationFindTask(String taskCode, String applicationName, String appCode) {
        return new DynamicTaskOperationFindTask(taskCode, applicationName, appCode);
    }

    @Bean
    @Scope(value="prototype")
    public DynamicTaskOperationFindTask getDynamicTaskOperationFindTask(Pageable pageable, DynamicTaskSchedulerDto conditions) {
        return new DynamicTaskOperationFindTask(pageable, conditions);
    }

    @Bean(value={"platform_dynamicTaskLoadingThreadScheduler"})
    public ThreadPoolTaskScheduler getInitProcessThreadPoolExecutor() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setBeanName("platform_dynamicTaskMSThreadScheduler");
        scheduler.setDaemon(false);
        scheduler.setPoolSize(50);
        scheduler.setThreadFactory(new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread currentThread = new Thread(r);
                ClassLoader classLoader = SchedulerAutoConfiguration.this.applicationContext.getClassLoader();
                currentThread.setDaemon(false);
                currentThread.setName("platform_DynamicTask_LoadingThread_" + this.count.getAndIncrement());
                currentThread.setContextClassLoader(classLoader);
                return currentThread;
            }
        });
        scheduler.setThreadNamePrefix("platform_dynamicTaskMSThreadScheduler_");
        return scheduler;
    }

    @Bean(value={"platform_dynamicTaskScheduler"})
    public ThreadPoolTaskScheduler getThreadPoolTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setBeanName("platform_dynamicTaskScheduler");
        scheduler.setDaemon(false);
        scheduler.setPoolSize(50);
        scheduler.setThreadFactory(new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread currentThread = new Thread(r);
                ClassLoader classLoader = SchedulerAutoConfiguration.this.applicationContext.getClassLoader();
                currentThread.setDaemon(false);
                currentThread.setName("platform_DynamicTask_" + this.count.getAndIncrement());
                currentThread.setContextClassLoader(classLoader);
                return currentThread;
            }
        });
        scheduler.setThreadNamePrefix("platform_");
        return scheduler;
    }
}

