/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.dto.DynamicTaskRightNowDto;
import com.bizunited.nebula.task.dto.DynamicTaskSchedulerDto;
import com.bizunited.nebula.task.local.configuration.DynamicTaskProperties;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerVoService;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/task/dynamicTasks"})
public class DynamicTaskSchedulerController
extends BaseController {
    @Autowired
    private DynamicTaskSchedulerVoService dynamicTaskSchedulerVoService;
    @Autowired
    private DynamicTaskProperties dynamicTaskProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTaskSchedulerController.class);

    @ApiOperation(value="\u7531\u4e8e\u52a8\u6001\u4efb\u52a1\u4f7f\u7528\u521b\u5efa\u6388\u6743\u6807\u7b7e\u6765\u907f\u514d\u91cd\u590d\u63d0\u4ea4\u7684\u95ee\u9898\u3002\u6240\u4ee5\u5728\u521b\u5efa/\u4fee\u6539\u8425\u9500\u653f\u7b56\u5355\u524d\uff0c\u9700\u8981\u4f7f\u7528\u8be5\u65b9\u6cd5\u83b7\u5f97\u9884\u6388\u6743\u3002\u9884\u6388\u6743\u6210\u529f\u540e\uff0c\u624d\u80fd\u901a\u8fc7\u9884\u6388\u6743\u4fe1\u606f\u8fdb\u884c\u6dfb\u52a0\uff0c")
    @PostMapping(value={"/preSave"})
    public ResponseModel preSave() {
        try {
            String prefix = this.dynamicTaskSchedulerVoService.preModify();
            return this.buildHttpResult(prefix);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u5b9a\u65f6\u4efb\u52a1\uff0c\u76ee\u524d\u53ea\u80fd\u521b\u5efa1\uff1agroovy\u811a\u672c\u6267\u884c\u5668\uff1b3\u3001\u5168\u52a8\u6001\u8c03\u7528\u4efb\u52a1")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@RequestParam(value="taskstr") @ApiParam(name="taskstr", value="\u4ee5json\u5b57\u7b26\u4e32\u5f62\u5f0f\u8868\u5355\u7684\u52a8\u6001\u4efb\u52a1\u63cf\u8ff0") String taskstr, @RequestParam(value="scriptContent") @ApiParam(name="scriptContent", value="groovy\u811a\u672c\u5185\u5bb9") String scriptContent) {
        try {
            DynamicTaskSchedulerVo task = (DynamicTaskSchedulerVo)JSONObject.parseObject((String)taskstr, DynamicTaskSchedulerVo.class);
            this.dynamicTaskSchedulerVoService.create(task, scriptContent);
            return this.buildHttpResultW(task, new String[0]);
        }
        catch (RuntimeException e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u4e00\u4e2a\u6307\u5b9a\u7684task\u72b6\u6001\uff0c\u53ea\u6709\u72b6\u6001\u540c\u65f6\u5904\u4e8e\u201c\u6709\u6548\u201d\u7684\u201c\u672a\u5de5\u4f5c\u201d\u4efb\u52a1\uff0c\u624d\u80fd\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c", notes="\u8be5\u65b9\u6cd5\u4ec5\u63d0\u4f9b\u5bf9\u4e00\u4e9b\u57fa\u672c\u5c5e\u6027\u8fdb\u884c\u66f4\u65b0")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel update(@RequestParam(value="taskstr") @ApiParam(name="taskstr", value="\u4ee5json\u5b57\u7b26\u4e32\u5f62\u5f0f\u8868\u5355\u7684\u52a8\u6001\u4efb\u52a1\u63cf\u8ff0") String taskstr, @RequestParam(value="scriptContent") @ApiParam(name="scriptContent", value="\u76ee\u524d\u4ec5\u652f\u6301groovy\u5f62\u5f0f\u7684\u811a\u672c\u5185\u5bb9") String scriptContent) {
        try {
            DynamicTaskSchedulerVo task = (DynamicTaskSchedulerVo)JSONObject.parseObject((String)taskstr, DynamicTaskSchedulerVo.class);
            task = this.dynamicTaskSchedulerVoService.update(task, scriptContent);
            return this.buildHttpResultW(task, new String[0]);
        }
        catch (RuntimeException e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u5df2\u8bbe\u5b9a\u6240\u6709\u52a8\u6001\u4efb\u52a1\uff0c\u65e0\u8bba\u5176\u72b6\u6001\u5982\u4f55\uff1b\u5e76\u4e14\u8fd4\u56de\u4fe1\u606f\u6309\u7167\u521b\u5efa\u65f6\u95f4\u5012\u5e8f\u6392\u5217\u3002")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@PageableDefault(value=50) @ApiParam(name="pageable", value="\u5206\u9875\u53c2\u6570\uff0c\u5f53\u6307\u5b9apage\u65f6\u4e3a\u67e5\u8be2\u5f53\u524d\u9875\u7801\uff08\u9875\u7801\u4ece0\u5f00\u59cb\uff09\uff1b\u5f53\u6307\u5b9asize\u65f6\uff0c\u4e3a\u6307\u5b9a\u6bcf\u9875\u5927\u5c0f\uff0c\u9ed8\u8ba4\u4e3a50") Pageable pageable, DynamicTaskSchedulerDto conditions) {
        try {
            Page results = this.dynamicTaskSchedulerVoService.findByConditions(pageable, conditions);
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6307\u5b9a\u7684\u4efb\u52a1\u4e1a\u52a1\u7f16\u53f7\uff0c\u67e5\u8be2\u52a8\u6001\u4efb\u52a1\u8be6\u7ec6\u60c5\u51b5\u3002\u53ea\u5305\u62ec\u52a8\u6001\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u548c\u53ef\u80fd\u7684\u521b\u5efa\u8005\u3001\u4fee\u6539\u8005\u4fe1\u606f")
    @RequestMapping(value={"/findByTaskCode"}, method={RequestMethod.GET})
    public ResponseModel findByTaskCode(@RequestParam(name="taskCode", required=false) @ApiParam(name="taskCode", value="\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\uff08\u53ea\u80fd\u7531\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u6760\u6784\u6210\uff09", required=false) String taskCode) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            String applicationName = this.dynamicTaskProperties.getApplicationName();
            DynamicTaskSchedulerVo result = this.dynamicTaskSchedulerVoService.findByTaskCodeAndApplicationNameAndAppCode(taskCode, applicationName, tenantCode);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u505c\u6b62\u6307\u5b9a\u7684\u4efb\u52a1\uff0c\u53ea\u6709\u5904\u4e8e\u201c\u8fd0\u884c\u4e2d\u201d\u7684\u4efb\u52a1\u80fd\u591f\u88ab\u505c\u6b62", notes="\u7531\u4e8e\u5f53\u524d\u7684\u201c\u8f7b\u8d28\u8bf7\u6c42\u201d\u53ef\u80fd\u4e0d\u6765\u81ea\u4e8emaster\u8282\u70b9\uff0c\u6240\u4ee5\u8fd9\u91cc\u53ea\u662f\u66f4\u6539\u4efb\u52a1\u72b6\u6001\uff0c\u4ee5\u4fbfmaster\u8282\u70b9\u4e0b\u4e00\u6b21\u4efb\u52a1\u72b6\u6001\u626b\u63cf\u65f6\u505c\u6b62\u8be5\u8282\u70b9")
    @RequestMapping(value={"/interrupt"}, method={RequestMethod.POST})
    public ResponseModel interrupt(@RequestParam(value="taskCode") @ApiParam(name="taskCode", value="\u6307\u5b9a\u7684\u52a8\u6001\u4efb\u52a1\u7f16\u53f7\u4fe1\u606f") String[] taskCodes) {
        try {
            this.dynamicTaskSchedulerVoService.stop(taskCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8ba9\u6307\u5b9a\u7684\u4efb\u52a1\u7acb\u5373\u8fd0\u884c\u4e00\u6b21\uff0c\u65e0\u8bba\u8fd9\u4e2a\u4efb\u52a1\u76ee\u524d\u5904\u4e8e\u4ec0\u4e48\u72b6\u6001\u3001\u5904\u4e8e\u4ec0\u4e48\u6837\u7684\u8fd0\u884c\u573a\u666f")
    @RequestMapping(value={"/startRightNowOnce"}, method={RequestMethod.POST})
    public ResponseModel startRightNowOnce(@RequestParam(value="taskCode") @ApiParam(name="taskCode", value="\u6307\u5b9a\u7684\u52a8\u6001\u4efb\u52a1\u7f16\u53f7\u4fe1\u606f") String[] taskCodes) {
        try {
            this.dynamicTaskSchedulerVoService.startRightNowOnce(taskCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8ba9\u6307\u5b9a\u7684\u4efb\u52a1\u5e26\u53c2\u6570\u7acb\u5373\u8fd0\u884c\u4e00\u6b21\uff0c\u65e0\u8bba\u8fd9\u4e2a\u4efb\u52a1\u76ee\u524d\u5904\u4e8e\u4ec0\u4e48\u72b6\u6001\u3001\u5904\u4e8e\u4ec0\u4e48\u6837\u7684\u8fd0\u884c\u573a\u666f")
    @RequestMapping(value={"/startByRightNowDto"}, method={RequestMethod.POST})
    public ResponseModel startByRightNowDto(@RequestBody DynamicTaskRightNowDto dto) {
        try {
            this.dynamicTaskSchedulerVoService.startByRightNowDto(dto);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u542f\u52a8\u6307\u5b9a\u7684\u4efb\u52a1", notes="\u7531\u4e8e\u5f53\u524d\u7684\u201c\u542f\u52a8\u8bf7\u6c42\u201d\u53ef\u80fd\u4e0d\u6765\u81ea\u4e8emaster\u8282\u70b9\uff0c\u6240\u4ee5\u8fd9\u91cc\u53ea\u662f\u66f4\u6539\u4efb\u52a1\u72b6\u6001\uff0c\u4ee5\u4fbfmaster\u8282\u70b9\u4e0b\u4e00\u6b21\u4efb\u52a1\u72b6\u6001\u626b\u63cf\u65f6\u542f\u52a8\u8be5\u8282\u70b9,\u65e0\u6548\u4efb\u52a1\u4e5f\u53ef\u4ee5\u4f7f\u7528\u8be5\u65b9\u6cd5\uff0c\u4e00\u65e6\u4f7f\u7528\u65e0\u6548\u4efb\u52a1\u5c31\u4f1a\u53d8\u6210\u6709\u6548\u4efb\u52a1")
    @RequestMapping(value={"/start"}, method={RequestMethod.POST})
    public ResponseModel start(@RequestParam(value="taskCode") @ApiParam(name="taskCode", value="\u6307\u5b9a\u7684\u52a8\u6001\u4efb\u52a1\u7f16\u53f7\u4fe1\u606f") String[] taskCodes) {
        try {
            this.dynamicTaskSchedulerVoService.start(taskCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6307\u5b9a\u7684\u4efb\u52a1\u4e1a\u52a1\u7f16\u53f7\uff0c\u5220\u9664\u8be5\u6761\u4efb\u52a1\uff0c\u53ea\u6709\u5df2\u505c\u6b62\u7684groovy\u7c7b\u578b\u7684\u4efb\u52a1\u624d\u80fd\u5220\u9664")
    @DeleteMapping(value={"/deleteByTaskcode"})
    public ResponseModel deleteTaskBytaskcode(@RequestParam(name="taskcode") @ApiParam(name="taskcode", value="\u6307\u5b9a\u5b9a\u65f6\u4efb\u52a1\u7684taskcode", required=true) String[] taskcodes) {
        try {
            this.dynamicTaskSchedulerVoService.deleteByTaskcodes(taskcodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

