/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.converter;

import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.task.service.strategy.DynamicTaskOperatorConverter;
import com.bizunited.nebula.task.vo.DynamicTaskOperatorVo;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DynamicTaskOperatorConverterFromSecurity
implements DynamicTaskOperatorConverter {
    public int sort() {
        return 1;
    }

    public DynamicTaskOperatorVo buildDynamicTaskOperator(DynamicTaskSchedulerVo task) {
        String tenantCode;
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        String userAccount = null;
        CharSequence[] roles = null;
        if (authentication == null || !(authentication.getDetails() instanceof UserIdentity)) {
            return null;
        }
        UserIdentity loginDetails = (UserIdentity)authentication.getDetails();
        userAccount = loginDetails.getAccount();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{userAccount, tenantCode = loginDetails.getTenantCode()})) {
            return null;
        }
        Collection authorities = authentication.getAuthorities();
        if (CollectionUtils.isEmpty((Collection)authorities)) {
            return null;
        }
        roles = (String[])authorities.stream().map(GrantedAuthority::getAuthority).toArray(String[]::new);
        if (StringUtils.equalsAny((CharSequence)"ANONYMOUS", (CharSequence[])roles)) {
            return null;
        }
        DynamicTaskOperatorVo dynamicTaskOperatorVo = new DynamicTaskOperatorVo();
        String taskCode = task.getTaskCode();
        String appCode = task.getAppCode();
        String applicationName = task.getApplicationName();
        dynamicTaskOperatorVo.setApplicationName(applicationName);
        dynamicTaskOperatorVo.setTaskCode(taskCode);
        dynamicTaskOperatorVo.setAppCode(appCode);
        dynamicTaskOperatorVo.setAccount(userAccount);
        dynamicTaskOperatorVo.setTenantCode(tenantCode);
        dynamicTaskOperatorVo.setRoles((String[])roles);
        return dynamicTaskOperatorVo;
    }
}

