/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.log;

import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.bizunited.nebula.task.local.log.DynamicTaskSchedulerLog;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class DynamicTaskSchedulerLogCleanTask {
    @Autowired
    private ElasticsearchRestTemplate esTemplate;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTaskSchedulerLogCleanTask.class);

    @DynamicTaskService(cornExpression="0 0 1 ? * * ", taskDesc="\u8d1f\u8d23\u8fdb\u884c\u52a8\u6001\u4efb\u52a1\u6267\u884c\u65e5\u5fd7\u7684\u6e05\u7406\u5de5\u4f5c\uff08\u6bcf\u5929\u51cc\u66681\u70b9\u8fd0\u884c\uff0c\u6bcf\u4e2a\u79df\u6237\u9ed8\u8ba4\u90fd\u8fd0\u884c\uff09\uff0c\u8d85\u8fc7\u4e09\u4e2a\u6708\u7684\u65e5\u5fd7\u90fd\u5c06\u88ab\u6e05\u7406")
    public void cleanEs() {
        Date now = new Date();
        Date targetDate = DateUtils.addMonths((Date)now, (int)-3);
        LOGGER.info("\u8bd5\u56fe\u5220\u9664\u4e09\u4e2a\u6708\u524d\u7684\u4efb\u52a1\u6267\u884c\u65e5\u5fd7");
        NativeSearchQuery nativeSearchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.rangeQuery((String)"endTime").lte((Object)targetDate)).build();
        ByQueryResponse queryResponse = this.esTemplate.delete((Query)nativeSearchQuery, DynamicTaskSchedulerLog.class);
        long deletedCount = queryResponse.getDeleted();
        LOGGER.info("\u672c\u6b21\u5220\u9664\u7684\u65e5\u5fd7\u6570\u91cf\uff1a" + deletedCount);
    }
}

