/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.init;

import com.bizunited.nebula.init.service.InitProcessEnvironmentService;
import com.bizunited.nebula.script.context.InvokeProxyContext;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.bizunited.nebula.task.local.configuration.DynamicTaskProperties;
import com.bizunited.nebula.task.local.service.scheduler.DynamicMasterKeeperTask;
import com.bizunited.nebula.task.local.service.scheduler.DynamicNodeKeeperTask;
import com.bizunited.nebula.task.local.service.scheduler.DynamicShardingKeeperTask;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerVoService;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import javassist.NotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="_SchedulerTaskInitProcess")
public class SchedulerTaskInitProcess
implements CommandLineRunner,
InitProcessEnvironmentService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="platform_dTaskMasterKeeperThreadExecutor")
    private ThreadPoolExecutor dynamicTaskMasterKeeperThreadExecutor;
    @Autowired
    private DynamicTaskSchedulerVoService dynamicTaskSchedulerVoService;
    @Autowired
    private DynamicTaskProperties dynamicTaskProperties;
    private BlockingQueue<Pair<String, String>> taskQueue = new ArrayBlockingQueue<Pair<String, String>>(100);
    private static Map<String, List<Method>> nebulaServiceMethodMapping = Maps.newLinkedHashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerTaskInitProcess.class);

    public void run(String ... args) throws Exception {
        String[] definitionNames;
        for (String definitionName : definitionNames = this.applicationContext.getBeanDefinitionNames()) {
            Method[] beanMethods;
            LinkedList methods;
            block7: {
                methods = Lists.newLinkedList();
                Class beanClass = this.applicationContext.getType(definitionName);
                if (Objects.isNull(beanClass)) {
                    LOGGER.warn("\u5b58\u5728\u65e0\u6cd5\u8bc6\u522b\u7684class\u4fe1\u606f:{}", (Object)definitionName);
                    continue;
                }
                String beanClassName = Objects.requireNonNull(beanClass).getName();
                if (beanClassName.contains("$")) {
                    beanClassName = beanClassName.substring(0, beanClassName.indexOf("$"));
                }
                if (StringUtils.isBlank((CharSequence)beanClassName)) continue;
                try {
                    beanMethods = beanClass.getMethods();
                    if (beanMethods.length == 0) {
                    }
                    break block7;
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            for (Method method : beanMethods) {
                DynamicTaskService dynamicTaskService = (DynamicTaskService)AnnotationUtils.findAnnotation((Method)method, DynamicTaskService.class);
                if (dynamicTaskService == null) continue;
                methods.add(method);
            }
            if (CollectionUtils.isEmpty((Collection)methods)) continue;
            nebulaServiceMethodMapping.put(definitionName, methods);
        }
        DynamicMasterKeeperTask dynamicMasterKeeperTask = (DynamicMasterKeeperTask)this.applicationContext.getBean(DynamicMasterKeeperTask.class, new Object[]{this.taskQueue});
        this.dynamicTaskMasterKeeperThreadExecutor.submit(dynamicMasterKeeperTask);
        DynamicNodeKeeperTask dynamicNodeKeeperTask = (DynamicNodeKeeperTask)this.applicationContext.getBean(DynamicNodeKeeperTask.class);
        this.dynamicTaskMasterKeeperThreadExecutor.submit(dynamicNodeKeeperTask);
        DynamicShardingKeeperTask dynamicShardingKeeperTask = (DynamicShardingKeeperTask)this.applicationContext.getBean(DynamicShardingKeeperTask.class);
        this.dynamicTaskMasterKeeperThreadExecutor.submit(dynamicShardingKeeperTask);
    }

    public boolean doInitForAppCode(String appCode) {
        return true;
    }

    public void initForAppCode(String appCode) {
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        if (!CollectionUtils.isEmpty(nebulaServiceMethodMapping)) {
            ArrayList currentScanTasks = Lists.newArrayList();
            for (Map.Entry<String, List<Method>> entry : nebulaServiceMethodMapping.entrySet()) {
                entry.getValue().forEach(method -> {
                    try {
                        currentScanTasks.addAll(this.analysisMethods((Method)method, (String)entry.getKey(), applicationName, appCode));
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                });
            }
            try {
                this.dynamicTaskSchedulerVoService.saveIgnorePrefix((List)currentScanTasks, Integer.valueOf(2), applicationName, appCode);
            }
            catch (RuntimeException e) {
                LOGGER.error(String.format("\u52a8\u6001\u4efb\u52a1\u542f\u52a8(\u521d\u59cb\u5316)\u65f6\uff0c\u53d1\u751f\u4e25\u91cd\u9519\u8bef\uff0c\u8fd9\u4e2a\u9519\u8bef\u5c06\u5bfc\u81f4\u672c\u8282\u70b9\u65e0\u6cd5\u53c2\u4e0e\u52a8\u6001\u4efb\u52a1\u7684\u7ba1\u7406\uff0c\u8bf7\u91cd\u70b9\u68c0\u67e5\u6570\u636e\u5e93\u8bbe\u5b9a\uff08applicationName+appCode+taskcode\u624d\u80fd\u8fdb\u884c\u552f\u4e00\u952e\u5224\u5b9a\uff09:%s", e.getMessage()), (Throwable)e);
            }
        }
        Pair pair = Pair.of((Object)applicationName, (Object)appCode);
        this.taskQueue.add((Pair<String, String>)pair);
    }

    private List<DynamicTaskSchedulerVo> analysisMethods(Method nebulaServiceMethod, String definitionName, String applicationName, String appCode) throws ClassNotFoundException, NotFoundException {
        ArrayList currentScanTasks = Lists.newArrayList();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DynamicTaskService dynamicTaskService = (DynamicTaskService)AnnotationUtils.findAnnotation((Method)nebulaServiceMethod, DynamicTaskService.class);
        if (dynamicTaskService == null) {
            return currentScanTasks;
        }
        String cornExpression = dynamicTaskService.cornExpression();
        String executePoint = dynamicTaskService.executePoint();
        String taskDesc = dynamicTaskService.taskDesc();
        String validityPoint = dynamicTaskService.validityPoint();
        boolean onlyOnce = dynamicTaskService.onlyOnce();
        String methodName = nebulaServiceMethod.getName();
        Class<?> declaringClass = nebulaServiceMethod.getDeclaringClass();
        String declaringClassName = declaringClass.getName();
        if (declaringClassName.contains("$")) {
            declaringClassName = StringUtils.substringBefore((String)declaringClassName, (String)"$");
        }
        String methodLongName = StringUtils.join((Object[])new String[]{declaringClassName, ".", methodName});
        Class<?>[] parameterTypes = nebulaServiceMethod.getParameterTypes();
        DynamicTaskSchedulerVo currentTask = new DynamicTaskSchedulerVo();
        Validate.isTrue((parameterTypes.length == 0 || parameterTypes.length == 1 && StringUtils.equals((CharSequence)parameterTypes[0].getName(), (CharSequence)InvokeProxyContext.class.getName()) ? 1 : 0) != 0, (String)"\u4f7f\u7528DynamicTaskService\u6ce8\u89e3\u7684\u65b9\u6cd5\uff0c\u5fc5\u987b\u6258\u7ba1\u7ed9Spring\uff0c\u5e76\u4e14\u76ee\u524d\u53ea\u5141\u8bb8\u6ca1\u6709\u5165\u53c2\u6216\u8005\u5165\u53c2\u4e3acom.bizunited.platform.core.service.invoke.InvokeProxyContext\u7684\u65b9\u6cd5\uff0c\u8bf7\u68c0\u67e5%s", (Object[])new Object[]{methodLongName});
        Validate.notBlank((CharSequence)taskDesc, (String)"\u57fa\u4e8eDynamicTaskService\u6ce8\u89e3\u7684\u5b9a\u65f6\u5668\u4efb\u52a1\u5e76\u6ca1\u6709\u8bf4\u660e\u5176\u4e1a\u52a1\u610f\u4e49\uff08expressionDesc\uff09\uff0c\u8bf7\u68c0\u67e5%s!", (Object[])new Object[]{methodLongName});
        if (onlyOnce) {
            if (!StringUtils.isBlank((CharSequence)executePoint)) {
                Date executePointTime = null;
                try {
                    executePointTime = dateFormat.parse(executePoint);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(String.format("\u4e00\u6b21\u6027\u5b9a\u65f6\u4efb\u52a1%s\u8bbe\u5b9a\u7684\u65e5\u671f\u683c\u5f0f\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5", methodLongName));
                }
                currentTask.setExecutePoint(executePointTime);
                Date validityTime = DateUtils.addMinutes((Date)executePointTime, (int)60);
                currentTask.setValidityTime(validityTime);
            } else if (!StringUtils.isBlank((CharSequence)cornExpression)) {
                try {
                    new CronTrigger(cornExpression);
                }
                catch (RuntimeException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException(String.format("\u4e00\u6b21\u6027\u4efb\u52a1%s\u8bbe\u5b9a\u7684corn\u8868\u8fbe\u662f\u5b58\u5728\u683c\u5f0f\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5", methodLongName));
                }
                currentTask.setExecuteExpression(cornExpression);
                currentTask.setExpressionDesc(cornExpression);
            } else {
                throw new IllegalArgumentException(String.format("\u5f53\u4efb\u52a1\u662f\u4e00\u6b21\u6027\u6267\u884c\u4efb\u52a1\u65f6\uff0c\u8981\u4e48\u8bbe\u5b9acorn\u8868\u8fbe\u5f0f\uff08cornExpression\uff09\uff0c\u8981\u4e48\u8bbe\u5b9a\u786e\u5b9a\u7684\u6267\u884c\u65f6\u95f4\u70b9\uff08executePoint\uff09\uff0c\u8bf7\u68c0\u67e5\u4efb\u52a1%s", methodLongName));
            }
            currentTask.setTaskType(Integer.valueOf(1));
        } else {
            if (!StringUtils.isBlank((CharSequence)cornExpression)) {
                try {
                    new CronTrigger(cornExpression);
                }
                catch (RuntimeException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException(String.format("\u5468\u671f\u6027\u6267\u884c\u4efb\u52a1%s\u8bbe\u5b9a\u7684corn\u8868\u8fbe\u662f\u5b58\u5728\u683c\u5f0f\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\uff1a%s", methodLongName, e.getMessage()));
                }
            } else {
                throw new IllegalArgumentException(String.format("\u5f53\u4efb\u52a1\u662f\u5468\u671f\u6027\u6267\u884c\u4efb\u52a1\u65f6\uff0c\u8981\u8bbe\u5b9acorn\u8868\u8fbe\u5f0f\uff08cornExpression\uff09\uff0c\u8bf7\u68c0\u67e5\u4efb\u52a1%s", methodLongName));
            }
            currentTask.setExecuteExpression(cornExpression);
            currentTask.setExpressionDesc(cornExpression);
            currentTask.setTaskType(Integer.valueOf(2));
        }
        if (!StringUtils.isBlank((CharSequence)validityPoint)) {
            Date validityPointTime = null;
            try {
                validityPointTime = dateFormat.parse(validityPoint);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("\u5b9a\u65f6\u4efb\u52a1%s\u8bbe\u5b9a\u7684\u5931\u6548\u65f6\u95f4\u65e5\u671f\u683c\u5f0f\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5", methodLongName));
            }
            currentTask.setValidityTime(validityPointTime);
        }
        currentTask.setTaskDesc(taskDesc);
        currentTask.setInvokeType(Integer.valueOf(2));
        currentTask.setTaskCode(methodLongName);
        currentTask.setScriptName("");
        currentTask.setInvokeBeanName(definitionName);
        currentTask.setInvokeMethod(methodName);
        currentTask.setAppCode(appCode);
        currentTask.setApplicationName(applicationName);
        currentScanTasks.add(currentTask);
        return currentScanTasks;
    }
}

