/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.IpUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.local.configuration.DynamicTaskProperties;
import com.bizunited.nebula.task.local.service.DynamicTaskNodeService;
import com.bizunited.nebula.task.local.service.scheduler.DynamicNode;
import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DynamicTaskNodeServiceImpl
implements DynamicTaskNodeService {
    @Autowired
    private DynamicTaskProperties dynamicTaskProperties;
    @Autowired
    private RedisMutexService redisMutexService;

    @Override
    public DynamicNode findMasterByCurrentTenantCode() {
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        String mapName = StringUtils.join((Object[])new String[]{applicationName, "_", "REDIS_KEY_DYNAMICTASK_NODE"});
        Set entrySets = this.redisMutexService.entrySet(mapName);
        if (CollectionUtils.isEmpty((Collection)entrySets)) {
            return null;
        }
        mapName = "REDIS_KEY_DYNAMICTASK_NODE_MASTER";
        String appCode = TenantUtils.getTenantCode();
        String mapKey = StringUtils.join((Object[])new String[]{applicationName, "_", appCode, "_", "REDIS_KEY_DYNAMICTASK_NODE_MASTER"});
        String currentMaster = this.redisMutexService.getMCode(mapName, mapKey);
        if (StringUtils.isBlank((CharSequence)currentMaster)) {
            return null;
        }
        DynamicNode currentMasterNode = (DynamicNode)JSONObject.parseObject((String)currentMaster, DynamicNode.class);
        for (Map.Entry entry : entrySets) {
            String value = entry.getValue().toString();
            DynamicNode dynamicNode = (DynamicNode)JSONObject.parseObject((String)value, DynamicNode.class);
            if (!StringUtils.equals((CharSequence)currentMasterNode.getApplicationName(), (CharSequence)dynamicNode.getApplicationName()) || !StringUtils.equals((CharSequence)currentMasterNode.getInternalIp(), (CharSequence)dynamicNode.getInternalIp()) || !StringUtils.equals((CharSequence)currentMasterNode.getProcessName(), (CharSequence)dynamicNode.getProcessName())) continue;
            return dynamicNode;
        }
        return null;
    }

    @Override
    public List<DynamicNode> findNodesByCurrentTenantCode() {
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        String mapName = StringUtils.join((Object[])new String[]{applicationName, "_", "REDIS_KEY_DYNAMICTASK_NODE"});
        Set entrySets = this.redisMutexService.entrySet(mapName);
        if (CollectionUtils.isEmpty((Collection)entrySets)) {
            return null;
        }
        ArrayList dynamicNodes = Lists.newArrayList();
        for (Map.Entry entry : entrySets) {
            String value = entry.getValue().toString();
            DynamicNode dynamicNode = (DynamicNode)JSONObject.parseObject((String)value, DynamicNode.class);
            dynamicNodes.add(dynamicNode);
        }
        return dynamicNodes;
    }

    @Override
    public DynamicNode findCurrentNode() {
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        Validate.notBlank((CharSequence)applicationName, (String)"\u4e25\u91cd\u9519\u8bef\uff1a\u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u5e76\u672a\u6307\u5b9a\u7cfb\u7edf\u540d(spring.application.name)\uff0c\u8c03\u5ea6\u4efb\u52a1\u529f\u80fd\u5c06\u4e0d\u80fd\u6b63\u5e38\u5de5\u4f5c!!", (Object[])new Object[0]);
        String internalIp = IpUtils.findInternalIp();
        Validate.notBlank((CharSequence)internalIp, (String)"\u4e25\u91cd\u9519\u8bef\uff1a\u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u6ca1\u6709\u4efb\u4f55\u5185\u7f51IP\uff0c\u8c03\u5ea6\u4efb\u52a1\u529f\u80fd\u5c06\u4e0d\u80fd\u6b63\u5e38\u5de5\u4f5c!!", (Object[])new Object[0]);
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        String processName = runtimeBean.getName();
        DynamicNode dynamicNode = new DynamicNode();
        dynamicNode.setApplicationName(applicationName);
        dynamicNode.setInternalIp(internalIp);
        dynamicNode.setProcessName(processName);
        return dynamicNode;
    }
}

