/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.internal;

import com.bizunited.nebula.task.local.entity.DynamicTaskParamEntity;
import com.bizunited.nebula.task.local.entity.DynamicTaskTemporaryParamEntity;
import com.bizunited.nebula.task.local.service.DynamicTaskParamService;
import com.bizunited.nebula.task.local.service.DynamicTaskTemporaryParamService;
import com.bizunited.nebula.task.service.DynamicTaskParamVoService;
import com.bizunited.nebula.task.service.strategy.DynamicTaskParamValueConverter;
import com.bizunited.nebula.task.vo.DynamicTaskParamVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="_DynamicTaskParamVoServiceImpl")
public class DynamicTaskParamVoServiceImpl
implements DynamicTaskParamVoService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DynamicTaskParamService dynamicTaskParamService;
    @Autowired
    private DynamicTaskTemporaryParamService dynamicTaskTemporaryParamService;
    @Autowired(required=false)
    private List<DynamicTaskParamValueConverter> dynamicTaskParamValueConverters;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTaskParamVoServiceImpl.class);

    public List<DynamicTaskParamVo> findByDynamicTask(String dynamicTaskId) {
        List<DynamicTaskParamEntity> dynamicTaskParams = this.dynamicTaskParamService.findByDynamicTask(dynamicTaskId);
        if (CollectionUtils.isEmpty(dynamicTaskParams)) {
            return null;
        }
        ClassLoader classLoader = this.applicationContext.getClassLoader();
        DynamicTaskParamValueConverter defaultDynamicTaskParamValueConverter = this.dynamicTaskParamValueConverters.stream().filter(item -> item.isDefault()).findFirst().orElse(null);
        ArrayList results = Lists.newArrayList();
        for (int index = 0; index < dynamicTaskParams.size(); ++index) {
            DynamicTaskParamEntity dynamicTaskParam = dynamicTaskParams.get(index);
            String paramTypeValue = dynamicTaskParam.getParamType();
            Class<?> paramTypeClass = null;
            try {
                paramTypeClass = classLoader.loadClass(paramTypeValue);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage());
            }
            String paramValue = dynamicTaskParam.getParamValue();
            Object deserialize = null;
            if (paramValue != null) {
                boolean canConverter = false;
                DynamicTaskParamValueConverter currntDynamicTaskParamValueConverter = null;
                for (DynamicTaskParamValueConverter dynamicTaskParamValueConverter : this.dynamicTaskParamValueConverters) {
                    canConverter = dynamicTaskParamValueConverter.canConverter(index, paramTypeClass);
                    if (!canConverter) continue;
                    currntDynamicTaskParamValueConverter = dynamicTaskParamValueConverter;
                    break;
                }
                if (!canConverter) {
                    currntDynamicTaskParamValueConverter = defaultDynamicTaskParamValueConverter;
                }
                deserialize = currntDynamicTaskParamValueConverter.deserialize(index, paramTypeClass, paramValue);
            }
            DynamicTaskParamVo dynamicTaskParamVo = new DynamicTaskParamVo();
            dynamicTaskParamVo.setId(dynamicTaskParam.getId());
            dynamicTaskParamVo.setParamIndex(Integer.valueOf(index));
            dynamicTaskParamVo.setParamType(paramTypeClass);
            dynamicTaskParamVo.setParamValue(deserialize);
            results.add(dynamicTaskParamVo);
        }
        return results;
    }

    public List<DynamicTaskParamVo> findTemporaryByDynamicTask(String dynamicTaskId) {
        List<DynamicTaskTemporaryParamEntity> dynamicTaskTemporaryParams = this.dynamicTaskTemporaryParamService.findByDynamicTask(dynamicTaskId);
        if (CollectionUtils.isEmpty(dynamicTaskTemporaryParams)) {
            return null;
        }
        ClassLoader classLoader = this.applicationContext.getClassLoader();
        DynamicTaskParamValueConverter defaultDynamicTaskParamValueConverter = this.dynamicTaskParamValueConverters.stream().filter(DynamicTaskParamValueConverter::isDefault).findFirst().orElse(null);
        ArrayList results = Lists.newArrayList();
        for (int index = 0; index < dynamicTaskTemporaryParams.size(); ++index) {
            DynamicTaskTemporaryParamEntity dynamicTaskTemporaryParam = dynamicTaskTemporaryParams.get(index);
            String paramTypeValue = dynamicTaskTemporaryParam.getParamType();
            Class<?> paramTypeClass = null;
            try {
                paramTypeClass = classLoader.loadClass(paramTypeValue);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage());
            }
            String paramValue = dynamicTaskTemporaryParam.getParamValue();
            Object deserialize = null;
            if (paramValue != null) {
                boolean canConverter = false;
                DynamicTaskParamValueConverter currntDynamicTaskParamValueConverter = null;
                for (DynamicTaskParamValueConverter dynamicTaskParamValueConverter : this.dynamicTaskParamValueConverters) {
                    if (!dynamicTaskParamValueConverter.canConverter(index, paramTypeClass)) continue;
                    canConverter = dynamicTaskParamValueConverter.canConverter(index, paramTypeClass);
                    currntDynamicTaskParamValueConverter = dynamicTaskParamValueConverter;
                    break;
                }
                if (!canConverter) {
                    currntDynamicTaskParamValueConverter = defaultDynamicTaskParamValueConverter;
                }
                deserialize = currntDynamicTaskParamValueConverter.deserialize(index, paramTypeClass, paramValue);
            }
            DynamicTaskParamVo dynamicTaskParamVo = new DynamicTaskParamVo();
            dynamicTaskParamVo.setId(dynamicTaskTemporaryParam.getId());
            dynamicTaskParamVo.setParamIndex(Integer.valueOf(index));
            dynamicTaskParamVo.setParamType(paramTypeClass);
            dynamicTaskParamVo.setParamValue(deserialize);
            results.add(dynamicTaskParamVo);
        }
        return results;
    }
}

