/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.internal;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.dto.DynamicTaskSchedulerLogDto;
import com.bizunited.nebula.task.local.configuration.DynamicTaskProperties;
import com.bizunited.nebula.task.local.log.DynamicTaskSchedulerLog;
import com.bizunited.nebula.task.local.log.DynamicTaskSchedulerLogRepository;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerLogVoService;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerLogVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;

@Service(value="DynamicTaskSchedulerLogServiceImpl")
public class DynamicTaskSchedulerLogVoServiceImpl
implements DynamicTaskSchedulerLogVoService {
    @Autowired
    private DynamicTaskSchedulerLogRepository dynamicTaskSchedulerLogRepository;
    @Autowired
    private DynamicTaskProperties dynamicTaskProperties;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ElasticsearchRestTemplate esTemplate;

    public DynamicTaskSchedulerLogVo create(DynamicTaskSchedulerLogVo log) {
        DynamicTaskSchedulerLog logEntity = (DynamicTaskSchedulerLog)this.nebulaToolkitService.copyObjectByWhiteList((Object)log, DynamicTaskSchedulerLog.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        logEntity.setId(UUID.randomUUID().toString());
        this.dynamicTaskSchedulerLogRepository.save(logEntity);
        log.setId(logEntity.getId());
        return log;
    }

    public DynamicTaskSchedulerLogVo createOrModify(DynamicTaskSchedulerLogVo log) {
        DynamicTaskSchedulerLog logEntity = (DynamicTaskSchedulerLog)this.nebulaToolkitService.copyObjectByWhiteList((Object)log, DynamicTaskSchedulerLog.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.dynamicTaskSchedulerLogRepository.save(logEntity);
        return log;
    }

    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional current = this.dynamicTaskSchedulerLogRepository.findById(id);
        if (current.isPresent()) {
            this.dynamicTaskSchedulerLogRepository.delete(current.get());
        }
    }

    public void deleteByDynamicTaskId(String dynamicTaskId) {
        Validate.notBlank((CharSequence)dynamicTaskId, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u5173\u8054\u7684\u52a8\u6001\u4efb\u52a1id\u4fe1\u606f!!", (Object[])new Object[0]);
        this.dynamicTaskSchedulerLogRepository.deleteByDynamicTaskId(dynamicTaskId);
    }

    public DynamicTaskSchedulerLogVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DynamicTaskSchedulerLog currentDynamicTask = this.dynamicTaskSchedulerLogRepository.findById(id).orElse(null);
        if (currentDynamicTask == null) {
            return null;
        }
        List<DynamicTaskSchedulerLogVo> logVos = this.buildDynamicTaskSchedulerLogVo(Lists.newArrayList((Object[])new DynamicTaskSchedulerLog[]{currentDynamicTask}));
        return logVos.get(0);
    }

    public Page<DynamicTaskSchedulerLogVo> findByConditions(Pageable pageable, DynamicTaskSchedulerLogDto condition) {
        NativeSearchQuery nativeSearchQuery;
        SearchHits searchResult;
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (condition == null) {
            return null;
        }
        String appCode = TenantUtils.getTenantCode();
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        condition.setAppCode(appCode);
        condition.setApplicationName(applicationName);
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)condition.getApplicationName()).field("applicationName"));
        queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)condition.getAppCode()).field("appCode"));
        if (StringUtils.isNotBlank((CharSequence)condition.getTaskId())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)condition.getTaskId()).field("dynamicTaskId"));
        }
        if (condition.getLogtime() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"logtime").gte((Object)condition.getLogtime()));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getError())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)condition.getError(), (String[])new String[]{"taskDesc", "errorContents", "errorSummary"}));
        }
        if ((searchResult = this.esTemplate.search((Query)(nativeSearchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)queryBuilder).withPageable(pageable).withSorts(new SortBuilder[]{SortBuilders.fieldSort((String)"startTime").order(SortOrder.DESC)}).build()), DynamicTaskSchedulerLog.class)) == null || searchResult.isEmpty()) {
            return null;
        }
        List<DynamicTaskSchedulerLog> searchList = searchResult.stream().map(SearchHit::getContent).collect(Collectors.toList());
        List<DynamicTaskSchedulerLogVo> copyVos = this.buildDynamicTaskSchedulerLogVo(searchList);
        return new PageImpl((List)Lists.newArrayList(copyVos), pageable, searchResult.getTotalHits());
    }

    private List<DynamicTaskSchedulerLogVo> buildDynamicTaskSchedulerLogVo(List<DynamicTaskSchedulerLog> searchList) {
        if (CollectionUtils.isEmpty(searchList)) {
            return Lists.newArrayList();
        }
        List schedulerLogVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(searchList, DynamicTaskSchedulerLog.class, DynamicTaskSchedulerLogVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        schedulerLogVos.forEach(logVo -> {
            if (StringUtils.isBlank((CharSequence)logVo.getState())) {
                logVo.setState(Objects.nonNull(logVo.getSuccess()) && logVo.getSuccess() != false ? "20" : "30");
            }
        });
        return schedulerLogVos;
    }
}

