/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.bizunited.nebula.task.dto.DynamicTaskRightNowDto;
import com.bizunited.nebula.task.dto.DynamicTaskSchedulerDto;
import com.bizunited.nebula.task.local.configuration.DynamicTaskProperties;
import com.bizunited.nebula.task.local.entity.DynamicTaskParamEntity;
import com.bizunited.nebula.task.local.entity.DynamicTaskSchedulerEntity;
import com.bizunited.nebula.task.local.repository.DynamicTaskParamRepository;
import com.bizunited.nebula.task.local.repository.DynamicTaskSchedulerRepository;
import com.bizunited.nebula.task.local.repository.DynamicTaskTemporaryParamRepository;
import com.bizunited.nebula.task.local.service.DynamicTaskTemporaryParamService;
import com.bizunited.nebula.task.local.service.internal.task.DynamicTaskOperation;
import com.bizunited.nebula.task.local.service.internal.task.DynamicTaskOperationCreateTask;
import com.bizunited.nebula.task.local.service.internal.task.DynamicTaskOperationFindTask;
import com.bizunited.nebula.task.local.service.internal.task.DynamicTaskOperationUpdateTask;
import com.bizunited.nebula.task.local.service.scheduler.DynamicShardingActivateTask;
import com.bizunited.nebula.task.service.DynamicTaskParamVoService;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerVoService;
import com.bizunited.nebula.task.service.strategy.DynamicTaskOperatorConverter;
import com.bizunited.nebula.task.vo.DynamicTaskParamVo;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="dynamicTaskSchedulerServiceImpl")
public class DynamicTaskSchedulerServiceImpl
implements DynamicTaskSchedulerVoService {
    @Autowired
    @Qualifier(value="platform_dynamicTaskScheduler")
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private DynamicTaskProperties dynamicTaskProperties;
    @Autowired
    private DynamicTaskParamVoService dynamicTaskParamVoService;
    @Autowired
    private DynamicTaskSchedulerRepository dynamicTaskSchedulerRepository;
    @Autowired
    private DynamicTaskParamRepository dynamicTaskParamRepository;
    @Autowired
    private DynamicTaskTemporaryParamRepository dynamicTaskTemporaryParamRepository;
    @Autowired
    private DynamicTaskTemporaryParamService dynamicTaskTemporaryParamService;
    @Autowired
    @Qualifier(value="platform_dTaskOperationThreadExecutor")
    private ThreadPoolExecutor dynamicTaskOperationThreadExecutor;
    @Autowired
    @Lazy
    private List<DynamicTaskOperatorConverter> dynamicTaskOperatorConverters;
    private static Map<String, ScheduledFuture<?>> taskMapping = Maps.newConcurrentMap();
    private static final String _TASK_GEN_PREFIX = "_NEBULA_TASK_REPEAT";
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTaskSchedulerServiceImpl.class);

    @Transactional
    public void loading(String applicationName, String appCode) {
        Set<DynamicTaskSchedulerEntity> rightNowOnceTasks;
        Set<DynamicTaskSchedulerEntity> validityTimeDynamicTasks;
        Set<DynamicTaskSchedulerEntity> requestStopInvalidDynamicTasks;
        Sets.SetView mustStopTaskCodes;
        Sets.SetView mustStartTaskCodes;
        Set<DynamicTaskSchedulerEntity> dbWorkingStatusesDynamicTasks = this.dynamicTaskSchedulerRepository.findByTstatusAndWorkingStatusAndApplicationNameAndAppCode(1, new int[]{0, 1, 2, 4}, applicationName, appCode);
        LOGGER.debug("\u672c\u6b21\u83b7\u53d6\u5230\u9700\u8981\u8fdb\u884c\u8fd0\u884c\u72b6\u6001\u540c\u6b65\u7684\u6570\u636e\u4e00\u5171 {} \u6761", (Object)dbWorkingStatusesDynamicTasks.size());
        int workingStatus = 2;
        Date now = new Date();
        Set<Object> dbDynamicTasks = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(dbWorkingStatusesDynamicTasks)) {
            dbDynamicTasks = dbWorkingStatusesDynamicTasks.stream().filter(item -> item.getWorkingStatus() == 2).collect(Collectors.toSet());
        }
        if (!CollectionUtils.isEmpty((Collection)dbDynamicTasks)) {
            dbDynamicTasks = dbDynamicTasks.stream().filter(item -> DynamicTaskSchedulerServiceImpl.validateValidity(item, now)).collect(Collectors.toSet());
        }
        Set dbDynamicTaskCodes = dbDynamicTasks.stream().map(item -> StringUtils.join((Object[])new String[]{applicationName, "_", appCode, "_", item.getTaskCode()})).collect(Collectors.toSet());
        LOGGER.debug("\u6b63\u5f0f\u7b5b\u9009\u51fa\u6570\u636e\u5e93\u4e2d\u72b6\u6001\u6b63\u786e\u7684\u201c\u5df2\u8fd0\u884c\u201d\u4efb\u52a1\u4e00\u5171 {} \u6761", (Object)dbDynamicTasks.size());
        Set<Object> currentDynamicTaskCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(taskMapping)) {
            String matchKey = StringUtils.join((Object[])new String[]{applicationName, "_", appCode, "_"});
            currentDynamicTaskCodes = taskMapping.keySet().stream().filter(item -> StringUtils.indexOf((CharSequence)item, (CharSequence)matchKey) == 0).collect(Collectors.toSet());
        }
        if (!CollectionUtils.isEmpty((Collection)(mustStartTaskCodes = Sets.difference(dbDynamicTaskCodes, (Set)currentDynamicTaskCodes)))) {
            LOGGER.debug("\u8bd5\u56fe\u542f\u52a8\u6570\u636e\u5e93\u4e2d\u6807\u8bc6\u4e3a\u201c\u5df2\u8fd0\u884c\u201d\uff0c\u4f46\u5b9e\u9645\u5e76\u6ca1\u6709\u5728\u8be5\u8282\u70b9\u8fd0\u884c\u7684\u4efb\u52a1\u4e00\u5171 {} \u6761", (Object)mustStartTaskCodes.size());
            Set<DynamicTaskSchedulerEntity> mustStartTasks = dbDynamicTasks.stream().filter(arg_0 -> DynamicTaskSchedulerServiceImpl.lambda$loading$4((Set)mustStartTaskCodes, arg_0)).collect(Collectors.toSet());
            this.startupTasks(applicationName, appCode, mustStartTasks);
        }
        if (!CollectionUtils.isEmpty((Collection)(mustStopTaskCodes = Sets.difference((Set)currentDynamicTaskCodes, dbDynamicTaskCodes)))) {
            Set<DynamicTaskSchedulerEntity> mustStopTasks = dbDynamicTasks.stream().filter(arg_0 -> DynamicTaskSchedulerServiceImpl.lambda$loading$5((Set)mustStopTaskCodes, arg_0)).collect(Collectors.toSet());
            this.stopTasks(applicationName, appCode, mustStopTasks);
        }
        boolean workingStartupStatus = false;
        Set<Object> requestStartupDynamicTasks = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(dbWorkingStatusesDynamicTasks)) {
            requestStartupDynamicTasks = dbWorkingStatusesDynamicTasks.stream().filter(item -> item.getWorkingStatus() == 0).collect(Collectors.toSet());
        }
        if (!CollectionUtils.isEmpty((Collection)requestStartupDynamicTasks)) {
            requestStartupDynamicTasks = requestStartupDynamicTasks.stream().filter(item -> DynamicTaskSchedulerServiceImpl.validateValidity(item, now)).collect(Collectors.toSet());
            LOGGER.debug("\u8bd5\u56fe\u542f\u52a8\u6570\u636e\u5e93\u4e2d\u6807\u8bc6\u4e3a\u201c\u8981\u6c42\u8fd0\u884c\u201d\uff0c\u7684\u4efb\u52a1\u4e00\u5171 {} \u6761", (Object)requestStartupDynamicTasks.size());
            this.startupTasks(applicationName, appCode, requestStartupDynamicTasks);
        }
        boolean workingStopStatus = true;
        HashSet requestStopDynamicTasks = Sets.newHashSet();
        Set<Object> requestStopEffectiveDynamicTasks = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(dbWorkingStatusesDynamicTasks)) {
            requestStopEffectiveDynamicTasks = dbWorkingStatusesDynamicTasks.stream().filter(item -> item.getWorkingStatus() == 1).collect(Collectors.toSet());
        }
        if (!CollectionUtils.isEmpty((Collection)requestStopEffectiveDynamicTasks)) {
            requestStopDynamicTasks.addAll(requestStopEffectiveDynamicTasks);
        }
        if (!CollectionUtils.isEmpty(requestStopInvalidDynamicTasks = this.dynamicTaskSchedulerRepository.findByTstatusAndApplicationNameAndAppCode(0, applicationName, appCode))) {
            requestStopDynamicTasks.addAll(requestStopInvalidDynamicTasks);
        }
        if (!CollectionUtils.isEmpty(validityTimeDynamicTasks = this.dynamicTaskSchedulerRepository.findByValidityTimeAndApplicationNameAndAppCode(now, applicationName, appCode))) {
            requestStopDynamicTasks.addAll(validityTimeDynamicTasks);
        }
        if (!CollectionUtils.isEmpty((Collection)requestStopDynamicTasks)) {
            LOGGER.debug("\u8bd5\u56fe\u505c\u6b62\u201c\u5df2\u8fc7\u671f\u201d\u3001\u201c\u5df2\u5931\u6548\u201d\u3001\u201c\u8981\u6c42\u505c\u6b62\u201d\uff0c\u7684\u4efb\u52a1\u4e00\u5171 {} \u6761", (Object)requestStopDynamicTasks.size());
            this.stopTasks(applicationName, appCode, requestStopDynamicTasks);
        }
        int workingRestartStatus = 4;
        Set<DynamicTaskSchedulerEntity> requestRestartupDynamicTasks = null;
        if (!CollectionUtils.isEmpty(dbWorkingStatusesDynamicTasks)) {
            requestRestartupDynamicTasks = dbWorkingStatusesDynamicTasks.stream().filter(item -> item.getWorkingStatus() == 4).collect(Collectors.toSet());
        }
        if (!CollectionUtils.isEmpty(requestRestartupDynamicTasks)) {
            this.restartupTasks(applicationName, appCode, requestRestartupDynamicTasks);
        }
        if (!CollectionUtils.isEmpty(rightNowOnceTasks = this.dynamicTaskSchedulerRepository.findRightNowByApplicationNameAndAppCode(applicationName, appCode))) {
            this.startupTasksRightNowOnce(applicationName, appCode, rightNowOnceTasks);
        }
    }

    private static boolean validateValidity(DynamicTaskSchedulerEntity task, Date now) {
        boolean matched = true;
        if (task.getExecutePoint() != null && task.getExecutePoint().getTime() < now.getTime()) {
            matched = false;
        }
        if (task.getValidityTime() != null && task.getValidityTime().getTime() < now.getTime()) {
            matched = false;
        }
        if (!matched) {
            LOGGER.warn("\u52a8\u6001\u4efb\u52a1\uff1a{} | {} \uff0c\u5df2\u7ecf\u8fc7\u671f\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u201c\u91cd\u542f/\u6062\u590d/\u542f\u52a8\u201d\u8fc7\u7a0b\uff0c\u8bf7\u68c0\u67e5\u4efb\u52a1\u72b6\u6001\u3002", (Object)task.getTaskCode(), (Object)task.getTaskDesc());
        }
        return matched;
    }

    private void stopTasks(String applicationName, String appCode, Set<DynamicTaskSchedulerEntity> mustStopTasks) {
        Set<String> requireStopCodes;
        Set mustStopFullTaskCodes = mustStopTasks.stream().map(item -> StringUtils.join((Object[])new String[]{applicationName, "_", appCode, "_", item.getTaskCode()})).collect(Collectors.toSet());
        Set mustStopScheduledFutureKeys = taskMapping.keySet().stream().filter(item -> mustStopFullTaskCodes.contains(item)).collect(Collectors.toSet());
        Set realStopTasks = mustStopTasks.stream().filter(item -> mustStopScheduledFutureKeys.contains(StringUtils.join((Object[])new String[]{applicationName, "_", appCode, "_", item.getTaskCode()}))).collect(Collectors.toSet());
        HashSet realStopTaskCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(realStopTasks)) {
            for (DynamicTaskSchedulerEntity realStopTask : realStopTasks) {
                String fullTaskCode = StringUtils.join((Object[])new String[]{applicationName, "_", appCode, "_", realStopTask.getTaskCode()});
                ScheduledFuture<?> scheduledFuture = taskMapping.remove(fullTaskCode);
                try {
                    scheduledFuture.cancel(true);
                }
                catch (RuntimeException e) {
                    LOGGER.warn("===== \u52a8\u6001\u4efb\u52a1\uff1a{}:{}:{} \u505c\u6b62  ===== \u51fa\u73b0\u95ee\u9898 {} , \u8fd9\u53ef\u80fd\u662f\u4e00\u4e2a\u6b63\u5e38\u73b0\u8c61\uff08\u7531\u4e8e\u5e94\u7528\u8282\u70b9M/S\u5207\u6362\u5bfc\u81f4\uff09", new Object[]{applicationName, appCode, realStopTask.getTaskCode(), e.getMessage()});
                }
                LOGGER.info("===== \u52a8\u6001\u4efb\u52a1\uff1a{}:{}:{}[{}] \u505c\u6b62  ===== ", new Object[]{applicationName, appCode, realStopTask.getTaskCode(), realStopTask.getTaskDesc()});
                realStopTaskCodes.add(realStopTask.getTaskCode());
            }
        }
        if (!CollectionUtils.isEmpty(requireStopCodes = mustStopTasks.stream().map(DynamicTaskSchedulerEntity::getTaskCode).collect(Collectors.toSet()))) {
            this.dynamicTaskSchedulerRepository.updateStopedByTaskCodesAndApplicationNameAndAppCode(requireStopCodes.toArray(new String[0]), applicationName, appCode);
        }
    }

    private void startupTasksRightNowOnce(String applicationName, String appCode, Set<DynamicTaskSchedulerEntity> rightNowOnceTasks) {
        if (CollectionUtils.isEmpty(rightNowOnceTasks)) {
            return;
        }
        for (DynamicTaskSchedulerEntity rightNowOnceTask : rightNowOnceTasks) {
            DynamicTaskSchedulerVo taskVo = (DynamicTaskSchedulerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)rightNowOnceTask, DynamicTaskSchedulerVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            String taskId = rightNowOnceTask.getId();
            List dynamicTaskTemporaryParams = this.dynamicTaskParamVoService.findTemporaryByDynamicTask(taskId);
            if (!CollectionUtils.isEmpty((Collection)dynamicTaskTemporaryParams)) {
                taskVo.setParams(dynamicTaskTemporaryParams);
            } else {
                List dynamicTaskParams = this.dynamicTaskParamVoService.findByDynamicTask(taskId);
                if (!CollectionUtils.isEmpty((Collection)dynamicTaskParams)) {
                    taskVo.setParams(dynamicTaskParams);
                }
            }
            taskVo.setTaskType(Integer.valueOf(1));
            Date executePoint = new Date();
            taskVo.setExecutePoint(executePoint);
            this.schedule(taskVo.getTaskType(), null, executePoint, taskVo, applicationName, appCode);
            this.dynamicTaskTemporaryParamRepository.deleteByDynamicTask(taskId);
        }
        String[] taskCodes = (String[])rightNowOnceTasks.stream().map(DynamicTaskSchedulerEntity::getTaskCode).toArray(String[]::new);
        this.dynamicTaskSchedulerRepository.updateNonRightNowByTaskCodesAndApplicationNameAndAppCode(taskCodes, applicationName, appCode);
    }

    private void startupTasks(String applicationName, String appCode, Set<DynamicTaskSchedulerEntity> mustStartTasks) {
        ArrayList<String> invalidTaskCodes = new ArrayList<String>(100);
        ArrayList<String> runningTaskCodes = new ArrayList<String>(100);
        for (DynamicTaskSchedulerEntity mustStartTask : mustStartTasks) {
            DynamicTaskSchedulerVo taskVo = (DynamicTaskSchedulerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)mustStartTask, DynamicTaskSchedulerVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            String taskId = mustStartTask.getId();
            List dynamicTaskParams = this.dynamicTaskParamVoService.findByDynamicTask(taskId);
            if (!CollectionUtils.isEmpty((Collection)dynamicTaskParams)) {
                taskVo.setParams(dynamicTaskParams);
            }
            String key = StringUtils.join((Object[])new String[]{applicationName, "_", appCode, "_", mustStartTask.getTaskCode()});
            String targetKey = "";
            if (StringUtils.indexOf((CharSequence)key, (CharSequence)"$$") != -1) {
                targetKey = StringUtils.substringBefore((String)key, (String)"$$");
                targetKey = StringUtils.join((Object[])new String[]{targetKey, ".", StringUtils.substringAfterLast((String)key, (String)".")});
            } else {
                targetKey = key;
            }
            Set<String> alreadyKeys = taskMapping.keySet();
            boolean repeatKey = false;
            String currentAlreadyKey = "";
            String fullKey = "";
            Iterator<String> iterator = alreadyKeys.iterator();
            while (iterator.hasNext()) {
                String alreadyKey;
                fullKey = alreadyKey = iterator.next();
                if (StringUtils.indexOf((CharSequence)alreadyKey, (CharSequence)"$$") != -1) {
                    currentAlreadyKey = StringUtils.substringBefore((String)alreadyKey, (String)"$$");
                    currentAlreadyKey = StringUtils.join((Object[])new String[]{currentAlreadyKey, ".", StringUtils.substringAfterLast((String)alreadyKey, (String)".")});
                } else {
                    currentAlreadyKey = alreadyKey;
                }
                if (!StringUtils.equals((CharSequence)targetKey, (CharSequence)currentAlreadyKey)) continue;
                repeatKey = true;
                break;
            }
            if (repeatKey && taskMapping.get(fullKey) != null) {
                LOGGER.debug("===== \u52a8\u6001\u4efb\u52a1\uff1a{}:{}:{} \u5df2\u7ecf\u5b58\u5728\u4e8e\u5f53\u524d\u8fdb\u7a0b\u7684\u4efb\u52a1\u7ba1\u7406\u4e2d \uff0c\u5c06\u5bf9\u5f53\u524d\u4efb\u52a1\u8fdb\u884c\u5237\u65b0\u5904\u7406 =====", new Object[]{applicationName, appCode, mustStartTask.getTaskCode()});
                try {
                    taskMapping.remove(fullKey).cancel(true);
                }
                catch (RuntimeException e) {
                    LOGGER.warn("===== \u52a8\u6001\u4efb\u52a1\uff1a{}:{}:{} \u5237\u65b0 ===== \u51fa\u73b0\u95ee\u9898 {} , \u8fd9\u53ef\u80fd\u662f\u4e00\u4e2a\u6b63\u5e38\u73b0\u8c61\uff08\u7531\u4e8e\u5e94\u7528\u8282\u70b9M/S\u5207\u6362\u5bfc\u81f4\uff09", new Object[]{applicationName, appCode, mustStartTask.getTaskCode(), e.getMessage()});
                }
            }
            if (mustStartTask.getTaskType() == 1) {
                boolean hasRunning = DynamicTaskSchedulerServiceImpl.validateValidity(mustStartTask, new Date());
                if (!hasRunning) {
                    invalidTaskCodes.add(mustStartTask.getTaskCode());
                    continue;
                }
                Date executePoint = mustStartTask.getExecutePoint();
                String cornExpression = mustStartTask.getExecuteExpression();
                Validate.isTrue((executePoint != null || !StringUtils.isBlank((CharSequence)cornExpression) ? 1 : 0) != 0, (String)"\u6307\u5b9a\u4efb\u52a1[%s]\u662f\u4e00\u4e2a\u4e00\u6b21\u6027\u4efb\u52a1\uff0c\u4f46\u662f\u5374\u6ca1\u6709\u6307\u5b9a\u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{mustStartTask.getTaskCode()});
                ScheduledFuture<?> scheduledFuture = this.schedule(mustStartTask.getTaskType(), cornExpression, executePoint, taskVo, applicationName, appCode);
                if (scheduledFuture != null) {
                    taskMapping.put(key, scheduledFuture);
                }
                runningTaskCodes.add(mustStartTask.getTaskCode());
                continue;
            }
            if (mustStartTask.getTaskType() == 2) {
                String cornExpression = mustStartTask.getExecuteExpression();
                Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)cornExpression), (String)"\u6307\u5b9a\u52a8\u6001\u4efb\u52a1[%s]\u662f\u4e00\u4e2a\u5468\u671f\u6027\u4efb\u52a1\uff0c\u4f46\u662f\u5374\u6ca1\u6709\u6307\u5b9a\u6709\u6548\u7684corn\u8868\u8fbe\u5f0f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{mustStartTask.getTaskCode()});
                ScheduledFuture<?> scheduledFuture = this.schedule(mustStartTask.getTaskType(), cornExpression, null, taskVo, applicationName, appCode);
                if (scheduledFuture != null) {
                    taskMapping.put(key, scheduledFuture);
                }
                runningTaskCodes.add(mustStartTask.getTaskCode());
                continue;
            }
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u52a8\u6001\u4efb\u52a1\u7c7b\u578b[" + mustStartTask.getTaskCode() + "]\uff0c\u8bf7\u68c0\u67e5");
        }
        if (!invalidTaskCodes.isEmpty()) {
            this.dynamicTaskSchedulerRepository.updateInvalidByTaskCodesAndApplicationNameAndAppCode(invalidTaskCodes.toArray(new String[0]), applicationName, appCode);
        }
        if (!runningTaskCodes.isEmpty()) {
            this.dynamicTaskSchedulerRepository.updateRunningByTaskCodesAndApplicationNameAndAppCode(runningTaskCodes.toArray(new String[0]), applicationName, appCode);
        }
    }

    private ScheduledFuture<?> schedule(Integer taskType, String cornExpression, Date executePoint, DynamicTaskSchedulerVo taskVo, String applicationName, String appCode) {
        ScheduledFuture scheduledFuture = null;
        try {
            Boolean enableSharding = this.dynamicTaskProperties.getEnableSharding();
            Runnable runnable = Boolean.TRUE.equals(enableSharding) ? (Runnable)this.applicationContext.getBean(DynamicShardingActivateTask.class, new Object[]{taskVo}) : (Runnable)this.applicationContext.getBean("_DynamicTask", new Object[]{taskVo});
            if (taskType == 1) {
                if (executePoint != null) {
                    scheduledFuture = this.threadPoolTaskScheduler.schedule(runnable, executePoint);
                } else {
                    CronTrigger cronTrigger = new CronTrigger(cornExpression);
                    scheduledFuture = this.threadPoolTaskScheduler.schedule(runnable, (Trigger)cronTrigger);
                }
                LOGGER.debug("===== \u4e00\u6b21\u6027\u4efb\u52a1\uff1a{}:{}:{}[{}] \u542f\u52a8 ===== ", new Object[]{applicationName, appCode, taskVo.getTaskCode(), taskVo.getTaskDesc()});
            } else {
                CronTrigger cronTrigger = new CronTrigger(cornExpression);
                scheduledFuture = this.threadPoolTaskScheduler.schedule(runnable, (Trigger)cronTrigger);
                LOGGER.debug("===== \u5468\u671f\u6027\u4efb\u52a1\uff1a{}:{}:{}[{}] \u542f\u52a8 ===== ", new Object[]{applicationName, appCode, taskVo.getTaskCode(), taskVo.getTaskDesc()});
            }
        }
        catch (RuntimeException e) {
            LOGGER.warn(" ===== \u7cfb\u7edf\u8bd5\u56fe\u542f\u52a8\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\uff1a {}:{}:{}[{}] ===== \uff0c \u4f46\u542f\u52a8\u5931\u8d25\uff0c\u5f88\u53ef\u80fd\u662f\u56e0\u4e3a\u5b9a\u65f6\u4efb\u52a1\u7684cron\u8868\u8fbe\u5f0f\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u8fd9\u6761\u4efb\u52a1\u7684\u8bbe\u5b9a\u3002");
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return scheduledFuture;
    }

    private void restartupTasks(String applicationName, String appCode, Set<DynamicTaskSchedulerEntity> mustRestartTasks) {
        if (CollectionUtils.isEmpty(mustRestartTasks)) {
            return;
        }
        for (DynamicTaskSchedulerEntity mustRestartTask : mustRestartTasks) {
            Validate.isTrue((mustRestartTask.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u4efb\u52a1\u91cd\u542f\u65f6\uff0c\u53d1\u73b0\u4efb\u52a1%s:%s:%s\u72b6\u6001\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{applicationName, appCode, mustRestartTask.getTaskCode()});
        }
        Set mustRestartFullTaskCodes = mustRestartTasks.stream().map(item -> StringUtils.join((Object[])new String[]{item.getApplicationName(), "_", item.getAppCode(), "_", item.getTaskCode()})).collect(Collectors.toSet());
        Set<String> mustRestartTaskCodes = mustRestartTasks.stream().map(DynamicTaskSchedulerEntity::getTaskCode).collect(Collectors.toSet());
        Sets.SetView mustRealStopTaskCodes = Sets.intersection(taskMapping.keySet(), mustRestartFullTaskCodes);
        if (!CollectionUtils.isEmpty((Collection)mustRealStopTaskCodes)) {
            for (String mustRealStopTaskCode : mustRealStopTaskCodes) {
                LOGGER.debug("===== \u5468\u671f\u6027\u4efb\u52a1\uff1a{} \u51c6\u5907\u91cd\u542f ===== ", (Object)mustRealStopTaskCode);
                taskMapping.remove(mustRealStopTaskCode).cancel(false);
            }
        }
        this.dynamicTaskSchedulerRepository.updateReadyRunningByTaskCodesAndApplicationNameAndAppCode(mustRestartTaskCodes.toArray(new String[0]), applicationName, appCode);
        this.dynamicTaskParamRepository.flush();
        int[] workingStatuses = new int[]{0};
        Set<DynamicTaskSchedulerEntity> requestStartupDynamicTasks = this.dynamicTaskSchedulerRepository.findByTstatusAndWorkingStatusAndApplicationNameAndAppCode(1, workingStatuses, applicationName, appCode);
        if (!CollectionUtils.isEmpty(requestStartupDynamicTasks)) {
            this.startupTasks(applicationName, appCode, requestStartupDynamicTasks);
        }
    }

    @Transactional
    public void startRightNowOnce(String[] taskCodes) {
        Validate.notNull((Object)taskCodes, (String)"\u8981\u6c42\u4efb\u52a1\u7acb\u5373\u8fd0\u884c\u4e00\u6b21\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u7684\u7f16\u53f7code!!", (Object[])new Object[0]);
        Validate.isTrue((taskCodes.length > 0 ? 1 : 0) != 0, (String)"\u8981\u6c42\u4efb\u52a1\u7acb\u5373\u8fd0\u884c\u4e00\u6b21\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u7684\u7f16\u53f7code!!", (Object[])new Object[0]);
        String appCode = TenantUtils.getTenantCode();
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        LOGGER.debug("\u4ee5\u4e0b\u52a8\u6001\u4efb\u52a1\u6b63\u8981\u8fdb\u884c\u201c\u7acb\u5373\u6267\u884c\u201d\uff1atenantCode:[{}]; applicationName:[{}]; taskCodes:[{}];", new Object[]{appCode, applicationName, StringUtils.join((Object[])taskCodes, (String)",")});
        int affectedRows = this.dynamicTaskSchedulerRepository.updateRightNowByTaskCodesAndApplicationNameAndAppCode(taskCodes, applicationName, appCode);
        LOGGER.debug("\u6700\u7ec8\u53d7\u5f71\u54cd\u7684\u6267\u884c\u4efb\u52a1\u6570\u91cf\u4e3a: [{}]", (Object)affectedRows);
    }

    @Transactional
    public void startByRightNowDto(DynamicTaskRightNowDto dto) {
        String appCode = TenantUtils.getTenantCode();
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        LOGGER.debug("\u4ee5\u4e0b\u52a8\u6001\u4efb\u52a1\u6b63\u8981\u8fdb\u884c\u201c\u7acb\u5373\u6267\u884c\u201d\uff1atenantCode:[{}]; applicationName:[{}]; taskCodes:[{}]; params:[{}];", new Object[]{appCode, applicationName, dto.getTaskCode(), JSON.toJSONString((Object)dto.getParams())});
        DynamicTaskSchedulerEntity taskSchedulerEntity = this.validationRightNowDynamicTask(dto);
        int affectedRows = this.dynamicTaskSchedulerRepository.updateRightNowByTaskCodesAndApplicationNameAndAppCode(new String[]{dto.getTaskCode()}, applicationName, appCode);
        this.dynamicTaskTemporaryParamService.update(taskSchedulerEntity, dto.getParams());
        LOGGER.debug("\u6700\u7ec8\u53d7\u5f71\u54cd\u7684\u6267\u884c\u4efb\u52a1\u6570\u91cf\u4e3a: [{}]", (Object)affectedRows);
    }

    private DynamicTaskSchedulerEntity validationRightNowDynamicTask(DynamicTaskRightNowDto dto) {
        Validate.notNull((Object)dto, (String)"\u8981\u6c42\u4efb\u52a1\u7acb\u5373\u8fd0\u884c\u4e00\u6b21\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTaskCode(), (String)"\u8981\u6c42\u4efb\u52a1\u7acb\u5373\u8fd0\u884c\u4e00\u6b21\u65f6\uff0c\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        String appCode = TenantUtils.getTenantCode();
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        DynamicTaskSchedulerEntity taskSchedulerEntity = this.dynamicTaskSchedulerRepository.findByTaskCodeAndApplicationNameAndAppCode(dto.getTaskCode(), applicationName, appCode);
        Validate.notNull((Object)((Object)taskSchedulerEntity), (String)"\u5b9a\u65f6\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728!!", (Object[])new Object[0]);
        if (taskSchedulerEntity.getGenerateType() == 2) {
            List<DynamicTaskParamEntity> params = taskSchedulerEntity.getParams();
            if (!CollectionUtils.isEmpty(params)) {
                Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getParams()) ? 1 : 0) != 0, (String)"\u5b9a\u65f6\u4efb\u52a1\u4e3a\u6709\u53c2\u5b9a\u65f6\u4efb\u52a1,\u8bf7\u4f20\u9012\u53c2\u6570", (Object[])new Object[0]);
            } else {
                Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)dto.getParams()), (String)"\u5b9a\u65f6\u4efb\u52a1\u4e3a\u65e0\u53c2\u5b9a\u65f6\u4efb\u52a1,\u65e0\u6cd5\u4f20\u9012\u53c2\u6570", (Object[])new Object[0]);
            }
        } else {
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)dto.getParams()), (String)"\u53ea\u6709\u624b\u52a8\u521b\u5efa\u7684\u5b9a\u65f6\u4efb\u52a1\u53ef\u4ee5\u4fee\u6539\u6267\u884c\u53c2\u6570", (Object[])new Object[0]);
        }
        return taskSchedulerEntity;
    }

    @Transactional
    public void start(String[] taskCodes) {
        Validate.notNull((Object)taskCodes, (String)"\u8981\u6c42\u4efb\u52a1\u542f\u52a8\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u7684\u7f16\u53f7code!!", (Object[])new Object[0]);
        Validate.isTrue((taskCodes.length > 0 ? 1 : 0) != 0, (String)"\u8981\u6c42\u4efb\u52a1\u542f\u52a8\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u7684\u7f16\u53f7code!!", (Object[])new Object[0]);
        String appCode = TenantUtils.getTenantCode();
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        Set<DynamicTaskSchedulerEntity> dynamicTasks = this.dynamicTaskSchedulerRepository.findByTaskCodesAndApplicationNameAndAppCode(Lists.newArrayList((Object[])taskCodes), applicationName, appCode);
        Set<Object> dbDynamicStopedTaskCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(dynamicTasks)) {
            dbDynamicStopedTaskCodes = dynamicTasks.stream().filter(item -> item.getTstatus() == 1 && item.getWorkingStatus() == 3).map(DynamicTaskSchedulerEntity::getTaskCode).collect(Collectors.toSet());
        }
        Validate.isTrue((boolean)Sets.difference((Set)dbDynamicStopedTaskCodes, (Set)Sets.newHashSet((Object[])taskCodes)).isEmpty(), (String)"\u8981\u6c42\u4efb\u52a1\u542f\u52a8\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u4efb\u52a1\u7684\u72b6\u6001\u4e0d\u4e3a\u201c\u6709\u6548\u201d\u72b6\u6001\u6216\u8005\u4e0d\u4e3a\u201c\u5df2\u505c\u6b62\u201d\u72b6\u6001!!", (Object[])new Object[0]);
        dynamicTasks.forEach(entity -> Validate.isTrue((Objects.isNull(entity.getValidityTime()) || entity.getValidityTime().getTime() >= System.currentTimeMillis() ? 1 : 0) != 0, (String)"\u8981\u6c42\u4efb\u52a1\u542f\u52a8\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u4efb\u52a1\u5df2\u7ecf\u8fc7\u671f!!", (Object[])new Object[0]));
        this.dynamicTaskSchedulerRepository.updateReadyRunningByTaskCodesAndApplicationNameAndAppCode(taskCodes, applicationName, appCode);
    }

    @Transactional
    public void stop(String[] taskCodes) {
        Validate.notNull((Object)taskCodes, (String)"\u8981\u6c42\u4efb\u52a1\u505c\u6b62\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u7684\u7f16\u53f7code!!", (Object[])new Object[0]);
        Validate.isTrue((taskCodes.length > 0 ? 1 : 0) != 0, (String)"\u8981\u6c42\u4efb\u52a1\u505c\u6b62\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u7684\u7f16\u53f7code!!", (Object[])new Object[0]);
        String appCode = TenantUtils.getTenantCode();
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        Set<DynamicTaskSchedulerEntity> dynamicTasks = this.dynamicTaskSchedulerRepository.findByTaskCodesAndApplicationNameAndAppCode(Lists.newArrayList((Object[])taskCodes), applicationName, appCode);
        Set<Object> dbDynamicRequestStopedTaskCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(dynamicTasks)) {
            dbDynamicRequestStopedTaskCodes = dynamicTasks.stream().filter(item -> item.getWorkingStatus() == 2).map(DynamicTaskSchedulerEntity::getTaskCode).collect(Collectors.toSet());
        }
        Validate.isTrue((boolean)Sets.difference((Set)dbDynamicRequestStopedTaskCodes, (Set)Sets.newHashSet((Object[])taskCodes)).isEmpty(), (String)"\u8981\u6c42\u4efb\u52a1\u505c\u6b62\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u4efb\u52a1\u7684\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u8fd0\u884c\u201d\u72b6\u6001!!", (Object[])new Object[0]);
        this.dynamicTaskSchedulerRepository.updateReadyStopByTaskCodesAndApplicationNameAndAppCode(taskCodes, applicationName, appCode);
    }

    public void unloading(String applicationName, String appCode) {
        Validate.isTrue((boolean)StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{applicationName, appCode}), (String)"\u9519\u8bef\u7684\u53c2\u6570\u6027\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String matchKey = StringUtils.join((Object[])new String[]{applicationName, "_", appCode, "_"});
        Set mustStopTasks = taskMapping.entrySet().stream().filter(item -> StringUtils.indexOf((CharSequence)((CharSequence)item.getKey()), (CharSequence)matchKey) == 0).map(Map.Entry::getValue).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(mustStopTasks)) {
            for (ScheduledFuture scheduledFuture : mustStopTasks) {
                scheduledFuture.cancel(true);
            }
        }
    }

    public String preModify() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode(_TASK_GEN_PREFIX, prefix, prefix, TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS));
        return prefix;
    }

    private void validationPrefix(String prefix) {
        block5: {
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u8ba2\u5355\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode(_TASK_GEN_PREFIX, prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u52a8\u6001\u4efb\u52a1\u7684\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode(_TASK_GEN_PREFIX, prefix, prefix, 1L);
                    break block5;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u8fdb\u884c\u52a8\u6001\u4efb\u52a1\u7684\u5199\u64cd\u4f5c!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
    }

    public DynamicTaskSchedulerVo create(DynamicTaskSchedulerVo task, String scriptContent) {
        Validate.isTrue((task.getInvokeType() != null && (task.getInvokeType() == 3 || task.getInvokeType() == 1) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u521b\u5efagroovy\u811a\u672c\u6027\u8d28\u6216\u8005\u5168\u52a8\u6001\u6027\u8d28\u7684\u4efb\u52a1", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)2L, (long)task.getTaskType().intValue(), (String)"\u5fc5\u987b\u4f20\u5165\u6b63\u786e\u7684taskType\u4fe1\u606f\uff081\uff1a\u4e00\u6b21\u6027\u4efb\u52a1\uff1b2\uff1a\u5468\u671f\u6027\u4efb\u52a1\uff09\uff0c\u8bf7\u68c0\u67e5!!");
        if (task.getTaskType() == 1) {
            task.setExecuteExpression(null);
            task.setExpressionDesc(task.getTaskDesc());
            Validate.notNull((Object)task.getExecutePoint(), (String)"\u5f53\u5efa\u7acb\u4e00\u6b21\u6027\u4efb\u52a1\u65f6\uff0c\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u6267\u884c\u65f6\u95f4\u70b9\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        } else {
            task.setExecutePoint(null);
            Validate.notBlank((CharSequence)task.getExecuteExpression(), (String)"\u5f53\u5efa\u7acb\u5468\u671f\u6027\u65f6\uff0c\u5468\u671f\u6027\u503c\u8bbe\u5b9a\u5185\u5bb9\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        }
        if (task.getValidityTime() != null) {
            Validate.isTrue((new Date().getTime() < task.getValidityTime().getTime() ? 1 : 0) != 0, (String)"\u4efb\u52a1\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
        }
        if (task.getInvokeType() == 3) {
            this.validationManualDynamicTask(task, task.getParams());
            task.setScriptName("");
            task.setGenerateType(Integer.valueOf(2));
        }
        return this.createIgnorePrefix(task, scriptContent);
    }

    private void validationManualDynamicTask(DynamicTaskSchedulerVo task, List<DynamicTaskParamVo> params) {
        Method method;
        Object bean;
        Validate.notBlank((CharSequence)task.getInvokeBeanName(), (String)"spring bean\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)task.getInvokeMethod(), (String)"method\u65b9\u6cd5\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            bean = this.applicationContext.getBean(task.getInvokeBeanName());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Spring Ioc\u5bb9\u5668\u4e2d\u65e0\u6cd5\u627e\u5230\u540d\u79f0\u4e3a%s\u7684bean", task.getInvokeBeanName()));
        }
        Validate.notNull((Object)bean, (String)"Spring Ioc\u5bb9\u5668\u4e2d\u65e0\u6cd5\u627e\u5230\u540d\u79f0\u4e3a%s\u7684bean", (Object[])new Object[]{task.getInvokeBeanName()});
        Class<?> beanClass = bean.getClass();
        if (CollectionUtils.isEmpty(params)) {
            try {
                method = beanClass.getMethod(task.getInvokeMethod(), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(String.format("\u65e0\u6cd5\u5728bean[%s]\u4e2d\u627e\u5230\u540d\u4e3a[%s]\u7684\u65e0\u53c2method\u65b9\u6cd5", task.getInvokeBeanName(), task.getInvokeMethod()));
            }
            Validate.notNull((Object)method, (String)"\u65e0\u6cd5\u5728bean[%s]\u4e2d\u627e\u5230\u540d\u4e3a[%s]\u7684\u65e0\u53c2method\u65b9\u6cd5", (Object[])new Object[]{task.getInvokeBeanName(), task.getInvokeMethod()});
        } else {
            Validate.isTrue((params.size() == 1 ? 1 : 0) != 0, (String)"\u914d\u7f6e\u6709\u5165\u53c2\u7684\u65b9\u6cd5,\u53ea\u652f\u63011\u4e2aString\u5165\u53c2", (Object[])new Object[0]);
            DynamicTaskParamVo paramVo = params.get(0);
            Validate.notNull((Object)paramVo.getParamValue(), (String)"\u914d\u7f6e\u6709\u5165\u53c2\u7684\u65b9\u6cd5,\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)paramVo.getParamType(), (String)"\u914d\u7f6e\u6709\u5165\u53c2\u7684\u65b9\u6cd5,\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)String.class.equals((Object)paramVo.getParamType()), (String)"\u914d\u7f6e\u6709\u5165\u53c2\u7684\u65b9\u6cd5,\u5165\u53c2\u7c7b\u578b\u53ea\u80fd\u662fString", (Object[])new Object[0]);
            Validate.isTrue((boolean)paramVo.getParamType().equals(paramVo.getParamValue().getClass()), (String)"\u914d\u7f6e\u6709\u5165\u53c2\u7684\u65b9\u6cd5,\u5165\u53c2\u7c7b\u578b\u548c\u5165\u53c2\u503c\u7c7b\u578b\u4e0d\u5339\u914d", (Object[])new Object[0]);
            paramVo.setParamIndex(Integer.valueOf(0));
            try {
                method = beanClass.getMethod(task.getInvokeMethod(), String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(String.format("\u65e0\u6cd5\u5728bean[%s]\u4e2d\u627e\u5230\u540d\u4e3a[%s]\u4e14\u53ea\u6709\u4e00\u4e2aString\u7c7b\u578b\u5165\u53c2\u7684method\u65b9\u6cd5", task.getInvokeBeanName(), task.getInvokeMethod()));
            }
            Validate.notNull((Object)method, (String)"\u65e0\u6cd5\u5728bean[%s]\u4e2d\u627e\u5230\u540d\u4e3a[%s]\u4e14\u53ea\u6709\u4e00\u4e2aString\u7c7b\u578b\u5165\u53c2\u7684method\u65b9\u6cd5", (Object[])new Object[]{task.getInvokeBeanName(), task.getInvokeMethod()});
        }
        DynamicTaskService dynamicTaskService = (DynamicTaskService)AnnotationUtils.findAnnotation((Method)method, DynamicTaskService.class);
        Validate.isTrue((boolean)Objects.isNull(dynamicTaskService), (String)"\u914d\u7f6e\u7684\u65b9\u6cd5\u4e0d\u80fd\u662f\u5df2\u7ecf\u5b58\u5728DynamicTaskService\u5b9a\u65f6\u4efb\u52a1\u6ce8\u89e3\u7684\u65b9\u6cd5", (Object[])new Object[0]);
    }

    public DynamicTaskSchedulerVo createIgnorePrefix(DynamicTaskSchedulerVo task, String scriptContent) {
        String tenantCode = task.getAppCode();
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
            task.setAppCode(tenantCode);
        }
        DynamicTaskOperationCreateTask dynamicTaskOperationCreateTask = (DynamicTaskOperationCreateTask)this.applicationContext.getBean(DynamicTaskOperationCreateTask.class, new Object[]{task, scriptContent});
        Future<Object> future = this.dynamicTaskOperationThreadExecutor.submit(dynamicTaskOperationCreateTask);
        try {
            DynamicTaskSchedulerVo result = (DynamicTaskSchedulerVo)future.get();
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public DynamicTaskSchedulerVo createIgnorePrefix(String taskCode, String invokeBeanName, String method, String executeExpression, Date validityTime, String taskDesc, Object ... args) {
        String tenantCode = TenantUtils.getTenantCode();
        DynamicTaskOperationCreateTask dynamicTaskOperationCreateTask = (DynamicTaskOperationCreateTask)this.applicationContext.getBean(DynamicTaskOperationCreateTask.class, new Object[]{tenantCode, taskCode, invokeBeanName, method, executeExpression, validityTime, taskDesc, args});
        Future<Object> future = this.dynamicTaskOperationThreadExecutor.submit(dynamicTaskOperationCreateTask);
        try {
            DynamicTaskSchedulerVo result = (DynamicTaskSchedulerVo)future.get();
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public DynamicTaskSchedulerVo createIgnorePrefix(String taskCode, String invokeBeanName, String method, Integer taskType, String executeExpression, Date executePoint, Date validityTime, String taskDesc, Object ... args) {
        String tenantCode = TenantUtils.getTenantCode();
        DynamicTaskOperationCreateTask dynamicTaskOperationCreateTask = (DynamicTaskOperationCreateTask)this.applicationContext.getBean(DynamicTaskOperationCreateTask.class, new Object[]{tenantCode, taskCode, invokeBeanName, method, taskType, executeExpression, executePoint, validityTime, taskDesc, args});
        Future<Object> future = this.dynamicTaskOperationThreadExecutor.submit(dynamicTaskOperationCreateTask);
        try {
            DynamicTaskSchedulerVo result = (DynamicTaskSchedulerVo)future.get();
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public DynamicTaskSchedulerVo update(DynamicTaskSchedulerVo task, String scriptContent) {
        this.validationPrefix(task.getPrefix());
        DynamicTaskSchedulerEntity schedulerEntity = this.dynamicTaskSchedulerRepository.findById(task.getId()).orElse(null);
        Validate.notNull((Object)((Object)schedulerEntity), (String)"\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((schedulerEntity.getGenerateType() == 2 ? 1 : 0) != 0, (String)"\u53ea\u80fd\u4fee\u6539\u624b\u52a8\u521b\u5efa\u7684\u5b9a\u65f6\u4efb\u52a1", (Object[])new Object[0]);
        Validate.isTrue((schedulerEntity.getInvokeType() != null && (schedulerEntity.getInvokeType() == 3 || schedulerEntity.getInvokeType() == 1) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u4fee\u6539groovy\u811a\u672c\u6027\u8d28\u6216\u8005\u5168\u52a8\u6001\u6027\u8d28\u7684\u4efb\u52a1", (Object[])new Object[0]);
        if (schedulerEntity.getTaskType() == 1) {
            task.setExecuteExpression(null);
            task.setExpressionDesc(task.getTaskDesc());
            Validate.notNull((Object)task.getExecutePoint(), (String)"\u5728\u8fdb\u884c\u52a8\u6001\u4efb\u52a1\u4fee\u6539\u65f6\uff0c\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u6267\u884c\u65f6\u95f4\u70b9\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        } else if (schedulerEntity.getTaskType() == 2) {
            task.setExecutePoint(null);
            Validate.notBlank((CharSequence)task.getExecuteExpression(), (String)"\u5728\u8fdb\u884c\u52a8\u6001\u4efb\u52a1\u4fee\u6539\u65f6\uff0c\u4efb\u52a1\u6267\u884c\u5468\u671f\u8868\u8fbe\u5f0f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        }
        if (task.getValidityTime() != null) {
            Validate.isTrue((new Date().getTime() < task.getValidityTime().getTime() ? 1 : 0) != 0, (String)"\u4efb\u52a1\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
        }
        if (task.getInvokeType() == 3) {
            List params = task.getParams();
            this.validationManualDynamicTask(task, params);
        }
        return this.updateIgnorePrefix(task, scriptContent);
    }

    public DynamicTaskSchedulerVo updateIgnorePrefix(String taskCode, String executeExpression, Date validityTime, String taskDesc, Object ... args) {
        String tenantCode = TenantUtils.getTenantCode();
        DynamicTaskOperationUpdateTask dynamicTaskOperationUpdateTask = (DynamicTaskOperationUpdateTask)this.applicationContext.getBean(DynamicTaskOperationUpdateTask.class, new Object[]{tenantCode, taskCode, executeExpression, validityTime, taskDesc, args});
        Future<Object> future = this.dynamicTaskOperationThreadExecutor.submit(dynamicTaskOperationUpdateTask);
        try {
            DynamicTaskSchedulerVo result = (DynamicTaskSchedulerVo)future.get();
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public DynamicTaskSchedulerVo updateIgnorePrefix(DynamicTaskSchedulerVo task, String scriptContent) {
        String tenantCode = task.getAppCode();
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
            task.setAppCode(tenantCode);
        }
        DynamicTaskOperationUpdateTask dynamicTaskOperationUpdateTask = (DynamicTaskOperationUpdateTask)this.applicationContext.getBean(DynamicTaskOperationUpdateTask.class, new Object[]{task, scriptContent});
        Future<Object> future = this.dynamicTaskOperationThreadExecutor.submit(dynamicTaskOperationUpdateTask);
        try {
            DynamicTaskSchedulerVo result = (DynamicTaskSchedulerVo)future.get();
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public void save(List<DynamicTaskSchedulerVo> tasks, String prefix, Integer invokeType, String applicationName, String appCode) {
        this.validationPrefix(prefix);
        this.saveIgnorePrefix(tasks, invokeType, applicationName, appCode);
    }

    public void saveIgnorePrefix(List<DynamicTaskSchedulerVo> tasks, Integer invokeType, String applicationName, String appCode) {
        DynamicTaskOperationCreateTask dynamicTaskOperationCreateTask = (DynamicTaskOperationCreateTask)this.applicationContext.getBean(DynamicTaskOperationCreateTask.class, new Object[]{tasks, invokeType, applicationName, appCode});
        Future<Object> future = this.dynamicTaskOperationThreadExecutor.submit(dynamicTaskOperationCreateTask);
        try {
            future.get();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public void invalid(String[] taskCodes) {
        String tenantCode = TenantUtils.getTenantCode();
        DynamicTaskOperationUpdateTask dynamicTaskOperationUpdateTask = (DynamicTaskOperationUpdateTask)this.applicationContext.getBean(DynamicTaskOperationUpdateTask.class, new Object[]{tenantCode, taskCodes, DynamicTaskOperation.invalid});
        Future<Object> future = this.dynamicTaskOperationThreadExecutor.submit(dynamicTaskOperationUpdateTask);
        try {
            future.get();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    @Transactional
    public void effective(String[] taskCodes) {
        String tenantCode = TenantUtils.getTenantCode();
        DynamicTaskOperationUpdateTask dynamicTaskOperationUpdateTask = (DynamicTaskOperationUpdateTask)this.applicationContext.getBean(DynamicTaskOperationUpdateTask.class, new Object[]{tenantCode, taskCodes, DynamicTaskOperation.effective});
        Future<Object> future = this.dynamicTaskOperationThreadExecutor.submit(dynamicTaskOperationUpdateTask);
        try {
            future.get();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    @Transactional
    public void deleteByTaskcodes(String[] taskCodes) {
        String tenantCode = TenantUtils.getTenantCode();
        DynamicTaskOperationUpdateTask dynamicTaskOperationUpdateTask = (DynamicTaskOperationUpdateTask)this.applicationContext.getBean(DynamicTaskOperationUpdateTask.class, new Object[]{tenantCode, taskCodes, DynamicTaskOperation.deleteByTaskcodes});
        Future<Object> future = this.dynamicTaskOperationThreadExecutor.submit(dynamicTaskOperationUpdateTask);
        try {
            future.get();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public DynamicTaskSchedulerVo findByTaskCodeAndApplicationNameAndAppCode(String taskCode, String applicationName, String appCode) {
        if (StringUtils.isBlank((CharSequence)appCode)) {
            appCode = TenantUtils.getTenantCode();
        }
        DynamicTaskOperationFindTask dynamicTaskOperationFindTask = (DynamicTaskOperationFindTask)this.applicationContext.getBean(DynamicTaskOperationFindTask.class, new Object[]{taskCode, applicationName, appCode});
        Future<Object> future = this.dynamicTaskOperationThreadExecutor.submit(dynamicTaskOperationFindTask);
        try {
            DynamicTaskSchedulerVo resutls = (DynamicTaskSchedulerVo)future.get();
            return resutls;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public Page<DynamicTaskSchedulerVo> findByConditions(Pageable pageable, DynamicTaskSchedulerDto conditions) {
        String appCode = TenantUtils.getTenantCode();
        conditions.setAppCode(appCode);
        DynamicTaskOperationFindTask dynamicTaskOperationFindTask = (DynamicTaskOperationFindTask)this.applicationContext.getBean(DynamicTaskOperationFindTask.class, new Object[]{pageable, conditions});
        Future<Object> future = this.dynamicTaskOperationThreadExecutor.submit(dynamicTaskOperationFindTask);
        try {
            Page resutls = (Page)future.get();
            return resutls;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    private static /* synthetic */ boolean lambda$loading$5(Set mustStopTaskCodes, DynamicTaskSchedulerEntity item) {
        return mustStopTaskCodes.contains(StringUtils.join((Object[])new String[]{item.getApplicationName(), "_", item.getAppCode(), "_", item.getTaskCode()}));
    }

    private static /* synthetic */ boolean lambda$loading$4(Set mustStartTaskCodes, DynamicTaskSchedulerEntity item) {
        return mustStartTaskCodes.contains(StringUtils.join((Object[])new String[]{item.getApplicationName(), "_", item.getAppCode(), "_", item.getTaskCode()}));
    }
}

