/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.internal;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.task.dto.DynamicTaskShardingDto;
import com.bizunited.nebula.task.local.entity.DynamicTaskSchedulerEntity;
import com.bizunited.nebula.task.local.repository.DynamicTaskSchedulerRepository;
import com.bizunited.nebula.task.local.service.DynamicTaskShardingService;
import com.bizunited.nebula.task.local.service.scheduler.DynamicShardingTask;
import com.bizunited.nebula.task.service.DynamicTaskParamVoService;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import com.bizunited.nebula.task.vo.DynamicTaskShardingVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DynamicTaskShardingServiceImpl
implements DynamicTaskShardingService {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private DynamicTaskSchedulerRepository dynamicTaskSchedulerRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DynamicTaskParamVoService dynamicTaskParamVoService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="platform_dynamicTaskScheduler")
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTaskShardingServiceImpl.class);
    private static final String sharding_code = UUID.randomUUID().toString().replace("-", "");

    @Override
    public String getShardingCode() {
        return sharding_code;
    }

    @Override
    public void refreshSharding(String applicationName, Integer expireTime) {
        String mapName = String.join((CharSequence)":", applicationName, "REDIS_KEY_DYNAMICTASK_SHARDING", sharding_code);
        this.redisTemplate.opsForHash().put((Object)mapName, (Object)"placeholder", (Object)new Date().getTime());
        this.redisTemplate.expire((Object)mapName, (long)expireTime.intValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void deleteSharding(String applicationName) {
        String mapName = String.join((CharSequence)":", applicationName, "REDIS_KEY_DYNAMICTASK_SHARDING", sharding_code);
        this.redisTemplate.delete((Object)mapName);
    }

    @Override
    public void addShardingTask(String applicationName, String appCode, String taskCode) {
        String mapName = String.join((CharSequence)":", applicationName, "REDIS_KEY_DYNAMICTASK_SHARDING", sharding_code);
        String mapKey = String.join((CharSequence)"-", appCode, taskCode);
        this.redisTemplate.opsForHash().put((Object)mapName, (Object)mapKey, (Object)new Date().getTime());
    }

    @Override
    public void deleteShardingTask(String applicationName, String appCode, String taskCode) {
        String mapName = String.join((CharSequence)":", applicationName, "REDIS_KEY_DYNAMICTASK_SHARDING", sharding_code);
        String mapKey = String.join((CharSequence)"-", appCode, taskCode);
        this.redisTemplate.opsForHash().delete((Object)mapName, new Object[]{mapKey});
    }

    @Override
    public Boolean existShardingTask(String applicationName, String appCode, String taskCode) {
        String mapLikeName = String.join((CharSequence)":", applicationName, "REDIS_KEY_DYNAMICTASK_SHARDING", "*");
        Set mapNames = this.redisTemplate.keys((Object)mapLikeName);
        if (CollectionUtils.isEmpty((Collection)mapNames)) {
            return Boolean.FALSE;
        }
        boolean result = Boolean.FALSE;
        String mapKey = String.join((CharSequence)"-", appCode, taskCode);
        for (String mapName : mapNames) {
            Long expireTime = this.redisTemplate.getExpire((Object)mapName, TimeUnit.MILLISECONDS);
            if (Objects.isNull(expireTime) || expireTime <= 0L) {
                LOGGER.info("\u5e94\u7528\u7a0b\u5e8f[{}]\u79df\u6237[{}]\u5b9a\u65f6\u4efb\u52a1\u5206\u7247\u8282\u70b9[{}]\u5df2\u8fc7\u671f,\u6267\u884c\u6e05\u7406\u64cd\u4f5c...", new Object[]{applicationName, appCode, mapKey});
                this.redisTemplate.delete((Object)mapName);
                continue;
            }
            Boolean hasKey = this.redisTemplate.opsForHash().hasKey((Object)mapName, (Object)mapKey);
            if (!hasKey.booleanValue()) continue;
            result = Boolean.TRUE;
            break;
        }
        return result;
    }

    @Override
    public DynamicTaskShardingVo executeShardingTask(DynamicTaskShardingDto dto) {
        Validate.notBlank((CharSequence)dto.getAppCode(), (String)"\u591a\u5e94\u7528\u7f16\u7801\u7f3a\u5931", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getApplicationName(), (String)"\u5e94\u7528\u7a0b\u5e8f\u540d\u7f3a\u5931", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTaskCode(), (String)"\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\u7f3a\u5931", (Object[])new Object[0]);
        try {
            this.addShardingTask(dto.getApplicationName(), dto.getAppCode(), dto.getTaskCode());
            DynamicTaskSchedulerEntity schedulerEntity = this.dynamicTaskSchedulerRepository.findByTaskCodeAndApplicationNameAndAppCode(dto.getTaskCode(), dto.getApplicationName(), dto.getAppCode());
            Validate.notNull((Object)((Object)schedulerEntity), (String)"\u672a\u627e\u5230\u5b9a\u65f6\u4efb\u52a1\u4fe1\u606f", (Object[])new Object[0]);
            DynamicTaskSchedulerVo taskVo = (DynamicTaskSchedulerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)schedulerEntity, DynamicTaskSchedulerVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            List dynamicTaskParams = this.dynamicTaskParamVoService.findByDynamicTask(schedulerEntity.getId());
            if (!CollectionUtils.isEmpty((Collection)dynamicTaskParams)) {
                taskVo.setParams(dynamicTaskParams);
            }
            DynamicShardingTask dynamicShardingTask = (DynamicShardingTask)this.applicationContext.getBean(DynamicShardingTask.class, new Object[]{taskVo});
            this.threadPoolTaskScheduler.execute((Runnable)dynamicShardingTask);
        }
        catch (Exception e) {
            LOGGER.error("\u5e94\u7528\u7a0b\u5e8f[{}]\u79df\u6237[{}]\u5206\u7247\u5b9a\u65f6\u4efb\u52a1[{}]\u6267\u884c\u51fa\u9519", new Object[]{dto.getApplicationName(), dto.getAppCode(), dto.getTaskCode(), e});
            this.deleteShardingTask(dto.getApplicationName(), dto.getAppCode(), dto.getTaskCode());
            throw new RuntimeException(e.getMessage());
        }
        DynamicTaskShardingVo shardingVo = new DynamicTaskShardingVo();
        shardingVo.setShardingCode(sharding_code);
        return shardingVo;
    }
}

