/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.internal.task;

import com.bizunited.nebula.task.local.entity.DynamicTaskParamEntity;
import com.bizunited.nebula.task.local.entity.DynamicTaskSchedulerEntity;
import com.bizunited.nebula.task.local.repository.DynamicTaskParamRepository;
import com.bizunited.nebula.task.service.strategy.DynamicTaskParamValueConverter;
import com.bizunited.nebula.task.vo.DynamicTaskParamVo;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractDynamicTaskOperationTask {
    @Autowired
    private DynamicTaskParamRepository dynamicTaskParamRepository;
    @Autowired(required=false)
    private List<DynamicTaskParamValueConverter> dynamicTaskParamValueConverters;

    protected void createTaskParams(DynamicTaskSchedulerEntity taskEntity, List<DynamicTaskParamVo> taskParams) {
        if (!CollectionUtils.isEmpty(taskParams)) {
            DynamicTaskParamValueConverter defaultDynamicTaskParamValueConverter = this.dynamicTaskParamValueConverters.stream().filter(item -> item.isDefault()).findFirst().orElse(null);
            for (DynamicTaskParamVo taskParam : taskParams) {
                Class paramType = taskParam.getParamType();
                Object value = taskParam.getParamValue();
                Integer index = taskParam.getParamIndex();
                Validate.notNull((Object)paramType, (String)"\u52a8\u6001\u4efb\u52a1\u6267\u884c\u53c2\u6570\u7684\u7c7b\u578b\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
                Validate.notNull((Object)value, (String)"\u52a8\u6001\u4efb\u52a1\u6267\u884c\u53c2\u6570\u7684\u503c\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
                Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"\u52a8\u6001\u4efb\u52a1\u6267\u884c\u53c2\u6570\u7684\u7d22\u5f15\u4f4d\u5982\u679c\u4f20\u5165\uff0c\u5219\u5fc5\u987b\u4e0d\u4e3a\u8d1f\u6570!!", (Object[])new Object[0]);
            }
            List currentTaskParams = taskParams.stream().sorted((s, t) -> s.getParamIndex() - t.getParamIndex()).collect(Collectors.toList());
            for (int index = 0; index < currentTaskParams.size(); ++index) {
                DynamicTaskParamVo currentTaskParam = (DynamicTaskParamVo)currentTaskParams.get(index);
                Class paramType = currentTaskParam.getParamType();
                Object value = currentTaskParam.getParamValue();
                boolean canConverter = false;
                DynamicTaskParamValueConverter currntDynamicTaskParamValueConverter = null;
                for (DynamicTaskParamValueConverter dynamicTaskParamValueConverter : this.dynamicTaskParamValueConverters) {
                    canConverter = dynamicTaskParamValueConverter.canConverter(index, (Type)paramType);
                    if (!canConverter) continue;
                    currntDynamicTaskParamValueConverter = dynamicTaskParamValueConverter;
                    break;
                }
                if (!canConverter) {
                    currntDynamicTaskParamValueConverter = defaultDynamicTaskParamValueConverter;
                }
                String serialize = currntDynamicTaskParamValueConverter.serialize(index, (Type)paramType, value);
                DynamicTaskParamEntity dynamicTaskParam = new DynamicTaskParamEntity();
                dynamicTaskParam.setDynamicTask(taskEntity);
                dynamicTaskParam.setParamIndex(index);
                dynamicTaskParam.setParamType(paramType.getName());
                dynamicTaskParam.setParamValue(serialize);
                this.dynamicTaskParamRepository.save((Object)dynamicTaskParam);
                currentTaskParam.setId(dynamicTaskParam.getId());
                currentTaskParam.setParamIndex(Integer.valueOf(index));
            }
        }
    }
}

