/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.internal.task;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.script.service.ScriptVoService;
import com.bizunited.nebula.script.vo.ScriptVo;
import com.bizunited.nebula.task.local.configuration.DynamicTaskProperties;
import com.bizunited.nebula.task.local.entity.DynamicTaskOperatorEntity;
import com.bizunited.nebula.task.local.entity.DynamicTaskSchedulerEntity;
import com.bizunited.nebula.task.local.repository.DynamicTaskOperatorRepository;
import com.bizunited.nebula.task.local.repository.DynamicTaskSchedulerRepository;
import com.bizunited.nebula.task.local.service.internal.task.AbstractDynamicTaskOperationTask;
import com.bizunited.nebula.task.local.service.internal.task.DynamicTaskOperation;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerLogVoService;
import com.bizunited.nebula.task.service.strategy.DynamicTaskOperatorConverter;
import com.bizunited.nebula.task.vo.DynamicTaskOperatorVo;
import com.bizunited.nebula.task.vo.DynamicTaskParamVo;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.executor.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.CollectionUtils;

public class DynamicTaskOperationCreateTask
extends AbstractDynamicTaskOperationTask
implements Callable<Object> {
    @Autowired
    private ScriptVoService scriptService;
    @Autowired
    private DynamicTaskProperties dynamicTaskProperties;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DynamicTaskOperatorRepository dynamicTaskOperatorRepository;
    @Autowired
    private DynamicTaskSchedulerRepository dynamicTaskSchedulerRepository;
    @Autowired
    private DynamicTaskSchedulerLogVoService dynamicTaskSchedulerLogService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Lazy
    private List<DynamicTaskOperatorConverter> dynamicTaskOperatorConverters;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTaskOperationCreateTask.class);
    private DynamicTaskSchedulerVo task;
    private String scriptContent;
    private String taskCode;
    private String invokeBeanName;
    private String method;
    private String executeExpression;
    private Date validityTime;
    private String taskDesc;
    private Object[] args;
    private Integer taskType;
    private Date executePoint;
    private String appCode;
    private Integer invokeType;
    private List<DynamicTaskSchedulerVo> tasks;
    private String applicationName;
    private DynamicTaskOperation dynamicTaskOperation;

    public DynamicTaskOperationCreateTask(DynamicTaskSchedulerVo task, String scriptContent, DynamicTaskOperation dynamicTaskOperation) {
        this.task = task;
        this.appCode = this.task.getAppCode();
        this.scriptContent = scriptContent;
        this.dynamicTaskOperation = dynamicTaskOperation;
    }

    public DynamicTaskOperationCreateTask(String appCode, String taskCode, String invokeBeanName, String method, String executeExpression, Date validityTime, String taskDesc, DynamicTaskOperation dynamicTaskOperation, Object ... args) {
        this.appCode = appCode;
        this.taskCode = taskCode;
        this.invokeBeanName = invokeBeanName;
        this.method = method;
        this.executeExpression = executeExpression;
        this.validityTime = validityTime;
        this.taskDesc = taskDesc;
        this.args = args;
        this.dynamicTaskOperation = dynamicTaskOperation;
    }

    public DynamicTaskOperationCreateTask(String appCode, String taskCode, String invokeBeanName, String method, Integer taskType, String executeExpression, Date executePoint, Date validityTime, String taskDesc, DynamicTaskOperation dynamicTaskOperation, Object ... args) {
        this.appCode = appCode;
        this.taskCode = taskCode;
        this.invokeBeanName = invokeBeanName;
        this.method = method;
        this.taskType = taskType;
        this.executeExpression = executeExpression;
        this.executePoint = executePoint;
        this.validityTime = validityTime;
        this.taskDesc = taskDesc;
        this.args = args;
        this.dynamicTaskOperation = dynamicTaskOperation;
    }

    public DynamicTaskOperationCreateTask(List<DynamicTaskSchedulerVo> tasks, Integer invokeType, String applicationName, String appCode, DynamicTaskOperation dynamicTaskOperation) {
        this.tasks = tasks;
        this.invokeType = invokeType;
        this.applicationName = applicationName;
        this.appCode = appCode;
        this.dynamicTaskOperation = dynamicTaskOperation;
    }

    @Override
    @Transactional
    public Object call() throws Exception {
        switch (this.dynamicTaskOperation) {
            case createIgnorePrefix: {
                return this.createIgnorePrefix(this.task, this.scriptContent);
            }
            case createIgnorePrefixForParams: {
                return this.createIgnorePrefix(this.taskCode, this.invokeBeanName, this.method, this.executeExpression, this.validityTime, this.taskDesc, this.args);
            }
            case createIgnorePrefixForTaskType: {
                return this.createIgnorePrefix(this.taskCode, this.invokeBeanName, this.method, this.taskType, this.executeExpression, this.executePoint, this.validityTime, this.taskDesc, this.args);
            }
            case saveIgnorePrefix: {
                this.saveIgnorePrefix(this.tasks, this.invokeType, this.applicationName, this.appCode);
                return null;
            }
        }
        return null;
    }

    private DynamicTaskSchedulerVo createIgnorePrefix(DynamicTaskSchedulerVo task, String scriptContent) {
        DynamicTaskSchedulerEntity taskEntity;
        SecurityContext securityContext = SecurityContextHolder.getContext();
        String userAccount = "admin";
        Authentication authentication = securityContext.getAuthentication();
        if (authentication != null) {
            userAccount = authentication.getName();
        }
        Validate.notBlank((CharSequence)this.appCode, (String)"\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!", (Object[])new Object[0]);
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        Date currentTime = new Date();
        Validate.notNull((Object)task, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u52a8\u6001\u4efb\u52a1\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        task.setCreateTime(currentTime);
        task.setCreateAccount(userAccount);
        task.setModifyTime(currentTime);
        task.setModifyAccount(userAccount);
        task.setTstatus(Integer.valueOf(1));
        task.setWorkingStatus(Integer.valueOf(0));
        task.setAppCode(this.appCode);
        task.setApplicationName(applicationName);
        this.createValidation(task);
        if (task.getInvokeType() == 1) {
            Validate.notBlank((CharSequence)scriptContent, (String)"\u5f53\u4efb\u52a1\u7c7b\u578b\u4e3agroovy\u811a\u672c\u65f6\uff0c\u811a\u672c\u5185\u5bb9\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
            ScriptVo script = new ScriptVo();
            String scriptName = "dynamicTask_" + this.appCode + "_" + task.getTaskCode();
            script.setLanguage("groovy");
            script.setName(scriptName);
            script = this.scriptService.create(script, scriptContent);
            task.setScriptName(scriptName);
        }
        if (StringUtils.isBlank((CharSequence)(taskEntity = (DynamicTaskSchedulerEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)task, DynamicTaskSchedulerEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]))).getInvokeBeanName())) {
            taskEntity.setInvokeBeanName("");
        }
        if (StringUtils.isBlank((CharSequence)taskEntity.getInvokeMethod())) {
            taskEntity.setInvokeMethod("");
        }
        this.dynamicTaskSchedulerRepository.save((Object)taskEntity);
        task.setId(taskEntity.getId());
        List taskParams = task.getParams();
        this.createTaskParams(taskEntity, taskParams);
        List sortDynamicTaskOperatorConverters = this.dynamicTaskOperatorConverters.stream().sorted((source, target) -> source.sort() - target.sort()).collect(Collectors.toList());
        DynamicTaskOperatorConverter matchedDynamicTaskOperatorConverter = null;
        for (DynamicTaskOperatorConverter dynamicTaskOperatorConverter : sortDynamicTaskOperatorConverters) {
            DynamicTaskOperatorVo dynamicTaskOperator = dynamicTaskOperatorConverter.buildDynamicTaskOperator(task);
            if (dynamicTaskOperator == null) continue;
            matchedDynamicTaskOperatorConverter = dynamicTaskOperatorConverter;
            DynamicTaskOperatorEntity dynamicTaskOperatorEntity = (DynamicTaskOperatorEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dynamicTaskOperator, DynamicTaskOperatorEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            dynamicTaskOperatorEntity.setRoles(StringUtils.join((Object[])dynamicTaskOperator.getRoles(), (String)","));
            this.dynamicTaskOperatorRepository.save((Object)dynamicTaskOperatorEntity);
            break;
        }
        if (matchedDynamicTaskOperatorConverter == null) {
            LOGGER.warn("\u52a8\u6001\u4efb\u52a1{}\u867d\u7136\u6dfb\u52a0\u6210\u529f\uff0c\u4f46\u662f\u5e76\u6ca1\u6709\u627e\u5230\u8be5\u4efb\u52a1\u7684\u64cd\u4f5c\u8005\uff0c\u8be5\u4efb\u52a1\u6267\u884c\u65f6\u5c06\u53ef\u80fd\u4ee5\u533f\u540d\u7528\u6237\u7684\u5f62\u5f0f\u8fdb\u884c\u8fd0\u884c\uff0c\u8bf7\u6ce8\u610f!!", (Object)task.getTaskCode());
        }
        return task;
    }

    private DynamicTaskSchedulerVo createIgnorePrefix(String taskCode, String invokeBeanName, String method, String executeExpression, Date validityTime, String taskDesc, Object ... args) {
        return this.createIgnorePrefix(taskCode, invokeBeanName, method, 2, executeExpression, null, validityTime, taskDesc, args);
    }

    private DynamicTaskSchedulerVo createIgnorePrefix(String taskCode, String invokeBeanName, String method, Integer taskType, String executeExpression, Date executePoint, Date validityTime, String taskDesc, Object ... args) {
        Validate.notBlank((CharSequence)invokeBeanName, (String)"\u9519\u8bef\u7684Spring ioc\u4e2d\u7684bean\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)method, (String)"\u9519\u8bef\u7684\u65b9\u6cd5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)2L, (long)taskType.intValue(), (String)"\u5fc5\u987b\u4f20\u5165\u6b63\u786e\u7684taskType\u4fe1\u606f\uff081\uff1a\u4e00\u6b21\u6027\u4efb\u52a1\uff1b2\uff1a\u5468\u671f\u6027\u4efb\u52a1\uff09\uff0c\u8bf7\u68c0\u67e5!!");
        if (taskType == 1) {
            Validate.isTrue((executePoint != null || !StringUtils.isBlank((CharSequence)executeExpression) ? 1 : 0) != 0, (String)"\u5f53\u5efa\u7acb\u4e00\u6b21\u6027\u4efb\u52a1\u65f6\uff0c\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u6267\u884c\u65f6\u95f4\u70b9\u6216cron\u8868\u8fbe\u5f0f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        } else {
            Validate.notBlank((CharSequence)executeExpression, (String)"\u9519\u8bef\u7684\u5468\u671f\u6027\u503c\u8bbe\u5b9a\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)taskDesc, (String)"\u5fc5\u987b\u8bbe\u5b9a\u4efb\u52a1\u7684\u8bf4\u660e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Date now = new Date();
        if (validityTime != null) {
            Validate.isTrue((now.getTime() < validityTime.getTime() ? 1 : 0) != 0, (String)"\u5982\u679c\u8bbe\u5b9a\u4e86\u8fc7\u671f\u65f6\u95f4\uff0c\u5219\u8fc7\u671f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
        }
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        try {
            this.applicationContext.getBean(invokeBeanName);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("\u6307\u5b9a\u7684\u65b9\u6cd5\u5e76\u4e0d\u5b58\u5728\u4e8eSpring Ioc\u5bb9\u5668\u4e2d\uff0c\u8bf7\u68c0\u67e5!!");
        }
        DynamicTaskSchedulerVo dynamicTaskScheduler = new DynamicTaskSchedulerVo();
        dynamicTaskScheduler.setTaskCode(taskCode);
        dynamicTaskScheduler.setAppCode(this.appCode);
        dynamicTaskScheduler.setApplicationName(applicationName);
        dynamicTaskScheduler.setExecuteExpression(executeExpression);
        dynamicTaskScheduler.setExecutePoint(executePoint);
        dynamicTaskScheduler.setInvokeBeanName(invokeBeanName);
        dynamicTaskScheduler.setInvokeMethod(method);
        dynamicTaskScheduler.setTaskType(taskType);
        dynamicTaskScheduler.setInvokeType(Integer.valueOf(3));
        dynamicTaskScheduler.setScriptName("");
        dynamicTaskScheduler.setTaskDesc(taskDesc);
        dynamicTaskScheduler.setExpressionDesc(taskDesc);
        dynamicTaskScheduler.setTstatus(Integer.valueOf(1));
        dynamicTaskScheduler.setValidityTime(validityTime);
        dynamicTaskScheduler.setWorkingStatus(Integer.valueOf(1));
        if (args != null && args.length > 0) {
            ArrayList taskParams = Lists.newArrayList();
            for (int index = 0; index < args.length; ++index) {
                Object arg = args[index];
                DynamicTaskParamVo param = new DynamicTaskParamVo();
                if (arg != null) {
                    param.setParamType(arg.getClass());
                    param.setParamValue(arg);
                } else {
                    param.setParamType(Object.class);
                }
                param.setParamIndex(Integer.valueOf(index));
                taskParams.add(param);
            }
            dynamicTaskScheduler.setParams((List)taskParams);
        }
        return this.createIgnorePrefix(dynamicTaskScheduler, null);
    }

    private void createValidation(DynamicTaskSchedulerVo task) {
        DynamicTaskSchedulerEntity currentDynamicTaskSchedulerEntity;
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)task.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        task.setId(null);
        Integer invokeType = task.getInvokeType();
        Validate.isTrue((invokeType != null && (invokeType == 3 || invokeType == 1) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u521b\u5efagroovy\u811a\u672c\u6027\u8d28\u6216\u8005\u5168\u52a8\u6001\u6027\u8d28\u7684\u4efb\u52a1!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)task.getTaskCode(), (String)"\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\uff08\u53ea\u80fd\u7531\u5927\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u201c-\u201d\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.indexOfAny((CharSequence)task.getTaskCode(), (String)"_") == -1 ? 1 : 0) != 0, (String)"\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\uff08\u53ea\u80fd\u7531\u5927\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u201c-\u201d\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)task.getTaskDesc(), (String)"\u4efb\u52a1\u4e2d\u6587\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)task.getTaskType(), (String)"\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)task.getCreateTime(), (String)"\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)task.getModifyTime(), (String)"\u6700\u540e\u4fee\u6539\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)task.getApplicationName(), (String)"\u5fc5\u987b\u4e3a\u52a8\u6001\u4efb\u52a1\u8bbe\u5b9a\u5e94\u7528\u7a0b\u5e8f\u540d!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)task.getAppCode(), (String)"\u5fc5\u987b\u4e3a\u52a8\u6001\u4efb\u52a1\u8bbe\u5b9a\u9876\u7ea7\u79df\u6237\u4fe1\u606f\uff08appCode/tenantCode\uff09!!", (Object[])new Object[0]);
        Validate.isTrue((task.getTaskCode() == null || task.getTaskCode().length() < 128 ? 1 : 0) != 0, (String)"\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\uff08\u53ea\u80fd\u7531\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u6760\u6784\u6210\uff09,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((task.getTaskDesc() == null || task.getTaskDesc().length() < 256 ? 1 : 0) != 0, (String)"\u4efb\u52a1\u4e2d\u6587\u8bf4\u660e,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Date currentTime = new Date();
        if (task.getTaskType() == 1) {
            Validate.notNull((Object)task.getExecutePoint(), (String)"\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
            Validate.isTrue((task.getExecutePoint().getTime() > currentTime.getTime() ? 1 : 0) != 0, (String)"\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\uff0c\u5fc5\u987b\u8bbe\u5b9a\u5728\u5f53\u524d\u65f6\u95f4\u70b9\u4ee5\u540e", (Object[])new Object[0]);
        } else if (task.getTaskType() == 2) {
            Validate.notBlank((CharSequence)task.getExecuteExpression(), (String)"\u5468\u671f\u6027\u4efb\u52a1\u5fc5\u987b\u7ed9\u5b9a\u6709\u6548\u7684corn\u8868\u8fbe\u5f0f!!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)task.getExpressionDesc(), (String)"\u5468\u671f\u6027\u4efb\u52a1\u5fc5\u987b\u4f20\u5165corn\u8868\u8fbe\u5f0f\u7684\u4e2d\u6587\u63cf\u8ff0!!", (Object[])new Object[0]);
            Validate.isTrue((task.getExecuteExpression() == null || task.getExecuteExpression().length() < 32 ? 1 : 0) != 0, (String)"\u5468\u671f\u6027\u4efb\u52a1\u6267\u884c\u8868\u5355\u5f0f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((task.getExpressionDesc() == null || task.getExpressionDesc().length() < 256 ? 1 : 0) != 0, (String)"\u5468\u671f\u6027\u8868\u5355\u65f6\u7684\u4e2d\u6587,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        } else {
            throw new IllegalArgumentException("\u52a8\u6001\u4efb\u52a1\u53ea\u80fd\u662f\u4e00\u6b21\u6027\u4efb\u52a1\u6216\u8005\u5468\u671f\u6027\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5!!");
        }
        if (StringUtils.isNotBlank((CharSequence)task.getExecuteExpression())) {
            try {
                new CronExpression(task.getExecuteExpression());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("cron\u8868\u8fbe\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5!\u3010%s\u3011", e.getMessage()));
            }
        }
        Validate.isTrue(((currentDynamicTaskSchedulerEntity = this.dynamicTaskSchedulerRepository.findByTaskCodeAndApplicationNameAndAppCode(task.getTaskCode(), task.getApplicationName(), task.getAppCode())) == null ? 1 : 0) != 0, (String)"\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\uff08\u53ea\u80fd\u7531\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u6760\u6784\u6210\uff09\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }

    private void saveIgnorePrefix(List<DynamicTaskSchedulerVo> tasks, Integer invokeType, String applicationName, String appCode) {
        Validate.isTrue((!CollectionUtils.isEmpty(tasks) ? 1 : 0) != 0, (String)"\u9700\u8981\u540c\u6b65\u7684\u4efb\u52a1\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)applicationName, (String)"applicationName\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)appCode, (String)"appCode\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)invokeType, (String)"invokeType\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (DynamicTaskSchedulerVo taskItem : tasks) {
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)taskItem.getApplicationName(), (CharSequence)applicationName), (String)"\u6bcf\u4e00\u4e2a\u9700\u8981\u540c\u6b65\u4efb\u52a1\uff0c\u90fd\u9700\u8981\u4fdd\u8bc1applicationName(%s)\u4fe1\u606f\u4e00\u81f4", (Object[])new Object[]{applicationName});
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)taskItem.getAppCode(), (CharSequence)appCode), (String)"\u6bcf\u4e00\u4e2a\u9700\u8981\u540c\u6b65\u4efb\u52a1\uff0c\u90fd\u9700\u8981\u4fdd\u8bc1appCode/tenantCode(%s)\u4fe1\u606f\u4e00\u81f4", (Object[])new Object[]{appCode});
            Validate.isTrue((invokeType.intValue() == taskItem.getInvokeType().intValue() ? 1 : 0) != 0, (String)"\u6bcf\u4e00\u4e2a\u9700\u8981\u540c\u6b65\u4efb\u52a1\uff0c\u90fd\u9700\u8981\u4fdd\u8bc1invokeType(%d)\u4fe1\u606f\u4e00\u81f4", (long)invokeType.intValue());
        }
        Collection currentTasks = this.nebulaToolkitService.copyCollectionByWhiteList(tasks, DynamicTaskSchedulerVo.class, DynamicTaskSchedulerEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Date currentTime = new Date();
        HashSet exsitDynamicTasks = this.dynamicTaskSchedulerRepository.findByInvokeTypeAndApplicationNameAndAppCode(invokeType, applicationName, appCode);
        if (exsitDynamicTasks == null) {
            exsitDynamicTasks = Sets.newHashSet();
        }
        HashSet deleteCollections = Sets.newHashSet();
        HashSet updateCollections = Sets.newHashSet();
        HashSet createCollections = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy(currentTasks, (Collection)exsitDynamicTasks, DynamicTaskSchedulerEntity::getTaskCode, (Collection)deleteCollections, (Collection)updateCollections, (Collection)createCollections);
        if (!createCollections.isEmpty()) {
            for (DynamicTaskSchedulerEntity createItem : createCollections) {
                createItem.setCreateAccount("admin");
                createItem.setCreateTime(currentTime);
                createItem.setModifyAccount("admin");
                createItem.setModifyTime(currentTime);
                createItem.setTstatus(1);
                createItem.setWorkingStatus(0);
                this.dynamicTaskSchedulerRepository.save((Object)createItem);
            }
        }
        if (!deleteCollections.isEmpty()) {
            for (DynamicTaskSchedulerEntity deleteItem : deleteCollections) {
                String dynamicTaskSchedulerId = deleteItem.getId();
                this.dynamicTaskSchedulerLogService.deleteByDynamicTaskId(dynamicTaskSchedulerId);
                this.dynamicTaskSchedulerRepository.flush();
                this.dynamicTaskSchedulerRepository.delete((Object)deleteItem);
            }
        }
        if (!updateCollections.isEmpty()) {
            Map<String, DynamicTaskSchedulerEntity> targetTasksMapping = currentTasks.stream().collect(Collectors.toMap(DynamicTaskSchedulerEntity::getTaskCode, item -> item));
            for (DynamicTaskSchedulerEntity updateItem : updateCollections) {
                String taskCode = updateItem.getTaskCode();
                DynamicTaskSchedulerEntity targetItem = targetTasksMapping.get(taskCode);
                String itemAppCode = targetItem.getAppCode();
                if (!StringUtils.equals((CharSequence)itemAppCode, (CharSequence)appCode)) {
                    throw new IllegalArgumentException("\u7ef4\u62a4\u65f6\u53d1\u73b0appCode\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                updateItem.setExecuteExpression(targetItem.getExecuteExpression());
                updateItem.setExecutePoint(targetItem.getExecutePoint());
                updateItem.setExpressionDesc(targetItem.getExpressionDesc());
                updateItem.setInvokeBeanName(targetItem.getInvokeBeanName());
                updateItem.setInvokeMethod(targetItem.getInvokeMethod());
                updateItem.setTaskDesc(targetItem.getTaskDesc());
                updateItem.setModifyAccount("admin");
                updateItem.setModifyTime(currentTime);
                updateItem.setAppCode(itemAppCode);
                updateItem.setApplicationName(targetItem.getApplicationName());
                updateItem.setValidityTime(targetItem.getValidityTime());
                this.dynamicTaskSchedulerRepository.save((Object)updateItem);
            }
        }
    }
}

