/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.internal.task;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.task.dto.DynamicTaskSchedulerDto;
import com.bizunited.nebula.task.local.configuration.DynamicTaskProperties;
import com.bizunited.nebula.task.local.entity.DynamicTaskSchedulerEntity;
import com.bizunited.nebula.task.local.repository.DynamicTaskSchedulerRepository;
import com.bizunited.nebula.task.local.service.internal.task.AbstractDynamicTaskOperationTask;
import com.bizunited.nebula.task.local.service.internal.task.DynamicTaskOperation;
import com.bizunited.nebula.task.service.strategy.DynamicTaskOperatorConverter;
import com.bizunited.nebula.task.vo.DynamicTaskParamVo;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class DynamicTaskOperationFindTask
extends AbstractDynamicTaskOperationTask
implements Callable<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTaskOperationFindTask.class);
    @Autowired
    private DynamicTaskProperties dynamicTaskProperties;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DynamicTaskSchedulerRepository dynamicTaskSchedulerRepository;
    @Autowired
    @Lazy
    private List<DynamicTaskOperatorConverter> dynamicTaskOperatorConverters;
    private String applicationName;
    private String appCode;
    private String taskCode;
    private Pageable pageable;
    private DynamicTaskSchedulerDto conditions;
    private DynamicTaskOperation dynamicTaskOperation;

    public DynamicTaskOperationFindTask(String taskCode, String applicationName, String appCode) {
        this.taskCode = taskCode;
        this.applicationName = applicationName;
        this.appCode = appCode;
        this.dynamicTaskOperation = DynamicTaskOperation.findByTaskCodeAndApplicationNameAndAppCode;
    }

    public DynamicTaskOperationFindTask(Pageable pageable, DynamicTaskSchedulerDto conditions) {
        this.pageable = pageable;
        this.conditions = conditions;
        this.dynamicTaskOperation = DynamicTaskOperation.findByConditions;
    }

    @Override
    @Transactional
    public Object call() throws Exception {
        switch (this.dynamicTaskOperation) {
            case findByTaskCodeAndApplicationNameAndAppCode: {
                return this.findByTaskCodeAndApplicationNameAndAppCode(this.taskCode, this.applicationName, this.appCode);
            }
            case findByConditions: {
                return this.findByConditions(this.pageable, this.conditions);
            }
        }
        return null;
    }

    private DynamicTaskSchedulerVo findByTaskCodeAndApplicationNameAndAppCode(String taskCode, String applicationName, String appCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{taskCode, applicationName, appCode})) {
            return null;
        }
        DynamicTaskSchedulerEntity dynamicTask = this.dynamicTaskSchedulerRepository.findByTaskCodeAndApplicationNameAndAppCode(taskCode, applicationName, appCode);
        if (dynamicTask == null) {
            return null;
        }
        DynamicTaskSchedulerVo schedulerVo = (DynamicTaskSchedulerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dynamicTask, DynamicTaskSchedulerVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List params = dynamicTask.getParams();
        params = (List)ObjectUtils.defaultIfNull(params, (Object)Lists.newArrayList());
        schedulerVo.setParams(params.stream().map(entity -> {
            DynamicTaskParamVo paramVo = new DynamicTaskParamVo();
            paramVo.setParamIndex(entity.getParamIndex());
            paramVo.setParamValue((Object)entity.getParamValue());
            if (StringUtils.isNotBlank((CharSequence)entity.getParamType())) {
                try {
                    paramVo.setParamType(Class.forName(entity.getParamType()));
                }
                catch (Exception e) {
                    LOGGER.error("\u8f6c\u6362\u53c2\u6570\u7c7b\u578b\u662f\u51fa\u73b0\u5f02\u5e38:{}", (Object)entity.getParamType());
                }
            }
            return paramVo;
        }).collect(Collectors.toList()));
        return schedulerVo;
    }

    private Page<DynamicTaskSchedulerVo> findByConditions(Pageable pageable, DynamicTaskSchedulerDto conditions) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (conditions == null) {
            conditions = new DynamicTaskSchedulerDto();
        }
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        conditions.setAppCode(this.appCode);
        conditions.setApplicationName(applicationName);
        Page results = this.dynamicTaskSchedulerRepository.findByConditions(pageable, conditions);
        if (results == null || results.isEmpty()) {
            return null;
        }
        Collection dynamicTaskSchedulerVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)results, DynamicTaskSchedulerEntity.class, DynamicTaskSchedulerVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new PageImpl((List)Lists.newArrayList((Iterable)dynamicTaskSchedulerVos), pageable, results.getTotalElements());
    }
}

