/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.internal.task;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.script.service.ScriptVoService;
import com.bizunited.nebula.script.vo.ScriptVo;
import com.bizunited.nebula.task.local.configuration.DynamicTaskProperties;
import com.bizunited.nebula.task.local.entity.DynamicTaskOperatorEntity;
import com.bizunited.nebula.task.local.entity.DynamicTaskSchedulerEntity;
import com.bizunited.nebula.task.local.repository.DynamicTaskOperatorRepository;
import com.bizunited.nebula.task.local.repository.DynamicTaskParamRepository;
import com.bizunited.nebula.task.local.repository.DynamicTaskSchedulerRepository;
import com.bizunited.nebula.task.local.service.internal.task.AbstractDynamicTaskOperationTask;
import com.bizunited.nebula.task.local.service.internal.task.DynamicTaskOperation;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerLogVoService;
import com.bizunited.nebula.task.service.strategy.DynamicTaskOperatorConverter;
import com.bizunited.nebula.task.vo.DynamicTaskOperatorVo;
import com.bizunited.nebula.task.vo.DynamicTaskParamVo;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.executor.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.CollectionUtils;

public class DynamicTaskOperationUpdateTask
extends AbstractDynamicTaskOperationTask
implements Callable<Object> {
    @Autowired
    private ScriptVoService scriptService;
    @Autowired
    private DynamicTaskProperties dynamicTaskProperties;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DynamicTaskParamRepository dynamicTaskParamRepository;
    @Autowired
    private DynamicTaskOperatorRepository dynamicTaskOperatorRepository;
    @Autowired
    private DynamicTaskSchedulerRepository dynamicTaskSchedulerRepository;
    @Autowired
    private DynamicTaskSchedulerLogVoService dynamicTaskSchedulerLogService;
    @Autowired
    @Lazy
    private List<DynamicTaskOperatorConverter> dynamicTaskOperatorConverters;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTaskOperationUpdateTask.class);
    private DynamicTaskSchedulerVo task;
    private String scriptContent;
    private String taskCode;
    private String executeExpression;
    private Date validityTime;
    private String taskDesc;
    private Object[] args;
    private String appCode;
    private String[] taskCodes;
    private DynamicTaskOperation dynamicTaskOperation;

    public DynamicTaskOperationUpdateTask(DynamicTaskSchedulerVo task, String scriptContent, DynamicTaskOperation dynamicTaskOperation) {
        this.task = task;
        this.appCode = task.getAppCode();
        this.scriptContent = scriptContent;
        this.dynamicTaskOperation = dynamicTaskOperation;
    }

    public DynamicTaskOperationUpdateTask(String appCode, String taskCode, String executeExpression, Date validityTime, String taskDesc, DynamicTaskOperation dynamicTaskOperation, Object ... args) {
        this.taskCode = taskCode;
        this.executeExpression = executeExpression;
        this.validityTime = validityTime;
        this.taskDesc = taskDesc;
        this.args = args;
        this.appCode = appCode;
        this.dynamicTaskOperation = dynamicTaskOperation;
    }

    public DynamicTaskOperationUpdateTask(String appCode, String[] taskCodes, DynamicTaskOperation dynamicTaskOperation) {
        this.taskCodes = taskCodes;
        this.appCode = appCode;
        this.dynamicTaskOperation = dynamicTaskOperation;
    }

    @Override
    @Transactional
    public Object call() throws Exception {
        switch (this.dynamicTaskOperation) {
            case updateIgnorePrefix: {
                return this.updateIgnorePrefix(this.task, this.scriptContent);
            }
            case updateIgnorePrefixForParams: {
                return this.updateIgnorePrefix(this.taskCode, this.executeExpression, this.validityTime, this.taskDesc, this.args);
            }
            case invalid: {
                this.invalid(this.taskCodes);
                return null;
            }
            case effective: {
                this.effective(this.taskCodes);
                return null;
            }
            case deleteByTaskcodes: {
                this.deleteByTaskcodes(this.taskCodes);
                return null;
            }
        }
        return null;
    }

    private DynamicTaskSchedulerVo updateIgnorePrefix(String taskCode, String executeExpression, Date validityTime, String taskDesc, Object ... args) {
        Validate.notBlank((CharSequence)taskCode, (String)"\u5728\u8fdb\u884c\u52a8\u6001\u4efb\u52a1\u4fee\u6539\u65f6\uff0c\u4efb\u52a1\u4e1a\u52a1\u7f16\u53f7\u5fc5\u987b\u4f20\u5165\uff08\u4e14\u5fc5\u987b\u5b58\u5728\uff09!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)executeExpression, (String)"\u5728\u8fdb\u884c\u52a8\u6001\u4efb\u52a1\u4fee\u6539\u65f6\uff0c\u4efb\u52a1\u6267\u884c\u5468\u671f\u8868\u8fbe\u5f0f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)taskDesc, (String)"\u5728\u8fdb\u884c\u52a8\u6001\u4efb\u52a1\u4fee\u6539\u65f6\uff0c\u4efb\u52a1\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        DynamicTaskSchedulerVo currentTask = this.findByTaskCodeAndApplicationNameAndAppCode(taskCode, applicationName, this.appCode);
        Validate.notNull((Object)currentTask, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u52a8\u6001\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((currentTask.getInvokeType() == 3 || currentTask.getInvokeType() == 1 ? 1 : 0) != 0, (String)"\u8be5\u65b9\u6cd5\u53ea\u80fd\u4fee\u6539\u5168\u52a8\u6001\u4efb\u52a1\u548c\u811a\u672c\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u4efb\u52a1\u7c7b\u578b", (Object[])new Object[0]);
        currentTask.setExecuteExpression(executeExpression);
        currentTask.setTaskDesc(taskDesc);
        currentTask.setValidityTime(validityTime);
        if (args != null && args.length > 0) {
            ArrayList taskParams = Lists.newArrayList();
            for (int index = 0; index < args.length; ++index) {
                Object arg = args[index];
                DynamicTaskParamVo param = new DynamicTaskParamVo();
                if (arg != null) {
                    param.setParamType(arg.getClass());
                    param.setParamValue(arg);
                } else {
                    param.setParamType(Object.class);
                }
                param.setParamIndex(Integer.valueOf(index));
                taskParams.add(param);
            }
            currentTask.setParams((List)taskParams);
        }
        return this.updateIgnorePrefix(currentTask, null);
    }

    private DynamicTaskSchedulerVo updateIgnorePrefix(DynamicTaskSchedulerVo task, String scriptContent) {
        Validate.notNull((Object)task, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u52a8\u6001\u4efb\u52a1\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        SecurityContext securityContext = SecurityContextHolder.getContext();
        String userAccount = "admin";
        if (securityContext.getAuthentication() != null) {
            userAccount = securityContext.getAuthentication().getName();
        }
        Date currentTime = new Date();
        String currentId = task.getId();
        Optional op = this.dynamicTaskSchedulerRepository.findById(currentId);
        DynamicTaskSchedulerEntity currentTask = op.orElse(null);
        Validate.notNull((Object)((Object)currentTask), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        Validate.isTrue((currentTask.getInvokeType() != 2 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u6ce8\u89e3\u65b9\u5f0f\u521b\u5efa\u7684\u52a8\u6001\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4fee\u6539!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)currentTask.getApplicationName(), (String)"\u9519\u8bef\u6570\u636e\uff0c\u52a8\u6001\u4efb\u52a1\u7684applicationName\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff08\u8fd9\u53ef\u80fd\u662f\u810f\u6570\u636e\u9020\u6210\u7684\uff09!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)currentTask.getAppCode(), (String)"\u9519\u8bef\u6570\u636e\uff0c\u52a8\u6001\u4efb\u52a1\u7684appCode\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff08\u8fd9\u53ef\u80fd\u662f\u810f\u6570\u636e\u9020\u6210\u7684\uff09!!", (Object[])new Object[0]);
        this.updateValidation(task);
        currentTask.setTaskDesc(task.getTaskDesc());
        currentTask.setExecutePoint(task.getExecutePoint());
        currentTask.setExecuteExpression(task.getExecuteExpression());
        currentTask.setExpressionDesc(task.getExpressionDesc());
        currentTask.setValidityTime(task.getValidityTime());
        currentTask.setModifyTime(currentTime);
        currentTask.setModifyAccount(userAccount);
        this.dynamicTaskSchedulerRepository.save((Object)currentTask);
        this.dynamicTaskSchedulerRepository.flush();
        if (currentTask.getInvokeType() == 1) {
            String scriptName = currentTask.getScriptName();
            Validate.notBlank((CharSequence)scriptName, (String)"\u8fdb\u884c\u66f4\u65b0\u65f6\uff0c\u811a\u672c\u5185\u5bb9\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
            ScriptVo script = this.scriptService.findByName(scriptName);
            Validate.notNull((Object)script, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684groovy\u811a\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            script = this.scriptService.update(script, scriptContent);
        } else if (currentTask.getInvokeType() == 3) {
            this.dynamicTaskParamRepository.deleteByDynamicTask(currentId);
            this.dynamicTaskSchedulerRepository.flush();
            this.createTaskParams(currentTask, task.getParams());
        } else {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u52a8\u6001\u4efb\u52a1\u6267\u884c\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!");
        }
        List sortDynamicTaskOperatorConverters = this.dynamicTaskOperatorConverters.stream().sorted((source, target) -> source.sort() - target.sort()).collect(Collectors.toList());
        DynamicTaskOperatorConverter matchedDynamicTaskOperatorConverter = null;
        for (DynamicTaskOperatorConverter dynamicTaskOperatorConverter : sortDynamicTaskOperatorConverters) {
            DynamicTaskOperatorVo dynamicTaskOperator = dynamicTaskOperatorConverter.buildDynamicTaskOperator(task);
            if (dynamicTaskOperator == null) continue;
            DynamicTaskOperatorEntity currentDynamicTaskOperator = this.dynamicTaskOperatorRepository.findByDynamicTaskCodeAndApplicationName(currentTask.getTaskCode(), currentTask.getAppCode(), currentTask.getApplicationName());
            if (currentDynamicTaskOperator == null) {
                DynamicTaskOperatorEntity dynamicTaskOperatorEntity = (DynamicTaskOperatorEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dynamicTaskOperator, DynamicTaskOperatorEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                dynamicTaskOperatorEntity.setRoles(StringUtils.join((Object[])dynamicTaskOperator.getRoles(), (String)","));
                this.dynamicTaskOperatorRepository.save((Object)dynamicTaskOperatorEntity);
            } else {
                currentDynamicTaskOperator.setAccount(dynamicTaskOperator.getAccount());
                currentDynamicTaskOperator.setRoles(StringUtils.join((Object[])dynamicTaskOperator.getRoles(), (String)","));
                currentDynamicTaskOperator.setTenantCode(dynamicTaskOperator.getTenantCode());
                this.dynamicTaskOperatorRepository.save((Object)currentDynamicTaskOperator);
            }
            matchedDynamicTaskOperatorConverter = dynamicTaskOperatorConverter;
            break;
        }
        if (matchedDynamicTaskOperatorConverter == null) {
            LOGGER.warn("\u52a8\u6001\u4efb\u52a1{}\u867d\u7136\u7ef4\u62a4\u6210\u529f\uff0c\u4f46\u662f\u5e76\u6ca1\u6709\u627e\u5230\u8be5\u4efb\u52a1\u7684\u64cd\u4f5c\u8005\uff0c\u8be5\u4efb\u52a1\u6267\u884c\u65f6\u5c06\u53ef\u80fd\u4ee5\u533f\u540d\u7528\u6237\u7684\u5f62\u5f0f\u8fdb\u884c\u8fd0\u884c\uff0c\u8bf7\u6ce8\u610f!!", (Object)task.getTaskCode());
        }
        String applicationName = currentTask.getApplicationName();
        if (currentTask.getTstatus() == 1 && currentTask.getWorkingStatus() != 1 && currentTask.getWorkingStatus() != 3) {
            this.dynamicTaskSchedulerRepository.updateRestartByTaskCodesAndApplicationNameAndAppCode(new String[]{currentTask.getTaskCode()}, applicationName, this.appCode);
        }
        DynamicTaskSchedulerVo taskVo = (DynamicTaskSchedulerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentTask, DynamicTaskSchedulerVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return taskVo;
    }

    private void updateValidation(DynamicTaskSchedulerVo task) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)task.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)task.getTaskCode(), (String)"\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\uff08\u53ea\u80fd\u7531\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u6760\u6784\u6210\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)task.getTaskDesc(), (String)"\u4efb\u52a1\u4e2d\u6587\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)task.getTaskType(), (String)"\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Date currentTime = new Date();
        if (task.getTaskType() == 1) {
            Validate.notNull((Object)task.getExecutePoint(), (String)"\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
            Validate.isTrue((task.getExecutePoint().getTime() > currentTime.getTime() ? 1 : 0) != 0, (String)"\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\uff0c\u5fc5\u987b\u8bbe\u5b9a\u5728\u5f53\u524d\u65f6\u95f4\u70b9\u4ee5\u540e", (Object[])new Object[0]);
        } else if (task.getTaskType() == 2) {
            Validate.notBlank((CharSequence)task.getExecuteExpression(), (String)"\u5468\u671f\u6027\u4efb\u52a1\u5fc5\u987b\u7ed9\u5b9a\u6709\u6548\u7684corn\u8868\u8fbe\u5f0f!!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)task.getExpressionDesc(), (String)"\u5468\u671f\u6027\u4efb\u52a1\u5fc5\u987b\u4f20\u5165corn\u8868\u8fbe\u5f0f\u7684\u4e2d\u6587\u63cf\u8ff0!!", (Object[])new Object[0]);
            Validate.isTrue((task.getExecuteExpression() == null || task.getExecuteExpression().length() < 32 ? 1 : 0) != 0, (String)"\u5468\u671f\u6027\u4efb\u52a1\u6267\u884c\u8868\u5355\u5f0f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((task.getExpressionDesc() == null || task.getExpressionDesc().length() < 256 ? 1 : 0) != 0, (String)"\u5468\u671f\u6027\u8868\u5355\u65f6\u7684\u4e2d\u6587,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        } else {
            throw new IllegalArgumentException("\u52a8\u6001\u4efb\u52a1\u53ea\u80fd\u662f\u4e00\u6b21\u6027\u4efb\u52a1\u6216\u8005\u5468\u671f\u6027\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5!!");
        }
        if (StringUtils.isNotBlank((CharSequence)task.getExecuteExpression())) {
            try {
                new CronExpression(task.getExecuteExpression());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("cron\u8868\u8fbe\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5!\u3010%s\u3011", e.getMessage()));
            }
        }
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        DynamicTaskSchedulerEntity currentForTaskCode = this.dynamicTaskSchedulerRepository.findByTaskCodeAndApplicationNameAndAppCode(task.getTaskCode(), applicationName, this.appCode);
        Validate.isTrue((currentForTaskCode == null || StringUtils.equals((CharSequence)currentForTaskCode.getId(), (CharSequence)task.getId()) ? 1 : 0) != 0, (String)"\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\uff08\u53ea\u80fd\u7531\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u6760\u6784\u6210\uff09\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((task.getTaskCode() == null || task.getTaskCode().length() < 128 ? 1 : 0) != 0, (String)"\u4efb\u52a1\u552f\u4e00\u7f16\u53f7\uff08\u53ea\u80fd\u7531\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u6760\u6784\u6210\uff09,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((task.getTaskDesc() == null || task.getTaskDesc().length() < 256 ? 1 : 0) != 0, (String)"\u4efb\u52a1\u4e2d\u6587\u8bf4\u660e,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((task.getExecuteExpression() == null || task.getExecuteExpression().length() < 32 ? 1 : 0) != 0, (String)"\u5468\u671f\u6027\u4efb\u52a1\u6267\u884c\u8868\u5355\u5f0f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((task.getExpressionDesc() == null || task.getExpressionDesc().length() < 256 ? 1 : 0) != 0, (String)"\u5468\u671f\u6027\u8868\u5355\u65f6\u7684\u4e2d\u6587,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void invalid(String[] taskCodes) {
        Validate.isTrue((taskCodes != null && taskCodes.length > 0 ? 1 : 0) != 0, (String)"\u53d8\u66f4\u4efb\u52a1\u4e3a\u65e0\u6548\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u7684\u7f16\u53f7code!!", (Object[])new Object[0]);
        Validate.isTrue((taskCodes.length > 0 ? 1 : 0) != 0, (String)"\u53d8\u66f4\u4efb\u52a1\u4e3a\u65e0\u6548\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u7684\u7f16\u53f7code!!", (Object[])new Object[0]);
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        Set<DynamicTaskSchedulerEntity> dynamicTasks = this.dynamicTaskSchedulerRepository.findByTaskCodesAndApplicationNameAndAppCode(Lists.newArrayList((Object[])taskCodes), applicationName, this.appCode);
        Set<Object> dbDynamicEffectiveTaskCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(dynamicTasks)) {
            dbDynamicEffectiveTaskCodes = dynamicTasks.stream().filter(item -> item.getTstatus() == 1 && item.getWorkingStatus() == 3).map(DynamicTaskSchedulerEntity::getTaskCode).collect(Collectors.toSet());
        }
        Validate.isTrue((boolean)Sets.difference((Set)dbDynamicEffectiveTaskCodes, (Set)Sets.newHashSet((Object[])taskCodes)).isEmpty(), (String)"\u53d8\u66f4\u4efb\u52a1\u4e3a\u65e0\u6548\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u4efb\u52a1\u7684\u72b6\u6001\u4e0d\u4e3a\u201c\u6709\u6548\u201d\u6216\u4e0d\u4e3a\u201c\u5df2\u505c\u6b62\u201d!!", (Object[])new Object[0]);
        this.dynamicTaskSchedulerRepository.updateInvalidByTaskCodesAndApplicationNameAndAppCode(taskCodes, applicationName, this.appCode);
    }

    private void effective(String[] taskCodes) {
        Validate.notNull((Object)taskCodes, (String)"\u53d8\u66f4\u4efb\u52a1\u4e3a\u6709\u6548\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u7684\u7f16\u53f7code!!", (Object[])new Object[0]);
        Validate.isTrue((taskCodes.length > 0 ? 1 : 0) != 0, (String)"\u53d8\u66f4\u4efb\u52a1\u4e3a\u6709\u6548\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u7684\u7f16\u53f7code!!", (Object[])new Object[0]);
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        Set<DynamicTaskSchedulerEntity> dynamicTasks = this.dynamicTaskSchedulerRepository.findByTaskCodesAndApplicationNameAndAppCode(Lists.newArrayList((Object[])taskCodes), applicationName, this.appCode);
        Set<Object> dbDynamicInvalidTaskCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(dynamicTasks)) {
            dbDynamicInvalidTaskCodes = dynamicTasks.stream().filter(item -> item.getTstatus() == 0).map(DynamicTaskSchedulerEntity::getTaskCode).collect(Collectors.toSet());
        }
        Validate.isTrue((boolean)Sets.difference((Set)dbDynamicInvalidTaskCodes, (Set)Sets.newHashSet((Object[])taskCodes)).isEmpty(), (String)"\u53d8\u66f4\u4efb\u52a1\u4e3a\u6709\u6548\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u4efb\u52a1\u7684\u72b6\u6001\u4e0d\u4e3a\u201c\u65e0\u6548\u201d!!", (Object[])new Object[0]);
        this.dynamicTaskSchedulerRepository.updateEffectiveByTaskCodesAndApplicationNameAndAppCode(taskCodes, applicationName, this.appCode);
    }

    private void deleteByTaskcodes(String[] taskCodes) {
        Validate.notNull((Object)taskCodes, (String)"\u5220\u9664\u4efb\u52a1\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u7684\u7f16\u53f7code!!", (Object[])new Object[0]);
        Validate.isTrue((taskCodes.length > 0 ? 1 : 0) != 0, (String)"\u5220\u9664\u4efb\u52a1\u65f6\uff0c\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u7684\u7f16\u53f7code!!", (Object[])new Object[0]);
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        Set<DynamicTaskSchedulerEntity> dynamicTasks = this.dynamicTaskSchedulerRepository.findByTaskCodesAndApplicationNameAndAppCode(Lists.newArrayList((Object[])taskCodes), applicationName, this.appCode);
        Set<Object> dbDynamicStopedTaskCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(dynamicTasks)) {
            dbDynamicStopedTaskCodes = dynamicTasks.stream().filter(item -> item.getWorkingStatus() == 3).map(DynamicTaskSchedulerEntity::getTaskCode).collect(Collectors.toSet());
        }
        Validate.isTrue((boolean)Sets.difference((Set)Sets.newHashSet((Object[])taskCodes), (Set)dbDynamicStopedTaskCodes).isEmpty(), (String)"\u5220\u9664\u4efb\u52a1\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u4efb\u52a1\u7684\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u505c\u6b62\u201d\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (DynamicTaskSchedulerEntity task : dynamicTasks) {
            this.dynamicTaskSchedulerLogService.deleteByDynamicTaskId(task.getId());
            this.dynamicTaskParamRepository.deleteByDynamicTask(task.getId());
            this.dynamicTaskOperatorRepository.deleteByApplicationNameAndAppCodeAndTaskCode(task.getTaskCode(), this.appCode, applicationName);
            this.dynamicTaskSchedulerRepository.delete((Object)task);
        }
    }

    private DynamicTaskSchedulerVo findByTaskCodeAndApplicationNameAndAppCode(String taskCode, String applicationName, String appCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{taskCode, applicationName, appCode})) {
            return null;
        }
        DynamicTaskSchedulerEntity dynamicTask = this.dynamicTaskSchedulerRepository.findByTaskCodeAndApplicationNameAndAppCode(taskCode, applicationName, appCode);
        if (dynamicTask == null) {
            return null;
        }
        return (DynamicTaskSchedulerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dynamicTask, DynamicTaskSchedulerVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }
}

