/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.scheduler;

import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerVoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="_DynamicLoadingTask")
@Scope(value="prototype")
@Lazy
public class DynamicLoadingSchedulerTask
implements Runnable {
    private String appCode;
    private String applicationName;
    @Autowired
    private DynamicTaskSchedulerVoService dynamicTaskSchedulerVoService;

    public DynamicLoadingSchedulerTask(String appCode, String applicationName) {
        this.appCode = appCode;
        this.applicationName = applicationName;
    }

    @Override
    public void run() {
        try {
            Thread currentThread = Thread.currentThread();
            if (currentThread.isInterrupted()) {
                return;
            }
            this.dynamicTaskSchedulerVoService.loading(this.applicationName, this.appCode);
        }
        finally {
            TenantContextHolder.clean();
        }
    }
}

