/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.scheduler;

import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.IpUtils;
import com.bizunited.nebula.task.local.configuration.DynamicTaskProperties;
import com.bizunited.nebula.task.local.service.scheduler.DynamicLoadingSchedulerTask;
import com.bizunited.nebula.task.local.service.scheduler.DynamicNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="_DynamicMasterKeeperTask")
@Scope(value="prototype")
@Lazy
public class DynamicMasterKeeperTask
implements Runnable {
    private BlockingQueue<Pair<String, String>> taskQueue;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    @Qualifier(value="platform_dynamicTaskLoadingThreadScheduler")
    private ThreadPoolTaskScheduler dynamicTaskLoadingThreadScheduler;
    @Autowired
    @Qualifier(value="platform_dynamicTaskScheduler")
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;
    @Autowired
    private DynamicTaskProperties dynamicTaskProperties;
    private static volatile Map<String, ScheduledFuture<?>> preemptedKeyMapping = Maps.newLinkedHashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicMasterKeeperTask.class);

    public DynamicMasterKeeperTask(BlockingQueue<Pair<String, String>> taskQueue) {
        this.taskQueue = taskQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String currentApplicationName = this.dynamicTaskProperties.getApplicationName();
        Validate.notBlank((CharSequence)currentApplicationName, (String)"\u4e25\u91cd\u9519\u8bef\uff1a\u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u5e76\u672a\u6307\u5b9a\u7cfb\u7edf\u540d(spring.application.name)\uff0c\u8c03\u5ea6\u4efb\u52a1\u529f\u80fd\u5c06\u4e0d\u80fd\u6b63\u5e38\u5de5\u4f5c!!", (Object[])new Object[0]);
        String internalIp = IpUtils.findInternalIp();
        Validate.notBlank((CharSequence)internalIp, (String)"\u4e25\u91cd\u9519\u8bef\uff1a\u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u6ca1\u6709\u4efb\u4f55\u5185\u7f51IP\uff0c\u8c03\u5ea6\u4efb\u52a1\u529f\u80fd\u5c06\u4e0d\u80fd\u6b63\u5e38\u5de5\u4f5c!!", (Object[])new Object[0]);
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        String processName = runtimeBean.getName();
        DynamicNode dynamicNode = new DynamicNode();
        dynamicNode.setApplicationName(currentApplicationName);
        dynamicNode.setInternalIp(internalIp);
        dynamicNode.setProcessName(processName);
        try {
            int count = 0;
            ArrayList allDynamicTaskLockInfos = Lists.newArrayList();
            while (count++ < Integer.MAX_VALUE) {
                Object applicationName;
                Pair<String, String> pair = this.taskQueue.poll(1L, TimeUnit.SECONDS);
                if (pair != null) {
                    applicationName = (String)pair.getLeft();
                    String appCode = (String)pair.getRight();
                    boolean matched = false;
                    Iterator iterator = allDynamicTaskLockInfos.iterator();
                    while (iterator.hasNext()) {
                        Pair info = (Pair)iterator.next();
                        String applicationNameItem = (String)info.getLeft();
                        String appCodeItem = (String)info.getRight();
                        if (!StringUtils.equals((CharSequence)applicationNameItem, (CharSequence)applicationName) || !StringUtils.equals((CharSequence)appCodeItem, (CharSequence)appCode)) continue;
                        matched = true;
                        break;
                    }
                    LOGGER.debug("\u76ee\u524d applicationName = {} , appCodeItem = {} \u7684\u4efb\u52a1\u8fd0\u884c\u8bf7\u6c42\uff0c\u5728\u672c\u8282\u70b9\u7684\u5339\u914d\u60c5\u51b5\u662f\uff1a{}", new Object[]{applicationName, appCode, matched});
                    if (!matched) {
                        allDynamicTaskLockInfos.add(pair);
                    }
                }
                applicationName = allDynamicTaskLockInfos.iterator();
                while (applicationName.hasNext()) {
                    String appCode;
                    Pair info = (Pair)applicationName.next();
                    String applicationName2 = (String)info.getLeft();
                    String key = StringUtils.join((Object[])new String[]{applicationName2, "_", appCode = (String)info.getRight()});
                    String dynamicTaskLockKey = StringUtils.join((Object[])new String[]{key, "_", "REDIS_LOCK_KEY_DYNAMICTASK"});
                    if (this.redisMutexService.tryLock(dynamicTaskLockKey, TimeUnit.SECONDS, 10)) {
                        if (preemptedKeyMapping.get(key) == null) {
                            DynamicLoadingSchedulerTask dynamicLoadingSchedulerTask = (DynamicLoadingSchedulerTask)this.applicationContext.getBean(DynamicLoadingSchedulerTask.class, new Object[]{appCode, applicationName2});
                            LOGGER.debug("\u9488\u5bf9appCode[{}:{}]\u7684\u52a8\u6001\u4efb\u52a1\u626b\u63cf\u5668\u542f\u52a8========", (Object)applicationName2, (Object)appCode);
                            CronTrigger cronTrigger = new CronTrigger("0/30 * * * * ? ");
                            ScheduledFuture scheduledFuture = this.dynamicTaskLoadingThreadScheduler.schedule((Runnable)dynamicLoadingSchedulerTask, (Trigger)cronTrigger);
                            preemptedKeyMapping.put(key, scheduledFuture);
                        }
                        String mapName = "REDIS_KEY_DYNAMICTASK_NODE_MASTER";
                        String dynamicTaskMasterNodeKey = StringUtils.join((Object[])new String[]{key, "_", "REDIS_KEY_DYNAMICTASK_NODE_MASTER"});
                        String dynamicTaskMasterNodeValue = dynamicNode.toString();
                        this.redisMutexService.setMCode(mapName, dynamicTaskMasterNodeKey, dynamicTaskMasterNodeValue, 30000L);
                        continue;
                    }
                    if (preemptedKeyMapping.get(key) == null) continue;
                    LOGGER.debug("\u5f53\u524d\u5e94\u7528\u5e76\u6ca1\u6709\u83b7\u53d6\u5230\u6307\u5b9aappCode[{}:{}]\u7684\u52a8\u6001\u4efb\u52a1\u72ec\u5360\u64cd\u4f5c\u6743\uff0c\u9488\u5bf9appCode[{}:{}]\u7684\u52a8\u6001\u4efb\u52a1\u8c03\u5ea6\u5de5\u4f5c\u505c\u6b62 ========", (Object)applicationName2, (Object)appCode);
                    ScheduledFuture<?> scheduledFuture = preemptedKeyMapping.get(key);
                    scheduledFuture.cancel(true);
                    preemptedKeyMapping.remove(key);
                    this.threadPoolTaskScheduler.shutdown();
                }
            }
        }
        catch (InterruptedException e) {
            Collection<ScheduledFuture<?>> scheduledFutures;
            try {
                LOGGER.error(e.getMessage(), (Throwable)e);
                LOGGER.warn("==== \u51c6\u5907\u505c\u6b62DynamicTaskMasterKeeperTask\u4efb\u52a1");
                scheduledFutures = preemptedKeyMapping.values();
            }
            catch (Throwable throwable) {
                Collection<ScheduledFuture<?>> scheduledFutures2 = preemptedKeyMapping.values();
                if (!CollectionUtils.isEmpty(scheduledFutures2)) {
                    for (ScheduledFuture<?> scheduledFuture : scheduledFutures2) {
                        scheduledFuture.cancel(true);
                    }
                }
                Set<String> keys = preemptedKeyMapping.keySet();
                for (String key : keys) {
                    String lockKey = StringUtils.join((Object[])new String[]{key, "_", "REDIS_LOCK_KEY_DYNAMICTASK"});
                    this.redisMutexService.unlock(lockKey);
                }
                throw throwable;
            }
            if (!CollectionUtils.isEmpty(scheduledFutures)) {
                for (ScheduledFuture<?> scheduledFuture : scheduledFutures) {
                    scheduledFuture.cancel(true);
                }
            }
            Set<String> set = preemptedKeyMapping.keySet();
            for (String key : set) {
                String lockKey = StringUtils.join((Object[])new String[]{key, "_", "REDIS_LOCK_KEY_DYNAMICTASK"});
                this.redisMutexService.unlock(lockKey);
            }
            return;
        }
        Collection<ScheduledFuture<?>> scheduledFutures = preemptedKeyMapping.values();
        if (!CollectionUtils.isEmpty(scheduledFutures)) {
            for (ScheduledFuture scheduledFuture : scheduledFutures) {
                scheduledFuture.cancel(true);
            }
        }
        Set<String> keys = preemptedKeyMapping.keySet();
        for (String key : keys) {
            String lockKey = StringUtils.join((Object[])new String[]{key, "_", "REDIS_LOCK_KEY_DYNAMICTASK"});
            this.redisMutexService.unlock(lockKey);
        }
    }
}

