/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.scheduler;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.IpUtils;
import com.bizunited.nebula.task.local.configuration.DynamicTaskProperties;
import com.bizunited.nebula.task.local.service.scheduler.DynamicNode;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="_DynamicNodeKeeperTask")
@Scope(value="prototype")
@Lazy
public class DynamicNodeKeeperTask
implements Runnable {
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private DynamicTaskProperties dynamicTaskProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicNodeKeeperTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        Validate.notBlank((CharSequence)applicationName, (String)"\u4e25\u91cd\u9519\u8bef\uff1a\u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u5e76\u672a\u6307\u5b9a\u7cfb\u7edf\u540d(spring.application.name)\uff0c\u8c03\u5ea6\u4efb\u52a1\u529f\u80fd\u5c06\u4e0d\u80fd\u6b63\u5e38\u5de5\u4f5c!!", (Object[])new Object[0]);
        String internalIp = IpUtils.findInternalIp();
        Validate.notBlank((CharSequence)internalIp, (String)"\u4e25\u91cd\u9519\u8bef\uff1a\u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u6ca1\u6709\u4efb\u4f55\u5185\u7f51IP\uff0c\u8c03\u5ea6\u4efb\u52a1\u529f\u80fd\u5c06\u4e0d\u80fd\u6b63\u5e38\u5de5\u4f5c!!", (Object[])new Object[0]);
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        String processName = runtimeBean.getName();
        DynamicNode dynamicNode = new DynamicNode();
        dynamicNode.setApplicationName(applicationName);
        dynamicNode.setInternalIp(internalIp);
        dynamicNode.setProcessName(processName);
        String mapName = StringUtils.join((Object[])new String[]{applicationName, "_", "REDIS_KEY_DYNAMICTASK_NODE"});
        String mapKey = dynamicNode.toString();
        String mapVlaue = JSONObject.toJSONString((Object)dynamicNode);
        LOGGER.info("register dynamic task node\uff1a{}", (Object)mapVlaue);
        try {
            int count = 0;
            while (count++ < Integer.MAX_VALUE) {
                this.redisMutexService.setMCode(mapName, mapKey, mapVlaue, 10000L);
                DynamicNodeKeeperTask dynamicNodeKeeperTask = this;
                synchronized (dynamicNodeKeeperTask) {
                    this.wait(5000L);
                }
            }
            return;
        }
        catch (InterruptedException | RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            LOGGER.warn("==== \u51c6\u5907\u505c\u6b62DynamicNodeKeeperTask\u4efb\u52a1");
            return;
        }
        finally {
            this.redisMutexService.removeMCode(mapName, mapKey);
        }
    }
}

