/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.scheduler;

import com.bizunited.nebula.task.local.service.DynamicTaskShardingService;
import com.bizunited.nebula.task.service.security.IndependencySecurity;
import com.bizunited.nebula.task.service.strategy.DynamicTaskShardingRequestStrategy;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="_DynamicShardingActivateTask")
@Scope(value="prototype")
@Lazy
public class DynamicShardingActivateTask
implements Runnable {
    @Autowired
    private DynamicTaskShardingRequestStrategy dynamicTaskShardingRequestStrategy;
    @Autowired
    private DynamicTaskShardingService dynamicTaskShardingService;
    @Autowired(required=false)
    private IndependencySecurity independencySecurity;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicShardingActivateTask.class);
    private DynamicTaskSchedulerVo currentTask;

    public DynamicShardingActivateTask(DynamicTaskSchedulerVo currentTask) {
        this.currentTask = currentTask;
    }

    @Override
    public void run() {
        try {
            if (this.independencySecurity != null) {
                this.independencySecurity.independency(this.currentTask, this.currentTask.getTaskCode(), this.currentTask.getAppCode(), this.currentTask.getApplicationName());
            } else {
                LOGGER.warn("\u52a8\u6001\u4efb\u52a1\u6a21\u5757\u8bd5\u56fe\u627e\u5230\u6b63\u786e\u7684\u6267\u884c\u8005\u8eab\u4efd\uff0c\u4f46\u662f\u6ca1\u6709\u53d1\u73b0independencySecurity\u63a5\u53e3\u7684\u5b9e\u73b0!!");
            }
            Boolean existShardingTask = this.dynamicTaskShardingService.existShardingTask(this.currentTask.getApplicationName(), this.currentTask.getAppCode(), this.currentTask.getTaskCode());
            if (Boolean.TRUE.equals(existShardingTask)) {
                LOGGER.warn("\u52a8\u6001\u4efb\u52a1[{}],\u5728\u5176\u4ed6\u5206\u7247\u8282\u70b9\u4e2d\u6b63\u5728\u6267\u884c,\u6b64\u6b21\u6267\u884c\u5c06\u88ab\u8df3\u8fc7", (Object)this.currentTask.getTaskCode());
                return;
            }
            this.dynamicTaskShardingRequestStrategy.doRequest(this.currentTask);
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u52a8\u6001\u4efb\u52a1[%s],\u5206\u7247\u8282\u70b9\u8c03\u7528\u65f6\u53d1\u751f\u9519\u8bef", this.currentTask.getTaskCode()), (Throwable)e);
        }
    }
}

