/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.scheduler;

import com.bizunited.nebula.task.local.service.DynamicTaskShardingService;
import com.bizunited.nebula.task.local.service.scheduler.DynamicTask;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="_DynamicShardingTask")
@Scope(value="prototype")
@Lazy
public class DynamicShardingTask
extends DynamicTask {
    @Autowired
    private DynamicTaskShardingService dynamicTaskShardingService;
    private DynamicTaskSchedulerVo currentTask;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicShardingTask.class);

    public DynamicShardingTask(DynamicTaskSchedulerVo currentTask) {
        super(currentTask);
        this.currentTask = currentTask;
    }

    @Override
    public void run() {
        try {
            LOGGER.info("\u5e94\u7528\u7a0b\u5e8f[{}]\u79df\u6237[{}]\u5206\u7247\u5b9a\u65f6\u4efb\u52a1[{}]\u6267\u884c...", new Object[]{this.currentTask.getApplicationName(), this.currentTask.getAppCode(), this.currentTask.getTaskCode()});
            super.run();
        }
        catch (Exception e) {
            LOGGER.info("\u5e94\u7528\u7a0b\u5e8f[{}]\u79df\u6237[{}]\u5206\u7247\u5b9a\u65f6\u4efb\u52a1[{}]\u6267\u884c\u9519\u8bef", new Object[]{this.currentTask.getApplicationName(), this.currentTask.getAppCode(), this.currentTask.getTaskCode(), e});
        }
        finally {
            this.dynamicTaskShardingService.deleteShardingTask(this.currentTask.getApplicationName(), this.currentTask.getAppCode(), this.currentTask.getTaskCode());
        }
    }
}

