/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.scheduler;

import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.common.vo.SimpleTenantInfo;
import com.bizunited.nebula.script.exception.InvokeProxyException;
import com.bizunited.nebula.script.service.ScriptVoService;
import com.bizunited.nebula.script.vo.ScriptVo;
import com.bizunited.nebula.task.local.configuration.DynamicTaskProperties;
import com.bizunited.nebula.task.local.entity.DynamicTaskSchedulerEntity;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerLogVoService;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerVoService;
import com.bizunited.nebula.task.service.security.IndependencySecurity;
import com.bizunited.nebula.task.vo.DynamicTaskParamVo;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerLogVo;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="_DynamicTask")
@Scope(value="prototype")
@Lazy
public class DynamicTask
implements Runnable {
    private DynamicTaskSchedulerVo currentTask;
    @Autowired
    private DynamicTaskSchedulerVoService dynamicTaskSchedulerVoService;
    @Autowired
    private DynamicTaskSchedulerLogVoService dynamicTaskSchedulerLogVoService;
    @Autowired
    private ScriptVoService scriptService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DynamicTaskProperties dynamicTaskProperties;
    @Autowired(required=false)
    private IndependencySecurity independencySecurity;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTask.class);

    public DynamicTask(DynamicTaskSchedulerVo currentTask) {
        this.currentTask = currentTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean success = false;
        Date endTime = null;
        Date startTime = new Date();
        String errorContents = null;
        String errorSummary = null;
        String appCode = this.currentTask.getAppCode();
        String taskCode = this.currentTask.getTaskCode();
        String applicationName = this.dynamicTaskProperties.getApplicationName();
        String startLogId = this.recordStartLog(startTime);
        try {
            Integer invokeType = this.currentTask.getInvokeType();
            SimpleTenantInfo simpleTenantInfo = new SimpleTenantInfo(appCode);
            TenantContextHolder.setTenantInfo((AbstractTenantInfo)simpleTenantInfo);
            if (this.independencySecurity != null) {
                this.independencySecurity.independency(this.currentTask, taskCode, appCode, applicationName);
            } else {
                LOGGER.warn("\u52a8\u6001\u4efb\u52a1\u6a21\u5757\u8bd5\u56fe\u627e\u5230\u6b63\u786e\u7684\u6267\u884c\u8005\u8eab\u4efd\uff0c\u4f46\u662f\u6ca1\u6709\u53d1\u73b0independencySecurity\u63a5\u53e3\u7684\u5b9e\u73b0!!");
            }
            if (invokeType == 1) {
                this.invokeGroovyScript(this.currentTask);
            } else if (invokeType == 2) {
                this.invokeAnnMethod(this.currentTask);
            } else if (invokeType == 3) {
                this.invokeDynamicMethod(this.currentTask);
            } else {
                throw new NoSuchBeanDefinitionException(DynamicTaskSchedulerEntity.class);
            }
            endTime = new Date();
            success = true;
        }
        catch (InvokeProxyException | RuntimeException e) {
            errorSummary = e.getMessage();
            endTime = new Date();
            success = false;
            errorContents = this.readErrorContent(e);
            LOGGER.error(errorContents, e);
        }
        finally {
            this.updateInvokeType(this.currentTask);
            SecurityContextHolder.clearContext();
            this.recordEndLog(startLogId, startTime, endTime, errorSummary, errorContents, success);
            TenantContextHolder.clean();
        }
    }

    private String recordStartLog(Date startTime) {
        try {
            DynamicTaskSchedulerLogVo dynamicTaskSchedulerLog = new DynamicTaskSchedulerLogVo();
            dynamicTaskSchedulerLog.setStartTime(startTime);
            dynamicTaskSchedulerLog.setAppCode(this.currentTask.getAppCode());
            dynamicTaskSchedulerLog.setApplicationName(this.dynamicTaskProperties.getApplicationName());
            dynamicTaskSchedulerLog.setDynamicTaskId(this.currentTask.getId());
            dynamicTaskSchedulerLog.setTaskCode(this.currentTask.getTaskCode());
            dynamicTaskSchedulerLog.setTaskDesc(this.currentTask.getTaskDesc());
            dynamicTaskSchedulerLog.setState("10");
            DynamicTaskSchedulerLogVo schedulerLogVo = this.dynamicTaskSchedulerLogVoService.create(dynamicTaskSchedulerLog);
            return schedulerLogVo.getId();
        }
        catch (Exception e) {
            LOGGER.error("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u65e5\u5fd7\u521b\u5efa\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private void recordEndLog(String startLogId, Date startTime, Date endTime, String errorSummary, String errorContents, Boolean success) {
        DynamicTaskSchedulerLogVo dynamicTaskSchedulerLog = new DynamicTaskSchedulerLogVo();
        dynamicTaskSchedulerLog.setEndTime(endTime);
        dynamicTaskSchedulerLog.setStartTime(startTime);
        dynamicTaskSchedulerLog.setId(startLogId);
        dynamicTaskSchedulerLog.setAppCode(this.currentTask.getAppCode());
        dynamicTaskSchedulerLog.setApplicationName(this.dynamicTaskProperties.getApplicationName());
        dynamicTaskSchedulerLog.setDynamicTaskId(this.currentTask.getId());
        dynamicTaskSchedulerLog.setTaskCode(this.currentTask.getTaskCode());
        dynamicTaskSchedulerLog.setTaskDesc(this.currentTask.getTaskDesc());
        dynamicTaskSchedulerLog.setSuccess(success);
        dynamicTaskSchedulerLog.setState("20");
        if (!success.booleanValue()) {
            dynamicTaskSchedulerLog.setState("30");
            dynamicTaskSchedulerLog.setErrorSummary(errorSummary);
            dynamicTaskSchedulerLog.setErrorContents(errorContents);
        }
        this.dynamicTaskSchedulerLogVoService.createOrModify(dynamicTaskSchedulerLog);
    }

    private String readErrorContent(Throwable e) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] byteContext = null;
        try (PrintWriter printWriter = new PrintWriter(outStream);){
            e.printStackTrace(printWriter);
            printWriter.flush();
            byteContext = outStream.toByteArray();
        }
        return StringUtils.toEncodedString((byte[])byteContext, (Charset)Charset.forName("utf-8"));
    }

    private void updateInvokeType(DynamicTaskSchedulerVo currentTask) {
        Integer taskType = currentTask.getTaskType();
        if (taskType == 1 && !Boolean.TRUE.equals(currentTask.getExecuteNow())) {
            this.dynamicTaskSchedulerVoService.stop(new String[]{currentTask.getTaskCode()});
        }
    }

    private void invokeGroovyScript(DynamicTaskSchedulerVo currentTask) throws InvokeProxyException {
        String scriptName = currentTask.getScriptName();
        ScriptVo scriptVo = this.scriptService.findByName(scriptName);
        Validate.notNull((Object)scriptVo, (String)"\u5728\u8fdb\u884c\u52a8\u6001\u4efb\u52a1\u6267\u884c\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684groovy\u811a\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5%s!", (Object[])new Object[]{currentTask.getId()});
        String scriptId = scriptVo.getId();
        HashMap params = Maps.newHashMap();
        params.put("ctx", this.applicationContext);
        params.put("task", currentTask);
        this.scriptService.invoke(new String[]{scriptId}, (Map)params);
    }

    private void invokeAnnMethod(DynamicTaskSchedulerVo currentTask) throws InvokeProxyException {
        String taskCode = currentTask.getTaskCode();
        String invokeBeanName = currentTask.getInvokeBeanName();
        Validate.notBlank((CharSequence)invokeBeanName, (String)"\u6267\u884c\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6\uff0c\u53d1\u73b0\u57fa\u4e8eDynamicTaskService\u6ce8\u89e3\u7684\u52a8\u6001\u6267\u884c\u4efb\u52a1%s\uff0c\u5176invokeBeanName\u4fe1\u606f\u975e\u6cd5", (Object[])new Object[]{taskCode});
        String invokeMethod = currentTask.getInvokeMethod();
        Validate.notBlank((CharSequence)invokeMethod, (String)"\u6267\u884c\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6\uff0c\u53d1\u73b0\u57fa\u4e8eDynamicTaskService\u6ce8\u89e3\u7684\u52a8\u6001\u6267\u884c\u4efb\u52a1%s\uff0c\u5176invokeMethod\u4fe1\u606f\u975e\u6cd5", (Object[])new Object[]{taskCode});
        Object currentBean = null;
        try {
            currentBean = this.applicationContext.getBean(invokeBeanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IllegalArgumentException(String.format("\u6267\u884c\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6\uff0c\u672a\u53d1\u73b0\u540d\u4e3a%s\u7684spring bean\uff0c\u8bf7\u68c0\u67e5", invokeBeanName));
        }
        Class beanClass = this.applicationContext.getType(invokeBeanName);
        Method beanClassMethod = null;
        try {
            beanClassMethod = beanClass.getMethod(invokeMethod, new Class[0]);
            beanClassMethod.invoke(currentBean, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("\u6267\u884c\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6\uff0c\u672a\u53d1\u73b0\u540d\u4e3a%s\u7684spring bean\u4e2d\u6307\u5b9a\u7684\u65b9\u6cd5%s\uff0c\u8bf7\u68c0\u67e5", invokeBeanName, invokeMethod));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("\u6267\u884c\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6,\u65b9\u6cd5\u6267\u884c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", e);
        }
    }

    private void invokeDynamicMethod(DynamicTaskSchedulerVo currentTask) {
        String taskCode = currentTask.getTaskCode();
        String invokeBeanName = currentTask.getInvokeBeanName();
        Validate.notBlank((CharSequence)invokeBeanName, (String)"\u6267\u884c\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6\uff0c\u53d1\u73b0\u5168\u52a8\u6001\u4efb\u52a1%s\uff0c\u5176invokeBeanName\u4fe1\u606f\u975e\u6cd5", (Object[])new Object[]{taskCode});
        String invokeMethod = currentTask.getInvokeMethod();
        Validate.notBlank((CharSequence)invokeMethod, (String)"\u6267\u884c\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6\uff0c\u53d1\u73b0\u5168\u52a8\u6001\u4efb\u52a1%s\uff0c\u5176invokeMethod\u4fe1\u606f\u975e\u6cd5", (Object[])new Object[]{taskCode});
        Object currentBean = null;
        try {
            currentBean = this.applicationContext.getBean(invokeBeanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IllegalArgumentException(String.format("\u6267\u884c\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6\uff0c\u672a\u53d1\u73b0\u540d\u4e3a%s\u7684spring bean\uff0c\u8bf7\u68c0\u67e5", invokeBeanName));
        }
        Class beanClass = this.applicationContext.getType(invokeBeanName);
        Method beanClassMethod = null;
        try {
            List params = currentTask.getParams();
            if (!CollectionUtils.isEmpty((Collection)params)) {
                Object[] values = params.stream().map(DynamicTaskParamVo::getParamValue).toArray(Object[]::new);
                Class[] classes = (Class[])params.stream().map(DynamicTaskParamVo::getParamType).toArray(Class[]::new);
                beanClassMethod = beanClass.getMethod(invokeMethod, classes);
                beanClassMethod.invoke(currentBean, values);
            } else {
                beanClassMethod = beanClass.getMethod(invokeMethod, new Class[0]);
                beanClassMethod.invoke(currentBean, new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("\u6267\u884c\u5168\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6\uff0c\u672a\u53d1\u73b0\u540d\u4e3a%s\u7684spring bean\u4e2d\u6307\u5b9a\u7684\u65b9\u6cd5%s\uff0c\u8bf7\u68c0\u67e5", invokeBeanName, invokeMethod));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("\u6267\u884c\u5168\u52a8\u6001\u8c03\u7528\u4efb\u52a1\u65f6\uff0c\u65b9\u6cd5\u6267\u884c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", e);
        }
    }
}

