/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.task.local.service.strategy;

import com.alibaba.fastjson.JSON;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.security.sdk.AuthenticationJwtTokenService;
import com.bizunited.nebula.task.dto.DynamicTaskShardingDto;
import com.bizunited.nebula.task.local.configuration.DynamicTaskProperties;
import com.bizunited.nebula.task.service.strategy.DynamicTaskShardingRequestStrategy;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component(value="_DefaultDynamicTaskShardingRequestStrategy")
public class DefaultDynamicTaskShardingRequestStrategy
implements DynamicTaskShardingRequestStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDynamicTaskShardingRequestStrategy.class);
    private static final String SHARDING_EXECUTE_URL_PATH = "/v1/task/dynamicTaskSharding/executeShardingTask";
    @Autowired(required=false)
    private LoadBalancerClient loadBalancerClient;
    @Autowired
    private DynamicTaskProperties dynamicTaskProperties;
    @Autowired
    private AuthenticationJwtTokenService authenticationJwtTokenService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ApplicationContext applicationContext;
    private final RestTemplate restTemplate = new RestTemplate();

    public void doRequest(DynamicTaskSchedulerVo currentTask) {
        Environment environment = this.applicationContext.getEnvironment();
        String nacosServiceId = environment.getProperty("spring.cloud.nacos.discovery.service");
        String contextPath = environment.getProperty("server.servlet.context-path");
        Validate.notNull((Object)this.loadBalancerClient, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u6240\u5728\u6ce8\u518c\u4e2d\u5fc3\u4fe1\u606f,\u8bf7\u68c0\u67e5\u5e94\u7528\u662f\u5426\u5df2\u6ce8\u5165\u6ce8\u518c\u4e2d\u5fc3!", (Object[])new Object[0]);
        String serviceId = this.dynamicTaskProperties.getServiceId();
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            serviceId = nacosServiceId;
        }
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            serviceId = this.dynamicTaskProperties.getApplicationName();
        }
        Validate.notBlank((CharSequence)serviceId, (String)"\u65e0\u6cd5\u627e\u5230\u5f53\u524d\u5e94\u7528\u5728\u6ce8\u518c\u4e2d\u5fc3\u670d\u52a1\u540d", (Object[])new Object[0]);
        ServiceInstance serviceInstance = this.loadBalancerClient.choose(serviceId);
        Validate.notNull((Object)serviceInstance, (String)"\u65e0\u6cd5\u627e\u5230\u670d\u52a1\u540d[%s]\u5728\u6ce8\u518c\u4e2d\u5fc3\u7684\u8282\u70b9\u4fe1\u606f", (Object[])new Object[]{serviceId});
        String jwt = this.authenticationJwtTokenService.rebuildJwt();
        HttpHeaders headers = new HttpHeaders();
        headers.add("jwt", jwt);
        headers.add("Content-Type", "application/json");
        DynamicTaskShardingDto shardingDto = (DynamicTaskShardingDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentTask, DynamicTaskShardingDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        HttpEntity requestEntity = new HttpEntity((Object)shardingDto, (MultiValueMap)headers);
        LOGGER.info("\u5e94\u7528\u7a0b\u5e8f[{}]\u79df\u6237[{}]\u5206\u7247\u5b9a\u65f6\u4efb\u52a1[{}]\u53d1\u8d77\u6267\u884c\u8bf7\u6c42", new Object[]{currentTask.getApplicationName(), currentTask.getAppCode(), currentTask.getTaskCode()});
        String url = String.format("%s%s%s", serviceInstance.getUri(), contextPath, SHARDING_EXECUTE_URL_PATH);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, ResponseModel.class, new Object[0]);
        ResponseModel responseModel = (ResponseModel)responseEntity.getBody();
        Validate.notNull((Object)responseModel, (String)"\u8bf7\u6c42\u5b9a\u65f6\u4efb\u52a1\u5206\u7247\u5f02\u5e38", (Object[])new Object[0]);
        Validate.isTrue((boolean)responseModel.getSuccess(), (String)"\u8bf7\u6c42\u5b9a\u65f6\u4efb\u52a1\u5206\u7247\u53d1\u751f\u9519\u8bef:%s", (Object[])new Object[]{ObjectUtils.defaultIfNull((Object)responseModel.getErrorMsg(), (Object)"\u672a\u77e5")});
        LOGGER.info("\u5e94\u7528\u7a0b\u5e8f[{}]\u79df\u6237[{}]\u5206\u7247\u5b9a\u65f6\u4efb\u52a1[{}]\u53d1\u8d77\u6267\u884c\u7ed3\u679c{}", new Object[]{currentTask.getApplicationName(), currentTask.getAppCode(), currentTask.getTaskCode(), JSON.toJSONString((Object)responseModel)});
    }
}

