/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.util.tenant;

import com.bizunited.nebula.common.configuration.SimpleTenantProperties;
import com.bizunited.nebula.common.event.RequestTenantInfoEventListener;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.common.vo.SimpleTenantInfo;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class TenantContextHolder
implements ApplicationContextAware {
    private static final ThreadLocal<AbstractTenantInfo> THREAD_LOCAL = new ThreadLocal();
    private static ApplicationContext applicationContext;

    public static void clean() {
        THREAD_LOCAL.remove();
    }

    public static void setTenantInfo(AbstractTenantInfo tenantInfo) {
        if (tenantInfo != null) {
            THREAD_LOCAL.set(tenantInfo);
        }
    }

    public static AbstractTenantInfo getTenantInfo() {
        if (applicationContext == null) {
            return new SimpleTenantInfo("default");
        }
        if (THREAD_LOCAL.get() != null) {
            return THREAD_LOCAL.get();
        }
        RequestTenantInfoEventListener requestTenantInfoEventListener = (RequestTenantInfoEventListener)applicationContext.getBean(RequestTenantInfoEventListener.class);
        Validate.notNull((Object)requestTenantInfoEventListener, (String)"RequestTenantInfoEventListener is null\uff0c please check", (Object[])new Object[0]);
        AbstractTenantInfo abstractTenantInfo = requestTenantInfoEventListener.onBuildTenantInfo();
        SimpleTenantProperties simpleTenantProperties = (SimpleTenantProperties)BeanUtils.instantiateClass(SimpleTenantProperties.class);
        if (abstractTenantInfo == null && simpleTenantProperties.getUseDefaultTenantCode().booleanValue()) {
            abstractTenantInfo = new SimpleTenantInfo(simpleTenantProperties.getDefaultTenantCode());
        } else if (abstractTenantInfo == null) {
            Validate.notNull((Object)abstractTenantInfo, (String)"tenant info is null , please check!", (Object[])new Object[0]);
        }
        THREAD_LOCAL.set(abstractTenantInfo);
        return abstractTenantInfo;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        TenantContextHolder.applicationContext = applicationContext;
    }
}

