/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.config;

import java.lang.reflect.Field;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.spring.web.plugins.WebMvcRequestHandlerProvider;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@Configuration
@EnableSwagger2WebMvc
public class SwaggerConfig {
    @Value(value="${knife4j.title:crm\u63a5\u53e3\u6587\u6863}")
    private String title;
    @Value(value="${knife4j.description:\u63a5\u53e3\u6587\u6863\u63cf\u8ff0}")
    private String description;
    @Value(value="${knife4j.version:3.0}")
    private String version;
    @Value(value="${knife4j.enable:true}")
    private Boolean enabled;
    @Value(value="${knife4j.swagger-package:com}")
    private String swaggerPackage;
    @Value(value="${knife4j.contact.name:crm}")
    private String contactName;
    @Value(value="${knife4j.contact.url:www.xxx.com}")
    private String contactUrl;
    @Value(value="${knife4j.contact.email:CRM@163.com}")
    private String contactEmail;

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).enable(this.enabled.booleanValue()).apiInfo(this.apiInfo()).pathMapping("/").select().apis(RequestHandlerSelectors.basePackage((String)this.swaggerPackage)).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.title).description(this.description).contact(new Contact(this.contactName, this.contactUrl, this.contactEmail)).version(this.version).build();
    }

    @Bean
    public static BeanPostProcessor springfoxHandlerProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof WebMvcRequestHandlerProvider) {
                    this.customizeHandlerMappings(this.getHandlerMappings(bean));
                }
                return bean;
            }

            private void customizeHandlerMappings(List<RequestMappingInfoHandlerMapping> mappings) {
                mappings.removeIf(mapping -> mapping.getPatternParser() != null);
            }

            private List<RequestMappingInfoHandlerMapping> getHandlerMappings(Object bean) {
                try {
                    Field field = ReflectionUtils.findField(bean.getClass(), (String)"handlerMappings");
                    field.setAccessible(true);
                    return (List)field.get(bean);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }
}

