/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.service;

import com.alibaba.fastjson.JSON;
import com.bizunited.nebula.common.service.CopyObjectCallback;
import com.bizunited.nebula.common.service.ProductValidateService;
import com.bizunited.nebula.common.service.async.AsyncTask;
import com.bizunited.nebula.common.service.async.AsyncTaskRunnable;
import com.bizunited.nebula.common.service.async.AsyncThreadHandler;
import com.bizunited.nebula.common.util.TStringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.core.Converter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="nebulaToolkitService")
public class NebulaToolkitService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NebulaToolkitService.class);
    @Autowired(required=false)
    @Lazy
    private Set<CopyObjectCallback> copyObjectCallbacks;
    @Autowired
    private ProductValidateService productValidateService;
    @Autowired
    @Qualifier(value="_asyncTaskExecutor")
    private ExecutorService executorService;
    @Autowired
    private ApplicationContext applicationContext;

    public NebulaToolkitService() {
    }

    public NebulaToolkitService(Set<CopyObjectCallback> copyObjectCallbacks) {
        this.copyObjectCallbacks = copyObjectCallbacks;
    }

    public <T, R> Set<R> collectionDiffent(Collection<T> targetCollections, Collection<T> resouceCollections, Function<T, R> function) {
        if (this.productValidateService != null) {
            this.productValidateService.validate();
        }
        Set<Object> currentTargetCollections = new HashSet();
        Set<Object> currentResouceCollections = new HashSet();
        if (targetCollections != null && !targetCollections.isEmpty()) {
            currentTargetCollections = targetCollections.stream().map(function).collect(Collectors.toSet());
        }
        if (resouceCollections != null && !resouceCollections.isEmpty()) {
            currentResouceCollections = resouceCollections.stream().map(function).collect(Collectors.toSet());
        }
        return Sets.difference(currentTargetCollections, currentResouceCollections);
    }

    public <T, R> Set<R> collectionIntersection(Collection<T> targetCollections, Collection<T> resouceCollections, Function<T, R> function) {
        if (this.productValidateService != null) {
            this.productValidateService.validate();
        }
        Set<Object> currentTargetCollections = new HashSet();
        Set<Object> currentResouceCollections = new HashSet();
        if (targetCollections != null && !targetCollections.isEmpty()) {
            currentTargetCollections = targetCollections.stream().map(function).collect(Collectors.toSet());
        }
        if (resouceCollections != null && !resouceCollections.isEmpty()) {
            currentResouceCollections = resouceCollections.stream().map(function).collect(Collectors.toSet());
        }
        return Sets.intersection(currentTargetCollections, currentResouceCollections);
    }

    public <T, E> void collectionDiscrepancy(Collection<E> currentCollections, Collection<E> referenceCollections, Function<E, T> function, Collection<E> deleteCollections, Collection<E> updateCollections, Collection<E> createCollections) {
        Set updateIds;
        if (this.productValidateService != null) {
            this.productValidateService.validate();
        }
        Validate.notNull(currentCollections, (String)"\u5f53\u524d\u8fdb\u884cCUD\u64cd\u4f5c\u7c7b\u578b\u62c6\u5206\u7684\u539f\u59cb\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notNull(function, (String)"\u6307\u5b9a\u7684\u53c2\u7167\u51fd\u6570\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notNull(deleteCollections, (String)"\u62c6\u5206\u5206\u6790\u5b8c\u6210\u540e\uff0c\u7528\u4e8e\u627f\u88c5\u201c\u5220\u9664\u6570\u636e\u201d\u7684\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notNull(updateCollections, (String)"\u62c6\u5206\u5206\u6790\u5b8c\u6210\u540e\uff0c\u7528\u4e8e\u627f\u88c5\u201c\u4fee\u6539\u6570\u636e\u201d\u7684\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notNull(createCollections, (String)"\u62c6\u5206\u5206\u6790\u5b8c\u6210\u540e\uff0c\u7528\u4e8e\u627f\u88c5\u201c\u65b0\u589e\u6570\u636e\u201d\u7684\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.isTrue((referenceCollections.stream().filter(item -> {
            Object result = function.apply(item);
            if (result == null) {
                return true;
            }
            return result instanceof String && StringUtils.isBlank((CharSequence)((String)result));
        }).count() == 0L ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u62c6\u5206\u5206\u6790\u65f6\uff0c\u53c2\u7167\u96c6\u5408referenceCollections\u4e2d\u5404\u5143\u7d20\u9488\u5bf9\u51fd\u6570\u5f0f[function]\u7684\u8fd4\u56de\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set deleteIds = this.collectionDiffent(referenceCollections, currentCollections, function);
        if (deleteIds != null) {
            List deleteResult = referenceCollections.stream().filter(currentItem -> deleteIds.contains(function.apply(currentItem))).collect(Collectors.toList());
            deleteCollections.addAll(deleteResult);
        }
        if ((updateIds = this.collectionIntersection(currentCollections, referenceCollections, function)) != null) {
            List updateResult = referenceCollections.stream().filter(currentItem -> updateIds.contains(function.apply(currentItem))).collect(Collectors.toList());
            updateCollections.addAll(updateResult);
        }
        List createResult1 = currentCollections.stream().filter(item -> {
            Object result = function.apply(item);
            if (result == null) {
                return true;
            }
            return result instanceof String && StringUtils.isBlank((CharSequence)((String)result));
        }).collect(Collectors.toList());
        Set createIds = this.collectionDiffent(currentCollections, referenceCollections, function);
        List createResult2 = null;
        if (createIds != null) {
            createResult2 = currentCollections.stream().filter(currentItem -> createIds.contains(function.apply(currentItem))).collect(Collectors.toList());
        }
        if (createResult1 != null) {
            createCollections.addAll(createResult1);
        }
        if (createResult2 != null) {
            createCollections.addAll(createResult2);
        }
    }

    public <T> T copyObjectByWhiteList(Object sourceObject, Class<T> targetClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, String ... propertiesFilter) {
        if (this.productValidateService != null) {
            this.productValidateService.validate();
        }
        if (Objects.isNull(sourceObject)) {
            return null;
        }
        Validate.notNull(targetClass, (String)"\u8fdb\u884c\u62f7\u8d1d\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u76ee\u6807\u7c7b\u578b!!", (Object[])new Object[0]);
        Class<?> sourceClass = sourceObject.getClass();
        T targetObject = null;
        try {
            BeanCopier copier = BeanCopier.create(sourceClass, targetClass, (boolean)true);
            PropertyConverterByWhite propertyConverter = new PropertyConverterByWhite(targetClass, setCollectionClass == null ? LinkedHashSet.class : setCollectionClass, listCollectionClass == null ? ArrayList.class : listCollectionClass, propertiesFilter);
            targetObject = targetClass.newInstance();
            copier.copy(sourceObject, targetObject, (Converter)propertyConverter);
            this.doCallback(sourceClass, Lists.newArrayList((Object[])new Object[]{sourceObject}), targetClass, Lists.newArrayList((Object[])new Object[]{targetObject}));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        return targetObject;
    }

    public <S, T> Collection<T> copyCollectionByWhiteList(Iterable<S> sourceCollections, Class<S> sourceClass, Class<T> targetClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, String ... propertiesFilter) {
        if (this.productValidateService != null) {
            this.productValidateService.validate();
        }
        if (Objects.isNull(sourceCollections)) {
            return null;
        }
        Validate.notNull(targetClass, (String)"\u8fdb\u884c\u62f7\u8d1d\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u76ee\u6807\u7c7b\u578b!!", (Object[])new Object[0]);
        Collection targetCollection = null;
        try {
            targetCollection = Set.class.isAssignableFrom(sourceCollections.getClass()) ? (Collection)setCollectionClass.newInstance() : (Collection)listCollectionClass.newInstance();
            BeanCopier copier = BeanCopier.create(sourceClass, targetClass, (boolean)true);
            PropertyConverterByWhite propertyConverter = new PropertyConverterByWhite(targetClass, setCollectionClass == null ? LinkedHashSet.class : setCollectionClass, listCollectionClass == null ? ArrayList.class : listCollectionClass, propertiesFilter);
            ArrayList sourceObjects = Lists.newArrayList();
            ArrayList targetObjects = Lists.newArrayList();
            for (S item : sourceCollections) {
                T targetItem = targetClass.newInstance();
                copier.copy(item, targetItem, (Converter)propertyConverter);
                targetCollection.add(targetItem);
                sourceObjects.add(item);
                targetObjects.add(targetItem);
            }
            this.doCallback(sourceClass, sourceObjects, targetClass, targetObjects);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        return targetCollection;
    }

    public <T> T copyObjectByBlankList(Object sourceObject, Class<T> targetClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, String ... propertiesFilter) {
        if (this.productValidateService != null) {
            this.productValidateService.validate();
        }
        if (Objects.isNull(sourceObject)) {
            return null;
        }
        Validate.notNull(targetClass, (String)"\u8fdb\u884c\u62f7\u8d1d\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u76ee\u6807\u7c7b\u578b!!", (Object[])new Object[0]);
        Class<?> sourceClass = sourceObject.getClass();
        T targetObject = null;
        try {
            BeanCopier copier = BeanCopier.create(sourceClass, targetClass, (boolean)true);
            PropertyConverterByBlank propertyConverter = new PropertyConverterByBlank(targetClass, setCollectionClass == null ? LinkedHashSet.class : setCollectionClass, listCollectionClass == null ? ArrayList.class : listCollectionClass, propertiesFilter);
            targetObject = targetClass.newInstance();
            copier.copy(sourceObject, targetObject, (Converter)propertyConverter);
            this.doCallback(sourceClass, Lists.newArrayList((Object[])new Object[]{sourceObject}), targetClass, Lists.newArrayList((Object[])new Object[]{targetObject}));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        return targetObject;
    }

    public <S, T> Collection<T> copyCollectionByBlankList(Iterable<S> sourceCollections, Class<S> sourceClass, Class<T> targetClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, String ... propertiesFilter) {
        if (this.productValidateService != null) {
            this.productValidateService.validate();
        }
        if (Objects.isNull(sourceCollections)) {
            return null;
        }
        Validate.notNull(targetClass, (String)"\u8fdb\u884c\u62f7\u8d1d\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u76ee\u6807\u7c7b\u578b!!", (Object[])new Object[0]);
        Collection targetCollection = null;
        try {
            targetCollection = Set.class.isAssignableFrom(sourceCollections.getClass()) ? (Collection)setCollectionClass.newInstance() : (Collection)listCollectionClass.newInstance();
            BeanCopier copier = BeanCopier.create(sourceClass, targetClass, (boolean)true);
            PropertyConverterByBlank propertyConverter = new PropertyConverterByBlank(targetClass, setCollectionClass == null ? LinkedHashSet.class : setCollectionClass, listCollectionClass == null ? ArrayList.class : listCollectionClass, propertiesFilter);
            ArrayList sourceObjects = Lists.newArrayList();
            ArrayList targetObjects = Lists.newArrayList();
            for (S item : sourceCollections) {
                T targetItem = targetClass.newInstance();
                copier.copy(item, targetItem, (Converter)propertyConverter);
                targetCollection.add(targetItem);
                sourceObjects.add(item);
                targetObjects.add(targetItem);
            }
            this.doCallback(sourceClass, sourceObjects, targetClass, targetObjects);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        return targetCollection;
    }

    public void async(AsyncTaskRunnable asyncTaskRunnable) {
        Validate.notNull((Object)this.executorService, (String)"\u8be5nebula\u5de5\u5177\u7c7bNebulaToolkitService\uff0c\u5e76\u6ca1\u6709\u88ab\u7a0b\u5e8f\u5458\u901a\u8fc7IOC\u5bb9\u5668\u7684\u65b9\u5f0f\u8fdb\u884c\u6ce8\u5165\u4f7f\u7528\uff0c\u65e0\u6cd5\u63d0\u4f9b\u5f02\u6b65\u4efb\u52a1\u670d\u52a1\u3002\u8bf7\u901a\u8fc7IOC\u5bb9\u5668\u53d6\u5f97NebulaToolkitService\u5bf9\u8c61\uff0c\u4ee5\u4fbf\u4fee\u6b63\u8be5\u9519\u8bef", (Object[])new Object[0]);
        Validate.notNull((Object)asyncTaskRunnable, (String)"async\u65b9\u6cd5\u7684\u5165\u53c2\u5bf9\u8c61asyncTaskRunnable\uff0c\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        Map asyncThreadHandlerMappings = this.applicationContext.getBeansOfType(AsyncThreadHandler.class);
        ArrayList asyncThreadHandlers = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Map)asyncThreadHandlerMappings)) {
            Thread currentThread = Thread.currentThread();
            Collection asyncThreadHandlerCollections = asyncThreadHandlerMappings.values();
            for (AsyncThreadHandler asyncThreadHandler : asyncThreadHandlerCollections) {
                if (asyncThreadHandler == null) continue;
                asyncThreadHandler.readContext(currentThread);
                asyncThreadHandlers.add(asyncThreadHandler);
            }
        }
        AsyncTask asyncTask = (AsyncTask)this.applicationContext.getBean(AsyncTask.class, new Object[]{asyncTaskRunnable, asyncThreadHandlers});
        this.executorService.execute(asyncTask);
    }

    private <S, T> void doCallback(Class<S> sourceClass, List<?> sourceObjects, Class<T> targetClass, List<T> targetObjects) {
        if (!CollectionUtils.isEmpty(this.copyObjectCallbacks)) {
            for (CopyObjectCallback copyObjectCallback : this.copyObjectCallbacks) {
                if (!copyObjectCallback.validate(sourceClass, targetClass)) continue;
                copyObjectCallback.callback(sourceClass, sourceObjects, targetClass, targetObjects);
            }
        }
    }

    private class PropertiesFilterNode {
        private String propertyName;
        private String[] wildcards;
        private Set<PropertiesFilterNode> childproperties = new HashSet<PropertiesFilterNode>();

        public PropertiesFilterNode(String propertyName) {
            this.propertyName = propertyName;
        }

        public PropertiesFilterNode(String propertyName, String[] wildcards) {
            this.propertyName = propertyName;
            this.wildcards = wildcards;
        }

        public void setWildcards(String[] wildcards) {
            this.wildcards = wildcards;
        }

        public String[] getWildcards() {
            return this.wildcards;
        }

        public PropertiesFilterNode getChildProperty(String propertyName) {
            List resultChilds = this.childproperties.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyName(), (CharSequence)propertyName)).collect(Collectors.toList());
            if (resultChilds == null || resultChilds.isEmpty()) {
                return null;
            }
            return (PropertiesFilterNode)resultChilds.get(0);
        }

        public boolean matchWildcard(String fieldName) {
            if (this.wildcards == null || this.wildcards.length == 0) {
                return false;
            }
            return StringUtils.equalsAny((CharSequence)fieldName, (CharSequence[])this.wildcards);
        }

        private PropertiesFilterNode addAndGetChildProperty(String propertyName) {
            if (StringUtils.isBlank((CharSequence)propertyName)) {
                return null;
            }
            PropertiesFilterNode currentNode = this.getChildProperty(propertyName);
            if (currentNode != null) {
                return currentNode;
            }
            currentNode = new PropertiesFilterNode(propertyName, this.wildcards);
            this.childproperties.add(currentNode);
            return currentNode;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    private class PropertyConverterByBlank
    extends AbstractPropertyConverter {
        public PropertyConverterByBlank(Class<?> targetClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, String[] propertiesFilter) {
            super(targetClass, setCollectionClass, listCollectionClass, propertiesFilter);
        }

        private PropertyConverterByBlank(Class<?> targetClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, PropertiesFilterNode currentRoot) {
            super(targetClass, setCollectionClass, listCollectionClass, currentRoot);
        }

        @Override
        protected boolean doNextFilterNode(PropertiesFilterNode root, String fieldName) {
            if (root == null) {
                return false;
            }
            return root.getChildProperty(fieldName) == null && !root.matchWildcard(fieldName);
        }

        @Override
        protected AbstractPropertyConverter nextPropertyConverter(Class<?> targetItemClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, PropertiesFilterNode nextFilterNode) {
            return new PropertyConverterByBlank(targetItemClass, setCollectionClass, listCollectionClass, nextFilterNode);
        }
    }

    private class PropertyConverterByWhite
    extends AbstractPropertyConverter {
        public PropertyConverterByWhite(Class<?> targetClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, String[] propertiesFilter) {
            super(targetClass, setCollectionClass, listCollectionClass, propertiesFilter);
        }

        private PropertyConverterByWhite(Class<?> targetClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, PropertiesFilterNode currentRoot) {
            super(targetClass, setCollectionClass, listCollectionClass, currentRoot);
        }

        @Override
        protected boolean doNextFilterNode(PropertiesFilterNode root, String fieldName) {
            if (root == null) {
                return false;
            }
            return root.getChildProperty(fieldName) != null || root.matchWildcard(fieldName);
        }

        @Override
        protected AbstractPropertyConverter nextPropertyConverter(Class<?> targetItemClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, PropertiesFilterNode nextFilterNode) {
            return new PropertyConverterByWhite(targetItemClass, setCollectionClass, listCollectionClass, nextFilterNode);
        }
    }

    private abstract class AbstractPropertyConverter
    implements Converter {
        private Class<?> targetClass;
        private Class<? extends Set> setCollectionClass;
        private Class<? extends List> listCollectionClass;
        protected PropertiesFilterNode currentRoot;

        public AbstractPropertyConverter(Class<?> targetClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, String[] propertiesFilter) {
            this.currentRoot = new PropertiesFilterNode("");
            this.targetClass = targetClass;
            this.setCollectionClass = setCollectionClass == null ? LinkedHashSet.class : setCollectionClass;
            this.listCollectionClass = listCollectionClass == null ? ArrayList.class : listCollectionClass;
            this.buildPropertyTree(propertiesFilter);
        }

        protected AbstractPropertyConverter(Class<?> targetClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, PropertiesFilterNode currentRoot) {
            this.currentRoot = new PropertiesFilterNode("");
            this.targetClass = targetClass;
            this.setCollectionClass = setCollectionClass == null ? LinkedHashSet.class : setCollectionClass;
            this.listCollectionClass = listCollectionClass == null ? ArrayList.class : listCollectionClass;
            this.currentRoot = currentRoot;
        }

        private void buildPropertyTree(String[] propertiesFilters) {
            if (propertiesFilters == null || propertiesFilters.length == 0) {
                return;
            }
            ArrayList wildcards = new ArrayList();
            Arrays.asList(propertiesFilters).stream().filter(item -> StringUtils.indexOf((CharSequence)item, (CharSequence)"..") != -1).forEach(item -> wildcards.add(item.substring(2)));
            this.currentRoot.setWildcards(wildcards.toArray(new String[0]));
            String[] currentPropertiesFilters = Arrays.asList(propertiesFilters).stream().filter(item -> StringUtils.indexOf((CharSequence)item, (CharSequence)"..") == -1).collect(Collectors.toList()).toArray(new String[0]);
            for (int index = 0; currentPropertiesFilters != null && index < currentPropertiesFilters.length; ++index) {
                String propertiyItem;
                String propertiyFilterItem = currentPropertiesFilters[index];
                String[] propertiyItemArrays = StringUtils.split((String)propertiyFilterItem, (String)".");
                PropertiesFilterNode currentPropertyNode = this.currentRoot;
                for (int sum = 0; sum < propertiyItemArrays.length && (currentPropertyNode = currentPropertyNode.addAndGetChildProperty(propertiyItem = propertiyItemArrays[sum])) != null; ++sum) {
                }
            }
        }

        private boolean isBaseProperty(Object fieldValue, Class targetFieldClass) {
            if (targetFieldClass.isPrimitive() || targetFieldClass == Byte.class || targetFieldClass == Short.class || targetFieldClass == Integer.class || targetFieldClass == Long.class || targetFieldClass == Float.class || targetFieldClass == Double.class || targetFieldClass == Character.class || targetFieldClass == Boolean.class) {
                return true;
            }
            if (JSON.class.isAssignableFrom(targetFieldClass)) {
                return true;
            }
            Class<?> sourceFieldClass = fieldValue.getClass();
            if (targetFieldClass.isEnum() && targetFieldClass == sourceFieldClass) {
                return true;
            }
            String fieldTypeName = targetFieldClass.getName();
            return (StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"javax.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"org.springframework.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"org.apache.")) && !Iterable.class.isAssignableFrom(targetFieldClass);
        }

        private String findFieldNameByMehthod(Object fieldMethodObject) {
            String fieldSetMethodName = fieldMethodObject.toString();
            String fieldGetMethodName = StringUtils.replace((String)fieldSetMethodName, (String)"s", (String)"g", (int)1);
            String fieldName = RegExUtils.replaceFirst((String)fieldGetMethodName, (String)"get", (String)"");
            fieldName = TStringUtils.letterLowercase(fieldName);
            return fieldName;
        }

        private Field findDeclaredField(Class<?> targetClass, String fieldName) {
            try {
                return targetClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if (targetClass.getSuperclass() != null) {
                    return this.findDeclaredField(targetClass.getSuperclass(), fieldName);
                }
                LOGGER.warn(e.getMessage(), (Object)"\u5728\u4e2d\u62f7\u65f6\u672a\u627e\u5230\u76ee\u6807\u7c7b\u7684\u5c5e\u6027");
                return null;
            }
        }

        private Collection buildCollection(Class<?> targetCollectionClass) throws IllegalAccessException, InstantiationException {
            if (Set.class.isAssignableFrom(targetCollectionClass)) {
                return this.setCollectionClass.newInstance();
            }
            if (List.class.isAssignableFrom(targetCollectionClass)) {
                return this.listCollectionClass.newInstance();
            }
            return Sets.newHashSet();
        }

        public Object convert(Object fieldValue, Class targetFieldClass, Object fieldMethodObject) {
            if (fieldValue == null) {
                return null;
            }
            Validate.notNull((Object)targetFieldClass, (String)"\u8f6c\u6362\u65f6\u76ee\u6807class\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            Validate.notNull((Object)fieldMethodObject, (String)"\u5143\u5bf9\u8c61\u7684set\u65b9\u6cd5\u5fc5\u987b\u7f16\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Class<?> sourceFieldClass = fieldValue.getClass();
            if (targetFieldClass.isEnum() && targetFieldClass != sourceFieldClass) {
                return null;
            }
            if (targetFieldClass.isArray() && !sourceFieldClass.isArray() || sourceFieldClass.isArray() && !targetFieldClass.isArray()) {
                return null;
            }
            if (Iterable.class.isAssignableFrom(sourceFieldClass) && !Iterable.class.isAssignableFrom(targetFieldClass) || !Iterable.class.isAssignableFrom(sourceFieldClass) && Iterable.class.isAssignableFrom(targetFieldClass)) {
                return null;
            }
            if (this.isBaseProperty(fieldValue, targetFieldClass)) {
                return fieldValue;
            }
            String fieldName = this.findFieldNameByMehthod(fieldMethodObject);
            if (!this.doNextFilterNode(this.currentRoot, fieldName)) {
                return null;
            }
            PropertiesFilterNode nextFilterNode = null;
            if (this.currentRoot != null && (nextFilterNode = this.currentRoot.getChildProperty(fieldName)) == null) {
                nextFilterNode = new PropertiesFilterNode("", this.currentRoot.getWildcards());
            }
            try {
                if (Collection.class.isAssignableFrom(targetFieldClass)) {
                    Collection results = this.convertPersistentCollectionClass(this.targetClass, fieldValue, targetFieldClass, fieldName, nextFilterNode);
                    return results;
                }
                return this.convertPersistentClass(fieldValue, targetFieldClass, nextFilterNode);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
                throw new IllegalArgumentException(e);
            }
        }

        protected abstract boolean doNextFilterNode(PropertiesFilterNode var1, String var2);

        protected abstract AbstractPropertyConverter nextPropertyConverter(Class<?> var1, Class<? extends Set> var2, Class<? extends List> var3, PropertiesFilterNode var4);

        private Collection convertPersistentCollectionClass(Class<?> targetClass, Object fieldValue, Class targetFieldClass, String fieldName, PropertiesFilterNode nextFilterNode) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
            Collection fieldValues = (Collection)fieldValue;
            if (fieldValues.isEmpty()) {
                return this.buildCollection(targetFieldClass);
            }
            Collection targetFieldValues = this.buildCollection(targetFieldClass);
            Class targetItemClass = null;
            Field field = this.findDeclaredField(targetClass, fieldName);
            if (field == null) {
                return Sets.newHashSet();
            }
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                targetItemClass = (Class)pt.getActualTypeArguments()[0];
                if (targetItemClass == null) {
                    return Sets.newHashSet();
                }
                String fieldTypeName = targetItemClass.getName();
                if (StringUtils.isBlank((CharSequence)fieldTypeName)) {
                    return Sets.newHashSet();
                }
            } else {
                return Sets.newHashSet();
            }
            for (Object fieldValueItem : fieldValues) {
                Class<?> fieldValueItemClass = fieldValueItem.getClass();
                BeanCopier fieldCopier = BeanCopier.create(fieldValueItemClass, (Class)targetItemClass, (boolean)true);
                Object currentTargetFieldValue = targetItemClass.newInstance();
                fieldCopier.copy(fieldValueItem, currentTargetFieldValue, (Converter)this.nextPropertyConverter(targetItemClass, this.setCollectionClass, this.listCollectionClass, nextFilterNode));
                targetFieldValues.add(currentTargetFieldValue);
            }
            return targetFieldValues;
        }

        private Object convertPersistentClass(Object fieldValue, Class targetFieldClass, PropertiesFilterNode nextFilterNode) throws IllegalAccessException, InstantiationException {
            Object currentFieldValue = fieldValue;
            Class<?> currentFieldItemClass = fieldValue.getClass();
            Class<?> currentTargetFieldClass = targetFieldClass;
            Object currentTargetFieldValue = null;
            try {
                currentTargetFieldValue = currentTargetFieldClass.newInstance();
            }
            catch (InstantiationException e) {
                currentTargetFieldValue = currentFieldItemClass.newInstance();
                currentTargetFieldClass = currentFieldItemClass;
            }
            BeanCopier fieldCopier = BeanCopier.create(currentFieldItemClass, currentTargetFieldClass, (boolean)true);
            fieldCopier.copy(currentFieldValue, currentTargetFieldValue, (Converter)this.nextPropertyConverter(currentTargetFieldClass, this.setCollectionClass, this.listCollectionClass, nextFilterNode));
            return currentTargetFieldValue;
        }
    }
}

