/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.service;

import com.alibaba.fastjson.JSON;
import com.bizunited.nebula.common.util.RSAUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ProductValidateService {
    @Value(value="${empower.productName:}")
    private String productName;
    @Value(value="${empower.customerName:}")
    private String customerName;
    @Value(value="${empower.appKey:}")
    private String appKey;
    private Cache<String, Boolean> validateProcess = CacheBuilder.newBuilder().expireAfterWrite(6L, TimeUnit.HOURS).build();

    public void validate() {
        try {
            this.validateProcess.get((Object)"validate", (Callable)new ValidateCacheLoader(this.productName, this.customerName, this.appKey));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private class ValidateCacheLoader
    implements Callable<Boolean> {
        private String productName;
        private String customerName;
        private String appKey;

        public ValidateCacheLoader(String productName, String customerName, String appKey) {
            this.productName = productName;
            this.customerName = customerName;
            this.appKey = appKey;
        }

        @Override
        public Boolean call() throws Exception {
            String encodeContent = "";
            if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.appKey, this.productName})) {
                try {
                    encodeContent = RSAUtils.encrypt(this.productName, this.appKey);
                }
                catch (RuntimeException e) {
                    encodeContent = "";
                }
            }
            encodeContent = URLEncoder.encode(encodeContent, "UTF-8");
            String customerCode = "";
            if (StringUtils.isNotBlank((CharSequence)this.customerName)) {
                customerCode = URLEncoder.encode(this.customerName, "UTF-8");
            }
            String plaintext = "";
            if (StringUtils.isNotBlank((CharSequence)this.productName)) {
                plaintext = URLEncoder.encode(this.productName, "UTF-8");
            }
            String scheme = "https";
            String domain = "validate.biz-united.com.cn";
            String query = StringUtils.join((Object[])new String[]{"encodeContent=", encodeContent, "&plaintext=", plaintext, "&customerCode=", customerCode});
            String path = "/biz/empower/validate";
            URI targetUri = new URI(scheme, null, domain, 443, path, query, null);
            String context = "{}";
            HttpPost httpPost = new HttpPost(targetUri);
            HttpEntity body = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setContentEncoding("utf-8").setBinary(StringUtils.getBytes((String)JSON.toJSONString((Object)context), (Charset)StandardCharsets.UTF_8)).build();
            httpPost.setEntity(body);
            httpPost.setHeader("Content-Type", "application/json");
            try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
                Throwable throwable = null;
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        response.close();
                    }
                }
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
            return true;
        }
    }
}

