/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.service.es;

import com.alibaba.fastjson.JSON;
import com.bizunited.nebula.common.interceptor.ElasticsearchQueryInterceptorStrategy;
import com.bizunited.nebula.common.register.ElasticsearchQueryRegister;
import com.bizunited.nebula.common.service.es.ElasticsearchQueryService;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElasticsearchQueryServiceImpl
implements ElasticsearchQueryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchQueryServiceImpl.class);
    @Autowired(required=false)
    private RestHighLevelClient restHighLevelClient;
    @Autowired(required=false)
    private List<ElasticsearchQueryRegister> queryRegisters;
    @Autowired(required=false)
    private List<ElasticsearchQueryInterceptorStrategy> queryInterceptorStrategies;

    @Override
    public SearchResponse queryWithRegister(Class<? extends ElasticsearchQueryRegister> registerClass, Map<String, Object> paramMap) {
        Validate.notNull(registerClass, (String)"\u67e5\u8be2\u6ce8\u518c\u5668\u5b9e\u73b0Class\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ElasticsearchQueryRegister queryRegister = this.findRegisterByClass(registerClass);
        Validate.notNull((Object)queryRegister, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u67e5\u8be2\u6ce8\u518c\u5668\u5b9e\u73b0", (Object[])new Object[0]);
        String indexName = queryRegister.getIndexName();
        Validate.notBlank((CharSequence)indexName, (String)"\u67e5\u8be2\u6ce8\u518c\u5668\u7d22\u5f15\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SearchSourceBuilder searchSourceBuilder = queryRegister.buildSearch(paramMap);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName}).source(searchSourceBuilder);
        try {
            SearchResponse searchResponse = this.queryWithRequest(searchRequest);
            if (Objects.isNull(searchResponse) || Objects.isNull(searchResponse.getHits())) {
                return searchResponse;
            }
            SearchHit[] hits = searchResponse.getHits().getHits();
            if (Objects.isNull(hits) || hits.length == 0) {
                return searchResponse;
            }
            List<Map<String, Object>> dataList = Arrays.stream(hits).map(SearchHit::getSourceAsMap).collect(Collectors.toList());
            queryRegister.adjustData(dataList);
            return searchResponse;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public SearchResponse queryWithRequest(SearchRequest searchRequest) {
        try {
            if (!CollectionUtils.isEmpty(this.queryInterceptorStrategies)) {
                List<ElasticsearchQueryInterceptorStrategy> sortedElasticsearchQueryInterceptorStrategies = this.queryInterceptorStrategies.stream().sorted(Comparator.comparingInt(ElasticsearchQueryInterceptorStrategy::sort)).collect(Collectors.toList());
                sortedElasticsearchQueryInterceptorStrategies.forEach(strategy -> strategy.intercept(searchRequest));
            }
            LOGGER.debug("ES\u67e5\u8be2\u8bed\u53e5:{}", (Object)searchRequest.source().toString());
            return this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public GetSettingsResponse queryWithSetting(GetSettingsRequest settingsRequest) {
        try {
            return this.restHighLevelClient.indices().getSettings(settingsRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public GetMappingsResponse queryWithMapping(GetMappingsRequest mappingsRequest) {
        try {
            return this.restHighLevelClient.indices().getMapping(mappingsRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public <T> List<T> convertResponse(SearchResponse searchResponse, Class<T> convertClass) {
        if (Objects.isNull(searchResponse) || Objects.isNull(searchResponse.getHits())) {
            return Lists.newArrayList();
        }
        SearchHit[] hits = searchResponse.getHits().getHits();
        if (Objects.isNull(hits) || hits.length == 0) {
            return Lists.newArrayList();
        }
        if (convertClass.getName().equals(Map.class.getName())) {
            return Arrays.stream(hits).map(SearchHit::getSourceAsMap).collect(Collectors.toList());
        }
        return Arrays.stream(hits).map(hit -> JSON.parseObject((String)hit.getSourceAsString(), (Class)convertClass)).collect(Collectors.toList());
    }

    @Override
    public ElasticsearchQueryRegister findRegisterByClass(Class<? extends ElasticsearchQueryRegister> registerClass) {
        if (CollectionUtils.isEmpty(this.queryRegisters) || Objects.isNull(registerClass)) {
            return null;
        }
        return this.queryRegisters.stream().filter(queryRegister -> queryRegister.getClass().getName().equals(registerClass.getName())).findFirst().orElse(null);
    }
}

