/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class IpUtils {
    private IpUtils() {
    }

    public static String findInternalIp() {
        String clientIp = "";
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address) || ip.getHostAddress().equals("127.0.0.1") || !IpUtils.internalIp(clientIp = ip.getHostAddress())) continue;
                    return clientIp;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace(System.out);
            throw new IllegalArgumentException(e);
        }
        return null;
    }

    public static boolean internalIp(String ip) {
        byte[] addr = IpUtils.textToNumericFormatV4(ip);
        return IpUtils.internalIp(addr) || "127.0.0.1".equals(ip);
    }

    private static boolean internalIp(byte[] addr) {
        if (addr == null || addr.length < 2) {
            return true;
        }
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                switch (b1) {
                    case -88: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static byte[] textToNumericFormatV4(String text) {
        if (text.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[4];
        String[] elements = text.split("\\.", -1);
        try {
            switch (elements.length) {
                case 1: {
                    long l = Long.parseLong(elements[0]);
                    if (l < 0L || l > 0xFFFFFFFFL) {
                        return null;
                    }
                    bytes[0] = (byte)(l >> 24 & 0xFFL);
                    bytes[1] = (byte)((l & 0xFFFFFFL) >> 16 & 0xFFL);
                    bytes[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 2: {
                    long l = Integer.parseInt(elements[0]);
                    if (l < 0L || l > 255L) {
                        return null;
                    }
                    bytes[0] = (byte)(l & 0xFFL);
                    l = Integer.parseInt(elements[1]);
                    if (l < 0L || l > 0xFFFFFFL) {
                        return null;
                    }
                    bytes[1] = (byte)(l >> 16 & 0xFFL);
                    bytes[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 3: {
                    long l;
                    for (int i = 0; i < 2; ++i) {
                        l = Integer.parseInt(elements[i]);
                        if (l < 0L || l > 255L) {
                            return null;
                        }
                        bytes[i] = (byte)(l & 0xFFL);
                    }
                    l = Integer.parseInt(elements[2]);
                    if (l < 0L || l > 65535L) {
                        return null;
                    }
                    bytes[2] = (byte)(l >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long l = Integer.parseInt(elements[i]);
                        if (l < 0L || l > 255L) {
                            return null;
                        }
                        bytes[i] = (byte)(l & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return bytes;
    }
}

