/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.util.transfer;

import com.bizunited.nebula.common.util.transfer.Transfer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionTransferUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionTransferUtils.class);

    public static <T, T1> Collection<T1> transfer(Collection<T> coll, Transfer<T, T1> transfer, Class<? extends Set> setClass, Class<? extends List> listClass) {
        Collection<T1> result = CollectionTransferUtils.validate(coll, transfer, setClass, listClass);
        if (result == null) {
            return result;
        }
        for (T t : coll) {
            T1 t1 = transfer.transfer(t);
            result.add(t1);
        }
        return result;
    }

    public static <T, T1> Collection<T1> transfer(Collection<T> coll, Class<? extends T1> specifyClass, Transfer<T, T1> transfer, Class<? extends Set> setClass, Class<? extends List> listClass) {
        Collection<T1> result = CollectionTransferUtils.validate(coll, transfer, setClass, listClass);
        if (result == null) {
            return result;
        }
        if (specifyClass != null) {
            for (T t : coll) {
                T1 t1 = transfer.transfer(t, specifyClass);
                result.add(t1);
            }
        } else {
            for (T t : coll) {
                T1 t1 = transfer.transfer(t);
                result.add(t1);
            }
        }
        return result;
    }

    private static <T, T1> Collection<T1> validate(Collection<T> coll, Transfer<T, T1> transfer, Class<? extends Set> setClass, Class<? extends List> listClass) {
        Collection result;
        Validate.notNull(transfer, (String)"\u8f6c\u6362\u5668\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (coll == null) {
            return null;
        }
        setClass = (Class)ObjectUtils.defaultIfNull(setClass, HashSet.class);
        listClass = (Class)ObjectUtils.defaultIfNull(listClass, ArrayList.class);
        try {
            result = List.class.isAssignableFrom(coll.getClass()) ? (Collection)listClass.newInstance() : (Set.class.isAssignableFrom(coll.getClass()) ? (Collection)setClass.newInstance() : (Collection)listClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return result;
    }
}

