/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.config;

import com.bizunited.nebula.common.config.RedisCustomProperties;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import java.time.Duration;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class JedisTemplateConfig {
    @Autowired
    private RedisCustomProperties redisProperties;

    @Bean
    @ConditionalOnMissingBean
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(this.redisProperties.getConnectionPoolSize());
        poolConfig.setMaxIdle(this.redisProperties.getConnectionMaximumIdleSize());
        poolConfig.setMaxWaitMillis((long)this.redisProperties.getConnectionTimeout());
        poolConfig.setMinIdle(this.redisProperties.getConnectionMinimumIdleSize());
        return poolConfig;
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisTemplate<String, Object> redisTemplate(JedisConnectionFactory jedisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)jedisConnectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_ARRAY);
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        redisTemplate.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        return redisTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public JedisConnectionFactory jedisConnectionFactory(JedisPoolConfig poolConfig) {
        JedisConnectionFactory jedisConnectionFactory;
        JedisClientConfiguration jedisClientConfiguration = JedisClientConfiguration.builder().usePooling().poolConfig((GenericObjectPoolConfig)poolConfig).and().readTimeout(Duration.ofMillis(this.redisProperties.getTimeout())).build();
        switch (this.redisProperties.getModel()) {
            case "single": {
                jedisConnectionFactory = new JedisConnectionFactory(this.getRedisStandaloneConfiguration(), jedisClientConfiguration);
                break;
            }
            case "cluster": {
                jedisConnectionFactory = new JedisConnectionFactory(this.getRedisClusterConfiguration(), jedisClientConfiguration);
                break;
            }
            case "sentinel": {
                jedisConnectionFactory = new JedisConnectionFactory(this.getRedisSentinelConfiguration(), jedisClientConfiguration);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Not support redis model:%s", this.redisProperties.getModel()));
            }
        }
        return jedisConnectionFactory;
    }

    private RedisStandaloneConfiguration getRedisStandaloneConfiguration() {
        String[] addressArray = this.redisProperties.getAddress();
        Validate.isTrue((addressArray != null && addressArray.length == 1 ? 1 : 0) != 0, (String)"Not support redis  address!", (Object[])new Object[0]);
        String[] hostAndPort = addressArray[0].split(":");
        Validate.isTrue((hostAndPort.length == 2 ? 1 : 0) != 0, (String)"For redis single mode, not support redis host or port!", (Object[])new Object[0]);
        RedisStandaloneConfiguration singleRedisConfig = new RedisStandaloneConfiguration();
        singleRedisConfig.setHostName(hostAndPort[0]);
        if (!StringUtils.isEmpty((CharSequence)this.redisProperties.getPassword())) {
            singleRedisConfig.setPassword(RedisPassword.of((String)this.redisProperties.getPassword()));
        }
        singleRedisConfig.setPort(Integer.parseInt(hostAndPort[1]));
        singleRedisConfig.setDatabase(this.redisProperties.getDatabase());
        return singleRedisConfig;
    }

    private RedisClusterConfiguration getRedisClusterConfiguration() {
        String[] addressArray = this.redisProperties.getAddress();
        Validate.isTrue((addressArray != null && addressArray.length > 0 ? 1 : 0) != 0, (String)"Not support redis cluster address!", (Object[])new Object[0]);
        RedisClusterConfiguration clusterRedisConfig = new RedisClusterConfiguration();
        ArrayList<RedisNode> nodeList = new ArrayList<RedisNode>();
        for (String address : addressArray) {
            String[] hostAndPort = address.split(":");
            Validate.isTrue((hostAndPort.length == 2 ? 1 : 0) != 0, (String)"For redis cluster mode, not support redis host or port!", (Object[])new Object[0]);
            nodeList.add(new RedisNode(hostAndPort[0], Integer.parseInt(hostAndPort[1])));
        }
        clusterRedisConfig.setClusterNodes(nodeList);
        if (!StringUtils.isEmpty((CharSequence)this.redisProperties.getPassword())) {
            clusterRedisConfig.setPassword(RedisPassword.of((String)this.redisProperties.getPassword()));
        }
        return clusterRedisConfig;
    }

    private RedisSentinelConfiguration getRedisSentinelConfiguration() {
        Validate.notBlank((CharSequence)this.redisProperties.getMasterName(), (String)"For redis sentinel mode, please check sentinel master name!", (Object[])new Object[0]);
        String[] addressArray = this.redisProperties.getAddress();
        Validate.isTrue((addressArray != null && addressArray.length > 0 ? 1 : 0) != 0, (String)"Not support redis sentinel address!", (Object[])new Object[0]);
        RedisSentinelConfiguration sentinelRedisConfig = new RedisSentinelConfiguration();
        sentinelRedisConfig.setMaster(this.redisProperties.getMasterName());
        ArrayList<RedisNode> nodeList = new ArrayList<RedisNode>();
        for (String address : addressArray) {
            String[] hostAndPort = address.split(":");
            Validate.isTrue((hostAndPort.length == 2 ? 1 : 0) != 0, (String)"For redis sentinel mode, not support redis host or port!", (Object[])new Object[0]);
            nodeList.add(new RedisNode(hostAndPort[0], Integer.parseInt(hostAndPort[1])));
        }
        sentinelRedisConfig.setSentinels(nodeList);
        sentinelRedisConfig.setDatabase(this.redisProperties.getDatabase());
        if (!StringUtils.isEmpty((CharSequence)this.redisProperties.getPassword())) {
            sentinelRedisConfig.setPassword(RedisPassword.of((String)this.redisProperties.getPassword()));
        }
        return sentinelRedisConfig;
    }
}

