/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.repository;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.Transformers;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public interface PageRepositoryImpl {
    default public <T> Page<T> queryByConditions(EntityManager entityManager, String sql, String countSql, Map<String, Object> parameter, Pageable pageable, boolean nativeQuery, Class<T> resultClazz) {
        Query countQuery;
        Query query;
        if (nativeQuery) {
            Validate.notNull(resultClazz, (String)"resultClazz\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            query = entityManager.createNativeQuery(sql);
            ((NativeQuery)query.unwrap(NativeQuery.class)).setResultTransformer(Transformers.aliasToBean(resultClazz));
            countQuery = entityManager.createNativeQuery(countSql);
        } else {
            query = entityManager.createQuery(sql);
            countQuery = entityManager.createQuery(countSql);
        }
        this.bindParamsSafely(query, sql, parameter);
        this.bindParamsSafely(countQuery, countSql, parameter);
        query.setFirstResult((int)pageable.getOffset());
        query.setMaxResults(pageable.getPageSize());
        Object countObj = countQuery.getSingleResult();
        long count = countObj instanceof BigInteger ? ((BigInteger)countObj).longValue() : (countObj instanceof Number ? ((Number)countObj).longValue() : Long.parseLong(String.valueOf(countObj)));
        List result = count > 0L ? query.getResultList() : Collections.emptyList();
        return new PageImpl(result, pageable, count);
    }

    default public String getSort(Pageable pageable, Sort defaultSort, String alias) {
        Validate.notNull((Object)defaultSort, (String)"\u9ed8\u8ba4\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Sort sort = pageable.getSortOr(defaultSort);
        if (sort.isUnsorted()) {
            return "";
        }
        Iterator iterator = sort.iterator();
        ArrayList<String> orders = new ArrayList<String>();
        while (iterator.hasNext()) {
            Sort.Order order = (Sort.Order)iterator.next();
            String property = order.getProperty();
            String sql = StringUtils.isBlank((CharSequence)alias) ? property : StringUtils.join((Object[])new String[]{alias, ".", property});
            sql = StringUtils.join((Object[])new String[]{sql, " ", order.getDirection().name()});
            orders.add(sql);
        }
        return StringUtils.join((Object[])new String[]{" order by ", StringUtils.join(orders, (String)",")});
    }

    default public void bindParamsSafely(Query q, String hqlOrSql, Map<String, Object> params) {
        Set<Object> names = new HashSet();
        try {
            for (Parameter parameter : q.getParameters()) {
                if (parameter.getName() == null) continue;
                names.add(parameter.getName());
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (names.isEmpty()) {
            names = PageRepositoryImpl.extractParamNamesByRegex(hqlOrSql);
        }
        for (String string : names) {
            if (!params.containsKey(string)) continue;
            q.setParameter(string, params.get(string));
        }
    }

    public static Set<String> extractParamNamesByRegex(String hqlOrSql) {
        HashSet<String> out = new HashSet<String>();
        Matcher m = Pattern.compile(":[a-zA-Z_][a-zA-Z0-9_]*").matcher(hqlOrSql);
        while (m.find()) {
            out.add(m.group().substring(1));
        }
        return out;
    }
}

